/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import mondrian.util.AbstractMemoryMonitor;
import org.apache.log4j.Logger;

public class NotificationMemoryMonitor
extends AbstractMemoryMonitor {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$util$NotificationMemoryMonitor == null ? (class$mondrian$util$NotificationMemoryMonitor = NotificationMemoryMonitor.class$("mondrian.util.NotificationMemoryMonitor")) : class$mondrian$util$NotificationMemoryMonitor));
    protected static final MemoryPoolMXBean TENURED_POOL = NotificationMemoryMonitor.findTenuredGenPool();
    private static final /* synthetic */ Class class$mondrian$util$NotificationMemoryMonitor;

    private static MemoryPoolMXBean findTenuredGenPool() {
        Iterator<MemoryPoolMXBean> i$ = ManagementFactory.getMemoryPoolMXBeans().iterator();
        while (i$.hasNext()) {
            MemoryPoolMXBean pool = i$.next();
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    NotificationMemoryMonitor() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationHandler(null), null, null);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected void notifyNewLowThreshold(long newLowThreshold) {
        if (newLowThreshold == Long.MAX_VALUE) {
            TENURED_POOL.setUsageThreshold(0L);
        } else {
            TENURED_POOL.setUsageThreshold(newLowThreshold);
        }
    }

    public long getMaxMemory() {
        return TENURED_POOL.getUsage().getMax();
    }

    public long getUsedMemory() {
        return TENURED_POOL.getUsage().getUsed();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
    }

    private class NotificationHandler
    implements NotificationListener {
        private NotificationHandler() {
        }

        public void handleNotification(Notification notification, Object unused) {
            String type = notification.getType();
            if (type.equals("java.management.memory.threshold.exceeded")) {
                MemoryUsage usage = TENURED_POOL.getUsage();
                NotificationMemoryMonitor.this.notifyListeners(usage.getUsed(), usage.getMax());
            }
        }

        NotificationHandler(1 x1) {
            this();
        }
    }
}

