/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import com.rc.retroweaver.runtime.Collections;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletResponse
implements HttpServletResponse {
    public static final String DATE_FORMAT_HEADER = "EEE, d MMM yyyy HH:mm:ss Z";
    private PrintWriter writer;
    private Locale locale;
    private String charEncoding = "ISO-8859-1";
    private List<Cookie> cookies = Collections.emptyList();
    private MockServletOutputStream outputStream;
    private int statusCode = 200;
    private boolean isCommited = false;
    private String errorMsg;
    private int errorCode = 200;
    private boolean wasErrorSent;
    private boolean wasRedirectSent;
    private int bufferSize = 8192;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public MockHttpServletResponse() {
        this.outputStream = new MockServletOutputStream(this.bufferSize);
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.outputStream), this.charEncoding), true);
        }
        return this.writer;
    }

    public void setCharacterEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
        this.outputStream.setEncoding(charEncoding);
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.outputStream.flush();
    }

    public void resetBuffer() {
        this.outputStream.clearContent();
    }

    public boolean isCommitted() {
        return this.isCommited;
    }

    public void reset() {
        this.headers.clear();
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies.isEmpty()) {
            this.cookies = new ArrayList<Cookie>();
        }
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return this.encode(url);
    }

    public String encodeRedirectURL(String url) {
        return this.encode(url);
    }

    public String encodeUrl(String s) {
        return this.encodeURL(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public void sendError(int code, String msg) throws IOException {
        this.errorCode = code;
        this.wasErrorSent = true;
        this.errorMsg = msg;
    }

    public void sendError(int code) throws IOException {
        this.errorCode = code;
        this.wasErrorSent = true;
    }

    public void sendRedirect(String location) throws IOException {
        this.setHeader("Location", location);
        this.wasRedirectSent = true;
    }

    public void setDateHeader(String name, long date) {
        Date dateValue = new Date(date);
        String dateString = DateFormat.getDateInstance().format(dateValue);
        this.setHeader(name, dateString);
    }

    public void addDateHeader(String name, long date) {
        Date dateValue = new Date(date);
        String dateString = new SimpleDateFormat(DATE_FORMAT_HEADER, Locale.US).format(dateValue);
        this.addHeader(name, dateString);
    }

    public void setHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>();
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    public void addHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (null == valueList) {
            valueList = new ArrayList<String>();
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    public void setIntHeader(String name, int value) {
        String stringValue = Integer.toString(value);
        this.addHeader(name, stringValue);
    }

    public void addIntHeader(String name, int value) {
        String stringValue = Integer.toString(value);
        this.addHeader(name, stringValue);
    }

    public void setStatus(int status) {
        this.statusCode = status;
    }

    public void setStatus(int status, String s) {
        this.setStatus(status);
    }

    public byte[] toByteArray() throws IOException {
        return this.outputStream.getBinaryContent();
    }

    public String getHeader(String name) {
        List<String> list = this.getHeaderList(name);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public List<String> getHeaderList(String name) {
        return this.headers.get(name);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public List getCookies() {
        return this.cookies;
    }

    public boolean wasErrorSent() {
        return this.wasErrorSent;
    }

    public boolean wasRedirectSent() {
        return this.wasRedirectSent;
    }

    protected String encode(String s) {
        return s;
    }

    static class MockServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream buffer;
        private String encoding;

        public MockServletOutputStream(int size) {
            this(size, "ISO-8859-1");
        }

        public MockServletOutputStream(int size, String encoding) {
            this.buffer = new ByteArrayOutputStream(size);
            this.encoding = encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void write(int value) throws IOException {
            this.buffer.write(value);
        }

        public String getContent() throws IOException {
            this.buffer.flush();
            return this.buffer.toString(this.encoding);
        }

        public byte[] getBinaryContent() throws IOException {
            this.buffer.flush();
            return this.buffer.toByteArray();
        }

        public void clearContent() {
            this.buffer = new ByteArrayOutputStream();
        }
    }
}

