/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import com.rc.retroweaver.runtime.Enum_;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Scanner;
import mondrian.olap.Util;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.type.TypeUtil;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.tui.XmlaSupport;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;

public class CmdRunner {
    private static final String nl = Util.nl;
    private static boolean RELOAD_CONNECTION = true;
    private static String CATALOG_NAME = "FoodMart";
    private static final Map<Object, String> paraNameValues = new HashMap<Object, String>();
    private static String[][] commentDelim;
    private static char[] commentStartChars;
    private static boolean allowNestedComments;
    private final Options options;
    private long queryTime;
    private long totalQueryTime;
    private String filename;
    private String mdxCmd;
    private String mdxResult;
    private String error;
    private String stack;
    private String connectString;
    private Connection connection;
    private final PrintWriter out;
    static NumberFormat nf;
    private static final String COMMAND_PROMPT_START = "> ";
    private static final String COMMAND_PROMPT_MID = "? ";
    private static final String INDENT = "  ";
    private static final int UNKNOWN_CMD = 0;
    private static final int HELP_CMD = 1;
    private static final int SET_CMD = 2;
    private static final int LOG_CMD = 4;
    private static final int FILE_CMD = 8;
    private static final int LIST_CMD = 16;
    private static final int MDX_CMD = 32;
    private static final int FUNC_CMD = 64;
    private static final int PARAM_CMD = 128;
    private static final int CUBE_CMD = 256;
    private static final int ERROR_CMD = 512;
    private static final int ECHO_CMD = 1024;
    private static final int EXPR_CMD = 2048;
    private static final int EXIT_CMD = 4096;
    private static final int ALL_CMD = 8191;
    private static final char ESCAPE_CHAR = '\\';
    private static final char EXECUTE_CHAR = '=';
    private static final char CANCEL_CHAR = '~';
    private static final char STRING_CHAR_1 = '\"';
    private static final char STRING_CHAR_2 = '\'';
    private static final char BRACKET_START = '[';
    private static final char BRACKET_END = ']';
    private static final String SEMI_COLON_STRING = ";";
    private static final int DO_MDX = 1;
    private static final int DO_XMLA = 2;
    private static final int DO_SOAP_XMLA = 3;
    private static final int VALIDATE_NONE = 1;
    private static final int VALIDATE_TRANSFORM = 2;
    private static final int VALIDATE_XPATH = 3;

    public CmdRunner(Options options, PrintWriter out) {
        if (options == null) {
            options = new Options();
        }
        this.options = options;
        this.filename = null;
        this.mdxResult = null;
        this.error = null;
        this.queryTime = -1L;
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        this.out = out;
    }

    public void setTimeQueries(boolean timeQueries) {
        Options.access$002(this.options, timeQueries);
    }

    public boolean getTimeQueries() {
        return Options.access$000(this.options);
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public long getTotalQueryTime() {
        return this.totalQueryTime;
    }

    public void noCubeCaching() {
        Cube[] cubes;
        Cube[] arr$ = cubes = this.getCubes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Cube cube = arr$[i$];
            RolapCube rcube = (RolapCube)cube;
            rcube.setCacheAggregations(false);
        }
    }

    void setError(String s) {
        this.error = s;
    }

    void setError(Throwable t) {
        this.error = this.formatError(t);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        this.stack = sw.toString();
    }

    void clearError() {
        this.error = null;
        this.stack = null;
    }

    private String formatError(Throwable mex) {
        String message = mex.getMessage();
        if (message == null) {
            message = mex.toString();
        }
        if (mex.getCause() != null && mex.getCause() != mex) {
            message = message + nl + this.formatError(mex.getCause());
        }
        return message;
    }

    public static void listPropertyNames(StringBuffer buf) {
        PropertyInfo propertyInfo = new PropertyInfo(MondrianProperties.instance());
        for (int i = 0; i < propertyInfo.size(); ++i) {
            buf.append(propertyInfo.getProperty(i).getPath());
            buf.append(nl);
        }
    }

    public static void listPropertiesAll(StringBuffer buf) {
        PropertyInfo propertyInfo = new PropertyInfo(MondrianProperties.instance());
        for (int i = 0; i < propertyInfo.size(); ++i) {
            String propertyName = propertyInfo.getPropertyName(i);
            String propertyValue = propertyInfo.getProperty(i).getString();
            buf.append(propertyName);
            buf.append('=');
            buf.append(propertyValue);
            buf.append(nl);
        }
    }

    private static String getPropertyValue(String propertyName) {
        Property property = PropertyInfo.lookupProperty(MondrianProperties.instance(), propertyName);
        return property.isSet() ? property.getString() : null;
    }

    public static void listProperty(String propertyName, StringBuffer buf) {
        buf.append(CmdRunner.getPropertyValue(propertyName));
    }

    public static boolean isProperty(String propertyName) {
        Property property = PropertyInfo.lookupProperty(MondrianProperties.instance(), propertyName);
        return property != null;
    }

    public static boolean setProperty(String name, String value) {
        Property property = PropertyInfo.lookupProperty(MondrianProperties.instance(), name);
        String oldValue = property.getString();
        if (!Util.equals(oldValue, value)) {
            property.setString(value);
            return true;
        }
        return false;
    }

    public void loadParameters(Query query) {
        Parameter[] params;
        Parameter[] arr$ = params = query.getParameters();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Parameter param = arr$[i$];
            this.loadParameter(query, param);
        }
    }

    public void loadParameter(Query query, Parameter param) {
        int category = TypeUtil.typeToCategory(param.getType());
        String name = param.getName();
        String value = paraNameValues.get(name);
        this.debug("loadParameter: name=" + name + ", value=" + value);
        if (value == null) {
            return;
        }
        Expr expr = this.parseParameter(value);
        if (expr == null) {
            return;
        }
        Expr.Type type = expr.type;
        switch (category) {
            case 7: {
                if (type == Expr.Type.NUMERIC) break;
                String msg = "For parameter named \"" + name + "\" of Catetory.Numeric, " + "the value was type \"" + (Object)((Object)type) + "\"";
                throw new IllegalArgumentException(msg);
            }
            case 9: {
                if (type == Expr.Type.STRING) break;
                String msg = "For parameter named \"" + name + "\" of Catetory.String, " + "the value was type \"" + (Object)((Object)type) + "\"";
                throw new IllegalArgumentException(msg);
            }
            case 6: {
                if (type == Expr.Type.MEMBER) break;
                String msg = "For parameter named \"" + name + "\" of Catetory.Member, " + "the value was type \"" + (Object)((Object)type) + "\"";
                throw new IllegalArgumentException(msg);
            }
            default: {
                throw Util.newInternal("unexpected category " + category);
            }
        }
        query.setParameter(param.getName(), String.valueOf(expr.value));
    }

    public Expr parseParameter(String value) {
        String trimmed = value.trim();
        int len = trimmed.length();
        if (trimmed.charAt(0) == '\"' && trimmed.charAt(len - 1) == '\"') {
            this.debug("parseParameter. STRING_TYPE: " + trimmed);
            return new Expr(trimmed.substring(1, trimmed.length() - 1), Expr.Type.STRING);
        }
        if (trimmed.charAt(0) == '\'' && trimmed.charAt(len - 1) == '\'') {
            this.debug("parseParameter. STRING_TYPE: " + trimmed);
            return new Expr(trimmed.substring(1, trimmed.length() - 1), Expr.Type.STRING);
        }
        Number number = null;
        try {
            number = nf.parse(trimmed);
        }
        catch (ParseException pex) {
            // empty catch block
        }
        if (number != null) {
            this.debug("parseParameter. NUMERIC_TYPE: " + number);
            return new Expr(number, Expr.Type.NUMERIC);
        }
        this.debug("parseParameter. MEMBER_TYPE: " + trimmed);
        Query query = this.connection.parseQuery(this.mdxCmd);
        OlapElement element = Util.lookup(query, Util.explode(trimmed));
        this.debug("parseParameter. exp=" + (element == null ? "null" : element.getClass().getName()));
        if (element instanceof Member) {
            Member member = (Member)element;
            return new Expr(member, Expr.Type.MEMBER);
        }
        if (element instanceof mondrian.olap.Level) {
            mondrian.olap.Level level = (mondrian.olap.Level)element;
            return new Expr(level, Expr.Type.MEMBER);
        }
        if (element instanceof Hierarchy) {
            Hierarchy hier = (Hierarchy)element;
            return new Expr(hier, Expr.Type.MEMBER);
        }
        if (element instanceof Dimension) {
            Dimension dim = (Dimension)element;
            return new Expr(dim, Expr.Type.MEMBER);
        }
        return null;
    }

    public static void listParameterNameValues(StringBuffer buf) {
        Iterator<Map.Entry<Object, String>> i$ = paraNameValues.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, String> e = i$.next();
            buf.append(e.getKey());
            buf.append('=');
            buf.append(e.getValue());
            buf.append(nl);
        }
    }

    public static void listParam(String name, StringBuffer buf) {
        String v = paraNameValues.get(name);
        buf.append(v);
    }

    public static boolean isParam(String name) {
        String v = paraNameValues.get(name);
        return v != null;
    }

    public static void setParameter(String name, String value) {
        if (name == null) {
            paraNameValues.clear();
        } else if (value == null) {
            paraNameValues.remove(name);
        } else {
            paraNameValues.put(name, value);
        }
    }

    public Cube[] getCubes() {
        Connection conn = this.getConnection();
        return conn.getSchemaReader().getCubes();
    }

    public Cube getCube(String name) {
        Cube[] cubes;
        Cube[] arr$ = cubes = this.getCubes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Cube cube = arr$[i$];
            if (!cube.getName().equals(name)) continue;
            return cube;
        }
        return null;
    }

    public void listCubeName(StringBuffer buf) {
        Cube[] cubes;
        Cube[] arr$ = cubes = this.getCubes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Cube cube = arr$[i$];
            buf.append(cube.getName());
            buf.append(nl);
        }
    }

    public void listCubeAttribues(String name, StringBuffer buf) {
        Cube cube = this.getCube(name);
        if (cube == null) {
            buf.append("No cube found with name \"");
            buf.append(name);
            buf.append("\"");
        } else {
            RolapCube rcube = (RolapCube)cube;
            buf.append("facttable=");
            buf.append(rcube.getStar().getFactTable().getAlias());
            buf.append(nl);
            buf.append("caching=");
            buf.append(rcube.isCacheAggregations());
            buf.append(nl);
        }
    }

    public void executeCubeCommand(String cubename, String command, StringBuffer buf) {
        Cube cube = this.getCube(cubename);
        if (cube == null) {
            buf.append("No cube found with name \"");
            buf.append(cubename);
            buf.append("\"");
        } else if (command.equals("clearCache")) {
            RolapCube rcube = (RolapCube)cube;
            rcube.clearCachedAggregations();
        } else {
            buf.append("For cube \"");
            buf.append(cubename);
            buf.append("\" there is no command \"");
            buf.append(command);
            buf.append("\"");
        }
    }

    public void setCubeAttribute(String cubename, String name, String value, StringBuffer buf) {
        Cube cube = this.getCube(cubename);
        if (cube == null) {
            buf.append("No cube found with name \"");
            buf.append(cubename);
            buf.append("\"");
        } else if (name.equals("caching")) {
            RolapCube rcube = (RolapCube)cube;
            boolean isCache = Boolean.valueOf(value);
            rcube.setCacheAggregations(isCache);
        } else {
            buf.append("For cube \"");
            buf.append(cubename);
            buf.append("\" there is no attribute \"");
            buf.append(name);
            buf.append("\"");
        }
    }

    public String execute(String queryString) {
        Result result = this.runQuery(queryString, true);
        return this.toString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runQuery(String queryString, boolean loadParams) {
        this.debug("CmdRunner.runQuery: TOP");
        Result result = null;
        long start = System.currentTimeMillis();
        try {
            this.connection = this.getConnection();
            this.debug("CmdRunner.runQuery: AFTER getConnection");
            Query query = this.connection.parseQuery(queryString);
            this.debug("CmdRunner.runQuery: AFTER parseQuery");
            if (loadParams) {
                this.loadParameters(query);
            }
            start = System.currentTimeMillis();
            result = this.connection.execute(query);
        }
        finally {
            this.queryTime = System.currentTimeMillis() - start;
            this.totalQueryTime += this.queryTime;
            this.debug("CmdRunner.runQuery: BOTTOM");
        }
        return result;
    }

    public String toString(Result result) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        result.print(pw);
        pw.flush();
        return sw.toString();
    }

    public void makeConnectString() {
        Util.PropertyList connectProperties;
        String connectString = CmdRunner.getConnectStringProperty();
        this.debug("CmdRunner.makeConnectString: connectString=" + connectString);
        if (connectString == null || connectString.equals("")) {
            connectProperties = new Util.PropertyList();
            connectProperties.put(RolapConnectionProperties.Provider.name(), "mondrian");
        } else {
            connectProperties = Util.parseConnectString(connectString);
        }
        String jdbcURL = CmdRunner.getJdbcURLProperty();
        this.debug("CmdRunner.makeConnectString: jdbcURL=" + jdbcURL);
        if (jdbcURL != null) {
            connectProperties.put(RolapConnectionProperties.Jdbc.name(), jdbcURL);
        }
        String jdbcDrivers = CmdRunner.getJdbcDriversProperty();
        this.debug("CmdRunner.makeConnectString: jdbcDrivers=" + jdbcDrivers);
        if (jdbcDrivers != null) {
            connectProperties.put(RolapConnectionProperties.JdbcDrivers.name(), jdbcDrivers);
        }
        String catalogURL = CmdRunner.getCatalogURLProperty();
        this.debug("CmdRunner.makeConnectString: catalogURL=" + catalogURL);
        if (catalogURL != null) {
            connectProperties.put(RolapConnectionProperties.Catalog.name(), catalogURL);
        }
        String jdbcUser = CmdRunner.getJdbcUserProperty();
        this.debug("CmdRunner.makeConnectString: jdbcUser=" + jdbcUser);
        if (jdbcUser != null) {
            connectProperties.put(RolapConnectionProperties.JdbcUser.name(), jdbcUser);
        }
        String jdbcPassword = CmdRunner.getJdbcPasswordProperty();
        this.debug("CmdRunner.makeConnectString: jdbcPassword=" + jdbcPassword);
        if (jdbcPassword != null) {
            connectProperties.put(RolapConnectionProperties.JdbcPassword.name(), jdbcPassword);
        }
        this.debug("CmdRunner.makeConnectString: connectProperties=" + connectProperties);
        this.connectString = connectProperties.toString();
    }

    public Connection getConnection() {
        return this.getConnection(RELOAD_CONNECTION);
    }

    public synchronized Connection getConnection(boolean fresh) {
        if (this.connectString == null) {
            this.makeConnectString();
        }
        if (fresh) {
            return DriverManager.getConnection(this.connectString, null, fresh);
        }
        if (this.connection == null) {
            this.connection = DriverManager.getConnection(this.connectString, null, fresh);
        }
        return this.connection;
    }

    public String getConnectString() {
        return this.getConnectString(RELOAD_CONNECTION);
    }

    public synchronized String getConnectString(boolean fresh) {
        if (this.connectString == null) {
            this.makeConnectString();
        }
        return this.connectString;
    }

    protected void debug(String msg) {
        if (Options.access$100(this.options)) {
            this.out.println(msg);
        }
    }

    protected static String getConnectStringProperty() {
        return MondrianProperties.instance().TestConnectString.get();
    }

    protected static String getJdbcURLProperty() {
        return MondrianProperties.instance().TestJdbcURL.get();
    }

    protected static String getJdbcUserProperty() {
        return MondrianProperties.instance().TestJdbcUser.get();
    }

    protected static String getJdbcPasswordProperty() {
        return MondrianProperties.instance().TestJdbcPassword.get();
    }

    protected static String getCatalogURLProperty() {
        return MondrianProperties.instance().CatalogURL.get();
    }

    protected static String getJdbcDriversProperty() {
        return MondrianProperties.instance().JdbcDrivers.get();
    }

    protected void commandLoop(boolean interactive) throws IOException {
        this.commandLoop(new BufferedReader(new InputStreamReader(System.in)), interactive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandLoop(File file) throws IOException {
        FileReader in = new FileReader(file);
        try {
            this.commandLoop(new BufferedReader(in), false);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void commandLoop(String mdxCmd, boolean interactive) throws IOException {
        StringReader is = new StringReader(mdxCmd);
        this.commandLoop(is, interactive);
    }

    protected void commandLoop(Reader in, boolean interactive) {
        StringBuffer buf = new StringBuffer(2048);
        boolean inMdxCmd = false;
        String resultString = null;
        while (true) {
            String mdxCmd;
            String line;
            if (resultString != null) {
                this.printResults(resultString);
                this.printQueryTime();
                resultString = null;
            } else if (interactive && this.error != null) {
                this.printResults(this.error);
                this.printQueryTime();
            }
            if (interactive) {
                if (inMdxCmd) {
                    this.out.print(COMMAND_PROMPT_MID);
                } else {
                    this.out.print(COMMAND_PROMPT_START);
                }
                this.out.flush();
            }
            if (!inMdxCmd) {
                buf.setLength(0);
            }
            try {
                line = CmdRunner.readLine(in, inMdxCmd);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while reading command line", e);
            }
            if (line != null) {
                line = line.trim();
            }
            this.debug("line=" + line);
            if (!inMdxCmd && line == null) {
                return;
            }
            if (!inMdxCmd) {
                String cmd = line;
                if (cmd.startsWith("help")) {
                    resultString = CmdRunner.executeHelp(cmd);
                } else if (cmd.startsWith("set")) {
                    resultString = this.executeSet(cmd);
                } else if (cmd.startsWith("log")) {
                    resultString = this.executeLog(cmd);
                } else if (cmd.startsWith("file")) {
                    resultString = this.executeFile(cmd);
                } else if (cmd.startsWith("list")) {
                    resultString = this.executeList(cmd);
                } else if (cmd.startsWith("func")) {
                    resultString = this.executeFunc(cmd);
                } else if (cmd.startsWith("param")) {
                    resultString = this.executeParam(cmd);
                } else if (cmd.startsWith("cube")) {
                    resultString = this.executeCube(cmd);
                } else if (cmd.startsWith("error")) {
                    resultString = this.executeError(cmd);
                } else if (cmd.startsWith("echo")) {
                    resultString = this.executeEcho(cmd);
                } else if (cmd.startsWith("expr")) {
                    resultString = this.executeExpr(cmd);
                } else if (cmd.equals("=")) {
                    resultString = this.reExecuteMdxCmd();
                } else if (cmd.startsWith("exit")) break;
                if (resultString != null) {
                    inMdxCmd = false;
                    continue;
                }
            }
            if (line == null || line.length() == 1 && (line.charAt(0) == '=' || line.charAt(0) == '~')) {
                if (line == null || line.charAt(0) == '=') {
                    mdxCmd = buf.toString().trim();
                    this.debug("mdxCmd=\"" + mdxCmd + "\"");
                    resultString = this.executeMdxCmd(mdxCmd);
                }
                inMdxCmd = false;
                continue;
            }
            if (line.length() <= 0) continue;
            inMdxCmd = true;
            if (line.endsWith(SEMI_COLON_STRING)) {
                buf.append(line.substring(0, line.length() - 1));
                mdxCmd = buf.toString().trim();
                this.debug("mdxCmd=\"" + mdxCmd + "\"");
                resultString = this.executeMdxCmd(mdxCmd);
                inMdxCmd = false;
                continue;
            }
            buf.append(line);
            buf.append(nl);
        }
    }

    protected void printResults(String resultString) {
        if (resultString != null && (resultString = resultString.trim()).length() > 0) {
            this.out.println(resultString);
            this.out.flush();
        }
    }

    protected void printQueryTime() {
        if (Options.access$000(this.options) && this.queryTime != -1L) {
            this.out.println("time[" + this.queryTime + "ms]");
            this.out.flush();
            this.queryTime = -1L;
        }
    }

    protected static String readLine(Reader reader, boolean inMdxCmd) throws IOException {
        StringBuffer buf = new StringBuffer(128);
        StringBuffer line = new StringBuffer(128);
        int i = CmdRunner.getLine(reader, line);
        boolean inName = false;
        for (int offset = 0; offset < line.length(); ++offset) {
            char c = line.charAt(offset);
            if (c == '\\') {
                buf.append('\\');
                buf.append(line.charAt(++offset));
                continue;
            }
            if (!(inName || c != '\"' && c != '\'')) {
                i = CmdRunner.readString(reader, line, offset, buf, i);
                offset = 0;
                continue;
            }
            int commentType = -1;
            if (c == '[') {
                inName = true;
            } else if (c == ']') {
                inName = false;
            } else if (!inName) {
                for (int x = 0; x < commentDelim.length; ++x) {
                    if (c != commentStartChars[x]) continue;
                    String startComment = commentDelim[x][0];
                    boolean foundCommentStart = true;
                    for (int j = 1; j + offset < line.length() && j < startComment.length(); ++j) {
                        if (line.charAt(j + offset) == startComment.charAt(j)) continue;
                        foundCommentStart = false;
                    }
                    if (!foundCommentStart) continue;
                    if (x == 0) {
                        if (offset != 0) continue;
                        commentType = x;
                        break;
                    }
                    commentType = x;
                    break;
                }
            }
            if (commentType == -1) {
                buf.append(c);
                continue;
            }
            if (commentDelim[commentType][1] == null) break;
            i = CmdRunner.readBlock(reader, line, offset, commentDelim[commentType][0], commentDelim[commentType][1], false, false, buf, i);
            offset = 0;
        }
        if (i == -1 && buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    protected static int getLine(Reader reader, StringBuffer line) throws IOException {
        int i;
        line.setLength(0);
        do {
            if ((i = reader.read()) == -1) {
                return i;
            }
            line.append((char)i);
        } while (i != 10 && i != 13);
        return i;
    }

    protected static int readString(Reader reader, StringBuffer line, int offset, StringBuffer buf, int i) throws IOException {
        String delim = line.substring(offset, offset + 1);
        return CmdRunner.readBlock(reader, line, offset, delim, delim, true, true, buf, i);
    }

    protected static int readBlock(Reader reader, StringBuffer line, int offset, String startDelim, String endDelim, boolean allowEscape, boolean addToBuf, StringBuffer buf, int i) throws IOException {
        int depth = 1;
        if (addToBuf) {
            buf.append(startDelim);
        }
        offset += startDelim.length();
        while (true) {
            if (line.substring(offset).startsWith(endDelim)) {
                if (addToBuf) {
                    buf.append(endDelim);
                }
                offset += endDelim.length();
                if (--depth != 0) continue;
                break;
            }
            if (allowNestedComments && line.substring(offset).startsWith(startDelim)) {
                if (addToBuf) {
                    buf.append(startDelim);
                }
                offset += startDelim.length();
                ++depth;
                continue;
            }
            if (offset < line.length()) {
                char c = line.charAt(offset++);
                if (allowEscape && c == '\\') {
                    if (addToBuf) {
                        buf.append('\\');
                    }
                    if (offset >= line.length()) continue;
                    if (addToBuf) {
                        buf.append(line.charAt(offset));
                    }
                    ++offset;
                    continue;
                }
                if (!addToBuf) continue;
                buf.append(c);
                continue;
            }
            if (i == -1) break;
            i = CmdRunner.getLine(reader, line);
            offset = 0;
            if (line.length() == 0) break;
        }
        if (offset > 0) {
            line.delete(0, offset - 1);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSoapXmla(File file, int validateXmlaResponse) throws Exception {
        String catalogURL = CmdRunner.getCatalogURLProperty();
        String[][] catalogNameUrls = new String[][]{{CATALOG_NAME, catalogURL}};
        long start = System.currentTimeMillis();
        byte[] bytes = null;
        try {
            bytes = XmlaSupport.processSoapXmla(file, this.getConnectString(), catalogNameUrls, null);
        }
        finally {
            this.queryTime = System.currentTimeMillis() - start;
            this.totalQueryTime += this.queryTime;
        }
        String response = new String(bytes);
        this.out.println(response);
        switch (validateXmlaResponse) {
            case 1: {
                break;
            }
            case 2: {
                XmlaSupport.validateSchemaSoapXmla(bytes);
                this.out.println("XML Data is Valid");
                break;
            }
            case 3: {
                XmlaSupport.validateSoapXmlaUsingXpath(bytes);
                this.out.println("XML Data is Valid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processXmla(File file, int validateXmlaResponce) throws Exception {
        String catalogURL = CmdRunner.getCatalogURLProperty();
        String[][] catalogNameUrls = new String[][]{{CATALOG_NAME, catalogURL}};
        long start = System.currentTimeMillis();
        byte[] bytes = null;
        try {
            bytes = XmlaSupport.processXmla(file, this.getConnectString(), catalogNameUrls);
        }
        finally {
            this.queryTime = System.currentTimeMillis() - start;
            this.totalQueryTime += this.queryTime;
        }
        String response = new String(bytes);
        this.out.println(response);
        switch (validateXmlaResponce) {
            case 1: {
                break;
            }
            case 2: {
                XmlaSupport.validateSchemaXmla(bytes);
                this.out.println("XML Data is Valid");
                break;
            }
            case 3: {
                XmlaSupport.validateXmlaUsingXpath(bytes);
                this.out.println("XML Data is Valid");
            }
        }
    }

    protected static String executeHelp(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        int cmd = 0;
        if (tokens.length == 1) {
            buf.append("Commands:");
            cmd = 8191;
        } else if (tokens.length == 2) {
            String cmdName = tokens[1];
            cmd = cmdName.equals("help") ? 1 : (cmdName.equals("set") ? 2 : (cmdName.equals("log") ? 4 : (cmdName.equals("file") ? 8 : (cmdName.equals("list") ? 16 : (cmdName.equals("func") ? 64 : (cmdName.equals("param") ? 128 : (cmdName.equals("cube") ? 256 : (cmdName.equals("error") ? 512 : (cmdName.equals("echo") ? 1024 : (cmdName.equals("exit") ? 4096 : 0))))))))));
        }
        if (cmd == 0) {
            buf.append("Unknown help command: ");
            buf.append(mdxCmd);
            buf.append(nl);
            buf.append("Type \"help\" for list of commands");
        }
        if ((cmd & 1) != 0) {
            buf.append(nl);
            CmdRunner.appendIndent(buf, 1);
            buf.append("help");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("Prints this text");
        }
        if ((cmd & 2) != 0) {
            buf.append(nl);
            CmdRunner.appendSet(buf);
        }
        if ((cmd & 4) != 0) {
            buf.append(nl);
            CmdRunner.appendLog(buf);
        }
        if ((cmd & 8) != 0) {
            buf.append(nl);
            CmdRunner.appendFile(buf);
        }
        if ((cmd & 0x10) != 0) {
            buf.append(nl);
            CmdRunner.appendList(buf);
        }
        if ((cmd & 0x20) != 0) {
            buf.append(nl);
            CmdRunner.appendIndent(buf, 1);
            buf.append("<mdx query> <cr> ( '");
            buf.append('=');
            buf.append("' | '");
            buf.append('~');
            buf.append("' ) <cr>");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("Execute or cancel mdx query.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("An mdx query may span one or more lines.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("After the last line of the query has been entered,");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("on the next line a single execute character, '");
            buf.append('=');
            buf.append("', may be entered");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("followed by a carriage return.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("The lone '");
            buf.append('=');
            buf.append("' informs the interpreter that the query has");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("has been entered and is ready to execute.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("At anytime during the entry of a query the cancel");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("character, '");
            buf.append('~');
            buf.append("', may be entered alone on a line.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("This removes all of the query text from the");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("the command interpreter.");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("Queries can also be ended by using a semicolon ';'");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 3);
            buf.append("at the end of a line.");
        }
        if ((cmd & 0x40) != 0) {
            buf.append(nl);
            CmdRunner.appendFunc(buf);
        }
        if ((cmd & 0x80) != 0) {
            buf.append(nl);
            CmdRunner.appendParam(buf);
        }
        if ((cmd & 0x100) != 0) {
            buf.append(nl);
            CmdRunner.appendCube(buf);
        }
        if ((cmd & 0x200) != 0) {
            buf.append(nl);
            CmdRunner.appendError(buf);
        }
        if ((cmd & 0x400) != 0) {
            buf.append(nl);
            CmdRunner.appendEcho(buf);
        }
        if ((cmd & 0x800) != 0) {
            buf.append(nl);
            CmdRunner.appendExpr(buf);
        }
        if (cmd == 8191) {
            buf.append(nl);
            CmdRunner.appendIndent(buf, 1);
            buf.append("= <cr>");
            buf.append(nl);
            CmdRunner.appendIndent(buf, 2);
            buf.append("Re-Execute mdx query.");
        }
        if ((cmd & 0x1000) != 0) {
            buf.append(nl);
            CmdRunner.appendExit(buf);
        }
        return buf.toString();
    }

    protected static void appendIndent(StringBuffer buf, int i) {
        while (i-- > 0) {
            buf.append(INDENT);
        }
    }

    protected static void appendSet(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("set [ property[=value ] ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no args, prints all mondrian properties and values.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"property\" prints property's value.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"property=value\" set property to that value.");
    }

    protected String executeSet(String mdxCmd) {
        StringBuffer buf = new StringBuffer(400);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            CmdRunner.listPropertiesAll(buf);
        } else if (tokens.length == 2) {
            String arg = tokens[1];
            int index = arg.indexOf(61);
            if (index == -1) {
                CmdRunner.listProperty(arg, buf);
            } else {
                String[] nv = arg.split("=");
                String name = nv[0];
                String value = nv[1];
                if (CmdRunner.isProperty(name)) {
                    try {
                        if (CmdRunner.setProperty(name, value)) {
                            this.connectString = null;
                        }
                    }
                    catch (Exception ex) {
                        this.setError(ex);
                    }
                } else {
                    buf.append("Bad property name:");
                    buf.append(name);
                    buf.append(nl);
                }
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendSet(buf);
        }
        return buf.toString();
    }

    protected static void appendLog(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("log [ classname[=level ] ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no args, prints the current log level of all classes.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"classname\" prints the current log level of the class.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"classname=level\" set log level to new value.");
    }

    protected String executeLog(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            Enumeration e = LogManager.getCurrentLoggers();
            while (e.hasMoreElements()) {
                Logger logger = (Logger)e.nextElement();
                buf.append(logger.getName());
                buf.append(':');
                buf.append(logger.getLevel());
                buf.append(nl);
            }
        } else if (tokens.length == 2) {
            String arg = tokens[1];
            int index = arg.indexOf(61);
            if (index == -1) {
                Logger logger = LogManager.exists((String)arg);
                if (logger == null) {
                    buf.append("Bad log name: ");
                    buf.append(arg);
                    buf.append(nl);
                } else {
                    buf.append(logger.getName());
                    buf.append(':');
                    buf.append(logger.getLevel());
                    buf.append(nl);
                }
            } else {
                String[] nv = arg.split("=");
                String classname = nv[0];
                String levelStr = nv[1];
                Logger logger = LogManager.getLogger((String)classname);
                if (logger == null) {
                    buf.append("Bad log name: ");
                    buf.append(classname);
                    buf.append(nl);
                } else {
                    Level level = Level.toLevel((String)levelStr, null);
                    if (level == null) {
                        buf.append("Bad log level: ");
                        buf.append(levelStr);
                        buf.append(nl);
                    } else {
                        logger.setLevel(level);
                    }
                }
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendSet(buf);
        }
        return buf.toString();
    }

    protected static void appendFile(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("file [ filename | '=' ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no args, prints the last filename executed.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"filename\", read and execute filename .");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"=\" character, re-read and re-execute previous filename .");
    }

    protected String executeFile(String mdxCmd) {
        StringBuffer buf = new StringBuffer(512);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            if (this.filename != null) {
                buf.append(this.filename);
            }
        } else if (tokens.length == 2) {
            String token = tokens[1];
            String nameOfFile = null;
            if (token.length() == 1 && token.charAt(0) == '=') {
                if (this.filename == null) {
                    buf.append("Bad command usage: \"");
                    buf.append(mdxCmd);
                    buf.append("\", no file to re-execute");
                    buf.append(nl);
                    CmdRunner.appendFile(buf);
                } else {
                    nameOfFile = this.filename;
                }
            } else {
                nameOfFile = token;
            }
            if (nameOfFile != null) {
                this.filename = nameOfFile;
                try {
                    this.commandLoop(new File(this.filename));
                }
                catch (IOException ex) {
                    this.setError(ex);
                    buf.append("Error: " + ex);
                }
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendFile(buf);
        }
        return buf.toString();
    }

    protected static void appendList(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("list [ cmd | result ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no arguments, list previous cmd and result");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"cmd\" argument, list the last mdx query cmd.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"result\" argument, list the last mdx query result.");
    }

    protected String executeList(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            if (this.mdxCmd != null) {
                buf.append(this.mdxCmd);
                if (this.mdxResult != null) {
                    buf.append(nl);
                    buf.append(this.mdxResult);
                }
            } else if (this.mdxResult != null) {
                buf.append(this.mdxResult);
            }
        } else if (tokens.length == 2) {
            String arg = tokens[1];
            if (arg.equals("cmd")) {
                if (this.mdxCmd != null) {
                    buf.append(this.mdxCmd);
                }
            } else if (arg.equals("result")) {
                if (this.mdxResult != null) {
                    buf.append(this.mdxResult);
                }
            } else {
                buf.append("Bad sub command usage:");
                buf.append(mdxCmd);
                buf.append(nl);
                CmdRunner.appendList(buf);
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendList(buf);
        }
        return buf.toString();
    }

    protected static void appendFunc(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("func [ name ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no arguments, list all defined function names");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"name\" argument, display the functions:");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("name, description, and syntax");
    }

    protected String executeFunc(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        FunTable funTable = this.getConnection().getSchema().getFunTable();
        if (tokens.length == 1) {
            List<FunInfo> funInfoList = funTable.getFunInfoList();
            Iterator<FunInfo> it = funInfoList.iterator();
            String prevName = null;
            while (it.hasNext()) {
                FunInfo fi = it.next();
                String name = fi.getName();
                if (prevName != null && prevName.equals(name)) continue;
                buf.append(name);
                buf.append(nl);
                prevName = name;
            }
        } else if (tokens.length == 2) {
            String funcname = tokens[1];
            List<FunInfo> funInfoList = funTable.getFunInfoList();
            ArrayList<FunInfo> matches = new ArrayList<FunInfo>();
            Iterator<FunInfo> it = funInfoList.iterator();
            while (it.hasNext()) {
                FunInfo fi = it.next();
                if (!fi.getName().equalsIgnoreCase(funcname)) continue;
                matches.add(fi);
            }
            if (matches.size() == 0) {
                buf.append("Bad function name \"");
                buf.append(funcname);
                buf.append("\", usage:");
                buf.append(nl);
                CmdRunner.appendList(buf);
            } else {
                it = matches.iterator();
                boolean doname = true;
                while (it.hasNext()) {
                    FunInfo fi = it.next();
                    if (doname) {
                        buf.append(fi.getName());
                        buf.append(nl);
                        doname = false;
                    }
                    CmdRunner.appendIndent(buf, 1);
                    buf.append(fi.getDescription());
                    buf.append(nl);
                    String[] sigs = fi.getSignatures();
                    if (sigs == null) {
                        CmdRunner.appendIndent(buf, 2);
                        buf.append("Signature: ");
                        buf.append("NONE");
                        buf.append(nl);
                        continue;
                    }
                    for (int i = 0; i < sigs.length; ++i) {
                        CmdRunner.appendIndent(buf, 2);
                        buf.append(sigs[i]);
                        buf.append(nl);
                    }
                }
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendList(buf);
        }
        return buf.toString();
    }

    protected static void appendParam(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("param [ name[=value ] ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no argumnts, all param name/value pairs are printed.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"name\" argument, the value of the param is printed.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"name=value\" sets the parameter with name to value.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append(" If name is null, then unsets all parameters");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append(" If value is null, then unsets the parameter associated with value");
    }

    protected String executeParam(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            CmdRunner.listParameterNameValues(buf);
        } else if (tokens.length == 2) {
            String arg = tokens[1];
            int index = arg.indexOf(61);
            if (index == -1) {
                String name = arg;
                if (CmdRunner.isParam(name)) {
                    CmdRunner.listParam(name, buf);
                } else {
                    buf.append("Bad parameter name:");
                    buf.append(name);
                    buf.append(nl);
                }
            } else {
                String[] nv = arg.split("=");
                String name = nv.length == 0 ? null : nv[0];
                String value = nv.length == 2 ? nv[1] : null;
                CmdRunner.setParameter(name, value);
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendSet(buf);
        }
        return buf.toString();
    }

    protected static void appendCube(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("cube [ cubename [ name [=value | command] ] ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no argumnts, all cubes are listed by name.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"cubename\" argument, cube attribute name/values for:");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("fact table (readonly)");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("aggregate caching (readwrite)");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("are printed");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"cubename name=value\" sets the readwrite attribute with name to value.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"cubename command\" executes the commands:");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("clearCache");
    }

    protected String executeCube(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            this.listCubeName(buf);
        } else if (tokens.length == 2) {
            String cubename = tokens[1];
            this.listCubeAttribues(cubename, buf);
        } else if (tokens.length == 3) {
            String cubename = tokens[1];
            String arg = tokens[2];
            int index = arg.indexOf(61);
            if (index == -1) {
                String command = arg;
                this.executeCubeCommand(cubename, command, buf);
            } else {
                String[] nv = arg.split("=");
                String name = nv.length == 0 ? null : nv[0];
                String value = nv.length == 2 ? nv[1] : null;
                this.setCubeAttribute(cubename, name, value, buf);
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendSet(buf);
        }
        return buf.toString();
    }

    protected static void appendError(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("error [ msg | stack ] <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With no argumnts, both message and stack are printed.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"msg\" argument, the Error message is printed.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("With \"stack\" argument, the Error stack trace is printed.");
    }

    protected String executeError(String mdxCmd) {
        StringBuffer buf = new StringBuffer(200);
        String[] tokens = mdxCmd.split("\\s+");
        if (tokens.length == 1) {
            if (this.error != null) {
                buf.append(this.error);
                if (this.stack != null) {
                    buf.append(nl);
                    buf.append(this.stack);
                }
            } else if (this.stack != null) {
                buf.append(this.stack);
            }
        } else if (tokens.length == 2) {
            String arg = tokens[1];
            if (arg.equals("msg")) {
                if (this.error != null) {
                    buf.append(this.error);
                }
            } else if (arg.equals("stack")) {
                if (this.stack != null) {
                    buf.append(this.stack);
                }
            } else {
                buf.append("Bad sub command usage:");
                buf.append(mdxCmd);
                buf.append(nl);
                CmdRunner.appendList(buf);
            }
        } else {
            buf.append("Bad command usage: \"");
            buf.append(mdxCmd);
            buf.append('\"');
            buf.append(nl);
            CmdRunner.appendList(buf);
        }
        return buf.toString();
    }

    protected static void appendEcho(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("echo text <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("echo text to standard out.");
    }

    protected String executeEcho(String mdxCmd) {
        try {
            String resultString = mdxCmd.length() == 4 ? "" : mdxCmd.substring(4);
            return resultString;
        }
        catch (Exception ex) {
            this.setError(ex);
            return null;
        }
    }

    protected static void appendExpr(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("expr cubename expression<cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("evaluate an expression against a cube.");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("where: ");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("cubename is single word or string using [], '' or \"\"");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 3);
        buf.append("expression is string using \"\"");
    }

    protected String executeExpr(String mdxCmd) {
        StringBuffer buf = new StringBuffer(256);
        mdxCmd = mdxCmd.length() == 5 ? "" : mdxCmd.substring(5);
        String regex = "(\"[^\"]+\"|'[^']+'|\\[[^\\]]+\\]|[^\\s]+)\\s+.*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(mdxCmd);
        boolean b = m.matches();
        if (!b) {
            buf.append("Could not parse into \"cubename expression\" command:");
            buf.append(nl);
            buf.append(mdxCmd);
            String msg = buf.toString();
            this.setError(msg);
            return msg;
        }
        String cubeName = m.group(1);
        String expression = mdxCmd.substring(cubeName.length() + 1);
        if (cubeName.charAt(0) == '\"') {
            cubeName = cubeName.substring(1, cubeName.length() - 1);
        } else if (cubeName.charAt(0) == '\'') {
            cubeName = cubeName.substring(1, cubeName.length() - 1);
        } else if (cubeName.charAt(0) == '[') {
            cubeName = cubeName.substring(1, cubeName.length() - 1);
        }
        int len = expression.length();
        if (expression.charAt(0) == '\"') {
            if (expression.charAt(len - 1) != '\"') {
                buf.append("Missing end '\"' in expression:");
                buf.append(nl);
                buf.append(expression);
                String msg = buf.toString();
                this.setError(msg);
                return msg;
            }
            expression = expression.substring(1, len - 1);
        } else if (expression.charAt(0) == '\'') {
            if (expression.charAt(len - 1) != '\'') {
                buf.append("Missing end \"'\" in expression:");
                buf.append(nl);
                buf.append(expression);
                String msg = buf.toString();
                this.setError(msg);
                return msg;
            }
            expression = expression.substring(1, len - 1);
        }
        Cube cube = this.getCube(cubeName);
        if (cube == null) {
            buf.append("No cube found with name \"");
            buf.append(cubeName);
            buf.append("\"");
            String msg = buf.toString();
            this.setError(msg);
            return msg;
        }
        try {
            String resultString;
            if (cubeName.indexOf(32) >= 0 && cubeName.charAt(0) != '[') {
                cubeName = Util.quoteMdxIdentifier(cubeName);
            }
            int c = 39;
            if (expression.indexOf(39) != -1) {
                int start = 0;
                int index = expression.indexOf(39, start);
                if (index == 0) {
                    buf.append("Double \"''\" starting expression:");
                    buf.append(nl);
                    buf.append(expression);
                    String msg = buf.toString();
                    this.setError(msg);
                    return msg;
                }
                while (index != -1) {
                    if (expression.charAt(index - 1) != '\\') {
                        buf.append("Non-escaped \"'\" in expression:");
                        buf.append(nl);
                        buf.append(expression);
                        String msg = buf.toString();
                        this.setError(msg);
                        return msg;
                    }
                    start = index + 1;
                    index = expression.indexOf(39, start);
                }
            }
            StringBuffer queryStringBuf = new StringBuffer(64);
            queryStringBuf.append("with member [Measures].[Foo] as ");
            queryStringBuf.append('\'');
            queryStringBuf.append(expression);
            queryStringBuf.append('\'');
            queryStringBuf.append(" select {[Measures].[Foo]} on columns from ");
            queryStringBuf.append(cubeName);
            String queryString = queryStringBuf.toString();
            Result result = this.runQuery(queryString, true);
            this.mdxResult = resultString = result.getCell(new int[]{0}).getFormattedValue();
            this.clearError();
            buf.append(resultString);
        }
        catch (Exception ex) {
            this.setError(ex);
            buf.append("Error: " + ex);
        }
        return buf.toString();
    }

    protected static void appendExit(StringBuffer buf) {
        CmdRunner.appendIndent(buf, 1);
        buf.append("exit <cr>");
        buf.append(nl);
        CmdRunner.appendIndent(buf, 2);
        buf.append("Exit mdx command interpreter.");
    }

    protected String reExecuteMdxCmd() {
        if (this.mdxCmd == null) {
            return "No command to execute";
        }
        return this.executeMdxCmd(this.mdxCmd);
    }

    protected String executeMdxCmd(String mdxCmd) {
        this.mdxCmd = mdxCmd;
        try {
            String resultString;
            this.mdxResult = resultString = this.execute(mdxCmd);
            this.clearError();
            return resultString;
        }
        catch (Exception ex) {
            this.setError(ex);
            return null;
        }
    }

    protected static void loadPropertiesFromFile(String propFile) throws IOException {
        MondrianProperties.instance().load(new FileInputStream(propFile));
    }

    protected static void usage(String msg, PrintStream out) {
        StringBuffer buf = new StringBuffer(256);
        if (msg != null) {
            buf.append(msg);
            buf.append(nl);
        }
        buf.append("Usage: mondrian.tui.CmdRunner args");
        buf.append(nl);
        buf.append("  args:");
        buf.append(nl);
        buf.append("  -h               : print this usage text");
        buf.append(nl);
        buf.append("  -d               : enable local debugging");
        buf.append(nl);
        buf.append("  -t               : time each mdx query");
        buf.append(nl);
        buf.append("  -nocache         : turn off in-memory aggregate caching");
        buf.append(nl);
        buf.append("                     for all cubes regardless of setting");
        buf.append(nl);
        buf.append("                     in schema");
        buf.append(nl);
        buf.append("  -rc              : do NOT reload connections each query");
        buf.append(nl);
        buf.append("                     (default is to reload connections)");
        buf.append(nl);
        buf.append("  -p propertyfile  : load mondrian properties");
        buf.append(nl);
        buf.append("  -f mdx_filename+ : execute mdx in one or more files");
        buf.append(nl);
        buf.append("  -x xmla_filename+: execute XMLA in one or more files");
        buf.append("                     the XMLA request has no SOAP wrapper");
        buf.append(nl);
        buf.append("  -xs soap_xmla_filename+ ");
        buf.append("                   : execute Soap XMLA in one or more files");
        buf.append("                     the XMLA request has a SOAP wrapper");
        buf.append(nl);
        buf.append("  -vt              : validate xmla response using transforms");
        buf.append("                     only used with -x or -xs flags");
        buf.append(nl);
        buf.append("  -vx              : validate xmla response using xpaths");
        buf.append("                     only used with -x or -xs flags");
        buf.append(nl);
        buf.append("  mdx_cmd          : execute mdx_cmd");
        buf.append(nl);
        out.println(buf.toString());
    }

    private static void setDefaultCommentState() {
        allowNestedComments = Scanner.getNestedCommentsState();
        String[][] scannerCommentsDelimiters = Scanner.getCommentDelimiters();
        commentDelim = new String[scannerCommentsDelimiters.length + 1][2];
        commentStartChars = new char[scannerCommentsDelimiters.length + 1];
        CmdRunner.commentDelim[0][0] = "#";
        CmdRunner.commentDelim[0][1] = null;
        CmdRunner.commentStartChars[0] = commentDelim[0][0].charAt(0);
        for (int x = 0; x < scannerCommentsDelimiters.length; ++x) {
            CmdRunner.commentDelim[x + 1][0] = scannerCommentsDelimiters[x][0];
            CmdRunner.commentDelim[x + 1][1] = scannerCommentsDelimiters[x][1];
            CmdRunner.commentStartChars[x + 1] = commentDelim[x + 1][0].charAt(0);
        }
    }

    public static void main(String[] args) throws Exception {
        Options options;
        try {
            options = CmdRunner.parseOptions(args);
        }
        catch (BadOption badOption) {
            CmdRunner.usage(badOption.getMessage(), System.out);
            return;
        }
        CmdRunner cmdRunner = new CmdRunner(options, new PrintWriter(System.out));
        if (Options.access$200(options)) {
            cmdRunner.noCubeCaching();
        }
        if (!Options.access$300(options).isEmpty()) {
            Iterator i$ = Options.access$300(options).iterator();
            while (i$.hasNext()) {
                String filename;
                cmdRunner.filename = filename = (String)i$.next();
                switch (Options.access$400(options)) {
                    case 1: {
                        cmdRunner.commandLoop(new File(filename));
                        break;
                    }
                    case 2: {
                        cmdRunner.processXmla(new File(filename), Options.access$500(options));
                        break;
                    }
                    default: {
                        cmdRunner.processSoapXmla(new File(filename), Options.access$500(options));
                    }
                }
                if (cmdRunner.error == null) continue;
                System.err.println(filename);
                System.err.println(cmdRunner.error);
                if (cmdRunner.stack != null) {
                    System.err.println(cmdRunner.stack);
                }
                cmdRunner.printQueryTime();
                cmdRunner.clearError();
            }
        } else if (Options.access$600(options) != null) {
            cmdRunner.commandLoop(Options.access$600(options), false);
            if (cmdRunner.error != null) {
                System.err.println(cmdRunner.error);
                if (cmdRunner.stack != null) {
                    System.err.println(cmdRunner.stack);
                }
            }
        } else {
            cmdRunner.commandLoop(true);
        }
        cmdRunner.printTotalQueryTime();
    }

    private void printTotalQueryTime() {
        if (Options.access$000(this.options) && this.totalQueryTime != this.queryTime) {
            this.out.println("total[" + this.totalQueryTime + "ms]");
        }
        this.out.flush();
    }

    private static Options parseOptions(String[] args) throws BadOption, IOException {
        Options options = new Options();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h")) {
                throw new BadOption(null);
            }
            if (arg.equals("-d")) {
                Options.access$102(options, true);
                continue;
            }
            if (arg.equals("-t")) {
                Options.access$002(options, true);
                continue;
            }
            if (arg.equals("-nocache")) {
                Options.access$202(options, true);
                continue;
            }
            if (arg.equals("-rc")) {
                RELOAD_CONNECTION = false;
                continue;
            }
            if (arg.equals("-vt")) {
                Options.access$502(options, 2);
                continue;
            }
            if (arg.equals("-vx")) {
                Options.access$502(options, 3);
                continue;
            }
            if (arg.equals("-f")) {
                if (++i == args.length) {
                    throw new BadOption("no mdx filename given");
                }
                Options.access$300(options).add(args[i]);
                continue;
            }
            if (arg.equals("-x")) {
                if (++i == args.length) {
                    throw new BadOption("no XMLA filename given");
                }
                Options.access$402(options, 2);
                Options.access$300(options).add(args[i]);
                continue;
            }
            if (arg.equals("-xs")) {
                if (++i == args.length) {
                    throw new BadOption("no XMLA filename given");
                }
                Options.access$402(options, 3);
                Options.access$300(options).add(args[i]);
                continue;
            }
            if (arg.equals("-p")) {
                if (++i == args.length) {
                    throw new BadOption("no mondrian properties file given");
                }
                String propFile = args[i];
                CmdRunner.loadPropertiesFromFile(propFile);
                continue;
            }
            if (!Options.access$300(options).isEmpty()) {
                Options.access$300(options).add(arg);
                continue;
            }
            Options.access$602(options, arg);
        }
        return options;
    }

    static {
        CmdRunner.setDefaultCommentState();
        nf = NumberFormat.getInstance();
    }

    private static class BadOption
    extends Exception {
        BadOption(String msg) {
            super(msg);
        }
    }

    protected static class Options {
        private boolean debug = false;
        private boolean timeQueries;
        private boolean noCache = false;
        private int validateXmlaResponse = 1;
        private final List<String> filenames = new ArrayList<String>();
        private int doingWhat = 1;
        private String singleMdxCmd;

        protected Options() {
        }

        static boolean access$002(Options x0, boolean x1) {
            x0.timeQueries = x1;
            return x0.timeQueries;
        }

        static boolean access$000(Options x0) {
            return x0.timeQueries;
        }

        static boolean access$100(Options x0) {
            return x0.debug;
        }

        static boolean access$200(Options x0) {
            return x0.noCache;
        }

        static List access$300(Options x0) {
            return x0.filenames;
        }

        static int access$400(Options x0) {
            return x0.doingWhat;
        }

        static int access$500(Options x0) {
            return x0.validateXmlaResponse;
        }

        static String access$600(Options x0) {
            return x0.singleMdxCmd;
        }

        static boolean access$102(Options x0, boolean x1) {
            x0.debug = x1;
            return x0.debug;
        }

        static boolean access$202(Options x0, boolean x1) {
            x0.noCache = x1;
            return x0.noCache;
        }

        static int access$502(Options x0, int x1) {
            x0.validateXmlaResponse = x1;
            return x0.validateXmlaResponse;
        }

        static int access$402(Options x0, int x1) {
            x0.doingWhat = x1;
            return x0.doingWhat;
        }

        static String access$602(Options x0, String x1) {
            x0.singleMdxCmd = x1;
            return x0.singleMdxCmd;
        }
    }

    private static class Expr {
        final Object value;
        final Type type;

        Expr(Object value, Type type) {
            this.value = value;
            this.type = type;
        }

        /*
         * Signature claims super is java.lang.Enum<mondrian.tui.CmdRunner$Expr$Type>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Type
        extends Enum_ {
            public static final /* enum */ Type STRING = new Type("STRING", 0);
            public static final /* enum */ Type NUMERIC = new Type("NUMERIC", 1);
            public static final /* enum */ Type MEMBER = new Type("MEMBER", 2);
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ long serialVersionUID = 0L;
            private static final /* synthetic */ Class class$mondrian$tui$CmdRunner$Expr$Type;

            public static final Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String name) {
                return (Type)Enum_.valueOf((Class)(class$mondrian$tui$CmdRunner$Expr$Type == null ? (class$mondrian$tui$CmdRunner$Expr$Type = Type.class$("mondrian.tui.CmdRunner$Expr$Type")) : class$mondrian$tui$CmdRunner$Expr$Type), (String)name);
            }

            private Type(String string, int n) {
                super(string, n);
            }

            static {
                $VALUES = new Type[]{STRING, NUMERIC, MEMBER};
                Enum_.setEnumValues((Object[])Type.values(), (Class)(class$mondrian$tui$CmdRunner$Expr$Type == null ? (class$mondrian$tui$CmdRunner$Expr$Type = Type.class$("mondrian.tui.CmdRunner$Expr$Type")) : class$mondrian$tui$CmdRunner$Expr$Type));
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }
    }

    private static class PropertyInfo {
        private final List<Property> propertyList = new ArrayList<Property>();
        private final List<String> propertyNameList = new ArrayList<String>();
        private static final /* synthetic */ Class class$org$eigenbase$util$property$Property;

        PropertyInfo(MondrianProperties properties) {
            Field[] fields;
            Class<?> clazz = ((Object)((Object)properties)).getClass();
            Field[] arr$ = fields = clazz.getFields();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Property property;
                Field field = arr$[i$];
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !(class$org$eigenbase$util$property$Property == null ? PropertyInfo.class$("org.eigenbase.util.property.Property") : class$org$eigenbase$util$property$Property).isAssignableFrom(field.getType())) continue;
                try {
                    property = (Property)field.get((Object)properties);
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                this.propertyList.add(property);
                this.propertyNameList.add(field.getName());
            }
        }

        public int size() {
            return this.propertyList.size();
        }

        public Property getProperty(int i) {
            return this.propertyList.get(i);
        }

        public String getPropertyName(int i) {
            return this.propertyNameList.get(i);
        }

        public static Property lookupProperty(MondrianProperties properties, String propertyName) {
            Field field;
            Class<?> clazz = ((Object)((Object)properties)).getClass();
            try {
                field = clazz.getField(propertyName);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !(class$org$eigenbase$util$property$Property == null ? (class$org$eigenbase$util$property$Property = PropertyInfo.class$("org.eigenbase.util.property.Property")) : class$org$eigenbase$util$property$Property).isAssignableFrom(field.getType())) {
                return null;
            }
            try {
                return (Property)field.get((Object)properties);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

