/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import com.rc.retroweaver.runtime.Autobox;
import java.util.Iterator;
import mondrian.olap.Hierarchy;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.DefaultRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;

class DefaultRecognizer
extends Recognizer {
    private static final MondrianResource mres = MondrianResource.instance();
    private final DefaultRules aggDefault;

    DefaultRecognizer(DefaultRules aggDefault, RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        super(star, dbFactTable, aggTable, msgRecorder);
        this.aggDefault = aggDefault;
    }

    DefaultRules getRules() {
        return this.aggDefault;
    }

    protected Recognizer.Matcher getIgnoreMatcher() {
        return this.getRules().getIgnoreMatcher();
    }

    protected Recognizer.Matcher getFactCountMatcher() {
        return this.getRules().getFactCountMatcher();
    }

    protected Recognizer.Matcher getMeasureMatcher(JdbcSchema.Table.Column.Usage factUsage) {
        String measureName = factUsage.getSymbolicName();
        String measureColumnName = factUsage.getColumn().getName();
        String aggregateName = factUsage.getAggregator().getName();
        return this.getRules().getMeasureMatcher(measureName, measureColumnName, aggregateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkMeasures() {
        this.msgRecorder.pushContextName("DefaultRecognizer.checkMeasures");
        try {
            int measureCountCount = 0;
            Iterator<JdbcSchema.Table.Column.Usage> it = this.dbFactTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
            while (it.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = it.next();
                Recognizer.Matcher matcher = this.getMeasureMatcher(factUsage);
                int matchCount = 0;
                Iterator<JdbcSchema.Table.Column> i$ = this.aggTable.getColumns().iterator();
                while (i$.hasNext()) {
                    JdbcSchema.Table.Column aggColumn = i$.next();
                    if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !matcher.matches(aggColumn.getName())) continue;
                    this.makeMeasure(factUsage, aggColumn);
                    ++measureCountCount;
                    ++matchCount;
                }
                if (matchCount <= true) continue;
                String msg = DefaultRecognizer.mres.AggMultipleMatchingMeasure.str(this.msgRecorder.getContext(), this.aggTable.getName(), this.dbFactTable.getName(), Autobox.valueOf((int)matchCount), factUsage.getSymbolicName(), factUsage.getColumn().getName(), factUsage.getAggregator().getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
            int n = measureCountCount;
            return n;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected int matchForeignKey(JdbcSchema.Table.Column.Usage factUsage) {
        JdbcSchema.Table.Column factColumn = factUsage.getColumn();
        Recognizer.Matcher matcher = this.getRules().getForeignKeyMatcher(factColumn.getName());
        int matchCount = 0;
        Iterator<JdbcSchema.Table.Column> i$ = this.aggTable.getColumns().iterator();
        while (i$.hasNext()) {
            JdbcSchema.Table.Column aggColumn = i$.next();
            if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !matcher.matches(aggColumn.getName())) continue;
            this.makeForeignKey(factUsage, aggColumn, null);
            ++matchCount;
        }
        return matchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchLevel(Hierarchy hierarchy, HierarchyUsage hierarchyUsage, RolapLevel level) {
        this.msgRecorder.pushContextName("DefaultRecognizer.matchLevel");
        try {
            String usagePrefix = hierarchyUsage.getUsagePrefix();
            String hierName = hierarchy.getName();
            String levelName = level.getName();
            String levelColumnName = this.getColumnName(level.getKeyExp());
            Recognizer.Matcher matcher = this.getRules().getLevelMatcher(usagePrefix, hierName, levelName, levelColumnName);
            Iterator<JdbcSchema.Table.Column> i$ = this.aggTable.getColumns().iterator();
            while (i$.hasNext()) {
                JdbcSchema.Table.Column aggColumn = i$.next();
                if (!matcher.matches(aggColumn.getName())) continue;
                this.makeLevel(aggColumn, hierarchy, hierarchyUsage, this.getColumnName(level.getKeyExp()), this.getColumnName(level.getKeyExp()), level.getName());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }
}

