/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public class AggGen {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$AggGen == null ? (class$mondrian$rolap$aggmatcher$AggGen = AggGen.class$("mondrian.rolap.aggmatcher.AggGen")) : class$mondrian$rolap$aggmatcher$AggGen));
    private final RolapStar star;
    private final RolapStar.Column[] columns;
    private final Map<RolapStar.Table, List<JdbcSchema.Table.Column.Usage>> collapsedColumnUsages;
    private final Set<JdbcSchema.Table.Column.Usage> notLostColumnUsages;
    private final List<JdbcSchema.Table.Column.Usage> measures;
    private boolean isReady;
    private static final String AGG_LOST_PREFIX = "agg_l_XXX_";
    private static final String AGG_COLLAPSED_PREFIX = "agg_c_XXX_";
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggGen;

    public AggGen(RolapStar star, RolapStar.Column[] columns) {
        this.star = star;
        this.columns = columns;
        this.notLostColumnUsages = new HashSet<JdbcSchema.Table.Column.Usage>();
        this.collapsedColumnUsages = new HashMap<RolapStar.Table, List<JdbcSchema.Table.Column.Usage>>();
        this.measures = new ArrayList<JdbcSchema.Table.Column.Usage>();
        this.init();
    }

    private Logger getLogger() {
        return LOGGER;
    }

    public boolean isReady() {
        return this.isReady;
    }

    protected RolapStar.Table getFactTable() {
        return this.star.getFactTable();
    }

    protected String getFactTableName() {
        return this.getFactTable().getAlias();
    }

    protected SqlQuery getSqlQuery() {
        return this.star.getSqlQuery();
    }

    protected String getFactCount() {
        return "fact_count";
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, RolapStar.Table rt) {
        JdbcSchema.Table jt = this.getTable(db, rt.getAlias());
        return jt == null ? this.getTable(db, rt.getTableName()) : jt;
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, String name) {
        return db.getTable(name);
    }

    protected JdbcSchema.Table.Column getColumn(JdbcSchema.Table table, String name) {
        return table.getColumn(name);
    }

    protected String getRolapStarColumnName(RolapStar.Column rColumn) {
        MondrianDef.Expression expr = rColumn.getExpression();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column cx = (MondrianDef.Column)expr;
            return cx.getColumnName();
        }
        return null;
    }

    protected void addForeignKeyToNotLostColumnUsages(JdbcSchema.Table.Column column) {
        JdbcSchema.Table.Column.Usage usage;
        String cname = column.getName();
        Iterator<JdbcSchema.Table.Column.Usage> i$ = this.notLostColumnUsages.iterator();
        while (i$.hasNext()) {
            JdbcSchema.Table.Column.Usage usage2 = i$.next();
            JdbcSchema.Table.Column c = usage2.getColumn();
            if (!cname.equals(c.getName())) continue;
            return;
        }
        if (column.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY)) {
            Iterator<JdbcSchema.Table.Column.Usage> it = column.getUsages(JdbcSchema.UsageType.FOREIGN_KEY);
            it.hasNext();
            usage = it.next();
        } else {
            usage = column.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
            usage.setSymbolicName(JdbcSchema.UsageType.FOREIGN_KEY.name());
        }
        this.notLostColumnUsages.add(usage);
    }

    private void init() {
        JdbcSchema db = JdbcSchema.makeDB(this.star.getDataSource());
        try {
            db.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        JdbcSchema.Table factTable = this.getTable(db, this.getFactTableName());
        if (factTable == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Init: ");
            buf.append("No fact table with name \"");
            buf.append(this.getFactTableName());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return;
        }
        try {
            factTable.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("Init: ");
            buf.append("RolapStar:");
            buf.append(Util.nl);
            buf.append(this.getFactTable());
            buf.append(Util.nl);
            buf.append("FactTable:");
            buf.append(Util.nl);
            buf.append(factTable);
            this.getLogger().debug((Object)buf.toString());
        }
        RolapStar.Column[] arr$ = this.columns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            MondrianDef.Expression left;
            RolapStar.Table table;
            RolapStar.Column column = arr$[i$];
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("Column: ");
                buf.append(column);
                this.getLogger().debug((Object)buf.toString());
            }
            if ((table = column.getTable()).getParentTable() == null) {
                if (!this.addSpecialCollapsedColumn(db, column)) {
                    return;
                }
                MondrianDef.Expression expr = column.getExpression();
                if (!(expr instanceof MondrianDef.Column)) continue;
                MondrianDef.Column exprColumn = (MondrianDef.Column)expr;
                String name = exprColumn.getColumnName();
                JdbcSchema.Table.Column c = this.getColumn(factTable, name);
                if (c == null) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("Init: ");
                    buf.append("FactTable:");
                    buf.append(this.getFactTableName());
                    buf.append(Util.nl);
                    buf.append("No Column with name \"");
                    buf.append(name);
                    buf.append("\"");
                    this.getLogger().warn((Object)buf.toString());
                    return;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
                }
                this.addForeignKeyToNotLostColumnUsages(c);
                continue;
            }
            if (!this.addCollapsedColumn(db, column)) {
                return;
            }
            while (table.getParentTable().getParentTable() != null) {
                table = table.getParentTable();
            }
            RolapStar.Condition cond = table.getJoinCondition();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  RolapStar.Condition: cond=" + cond));
            }
            if (!((left = cond.getLeft()) instanceof MondrianDef.Column)) continue;
            MondrianDef.Column leftColumn = (MondrianDef.Column)left;
            String name = leftColumn.getColumnName();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("FactTable:");
                buf.append(this.getFactTableName());
                buf.append(Util.nl);
                buf.append("No Column with name \"");
                buf.append(name);
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
            }
            this.addForeignKeyToNotLostColumnUsages(c);
        }
        Iterator<RolapStar.Column> i$ = this.getFactTable().getColumns().iterator();
        while (i$.hasNext()) {
            RolapStar.Column rColumn = i$.next();
            String name = this.getRolapStarColumnName(rColumn);
            if (name == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Init: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get column name for RolapStar.Column: ");
                buf.append(rColumn);
                this.getLogger().warn((Object)buf.toString());
                return;
            }
            if (!(rColumn instanceof RolapStar.Measure)) {
                this.getLogger().warn((Object)("not a measure: " + name));
                continue;
            }
            RolapStar.Measure rMeasure = (RolapStar.Measure)rColumn;
            RolapAggregator aggregator = rMeasure.getAggregator();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("For RolapStar: \"");
                buf.append(this.getFactTable().getAlias());
                buf.append("\" measure with name, ");
                buf.append(name);
                buf.append(", is not a column name. ");
                buf.append("The measure's column name may be an expression");
                buf.append(" and currently AggGen does not handle expressions.");
                buf.append(" You will have to add this measure to the");
                buf.append(" aggregate table definition by hand.");
                this.getLogger().warn((Object)buf.toString());
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column m=" + c));
            }
            JdbcSchema.Table.Column.Usage usage = null;
            if (c.hasUsage(JdbcSchema.UsageType.MEASURE)) {
                Iterator<JdbcSchema.Table.Column.Usage> uit = c.getUsages(JdbcSchema.UsageType.MEASURE);
                while (uit.hasNext()) {
                    JdbcSchema.Table.Column.Usage tmpUsage = uit.next();
                    if (tmpUsage.getAggregator() != aggregator || !tmpUsage.getSymbolicName().equals(rColumn.getName())) continue;
                    usage = tmpUsage;
                    break;
                }
            }
            if (usage == null) {
                usage = c.newUsage(JdbcSchema.UsageType.MEASURE);
                usage.setAggregator(aggregator);
                usage.setSymbolicName(rColumn.getName());
            }
            this.measures.add(usage);
        }
        this.isReady = true;
    }

    private boolean addSpecialCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        JdbcSchema.Table.Column c;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get column name for RolapStar.Column: ");
            buf.append(rColumn);
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema table ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        List<JdbcSchema.Table.Column.Usage> list = this.collapsedColumnUsages.get(rt);
        if (list == null) {
            list = new ArrayList<JdbcSchema.Table.Column.Usage>();
            this.collapsedColumnUsages.put(rt, list);
        }
        if ((c = this.getColumn(jt, rname)) == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Special Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema column ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\" and column name \"");
            buf.append(rname);
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        list.add(c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY));
        RolapStar.Column prColumn = rColumn;
        while (prColumn.getParentColumn() != null) {
            rname = this.getRolapStarColumnName(prColumn = prColumn.getParentColumn());
            if (rname == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Adding Special Collapsed Column: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get parent column name");
                buf.append("for RolapStar.Column \"");
                buf.append(rname);
                buf.append("\" for RolapStar.Table with alias \"");
                buf.append(rt.getAlias());
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return false;
            }
            c = this.getColumn(jt, rname);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + rname));
                break;
            }
            list.add(c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY));
        }
        return true;
    }

    private boolean addCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        List<JdbcSchema.Table.Column.Usage> l;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get column name for RolapStar.Column: ");
            buf.append(rColumn);
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("Adding Collapsed Column: ");
            buf.append("For fact table \"");
            buf.append(this.getFactTableName());
            buf.append("\", could not get jdbc schema table ");
            buf.append("for RolapStar.Table with alias \"");
            buf.append(rt.getAlias());
            buf.append("\"");
            this.getLogger().warn((Object)buf.toString());
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException sqle) {
            this.getLogger().error((Object)sqle);
            return false;
        }
        ArrayList<JdbcSchema.Table.Column.Usage> list = new ArrayList<JdbcSchema.Table.Column.Usage>();
        Iterator<RolapStar.Column> i$ = rt.getColumns().iterator();
        while (i$.hasNext()) {
            RolapStar.Column rc = i$.next();
            if (rc.isNameColumn()) continue;
            String name = this.getRolapStarColumnName(rc);
            if (name == null) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("Adding Collapsed Column: ");
                buf.append("For fact table \"");
                buf.append(this.getFactTableName());
                buf.append("\", could not get column name");
                buf.append(" for RolapStar.Column \"");
                buf.append(rc);
                buf.append("\" for RolapStar.Table with alias \"");
                buf.append(rt.getAlias());
                buf.append("\"");
                this.getLogger().warn((Object)buf.toString());
                return false;
            }
            JdbcSchema.Table.Column c = this.getColumn(jt, name);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + name));
                break;
            }
            JdbcSchema.Table.Column.Usage usage = c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
            usage.usagePrefix = rc.getUsagePrefix();
            list.add(usage);
            if (!rname.equals(name)) continue;
            break;
        }
        if ((l = this.collapsedColumnUsages.get(rt)) == null || l.size() < list.size()) {
            this.collapsedColumnUsages.put(rt, list);
        }
        return true;
    }

    String makeLostAggregateTableName(String factTableName) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(AGG_LOST_PREFIX);
        buf.append(factTableName);
        return buf.toString();
    }

    String makeCollapsedAggregateTableName(String factTableName) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(AGG_COLLAPSED_PREFIX);
        buf.append(factTableName);
        return buf.toString();
    }

    public String createLost() {
        JdbcSchema.Table.Column.Usage usage;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        pw.print("CREATE TABLE ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<JdbcSchema.Table.Column.Usage> i$ = this.notLostColumnUsages.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        i$ = this.measures.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    public String insertIntoLost() {
        JdbcSchema.Table.Column c;
        JdbcSchema.Table.Column.Usage usage;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<JdbcSchema.Table.Column.Usage> i$ = this.notLostColumnUsages.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(c.getName());
            pw.println(',');
        }
        i$ = this.measures.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            c = usage.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        i$ = this.notLostColumnUsages.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        i$ = this.measures.iterator();
        while (i$.hasNext()) {
            usage = i$.next();
            c = usage.getColumn();
            RolapAggregator agg = usage.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName())).toUpperCase());
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println("GROUP BY ");
        int k = 0;
        Iterator<JdbcSchema.Table.Column.Usage> i$2 = this.notLostColumnUsages.iterator();
        while (i$2.hasNext()) {
            JdbcSchema.Table.Column.Usage notLostColumnUsage = i$2.next();
            if (k++ > 0) {
                pw.println(",");
            }
            JdbcSchema.Table.Column.Usage usage2 = notLostColumnUsage;
            JdbcSchema.Table.Column c2 = usage2.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c2.getName()));
        }
        pw.println(';');
        return sw.toString();
    }

    public String createCollapsed() {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        pw.print("CREATE TABLE ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<Object> i$ = this.collapsedColumnUsages.values().iterator();
        while (i$.hasNext()) {
            List<JdbcSchema.Table.Column.Usage> list = i$.next();
            Iterator<JdbcSchema.Table.Column.Usage> i$2 = list.iterator();
            while (i$2.hasNext()) {
                JdbcSchema.Table.Column.Usage usage = i$2.next();
                this.addColumnCreate(pw, prefix, usage);
            }
        }
        i$ = this.measures.iterator();
        while (i$.hasNext()) {
            JdbcSchema.Table.Column.Usage usage = (JdbcSchema.Table.Column.Usage)i$.next();
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    public String insertIntoCollapsed() {
        RolapStar.Table rt;
        JdbcSchema.Table.Column c;
        JdbcSchema.Table.Column.Usage usage;
        JdbcSchema.Table.Column c2;
        JdbcSchema.Table.Column.Usage usage2;
        Iterator<JdbcSchema.Table.Column.Usage> i$;
        List list;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        Iterator<Object> i$2 = this.collapsedColumnUsages.values().iterator();
        while (i$2.hasNext()) {
            list = i$2.next();
            i$ = list.iterator();
            while (i$.hasNext()) {
                usage2 = i$.next();
                c2 = usage2.getColumn();
                pw.print(prefix);
                if (usage2.usagePrefix != null) {
                    pw.print(usage2.usagePrefix);
                }
                pw.print(c2.getName());
                pw.println(',');
            }
        }
        i$2 = this.measures.iterator();
        while (i$2.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)i$2.next();
            c = usage.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        i$2 = this.collapsedColumnUsages.values().iterator();
        while (i$2.hasNext()) {
            list = (List)i$2.next();
            i$ = list.iterator();
            while (i$.hasNext()) {
                usage2 = i$.next();
                c2 = usage2.getColumn();
                JdbcSchema.Table t = c2.getTable();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), c2.getName()));
                pw.print(" AS ");
                String n = usage2.usagePrefix == null ? c2.getName() : usage2.usagePrefix + c2.getName();
                pw.print(sqlQuery.getDialect().quoteIdentifier(n));
                pw.println(',');
            }
        }
        i$2 = this.measures.iterator();
        while (i$2.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)i$2.next();
            c = usage.getColumn();
            JdbcSchema.Table t = c.getTable();
            RolapAggregator agg = usage.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(t.getName(), c.getName())).toUpperCase());
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println(',');
        int k = 0;
        Iterator<Object> i$3 = this.collapsedColumnUsages.keySet().iterator();
        while (i$3.hasNext()) {
            rt = i$3.next();
            if (k++ > 0) {
                pw.println(',');
            }
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
            if (rt.getParentTable() == null) continue;
            while (rt.getParentTable().getParentTable() != null) {
                rt = rt.getParentTable();
                pw.println(',');
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
                pw.print(" AS ");
                pw.print(sqlQuery.getDialect().quoteIdentifier(rt.getAlias()));
            }
        }
        pw.println();
        pw.println("WHERE ");
        k = 0;
        i$3 = this.collapsedColumnUsages.keySet().iterator();
        while (i$3.hasNext()) {
            RolapStar.Condition cond;
            rt = i$3.next();
            if (k++ > 0) {
                pw.println(" and");
            }
            if ((cond = rt.getJoinCondition()) == null) continue;
            pw.print(prefix);
            pw.print(cond.toString(sqlQuery));
            if (rt.getParentTable() == null) continue;
            while (rt.getParentTable().getParentTable() != null) {
                rt = rt.getParentTable();
                cond = rt.getJoinCondition();
                pw.println(" and");
                pw.print(prefix);
                pw.print(cond.toString(sqlQuery));
            }
        }
        pw.println();
        pw.println("GROUP BY ");
        k = 0;
        i$3 = this.collapsedColumnUsages.values().iterator();
        while (i$3.hasNext()) {
            List list2 = (List)i$3.next();
            Iterator i$4 = list2.iterator();
            while (i$4.hasNext()) {
                JdbcSchema.Table.Column.Usage usage3 = (JdbcSchema.Table.Column.Usage)i$4.next();
                if (k++ > 0) {
                    pw.println(",");
                }
                JdbcSchema.Table.Column c3 = usage3.getColumn();
                JdbcSchema.Table t = c3.getTable();
                String n = usage3.usagePrefix == null ? c3.getName() : usage3.usagePrefix + c3.getName();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), n));
            }
        }
        pw.println(';');
        return sw.toString();
    }

    private String getUsageName(JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = c.getName();
        if (usage.getUsageType() == JdbcSchema.UsageType.MEASURE && c.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY)) {
            name = usage.getSymbolicName().replace(' ', '_').toUpperCase();
        }
        return name;
    }

    private void addColumnCreate(PrintWriter pw, String prefix, JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = this.getUsageName(usage);
        pw.print(prefix);
        if (usage.usagePrefix != null) {
            pw.print(usage.usagePrefix);
        }
        pw.print(name);
        pw.print(' ');
        pw.print(c.getTypeName().toUpperCase());
        switch (c.getType()) {
            case 2: 
            case 3: {
                pw.print('(');
                pw.print(c.getNumPrecRadix());
                pw.print(",");
                pw.print(c.getDecimalDigits());
                pw.print(')');
                break;
            }
            case 1: 
            case 12: {
                pw.print('(');
                pw.print(c.getCharOctetLength());
                pw.print(')');
                break;
            }
        }
        if (!c.isNullable()) {
            pw.print(" NOT NULL");
        }
        pw.println(',');
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

