/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQuery;

class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final Segment[] segments;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$SegmentArrayQuerySpec;

    SegmentArrayQuerySpec(Segment[] segments) {
        super(segments[0].aggregation.getStar());
        this.segments = segments;
        if (!$assertionsDisabled && !this.isValid(true)) {
            throw new AssertionError();
        }
    }

    private boolean isValid(boolean fail) {
        if (!$assertionsDisabled && this.segments.length <= 0) {
            throw new AssertionError();
        }
        Segment[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Segment segment = arr$[i$];
            if (segment.aggregation != this.segments[0].aggregation) {
                if (!$assertionsDisabled && fail) {
                    throw new AssertionError();
                }
                return false;
            }
            int n = segment.axes.length;
            if (n != this.segments[0].axes.length) {
                if (!$assertionsDisabled && fail) {
                    throw new AssertionError();
                }
                return false;
            }
            for (int j = 0; j < segment.axes.length; ++j) {
                if (segment.axes[j].getPredicate() == this.segments[0].axes[j].getPredicate()) continue;
                if (!$assertionsDisabled && fail) {
                    throw new AssertionError();
                }
                return false;
            }
        }
        return true;
    }

    public int getMeasureCount() {
        return this.segments.length;
    }

    public RolapStar.Measure getMeasure(int i) {
        return this.segments[i].measure;
    }

    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    public RolapStar.Column[] getColumns() {
        return this.segments[0].aggregation.getColumns();
    }

    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    public StarColumnPredicate getColumnPredicate(int i) {
        return this.segments[0].axes[i].getPredicate();
    }

    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        if (!sqlQuery.getDialect().allowsCountDistinct() && this.hasDistinct()) {
            this.distinctGenerateSql(sqlQuery);
        } else {
            this.nonDistinctGenerateSql(sqlQuery, false, false);
        }
        return sqlQuery.toString();
    }

    protected boolean hasDistinct() {
        int count = this.getMeasureCount();
        for (int i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            if (!measure.getAggregator().isDistinct()) continue;
            return true;
        }
        return false;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String exprInner = measure.generateExprString(sqlQuery);
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        sqlQuery.addSelect(exprOuter, this.getMeasureAlias(i));
    }

    protected boolean isAggregate() {
        return true;
    }

    protected void distinctGenerateSql(SqlQuery outerSqlQuery) {
        int i;
        SqlQuery innerSqlQuery = this.newSqlQuery();
        innerSqlQuery.setDistinct(true);
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(innerSqlQuery, false, true);
            String expr = column.generateExprString(innerSqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), innerSqlQuery.getDialect());
            if (!where.equals("true")) {
                innerSqlQuery.addWhere(where);
            }
            String alias = "d" + i;
            innerSqlQuery.addSelect(expr, alias);
            outerSqlQuery.addSelect(alias);
            outerSqlQuery.addGroupBy(alias);
        }
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
            measure.getTable().addToFrom(innerSqlQuery, false, true);
            String alias = this.getMeasureAlias(i);
            String expr = measure.generateExprString(outerSqlQuery);
            innerSqlQuery.addSelect(expr, alias);
            outerSqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(alias));
        }
        outerSqlQuery.addFrom(innerSqlQuery, "dummyname", true);
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$SegmentArrayQuerySpec == null ? (class$mondrian$rolap$agg$SegmentArrayQuerySpec = SegmentArrayQuerySpec.class$("mondrian.rolap.agg.SegmentArrayQuerySpec")) : class$mondrian$rolap$agg$SegmentArrayQuerySpec).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

