/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Collections;
import com.rc.retroweaver.runtime.Enum_;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.DenseSegmentDataset;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Segment {
    private static int nextId;
    final int id = nextId++;
    private String desc;
    final Aggregation aggregation;
    final RolapStar.Measure measure;
    final Aggregation.Axis[] axes;
    private SegmentDataset data;
    private final CellKey cellKey;
    private State state;
    private final List<Region> excludedRegions;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$java$lang$Boolean;
    private static final /* synthetic */ Class class$java$lang$Comparable;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$Segment;

    Segment(Aggregation aggregation, RolapStar.Measure measure, Aggregation.Axis[] axes, List<Region> excludedRegions) {
        this.aggregation = aggregation;
        this.measure = measure;
        this.axes = axes;
        this.cellKey = CellKey.Generator.newCellKey(axes.length);
        this.state = State.Loading;
        this.excludedRegions = excludedRegions;
        for (Region region : excludedRegions) {
            if (!$assertionsDisabled && region.getPredicates().size() != axes.length) {
                throw new AssertionError();
            }
        }
    }

    synchronized void setData(SegmentDataset data, RolapAggregationManager.PinSet pinnedSegments) {
        Util.assertTrue(this.data == null);
        Util.assertTrue(this.state == State.Loading);
        this.data = data;
        this.state = State.Ready;
        this.notifyAll();
    }

    synchronized void setFailed() {
        switch (this.state) {
            case Loading: {
                Util.assertTrue(this.data == null);
                this.state = State.Failed;
                this.notifyAll();
                break;
            }
            case Ready: {
                break;
            }
            default: {
                throw Util.badValue(this.state);
            }
        }
    }

    public boolean isReady() {
        return this.state == State.Ready;
    }

    private void makeDescription(StringBuffer buf, boolean values) {
        String sep = new StringBuffer().append(Util.nl).append("    ").toString();
        buf.append("Segment #");
        buf.append(this.id);
        buf.append(" {");
        buf.append(sep);
        buf.append("measure=");
        buf.append(this.measure.getAggregator().getExpression(this.measure.getExpression().getGenericExpression()));
        RolapStar.Column[] columns = this.aggregation.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            buf.append(sep);
            buf.append(columns[i].getExpression().getGenericExpression());
            Aggregation.Axis axis = this.axes[i];
            axis.getPredicate().describe(buf);
            if (!values) continue;
            Comparable<?>[] keys = axis.getKeys();
            buf.append(", values={");
            for (int j = 0; j < keys.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                Comparable<?> key = keys[j];
                buf.append(key);
            }
            buf.append("}");
        }
        if (!this.excludedRegions.isEmpty()) {
            buf.append(sep);
            buf.append("excluded={");
            int k = 0;
            for (Region excludedRegion : this.excludedRegions) {
                if (k++ > 0) {
                    buf.append(", ");
                }
                excludedRegion.describe(buf);
            }
            buf.append('}');
        }
        buf.append('}');
    }

    public String toString() {
        if (this.desc == null) {
            StringBuffer buf = new StringBuffer(64);
            this.makeDescription(buf, false);
            this.desc = buf.toString();
        }
        return this.desc;
    }

    Object get(Object[] keys) {
        if (!$assertionsDisabled && keys.length != this.axes.length) {
            throw new AssertionError();
        }
        int missed = 0;
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            int offset = this.axes[i].getOffset(key);
            if (offset < 0) {
                if (this.axes[i].getPredicate().evaluate(key)) {
                    ++missed;
                    continue;
                }
                return null;
            }
            this.cellKey.setAxis(i, offset);
        }
        if (this.isExcluded(keys)) {
            return null;
        }
        if (missed > 0) {
            return Util.nullValue;
        }
        Object o = this.data.get(this.cellKey);
        if (o == null) {
            o = Util.nullValue;
        }
        return o;
    }

    boolean wouldContain(Object[] keys) {
        Util.assertTrue(keys.length == this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (this.axes[i].getPredicate().evaluate(key)) continue;
            return false;
        }
        return !this.isExcluded(keys);
    }

    private boolean isExcluded(Object[] keys) {
        for (Region excludedRegion : this.excludedRegions) {
            if (!excludedRegion.wouldContain(keys)) continue;
            return true;
        }
        return false;
    }

    static void load(Segment[] segments, BitKey levelBitKey, BitKey measureBitKey, RolapAggregationManager.PinSet pinnedSegments, Aggregation.Axis[] axes) {
        String sql = AggregationManager.instance().generateSql(segments, levelBitKey, measureBitKey);
        Segment segment0 = segments[0];
        RolapStar star = segment0.aggregation.getStar();
        RolapStar.Column[] columns = segment0.aggregation.getColumns();
        int arity = columns.length;
        SortedSet[] axisValueSets = new SortedSet[arity];
        boolean[] axisContainsNull = new boolean[arity];
        for (int i = 0; i < axisValueSets.length; ++i) {
            if (Util.PreJdk15) {
                if (!$assertionsDisabled && (class$java$lang$Comparable == null ? Segment.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(class$java$lang$Boolean == null ? Segment.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new AssertionError();
                }
                axisValueSets[i] = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Boolean) {
                            Boolean b1 = (Boolean)o1;
                            if (o2 instanceof Boolean) {
                                Boolean b2 = (Boolean)o2;
                                return b1 == b2 ? 0 : (b1 != false ? 1 : -1);
                            }
                            return -1;
                        }
                        return ((Comparable)o1).compareTo(o2);
                    }
                });
                continue;
            }
            if (!$assertionsDisabled && !(class$java$lang$Comparable == null ? Segment.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(class$java$lang$Boolean == null ? Segment.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                throw new AssertionError();
            }
            axisValueSets[i] = new TreeSet();
        }
        ResultSet resultSet = null;
        int measureCount = segments.length;
        Connection jdbcConnection = star.getJdbcConnection();
        try {
            int i;
            int i2;
            DenseSegmentDataset[] denseDatasets;
            SegmentDataset[] dataSets;
            SparseSegmentDataset[] sparseDatasets;
            int i3;
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "Segment.load");
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                Object o;
                Object[] row = new Object[arity + measureCount];
                int k = 1;
                for (i3 = 0; i3 < arity; ++i3) {
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = RolapUtil.sqlNullValue;
                        axisContainsNull[i3] = true;
                    } else {
                        axisValueSets[i3].add(Aggregation.Axis.wrap(o));
                    }
                    row[i3] = o;
                }
                for (i3 = 0; i3 < measureCount; ++i3) {
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = Util.nullValue;
                    } else if (segments[i3].measure.getDatatype().isNumeric() && !(o instanceof Double)) {
                        o = o instanceof Number ? Autobox.valueOf((double)((Number)o).doubleValue()) : (o instanceof byte[] ? Autobox.valueOf((double)Double.parseDouble(new String((byte[])o))) : Autobox.valueOf((double)Double.parseDouble(o.toString())));
                    }
                    row[arity + i3] = o;
                }
                rows.add(row);
            }
            boolean sparse = false;
            int n = 1;
            for (i3 = 0; i3 < arity; ++i3) {
                int previous;
                Aggregation.Axis axis = axes[i3];
                SortedSet valueSet = axisValueSets[i3];
                int size = axis.loadKeys(valueSet, axisContainsNull[i3]);
                if ((n *= size) >= (previous = n) && n >= size) continue;
                n = Integer.MAX_VALUE;
                sparse = true;
            }
            boolean bl = sparse = sparse || Segment.useSparse(n, rows.size());
            if (sparse) {
                sparseDatasets = new SparseSegmentDataset[segments.length];
                dataSets = sparseDatasets;
                denseDatasets = null;
            } else {
                denseDatasets = new DenseSegmentDataset[segments.length];
                dataSets = denseDatasets;
                sparseDatasets = null;
            }
            if (sparse) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    sparseDatasets[i2] = new SparseSegmentDataset(segments[i2]);
                }
            } else {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    denseDatasets[i2] = new DenseSegmentDataset(segments[i2], new Object[n]);
                }
            }
            int[] pos = new int[arity];
            int count = rows.size();
            for (i = 0; i < count; ++i) {
                Object o;
                int j;
                Object[] row = (Object[])rows.get(i);
                int k = 0;
                for (int j2 = 0; j2 < arity; ++j2) {
                    int offset;
                    k *= axes[j2].getKeys().length;
                    Object o2 = row[j2];
                    Aggregation.Axis axis = axes[j2];
                    pos[j2] = offset = axis.getOffset(o2);
                    k += offset;
                }
                if (sparse) {
                    CellKey key = CellKey.Generator.newCellKey(pos);
                    for (j = 0; j < segments.length; ++j) {
                        o = row[arity + j];
                        sparseDatasets[j].put(key, o);
                    }
                    continue;
                }
                for (j = 0; j < segments.length; ++j) {
                    o = row[arity + j];
                    denseDatasets[j].set(k, o);
                }
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].setData(dataSets[i], pinnedSegments);
            }
        }
        catch (SQLException e) {
            throw Util.newInternal(e, new StringBuffer().append("Error while loading segment; sql=[").append(sql).append("]").toString());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
            for (Segment segment : segments) {
                segment.setFailed();
            }
        }
    }

    private static boolean useSparse(double possibleCount, double actualCount) {
        boolean sparse;
        int countThreshold;
        MondrianProperties properties = MondrianProperties.instance();
        double densityThreshold = properties.SparseSegmentDensityThreshold.get();
        if (densityThreshold < 0.0) {
            densityThreshold = 0.0;
        }
        if (densityThreshold > 1.0) {
            densityThreshold = 1.0;
        }
        if ((countThreshold = properties.SparseSegmentCountThreshold.get()) < 0) {
            countThreshold = 0;
        }
        boolean bl = sparse = (possibleCount - (double)countThreshold) * densityThreshold > actualCount;
        if (possibleCount < (double)countThreshold && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)new StringBuffer().append("Should never use sparse if count is less than threshold, possibleCount=").append(possibleCount).append(", actualCount=").append(actualCount).append(", countThreshold=").append(countThreshold).append(", densityThreshold=").append(densityThreshold).toString());
        }
        if (possibleCount == actualCount && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)new StringBuffer().append("Should never use sparse if result is 100% dense: possibleCount=").append(possibleCount).append(", actualCount=").append(actualCount).append(", countThreshold=").append(countThreshold).append(", densityThreshold=").append(densityThreshold).toString());
        }
        return sparse;
    }

    public synchronized void waitUntilLoaded() {
        if (!this.isReady()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (this.state) {
                case Ready: {
                    return;
                }
                case Failed: {
                    throw Util.newError(new StringBuffer().append("Pending segment failed to load: ").append(this.toString()).toString());
                }
            }
            throw Util.badValue(this.state);
        }
    }

    public void print(PrintWriter pw) {
        StringBuffer buf = new StringBuffer();
        this.makeDescription(buf, true);
        pw.print(buf.toString());
        pw.println();
    }

    public List<Region> getExcludedRegions() {
        return this.excludedRegions;
    }

    public int getCellCount() {
        int cellCount = 1;
        for (Aggregation.Axis axis : this.axes) {
            cellCount *= axis.getKeys().length;
        }
        for (Region excludedRegion : this.excludedRegions) {
            cellCount -= Region.access$000(excludedRegion);
        }
        return cellCount;
    }

    Segment createSubSegment(BitSet[] axisKeepBitSets, int bestColumn, StarColumnPredicate bestPredicate, List<Region> excludedRegions) {
        SegmentDataset newData;
        if (!$assertionsDisabled && axisKeepBitSets.length != this.axes.length) {
            throw new AssertionError();
        }
        Aggregation.Axis[] newAxes = (Aggregation.Axis[])this.axes.clone();
        Map[] axisPosMaps = new Map[this.axes.length];
        int valueCount = 1;
        for (int j = 0; j < this.axes.length; ++j) {
            Aggregation.Axis newAxis;
            Comparable<?>[] newAxisKeys;
            Aggregation.Axis axis = this.axes[j];
            StarColumnPredicate newPredicate = axis.getPredicate();
            if (j == bestColumn) {
                newPredicate = bestPredicate;
            }
            Comparable<?>[] axisKeys = axis.getKeys();
            BitSet keepBitSet = axisKeepBitSets[j];
            int firstClearBit = keepBitSet.nextClearBit(0);
            if (firstClearBit >= axisKeys.length) {
                newAxisKeys = axisKeys;
                axisPosMaps[j] = null;
            } else {
                ArrayList newAxisKeyList = new ArrayList();
                HashMap<Integer, Integer> map = axisPosMaps[j] = new HashMap<Integer, Integer>();
                int bit = keepBitSet.nextSetBit(0);
                while (bit >= 0) {
                    map.put(Autobox.valueOf((int)bit), Autobox.valueOf((int)newAxisKeyList.size()));
                    newAxisKeyList.add(axisKeys[bit]);
                    bit = keepBitSet.nextSetBit(bit + 1);
                }
                newAxisKeys = newAxisKeyList.toArray(new Comparable[newAxisKeyList.size()]);
                if (!$assertionsDisabled && newAxisKeys.length <= 0) {
                    throw new AssertionError();
                }
            }
            newAxes[j] = newAxis = new Aggregation.Axis(newPredicate, newAxisKeys);
            valueCount *= newAxisKeys.length;
        }
        Segment newSegment = new Segment(this.aggregation, this.measure, newAxes, excludedRegions);
        if (this.data instanceof SparseSegmentDataset) {
            newData = new SparseSegmentDataset(newSegment);
        } else {
            Object[] newValues = new Object[valueCount];
            newData = new DenseSegmentDataset(newSegment, newValues);
        }
        int[] pos = new int[this.axes.length];
        CellKey newKey = CellKey.Generator.newRefCellKey(pos);
        block2: for (Map.Entry entry : this.data) {
            CellKey key = (CellKey)entry.getKey();
            for (int i = 0; i < pos.length; ++i) {
                int ordinal = key.getAxis(i);
                Map axisPosMap = axisPosMaps[i];
                if (axisPosMap == null) {
                    pos[i] = ordinal;
                    continue;
                }
                Integer integer = (Integer)axisPosMap.get(Autobox.valueOf((int)ordinal));
                if (integer == null) continue block2;
                pos[i] = integer;
            }
            newData.put(newKey, entry.getValue());
        }
        newSegment.setData(newData, null);
        return newSegment;
    }

    SegmentDataset getData() {
        return this.data;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$Segment == null ? (class$mondrian$rolap$agg$Segment = Segment.class$("mondrian.rolap.agg.Segment")) : class$mondrian$rolap$agg$Segment).desiredAssertionStatus();
        nextId = 0;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Region {
        private final StarColumnPredicate[] predicates;
        private final StarPredicate[] multiColumnPredicates;
        private final int cellCount;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$agg$Segment;

        Region(List<StarColumnPredicate> predicateList, List<StarPredicate> multiColumnPredicateList, int cellCount) {
            this.predicates = predicateList.toArray(new StarColumnPredicate[predicateList.size()]);
            this.multiColumnPredicates = multiColumnPredicateList.toArray(new StarPredicate[multiColumnPredicateList.size()]);
            this.cellCount = cellCount;
        }

        public List<StarColumnPredicate> getPredicates() {
            return Collections.unmodifiableList((List)Arrays.asList((Object[])this.predicates));
        }

        public List<StarPredicate> getMultiColumnPredicates() {
            return Collections.unmodifiableList((List)Arrays.asList((Object[])this.multiColumnPredicates));
        }

        public int getCellCount() {
            return this.cellCount;
        }

        public boolean wouldContain(Object[] keys) {
            if (!$assertionsDisabled && keys.length != this.predicates.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < keys.length; ++i) {
                StarColumnPredicate predicate = this.predicates[i];
                Object key = keys[i];
                if (predicate.evaluate(key)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Region) {
                Region that = (Region)obj;
                return Arrays.equals((Object[])this.predicates, (Object[])that.predicates) && Arrays.equals((Object[])this.multiColumnPredicates, (Object[])that.multiColumnPredicates);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])this.multiColumnPredicates) ^ Arrays.hashCode((Object[])this.predicates);
        }

        public void describe(StringBuffer buf) {
            int k = 0;
            for (StarColumnPredicate starColumnPredicate : this.predicates) {
                if (starColumnPredicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)starColumnPredicate).getValue()) continue;
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                starColumnPredicate.describe(buf);
            }
            for (StarPredicate starPredicate : this.multiColumnPredicates) {
                if (starPredicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)starPredicate).getValue()) continue;
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                starPredicate.describe(buf);
            }
        }

        static int access$000(Region x0) {
            return x0.cellCount;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$agg$Segment == null ? (class$mondrian$rolap$agg$Segment = Region.class$("mondrian.rolap.agg.Segment")) : class$mondrian$rolap$agg$Segment).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.rolap.agg.Segment$State>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class State
    extends Enum_ {
        public static final /* enum */ State Initial = new State("Initial", 0);
        public static final /* enum */ State Loading = new State("Loading", 1);
        public static final /* enum */ State Ready = new State("Ready", 2);
        public static final /* enum */ State Failed = new State("Failed", 3);
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$rolap$agg$Segment$State;

        public static final State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return (State)Enum_.valueOf((Class)(class$mondrian$rolap$agg$Segment$State == null ? (class$mondrian$rolap$agg$Segment$State = State.class$("mondrian.rolap.agg.Segment$State")) : class$mondrian$rolap$agg$Segment$State), (String)name);
        }

        private State(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new State[]{Initial, Loading, Ready, Failed};
            Enum_.setEnumValues((Object[])State.values(), (Class)(class$mondrian$rolap$agg$Segment$State == null ? (class$mondrian$rolap$agg$Segment$State = State.class$("mondrian.rolap.agg.Segment$State")) : class$mondrian$rolap$agg$Segment$State));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

