/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.MinusStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RangeColumnPredicate
extends AbstractColumnPredicate {
    private final boolean lowerInclusive;
    private final ValueColumnPredicate lowerBound;
    private final boolean upperInclusive;
    private final ValueColumnPredicate upperBound;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$RangeColumnPredicate;

    public RangeColumnPredicate(RolapStar.Column column, boolean lowerInclusive, ValueColumnPredicate lowerBound, boolean upperInclusive, ValueColumnPredicate upperBound) {
        super(column);
        if (!$assertionsDisabled && lowerBound != null && lowerBound.getConstrainedColumn() != column) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && lowerBound == null && lowerInclusive) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && upperBound != null && upperBound.getConstrainedColumn() != column) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && upperBound == null && upperInclusive) {
            throw new AssertionError();
        }
        this.lowerInclusive = lowerInclusive;
        this.lowerBound = lowerBound;
        this.upperInclusive = upperInclusive;
        this.upperBound = upperBound;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.describe(buf);
        return buf.toString();
    }

    public int hashCode() {
        int h = this.lowerInclusive ? 2 : 1;
        h = 31 * h + this.lowerBound.hashCode();
        h = 31 * h + (this.upperInclusive ? 2 : 1);
        h = 31 * h + this.upperBound.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeColumnPredicate) {
            RangeColumnPredicate that = (RangeColumnPredicate)obj;
            return this.lowerInclusive == that.lowerInclusive && this.lowerBound.equals(that.lowerBound) && this.upperInclusive == that.upperInclusive && this.upperBound.equals(that.upperBound);
        }
        return false;
    }

    public void values(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluate(Object value) {
        int c;
        if (this.lowerBound != null) {
            c = ((Comparable)this.lowerBound.getValue()).compareTo(value);
            if (this.lowerInclusive ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            c = ((Comparable)this.upperBound.getValue()).compareTo(value);
            if (this.upperInclusive ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    public void describe(StringBuffer buf) {
        buf.append("Range(");
        if (this.lowerBound == null) {
            buf.append("unbounded");
        } else {
            this.lowerBound.describe(buf);
            if (this.lowerInclusive) {
                buf.append(" inclusive");
            }
        }
        buf.append(" to ");
        if (this.upperBound == null) {
            buf.append("unbounded");
        } else {
            this.upperBound.describe(buf);
            if (this.upperInclusive) {
                buf.append(" inclusive");
            }
        }
        buf.append(")");
    }

    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    public boolean mightIntersect(StarPredicate other) {
        if (other instanceof ValueColumnPredicate) {
            return this.evaluate(((ValueColumnPredicate)other).getValue());
        }
        return true;
    }

    public StarColumnPredicate minus(StarPredicate predicate) {
        if (!$assertionsDisabled && predicate == null) {
            throw new AssertionError();
        }
        return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
    }

    public ValueColumnPredicate getLowerBound() {
        return this.lowerBound;
    }

    public boolean getLowerInclusive() {
        return this.lowerInclusive;
    }

    public ValueColumnPredicate getUpperBound() {
        return this.upperBound;
    }

    public boolean getUpperInclusive() {
        return this.upperInclusive;
    }

    public StarPredicate minus(StarPredicate x0) {
        return this.minus(x0);
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$RangeColumnPredicate == null ? (class$mondrian$rolap$agg$RangeColumnPredicate = RangeColumnPredicate.class$("mondrian.rolap.agg.RangeColumnPredicate")) : class$mondrian$rolap$agg$RangeColumnPredicate).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

