/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Enum_;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTuplePredicate
implements StarPredicate {
    private final Bound[] bounds;
    private final List<RolapStar.Column> columnList;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$MemberTuplePredicate;

    public MemberTuplePredicate(Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapMember lower, boolean lowerStrict, RolapMember upper, boolean upperStrict) {
        this.columnList = this.computeColumnList(lower != null ? lower : upper, levelToColumnMap);
        if (lower == null) {
            if (!$assertionsDisabled && upper == null) {
                throw new AssertionError();
            }
            this.bounds = new Bound[]{new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        } else {
            this.bounds = upper == null ? new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE)} : new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE), new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        }
    }

    public MemberTuplePredicate(Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapMember member) {
        this.columnList = this.computeColumnList(member, levelToColumnMap);
        this.bounds = new Bound[]{new Bound(member, RelOp.EQ)};
    }

    public int hashCode() {
        return ((Object)this.columnList).hashCode() * 31 + Arrays.hashCode((Object[])this.bounds) * 31;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemberTuplePredicate) {
            MemberTuplePredicate that = (MemberTuplePredicate)obj;
            return ((Object)this.columnList).equals(that.columnList) && Arrays.equals((Object[])this.bounds, (Object[])that.bounds);
        }
        return false;
    }

    private List<RolapStar.Column> computeColumnList(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
        ArrayList<RolapStar.Column> columnList = new ArrayList<RolapStar.Column>();
        while (true) {
            RolapLevel level = member.getLevel();
            columnList.add(0, levelToColumnMap.get(level));
            if (level.isUnique()) {
                return columnList;
            }
            member = member.getParentMember();
        }
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return this.columnList;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (Bound bound : this.bounds) {
            block7: for (int k = 0; k < Bound.access$000(bound).length; ++k) {
                Object value = valueList.get(k);
                if (value == WILDCARD) {
                    return false;
                }
                Object boundValue = Bound.access$000(bound)[k];
                RelOp relOp = Bound.access$100(bound)[k];
                int c = Util.compareKey(value, boundValue);
                switch (relOp) {
                    case GT: {
                        if (c > 0) continue block7;
                        return false;
                    }
                    case GE: {
                        if (c > 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                    case LT: {
                        if (c < 0) continue block7;
                        return false;
                    }
                    case LE: {
                        if (c < 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void describe(StringBuffer buf) {
        int k = 0;
        for (Bound bound : this.bounds) {
            if (k++ > 0) {
                buf.append(" AND ");
            }
            buf.append(Bound.access$100(bound)[Bound.access$100(bound).length - 1].getOp());
            buf.append(' ');
            buf.append(Bound.access$200(bound));
        }
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$MemberTuplePredicate == null ? (class$mondrian$rolap$agg$MemberTuplePredicate = MemberTuplePredicate.class$("mondrian.rolap.agg.MemberTuplePredicate")) : class$mondrian$rolap$agg$MemberTuplePredicate).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class Bound {
        private final RolapMember member;
        private final Object[] values;
        private final RelOp[] relOps;

        Bound(RolapMember member, RelOp relOp) {
            this.member = member;
            ArrayList<Object> valueList = new ArrayList<Object>();
            ArrayList<RelOp> relOpList = new ArrayList<RelOp>();
            while (true) {
                valueList.add(0, member.getKey());
                relOpList.add(0, relOp);
                if (member.getLevel().isUnique()) break;
                member = member.getParentMember();
                switch (1.$SwitchMap$mondrian$rolap$agg$MemberTuplePredicate$RelOp[relOp.ordinal()]) {
                    case 1: {
                        relOp = RelOp.GE;
                        break;
                    }
                    case 3: {
                        relOp = RelOp.LE;
                    }
                }
            }
            this.values = valueList.toArray(new Object[valueList.size()]);
            this.relOps = relOpList.toArray(new RelOp[relOpList.size()]);
        }

        public int hashCode() {
            int h = this.member.hashCode();
            h = h * 31 + Arrays.hashCode((Object[])this.values);
            h = h * 31 + Arrays.hashCode((Object[])this.relOps);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bound) {
                Bound that = (Bound)obj;
                return this.member.equals((OlapElement)that.member) && Arrays.equals((Object[])this.values, (Object[])that.values) && Arrays.equals((Object[])this.relOps, (Object[])that.relOps);
            }
            return false;
        }

        static Object[] access$000(Bound x0) {
            return x0.values;
        }

        static RelOp[] access$100(Bound x0) {
            return x0.relOps;
        }

        static RolapMember access$200(Bound x0) {
            return x0.member;
        }
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.rolap.agg.MemberTuplePredicate$RelOp>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RelOp
    extends Enum_ {
        public static final /* enum */ RelOp LT = new RelOp("LT", 0, "<");
        public static final /* enum */ RelOp LE = new RelOp("LE", 1, "<=");
        public static final /* enum */ RelOp GT = new RelOp("GT", 2, ">");
        public static final /* enum */ RelOp GE = new RelOp("GE", 3, ">=");
        public static final /* enum */ RelOp EQ = new RelOp("EQ", 4, "=");
        private final String op;
        private static final /* synthetic */ RelOp[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$rolap$agg$MemberTuplePredicate$RelOp;

        public static final RelOp[] values() {
            return (RelOp[])$VALUES.clone();
        }

        public static RelOp valueOf(String name) {
            return (RelOp)Enum_.valueOf((Class)(class$mondrian$rolap$agg$MemberTuplePredicate$RelOp == null ? (class$mondrian$rolap$agg$MemberTuplePredicate$RelOp = RelOp.class$("mondrian.rolap.agg.MemberTuplePredicate$RelOp")) : class$mondrian$rolap$agg$MemberTuplePredicate$RelOp), (String)name);
        }

        private RelOp(String string, int n, String op) {
            super(string, n);
            this.op = op;
        }

        String getOp() {
            return this.op;
        }

        static {
            $VALUES = new RelOp[]{LT, LE, GT, GE, EQ};
            Enum_.setEnumValues((Object[])RelOp.values(), (Class)(class$mondrian$rolap$agg$MemberTuplePredicate$RelOp == null ? (class$mondrian$rolap$agg$MemberTuplePredicate$RelOp = RelOp.class$("mondrian.rolap.agg.MemberTuplePredicate$RelOp")) : class$mondrian$rolap$agg$MemberTuplePredicate$RelOp));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

