/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ListColumnPredicate
extends AbstractColumnPredicate {
    private final List<StarColumnPredicate> children;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$ListColumnPredicate;

    public ListColumnPredicate(RolapStar.Column column, List<StarColumnPredicate> list) {
        super(column);
        this.children = list;
    }

    public List<StarColumnPredicate> getPredicates() {
        return this.children;
    }

    public int hashCode() {
        return ((Object)this.children).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)obj;
            return ((Object)this.children).equals(that.children);
        }
        return false;
    }

    @Override
    public void values(Collection collection) {
        for (StarColumnPredicate child : this.children) {
            child.values(collection);
        }
    }

    @Override
    public boolean evaluate(Object value) {
        for (StarColumnPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describe(StringBuffer buf) {
        buf.append("={");
        for (int j = 0; j < this.children.size(); ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(this.children.get(j));
        }
        buf.append('}');
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        int matchCount = 0;
        for (StarColumnPredicate flushPredicate : this.children) {
            StarColumnPredicate.Overlap r2 = flushPredicate.intersect(predicate);
            if (!r2.matched) continue;
            if (r2.remaining == null) {
                return r2;
            }
            predicate = r2.remaining;
            ++matchCount;
        }
        if (matchCount == 0) {
            return new StarColumnPredicate.Overlap(false, null, 0.0f);
        }
        float selectivity = (float)matchCount / (float)this.children.size();
        return new StarColumnPredicate.Overlap(true, predicate, selectivity);
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (other instanceof LiteralStarPredicate) {
            return ((LiteralStarPredicate)other).getValue();
        }
        if (other instanceof ValueColumnPredicate) {
            ValueColumnPredicate valueColumnPredicate = (ValueColumnPredicate)other;
            return this.evaluate(valueColumnPredicate.getValue());
        }
        if (other instanceof ListColumnPredicate) {
            ArrayList thatSet = new ArrayList();
            ((ListColumnPredicate)other).values(thatSet);
            for (Object o : thatSet) {
                if (!this.evaluate(o)) continue;
                return true;
            }
            return false;
        }
        throw Util.newInternal(new StringBuffer().append("unknown constraint type ").append(other).toString());
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        if (!$assertionsDisabled && predicate == null) {
            throw new AssertionError();
        }
        if (predicate instanceof LiteralStarPredicate) {
            LiteralStarPredicate literalStarPredicate = (LiteralStarPredicate)predicate;
            if (literalStarPredicate.getValue()) {
                return LiteralStarPredicate.FALSE;
            }
            return this;
        }
        StarColumnPredicate columnPredicate = (StarColumnPredicate)predicate;
        ArrayList<StarColumnPredicate> newChildren = new ArrayList<StarColumnPredicate>(this.children);
        int changeCount = 0;
        Iterator iterator = newChildren.iterator();
        while (iterator.hasNext()) {
            ValueColumnPredicate child = (ValueColumnPredicate)iterator.next();
            if (!columnPredicate.evaluate(child.getValue())) continue;
            ++changeCount;
            iterator.remove();
        }
        if (changeCount > 0) {
            return new ListColumnPredicate(this.getConstrainedColumn(), newChildren);
        }
        return this;
    }

    @Override
    public StarPredicate minus(StarPredicate x0) {
        return this.minus(x0);
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$ListColumnPredicate == null ? (class$mondrian$rolap$agg$ListColumnPredicate = ListColumnPredicate.class$("mondrian.rolap.agg.ListColumnPredicate")) : class$mondrian$rolap$agg$ListColumnPredicate).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

