/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrillThroughQuerySpec
extends AbstractQuerySpec {
    private final CellRequest request;
    private final boolean countOnly;
    private final String[] columnNames;

    public DrillThroughQuerySpec(CellRequest request, boolean countOnly) {
        super(request.getMeasure().getStar());
        this.request = request;
        this.countOnly = countOnly;
        this.columnNames = this.computeDistinctColumnNames();
    }

    private String[] computeDistinctColumnNames() {
        RolapStar.Column[] columns;
        ArrayList<String> columnNames = new ArrayList<String>();
        HashSet<String> columnNameSet = new HashSet<String>();
        for (RolapStar.Column column : columns = this.getColumns()) {
            this.addColumnName(column, columnNames, columnNameSet);
        }
        this.addColumnName(this.request.getMeasure(), columnNames, columnNameSet);
        return columnNames.toArray(new String[columnNames.size()]);
    }

    private void addColumnName(RolapStar.Column column, List<String> columnNames, Set<String> columnNameSet) {
        String columnName = column.getName();
        if (columnName == null) {
            columnName = column.getExpression() instanceof MondrianDef.Column ? ((MondrianDef.Column)column.getExpression()).name : new StringBuffer().append("c").append(Integer.toString(columnNames.size())).toString();
        }
        int j = 0;
        while (!columnNameSet.add(columnName)) {
            columnName = new StringBuffer().append(columnName).append("_").append(Integer.toString(j)).toString();
            ++j;
        }
        columnNames.add(columnName);
    }

    @Override
    public int getMeasureCount() {
        return 1;
    }

    @Override
    public RolapStar.Measure getMeasure(int i) {
        Util.assertTrue(i == 0);
        return this.request.getMeasure();
    }

    @Override
    public String getMeasureAlias(int i) {
        Util.assertTrue(i == 0);
        return this.columnNames[this.columnNames.length - 1];
    }

    @Override
    public RolapStar.Column[] getColumns() {
        return this.request.getConstrainedColumns();
    }

    @Override
    public String getColumnAlias(int i) {
        return this.columnNames[i];
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        StarColumnPredicate constr = this.request.getValueList().get(i);
        return constr == null ? LiteralStarPredicate.TRUE : constr;
    }

    @Override
    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        this.nonDistinctGenerateSql(sqlQuery, true, this.countOnly);
        return sqlQuery.toString();
    }

    @Override
    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String expr = measure.generateExprString(sqlQuery);
        sqlQuery.addSelect(expr, this.getMeasureAlias(i));
    }

    @Override
    protected boolean isAggregate() {
        return false;
    }
}

