/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Iterator;
import java.util.Map;
import mondrian.rolap.CellKey;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DenseSegmentDataset
implements SegmentDataset {
    private final Segment segment;
    private final Object[] values;

    DenseSegmentDataset(Segment segment, Object[] values) {
        this.segment = segment;
        this.values = values;
    }

    @Override
    public Object get(CellKey key) {
        int offset = this.getOffset(key.getOrdinals());
        return this.values[offset];
    }

    @Override
    public double getBytes() {
        return this.values.length * 12;
    }

    @Override
    public void put(CellKey key, Object value) {
        int offset = this.getOffset(key.getOrdinals());
        this.values[offset] = value;
    }

    @Override
    public Iterator<Map.Entry<CellKey, Object>> iterator() {
        return new Itr();
    }

    boolean contains(Object[] keys) {
        return this.getOffset(keys) >= 0;
    }

    Object get(Object[] keys) {
        int offset = this.getOffset(keys);
        return keys[offset];
    }

    void put(Object[] keys, Object value) {
        int offset = this.getOffset(keys);
        keys[offset] = value;
    }

    private int getOffset(int[] keys) {
        int offset = 0;
        for (int i = 0; i < keys.length; ++i) {
            Aggregation.Axis axis = this.segment.axes[i];
            Comparable<?>[] ks = axis.getKeys();
            offset *= ks.length;
            offset += keys[i];
        }
        return offset;
    }

    private int getOffset(Object[] keys) {
        int offset = 0;
        block0: for (int i = 0; i < keys.length; ++i) {
            Aggregation.Axis axis = this.segment.axes[i];
            Comparable<?>[] ks = axis.getKeys();
            offset *= ks.length;
            Object value = keys[i];
            int axisLength = ks.length;
            for (int j = 0; j < axisLength; ++j) {
                if (!ks[j].equals(value)) continue;
                offset += j;
                continue block0;
            }
            return -1;
        }
        return offset;
    }

    void set(int k, Object o) {
        this.values[k] = o;
    }

    static Segment access$000(DenseSegmentDataset x0) {
        return x0.segment;
    }

    static Object[] access$100(DenseSegmentDataset x0) {
        return x0.values;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class Itr
    implements Iterator<Map.Entry<CellKey, Object>>,
    Map.Entry<CellKey, Object> {
        private int i = -1;
        private final int[] ordinals;
        private final CellKey key;

        Itr() {
            this.ordinals = new int[DenseSegmentDataset.access$000((DenseSegmentDataset)DenseSegmentDataset.this).axes.length];
            this.ordinals[this.ordinals.length - 1] = -1;
            this.key = CellKey.Generator.newRefCellKey(this.ordinals);
        }

        @Override
        public boolean hasNext() {
            return this.i < DenseSegmentDataset.access$100(DenseSegmentDataset.this).length - 1;
        }

        @Override
        public Map.Entry<CellKey, Object> next() {
            ++this.i;
            for (int k = this.ordinals.length - 1; k >= 0; --k) {
                if (this.ordinals[k] < DenseSegmentDataset.access$000((DenseSegmentDataset)DenseSegmentDataset.this).axes[k].getKeys().length - 1) {
                    int n = k;
                    this.ordinals[n] = this.ordinals[n] + 1;
                    break;
                }
                this.ordinals[k] = 0;
            }
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CellKey getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return DenseSegmentDataset.access$100(DenseSegmentDataset.this)[this.i];
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.next();
        }

        @Override
        public Object getKey() {
            return this.getKey();
        }
    }
}

