/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AggQuerySpec;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DrillThroughQuerySpec;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentArrayQuerySpec;
import mondrian.rolap.aggmatcher.AggStar;
import org.apache.log4j.Logger;

public class AggregationManager
extends RolapAggregationManager {
    private static final Logger LOGGER;
    private static AggregationManager instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$AggregationManager;

    public static synchronized AggregationManager instance() {
        if (instance == null) {
            instance = new AggregationManager();
        }
        return instance;
    }

    AggregationManager() {
    }

    public Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAggregation(RolapStar.Measure[] measures, RolapStar.Column[] columns, BitKey constrainedColumnsBitKey, StarColumnPredicate[] predicates, RolapAggregationManager.PinSet pinnedSegments) {
        Aggregation aggregation;
        RolapStar star = measures[0].getStar();
        Aggregation aggregation2 = aggregation = star.lookupOrCreateAggregation(constrainedColumnsBitKey);
        synchronized (aggregation2) {
            predicates = aggregation.optimizePredicates(columns, predicates);
            aggregation.load(columns, measures, predicates, pinnedSegments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellFromCache(CellRequest request) {
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getConstrainedColumnsBitKey());
        if (aggregation == null) {
            return null;
        }
        Aggregation aggregation2 = aggregation;
        synchronized (aggregation2) {
            Object o = aggregation.get(measure, request.getSingleValues(), null);
            if (o != null) {
                return o;
            }
        }
        throw Util.newInternal("not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellFromCache(CellRequest request, RolapAggregationManager.PinSet pinSet) {
        Util.assertPrecondition(pinSet != null);
        RolapStar.Measure measure = request.getMeasure();
        Aggregation aggregation = measure.getStar().lookupAggregation(request.getConstrainedColumnsBitKey());
        if (aggregation == null) {
            return null;
        }
        Aggregation aggregation2 = aggregation;
        synchronized (aggregation2) {
            return aggregation.get(measure, request.getSingleValues(), pinSet);
        }
    }

    public String getDrillThroughSql(CellRequest request, boolean countOnly) {
        DrillThroughQuerySpec spec = new DrillThroughQuerySpec(request, countOnly);
        String sql = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("DrillThroughSQL: ");
            buf.append(sql);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        return sql;
    }

    public String generateSql(Segment[] segments, BitKey levelBitKey, BitKey measureBitKey) {
        RolapStar star;
        if (MondrianProperties.instance().UseAggregates.get()) {
            star = segments[0].aggregation.getStar();
            boolean[] rollup = new boolean[]{false};
            AggStar aggStar = this.findAgg(star, levelBitKey, measureBitKey, rollup);
            if (aggStar != null) {
                if (this.getLogger().isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.append("MATCH: ");
                    buf.append(star.getFactTable().getAlias());
                    buf.append("   foreign=");
                    buf.append(levelBitKey);
                    buf.append(Util.nl);
                    buf.append("   measure=");
                    buf.append(measureBitKey);
                    buf.append(Util.nl);
                    buf.append("   aggstar=");
                    buf.append(aggStar.getBitKey());
                    buf.append(Util.nl);
                    buf.append("AggStar=");
                    buf.append(aggStar.getFactTable().getName());
                    buf.append(Util.nl);
                    Iterator<AggStar.Table.Column> i$ = aggStar.getFactTable().getColumns().iterator();
                    while (i$.hasNext()) {
                        AggStar.Table.Column column = i$.next();
                        buf.append("   ");
                        buf.append(column);
                        buf.append(Util.nl);
                    }
                    this.getLogger().debug((Object)buf.toString());
                }
                AggQuerySpec aggQuerySpec = new AggQuerySpec(aggStar, segments, rollup[0]);
                String sql = aggQuerySpec.generateSqlQuery();
                return sql;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            star = segments[0].aggregation.getStar();
            StringBuffer buf = new StringBuffer(256);
            buf.append("NO MATCH: ");
            buf.append(star.getFactTable().getAlias());
            buf.append(Util.nl);
            buf.append("   foreign=");
            buf.append(levelBitKey);
            buf.append(Util.nl);
            buf.append("   measure=");
            buf.append(measureBitKey);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(segments);
        String sql = spec.generateSqlQuery();
        return sql;
    }

    public AggStar findAgg(RolapStar star, BitKey levelBitKey, BitKey measureBitKey, boolean[] rollup) {
        if (!$assertionsDisabled && rollup == null) {
            throw new AssertionError();
        }
        BitKey fullBitKey = levelBitKey.or(measureBitKey);
        Iterator<AggStar> i$ = star.getAggStars().iterator();
        while (i$.hasNext()) {
            AggStar aggStar = i$.next();
            if (!aggStar.superSetMatch(fullBitKey)) continue;
            boolean isDistinct = measureBitKey.intersects(aggStar.getDistinctMeasureBitKey());
            if (!isDistinct) {
                rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
                return aggStar;
            }
            BitKey distinctMeasuresBitKey = measureBitKey.and(aggStar.getDistinctMeasureBitKey());
            BitSet distinctMeasures = distinctMeasuresBitKey.toBitSet();
            BitKey combinedLevelBitKey = null;
            int k = distinctMeasures.nextSetBit(0);
            while (k >= 0) {
                AggStar.FactTable.Measure distinctMeasure = aggStar.lookupMeasure(k);
                BitKey rollableLevelBitKey = distinctMeasure.getRollableLevelBitKey();
                combinedLevelBitKey = combinedLevelBitKey == null ? rollableLevelBitKey : combinedLevelBitKey.and(rollableLevelBitKey);
                k = distinctMeasures.nextSetBit(k + 1);
            }
            if (aggStar.hasForeignKeys()) {
                BitKey fkBitKey = aggStar.getForeignKeyBitKey().copy();
                Iterator<AggStar.FactTable.Measure> mit = aggStar.getFactTable().getMeasures().iterator();
                Iterator<AggStar.FactTable.Measure> i$2 = aggStar.getFactTable().getMeasures().iterator();
                while (i$2.hasNext()) {
                    AggStar.FactTable.Measure measure = i$2.next();
                    if (!measure.isDistinct() || !measureBitKey.get(measure.getBitPosition())) continue;
                    fkBitKey.clear(measure.getBitPosition());
                }
                if (!fkBitKey.isEmpty()) continue;
            }
            if (!aggStar.select(levelBitKey, combinedLevelBitKey, measureBitKey)) continue;
            rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
            return aggStar;
        }
        return null;
    }

    public RolapAggregationManager.PinSet createPinSet() {
        return new PinSetImpl();
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$AggregationManager == null ? (class$mondrian$rolap$agg$AggregationManager = AggregationManager.class$("mondrian.rolap.agg.AggregationManager")) : class$mondrian$rolap$agg$AggregationManager).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$agg$AggregationManager == null ? (class$mondrian$rolap$agg$AggregationManager = AggregationManager.class$("mondrian.rolap.agg.AggregationManager")) : class$mondrian$rolap$agg$AggregationManager));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PinSetImpl
    extends HashSet<Segment>
    implements RolapAggregationManager.PinSet {
    }
}

