/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Enum_;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTupleReader
implements TupleReader {
    TupleConstraint constraint;
    List<Target> targets = new ArrayList<Target>();
    int maxRows = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlTupleReader;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(class$mondrian$rolap$SqlTupleReader == null ? (class$mondrian$rolap$SqlTupleReader = SqlTupleReader.class$("mondrian.rolap.SqlTupleReader")) : class$mondrian$rolap$SqlTupleReader);
        for (Target target : this.targets) {
            if (Target.access$000(target) == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (Target target : this.targets) {
            if (Target.access$000(target) == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RolapMember[]> readTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        Connection con;
        try {
            con = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "could not connect to DB");
        }
        try {
            List<RolapMember[]> list = this.readTuples(con, partialResult, newPartialResult);
            return list;
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "could not close connection");
            }
        }
    }

    private void prepareTuples(Connection jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String sql = this.makeLevelMembersSql(jdbcConnection);
        ResultSet resultSet = null;
        boolean execQuery = partialResult == null;
        try {
            boolean moreRows;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                for (Target target : this.targets) {
                    if (Target.access$000(target) != null) continue;
                    partialTargets.add(target);
                }
                resultSet = RolapUtil.executeQuery(jdbcConnection, sql, this.maxRows, new StringBuffer().append("SqlTupleReader.readTuples ").append(partialTargets).toString(), -1, -1);
            }
            for (Target target : this.targets) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(Autobox.valueOf((long)limit));
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    for (Target target : this.targets) {
                        Target.access$102(target, null);
                        column = target.addRow(resultSet, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && Target.access$000(this.targets.get(firstEnumTarget)) == null; ++firstEnumTarget) {
                    }
                    List<RolapMember> partialRow = execQuery ? null : partialResult.get(currPartialResultIdx);
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, resultSet, sql);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
        catch (Throwable e) {
            throw Util.newInternal(e, new StringBuffer().append("while populating member cache with members for ").append(this.targets).append("'; sql=[").append(sql).append("]").toString());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    @Override
    public List<RolapMember> readMembers(Connection jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        if (!$assertionsDisabled && this.targets.size() != 1) {
            throw new AssertionError();
        }
        return this.targets.get(0).close();
    }

    @Override
    public List<RolapMember[]> readTuples(Connection jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            Target t = this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        while (iter[0].hasNext()) {
            RolapMember[] tuples = new RolapMember[n];
            for (int i = 0; i < n; ++i) {
                tuples[i] = (RolapMember)iter[i].next();
            }
            tupleList.add(tuples);
        }
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchize(tupleList, false);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (Target target : this.targets) {
            if (Target.access$000(target) != null) continue;
            if (partialRow != null) {
                Target.access$102(target, partialRow.get(nativeTarget++));
                continue;
            }
            Target.access$102(target, null);
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, ResultSet resultSet, String sql) {
        Target currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < Target.access$000(currTarget).length; ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && Target.access$000(this.targets.get(nextTargetIdx)) == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, resultSet, sql);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (Target target : this.targets) {
                if (Target.access$000(target) == null) {
                    try {
                        column = target.addRow(resultSet, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newInternal(e, new StringBuffer().append("while populating member cache with members for ").append(this.targets).append("'; sql=[").append(sql).append("]").toString());
                    }
                }
                RolapMember member = Target.access$000(target)[srcMemberIdxes[enumTargetIdx++]];
                target.list.add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (Target target : this.targets) {
            if (Target.access$000(target) != null) continue;
            row.add(Target.access$100(target));
        }
        partialResult.add(row);
    }

    String makeLevelMembersSql(Connection jdbcConnection) {
        Query query;
        SqlContextConstraint sqlConstraint;
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint && (sqlConstraint = (SqlContextConstraint)this.constraint).isJoinRequired()) {
            query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            virtualCube = cube.isVirtual();
        }
        if (virtualCube) {
            String selectString = "";
            query = this.constraint.getEvaluator().getQuery();
            Set<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps = query.getVirtualCubeBaseCubeMaps();
            Map<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap = query.getLevelMapToMeasureMap();
            int k = -1;
            for (Map<RolapLevel, RolapStar.Column> map : baseCubesLevelToColumnMaps) {
                boolean finalSelect = ++k == baseCubesLevelToColumnMaps.size() - 1;
                RolapMember measure = measureMap.get(map);
                if (!$assertionsDisabled && !(measure instanceof RolapStoredMeasure)) {
                    throw new AssertionError();
                }
                Evaluator evaluator = this.constraint.getEvaluator();
                evaluator.push();
                evaluator.setContext(measure);
                WhichSelect whichSelect = finalSelect ? WhichSelect.LAST : WhichSelect.NOT_LAST;
                selectString = new StringBuffer().append(selectString).append(this.generateSelectForLevels(jdbcConnection, map, whichSelect)).toString();
                evaluator = evaluator.pop();
                if (finalSelect) continue;
                selectString = new StringBuffer().append(selectString).append(" union ").toString();
            }
            return selectString;
        }
        Map<RolapLevel, RolapStar.Column> map = cube == null ? null : cube.getStar().getLevelToColumnMap(cube);
        return this.generateSelectForLevels(jdbcConnection, map, WhichSelect.ONLY);
    }

    private String generateSelectForLevels(Connection jdbcConnection, Map<RolapLevel, RolapStar.Column> levelToColumnMap, WhichSelect whichSelect) {
        String s = new StringBuffer().append("while generating query to retrieve members of level(s) ").append(this.targets).toString();
        SqlQuery sqlQuery = SqlTupleReader.newQuery(jdbcConnection, s);
        ArrayList<String> ordinalColumns = new ArrayList<String>();
        ArrayList<Integer> orderByColnos = new ArrayList<Integer>();
        for (Target target : this.targets) {
            if (Target.access$000(target) != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), levelToColumnMap, whichSelect, orderByColnos, ordinalColumns);
        }
        if (whichSelect != WhichSelect.ONLY) {
            int numNonOrdinalCols = sqlQuery.getCurrentSelectListSize();
            for (String col : ordinalColumns) {
                sqlQuery.addSelect(col);
            }
            if (whichSelect == WhichSelect.LAST) {
                Iterator i$ = orderByColnos.iterator();
                while (i$.hasNext()) {
                    int oByColno = (Integer)i$.next();
                    String ostr = oByColno < 0 ? Integer.toString(++numNonOrdinalCols) : Integer.toString(oByColno);
                    sqlQuery.addOrderBy(ostr, true, false, true);
                }
            }
        }
        this.constraint.addConstraint(sqlQuery, levelToColumnMap);
        return sqlQuery.toString();
    }

    private void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, Map<RolapLevel, RolapStar.Column> levelToColumnMap, WhichSelect whichSelect, List<Integer> orderByColnos, List<String> ordinalColumns) {
        RolapHierarchy hierarchy = level.getHierarchy();
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        for (int i = 0; i <= levelDepth; ++i) {
            RolapProperty[] properties;
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            String keySql = level2.getKeyExp().getExpression(sqlQuery);
            sqlQuery.addSelect(keySql);
            sqlQuery.addGroupBy(keySql);
            hierarchy.addToFrom(sqlQuery, level2.getOrdinalExp());
            this.constraint.addLevelConstraint(sqlQuery, null, level2, levelToColumnMap);
            if (level2.hasCaptionColumn()) {
                MondrianDef.Expression captionExp = level2.getCaptionExp();
                hierarchy.addToFrom(sqlQuery, captionExp);
                String captionSql = captionExp.getExpression(sqlQuery);
                sqlQuery.addSelect(captionSql);
                sqlQuery.addGroupBy(captionSql);
            }
            String ordinalSql = level2.getOrdinalExp().getExpression(sqlQuery);
            sqlQuery.addGroupBy(ordinalSql);
            if (whichSelect != WhichSelect.ONLY && !ordinalSql.equals(keySql)) {
                ordinalColumns.add(ordinalSql);
            }
            switch (whichSelect) {
                case LAST: {
                    if (ordinalSql.equals(keySql)) {
                        orderByColnos.add(Autobox.valueOf((int)sqlQuery.getCurrentSelectListSize()));
                        break;
                    }
                    orderByColnos.add(Autobox.valueOf((int)-1));
                    break;
                }
                case ONLY: {
                    sqlQuery.addOrderBy(ordinalSql, true, false, true);
                }
            }
            for (RolapProperty property : properties = level2.getProperties()) {
                String propSql = property.getExp().getExpression(sqlQuery);
                sqlQuery.addSelect(propSql);
                sqlQuery.addGroupBy(propSql);
            }
        }
    }

    static SqlQuery newQuery(Connection jdbcConnection, String err) {
        try {
            SqlQuery.Dialect dialect = SqlQuery.Dialect.create(jdbcConnection.getMetaData());
            return new SqlQuery(dialect);
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlTupleReader == null ? (class$mondrian$rolap$SqlTupleReader = SqlTupleReader.class$("mondrian.rolap.SqlTupleReader")) : class$mondrian$rolap$SqlTupleReader).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.rolap.SqlTupleReader$WhichSelect>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WhichSelect
    extends Enum_ {
        public static final /* enum */ WhichSelect ONLY = new WhichSelect("ONLY", 0);
        public static final /* enum */ WhichSelect NOT_LAST = new WhichSelect("NOT_LAST", 1);
        public static final /* enum */ WhichSelect LAST = new WhichSelect("LAST", 2);
        private static final /* synthetic */ WhichSelect[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$rolap$SqlTupleReader$WhichSelect;

        public static final WhichSelect[] values() {
            return (WhichSelect[])$VALUES.clone();
        }

        public static WhichSelect valueOf(String name) {
            return (WhichSelect)Enum_.valueOf((Class)(class$mondrian$rolap$SqlTupleReader$WhichSelect == null ? (class$mondrian$rolap$SqlTupleReader$WhichSelect = WhichSelect.class$("mondrian.rolap.SqlTupleReader$WhichSelect")) : class$mondrian$rolap$SqlTupleReader$WhichSelect), (String)name);
        }

        private WhichSelect(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new WhichSelect[]{ONLY, NOT_LAST, LAST};
            Enum_.setEnumValues((Object[])WhichSelect.values(), (Class)(class$mondrian$rolap$SqlTupleReader$WhichSelect == null ? (class$mondrian$rolap$SqlTupleReader$WhichSelect = WhichSelect.class$("mondrian.rolap.SqlTupleReader$WhichSelect")) : class$mondrian$rolap$SqlTupleReader$WhichSelect));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Target {
        final RolapLevel level;
        final MemberCache cache;
        RolapLevel[] levels;
        List<RolapMember> list;
        int levelDepth;
        boolean parentChild;
        RolapMember[] members;
        List<RolapMember>[] siblings;
        final TupleReader.MemberBuilder memberBuilder;
        private final RolapMember[] srcMembers;
        private RolapMember currMember;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
            this.level = level;
            this.cache = memberBuilder.getMemberCache();
            this.memberBuilder = memberBuilder;
            this.srcMembers = srcMembers;
        }

        public void open() {
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.list = new ArrayList<RolapMember>();
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new RolapMember[this.levels.length];
            this.siblings = new List[this.levels.length + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRow(ResultSet resultSet, int column) throws SQLException {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalAddRow(resultSet, column);
            }
        }

        private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
            RolapMember member = null;
            if (this.currMember != null) {
                member = this.currMember;
            } else {
                boolean checkCacheStatus = true;
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Object value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.level.getHierarchy().getAllMember();
                        continue;
                    }
                    if ((value = resultSet.getObject(++column)) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                    RolapMember parentMember = member;
                    Object key = this.cache.makeKey(parentMember, value);
                    member = this.cache.getMember(key, checkCacheStatus);
                    checkCacheStatus = false;
                    if (member == null) {
                        member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                    }
                    column += childLevel.getProperties().length;
                    if (member == this.members[i]) continue;
                    List<RolapMember> children = this.siblings[i + 1];
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members[i])) != null) {
                        this.cache.putChildren(this.members[i], mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    this.siblings[i + 1] = i < this.levelDepth && cachedChildren == null ? new ArrayList<RolapMember>() : null;
                    this.members[i] = member;
                    if (this.siblings[i] == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings[i], member);
                        continue;
                    }
                    this.siblings[i].add(member);
                }
                this.currMember = member;
            }
            this.list.add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<RolapMember> close() {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalClose();
            }
        }

        public List<RolapMember> internalClose() {
            for (int i = 0; i < this.members.length; ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members[i];
                List<RolapMember> children = this.siblings[i + 1];
                if (member == null || children == null || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.list;
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return this.level.getUniqueName();
        }

        static RolapMember[] access$000(Target x0) {
            return x0.srcMembers;
        }

        static RolapMember access$102(Target x0, RolapMember x1) {
            x0.currMember = x1;
            return x0.currMember;
        }

        static RolapMember access$100(Target x0) {
            return x0.currMember;
        }
    }
}

