/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Collections;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlMemberSource
implements MemberReader,
TupleReader.MemberBuilder {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final RolapHierarchy hierarchy;
    private final DataSource dataSource;
    private MemberCache cache;
    private int lastOrdinal = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlMemberSource;

    SqlMemberSource(RolapHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.dataSource = hierarchy.getRolapSchema().getInternalConnection().getDataSource();
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public int getMemberCount() {
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        int count = 0;
        for (RolapLevel level : levels) {
            count += this.getLevelMemberCount(level);
        }
        return count;
    }

    @Override
    public RolapMember lookupMember(String[] uniqueNameParts, boolean failIfNotFound) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLevelMemberCount(RolapLevel level) {
        Connection jdbcConnection;
        if (level.isAll()) {
            return 1;
        }
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating connection from data source");
        }
        try {
            int n = this.getMemberCount(level, jdbcConnection);
            return n;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    private int getMemberCount(RolapLevel level, Connection jdbcConnection) {
        int n;
        boolean[] mustCount = new boolean[1];
        String sql = this.makeLevelMemberCountSql(level, jdbcConnection, mustCount);
        ResultSet resultSet = null;
        try {
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "SqlMemberSource.getLevelMemberCount");
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                int n2 = resultSet.getInt(1);
                return n2;
            }
            ResultSetMetaData rmd = resultSet.getMetaData();
            int nColumns = rmd.getColumnCount();
            int count = 0;
            String[] colStrings = new String[nColumns];
            while (resultSet.next()) {
                boolean isEqual = true;
                for (int i = 0; i < nColumns; ++i) {
                    String colStr = resultSet.getString(i + 1);
                    if (!colStr.equals(colStrings[i])) {
                        isEqual = false;
                    }
                    colStrings[i] = colStr;
                }
                if (isEqual) continue;
                ++count;
            }
            n = count;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, new StringBuffer().append("while counting members of level '").append(level).append("'; sql=[").append(sql).append("]").toString());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
        return n;
    }

    private SqlQuery newQuery(Connection jdbcConnection, String err) {
        try {
            SqlQuery.Dialect dialect = SqlQuery.Dialect.create(jdbcConnection.getMetaData());
            return new SqlQuery(dialect);
        }
        catch (SQLException e) {
            throw Util.newInternal(e, err);
        }
    }

    private String makeLevelMemberCountSql(RolapLevel level, Connection jdbcConnection, boolean[] mustCount) {
        RolapLevel[] levels;
        mustCount[0] = false;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to count members in level ").append(level).toString());
        int levelDepth = level.getDepth();
        if (levelDepth == (levels = (RolapLevel[])this.hierarchy.getLevels()).length) {
            sqlQuery.addSelect("count(*)");
            this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
            return sqlQuery.toString();
        }
        if (!sqlQuery.getDialect().allowsFromQuery()) {
            String columnList = "";
            int columnCount = 0;
            for (int i = levelDepth; i >= 0; --i) {
                RolapLevel level2 = levels[i];
                if (level2.isAll()) continue;
                if (columnCount > 0) {
                    if (sqlQuery.getDialect().allowsCompoundCountDistinct()) {
                        columnList = new StringBuffer().append(columnList).append(", ").toString();
                    } else {
                        mustCount[0] = true;
                    }
                }
                this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
                String keyExp = level2.getKeyExp().getExpression(sqlQuery);
                if (columnCount > 0 && !sqlQuery.getDialect().allowsCompoundCountDistinct() && sqlQuery.getDialect().isSybase()) {
                    keyExp = new StringBuffer().append("convert(varchar, ").append(columnList).append(")").toString();
                }
                columnList = new StringBuffer().append(columnList).append(keyExp).toString();
                if (level2.isUnique()) break;
                ++columnCount;
            }
            if (mustCount[0]) {
                sqlQuery.addSelect(columnList);
                sqlQuery.addOrderBy(columnList, true, false, true);
            } else {
                sqlQuery.addSelect(new StringBuffer().append("count(DISTINCT ").append(columnList).append(")").toString());
            }
            return sqlQuery.toString();
        }
        sqlQuery.setDistinct(true);
        for (int i = levelDepth; i >= 0; --i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            sqlQuery.addSelect(level2.getKeyExp().getExpression(sqlQuery));
            if (level2.isUnique()) break;
        }
        SqlQuery outerQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to count members in level ").append(level).toString());
        outerQuery.addSelect("count(*)");
        boolean failIfExists = true;
        outerQuery.addFrom(sqlQuery, "init", failIfExists);
        return outerQuery.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RolapMember[] getMembers() {
        Connection jdbcConnection;
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating connection from data source");
        }
        try {
            RolapMember[] rolapMemberArray = this.getMembers(jdbcConnection);
            return rolapMemberArray;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private RolapMember[] getMembers(Connection jdbcConnection) {
        String sql = this.makeKeysSql(jdbcConnection);
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        ResultSet resultSet = null;
        try {
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "SqlMemberSource.getMembers");
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            HashMap<MemberKey, RolapMember> map = new HashMap<MemberKey, RolapMember>();
            RolapMember root = null;
            if (this.hierarchy.hasAll()) {
                root = this.hierarchy.getAllMember();
                list.add(root);
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int nFetch = 0;
            while (resultSet.next()) {
                if (limit > 0 && limit < ++nFetch) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(Autobox.valueOf((int)limit));
                }
                int column = 0;
                RolapMember member = root;
                for (RolapLevel level : levels) {
                    RolapProperty[] properties;
                    RolapMember parent;
                    MemberKey key;
                    if (level.isAll()) continue;
                    Object value = resultSet.getObject(column + 1);
                    if (value == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    if ((member = (RolapMember)map.get(key = new MemberKey(parent = member, value))) == null) {
                        member = new RolapMember(parent, level, value);
                        member.setOrdinal(this.lastOrdinal++);
                        if (value == RolapUtil.sqlNullValue) {
                            this.addAsOldestSibling(list, member);
                        } else {
                            list.add(member);
                        }
                        map.put(key, member);
                    }
                    ++column;
                    for (RolapProperty property : properties = level.getProperties()) {
                        member.setProperty(property.getName(), resultSet.getObject(column + 1));
                        ++column;
                    }
                }
            }
            RolapMember[] rolapMemberArray = RolapUtil.toArray(list);
            return rolapMemberArray;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, new StringBuffer().append("while building member cache; sql=[").append(sql).append("]").toString());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
        RolapMember sibling;
        int i = list.size();
        while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
        }
        list.add(i + 1, member);
    }

    private String makeKeysSql(Connection jdbcConnection) {
        RolapLevel[] levels;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to retrieve members of ").append(this.hierarchy).toString());
        for (RolapLevel level : levels = (RolapLevel[])this.hierarchy.getLevels()) {
            RolapProperty[] properties;
            if (level.isAll()) continue;
            MondrianDef.Expression exp = level.getKeyExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String expString = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(expString);
            sqlQuery.addGroupBy(expString);
            exp = level.getOrdinalExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            expString = exp.getExpression(sqlQuery);
            sqlQuery.addOrderBy(expString, true, false, true);
            sqlQuery.addGroupBy(expString);
            for (RolapProperty property : properties = level.getProperties()) {
                exp = property.getExp();
                this.hierarchy.addToFrom(sqlQuery, exp);
                expString = exp.getExpression(sqlQuery);
                sqlQuery.addSelect(expString);
                sqlQuery.addGroupBy(expString);
            }
        }
        return sqlQuery.toString();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        Connection jdbcConnection;
        if (level.isAll()) {
            return Collections.singletonList((Object)this.hierarchy.getAllMember());
        }
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating connection from data source");
        }
        try {
            List<RolapMember> list = this.getMembersInLevel(level, jdbcConnection, constraint);
            return list;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    private List<RolapMember> getMembersInLevel(RolapLevel level, Connection jdbcConnection, TupleConstraint constraint) {
        SqlTupleReader tupleReader = new SqlTupleReader(constraint);
        tupleReader.addLevelMembers(level, this, null);
        List<RolapMember[]> tupleList = tupleReader.readTuples(jdbcConnection, null, null);
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>(tupleList.size());
        for (RolapMember[] tuple : tupleList) {
            if (!$assertionsDisabled && tuple.length != 1) {
                throw new AssertionError();
            }
            memberList.add(tuple[0]);
        }
        return memberList;
    }

    @Override
    public MemberCache getMemberCache() {
        return this.cache;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.getMembersInLevel((RolapLevel)this.hierarchy.getLevels()[0], 0, Integer.MAX_VALUE);
    }

    String makeChildMemberSql(RolapMember member, Connection jdbcConnection, MemberChildrenConstraint constraint) {
        RolapProperty[] properties;
        Map<RolapLevel, RolapStar.Column> levelToColumnMap;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to retrieve children of member ").append(member).toString());
        AggStar aggStar = SqlMemberSource.chooseAggStar(constraint, member);
        if (constraint instanceof SqlContextConstraint) {
            SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
            Evaluator evaluator = contextConstraint.getEvaluator();
            RolapCube cube = (RolapCube)evaluator.getCube();
            RolapStar star = cube.getStar();
            levelToColumnMap = star.getLevelToColumnMap(cube);
        } else {
            levelToColumnMap = Collections.emptyMap();
        }
        constraint.addMemberConstraint(sqlQuery, levelToColumnMap, aggStar, member);
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String q = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(q);
        sqlQuery.addGroupBy(q);
        constraint.addLevelConstraint(sqlQuery, aggStar, level, null);
        if (level.hasCaptionColumn()) {
            MondrianDef.Expression captionExp = level.getCaptionExp();
            this.hierarchy.addToFrom(sqlQuery, captionExp);
            String captionSql = captionExp.getExpression(sqlQuery);
            sqlQuery.addSelect(captionSql);
            sqlQuery.addGroupBy(captionSql);
        }
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(q)) {
            sqlQuery.addGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    private static AggStar chooseAggStar(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        if (!(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getMembers();
        Member measure = members[0];
        int ordinal = measure.getOrdinal();
        RolapLevel childLevel = (RolapLevel)member.getLevel().getChildLevel();
        Map<RolapLevel, RolapStar.Column> levelToColumnMap = star.getLevelToColumnMap(cube);
        RolapStar.Column column = levelToColumnMap.get(childLevel);
        CellRequest request = RolapAggregationManager.makeRequest(members, false, false);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        levelBitKey.set(column.getBitPosition());
        measureBitKey.set(ordinal);
        return AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint mcc) {
        RolapLevel childLevel = this.getCommonChildLevelForDescendants(parentMembers);
        if (childLevel != null) {
            TupleConstraint lmc = this.sqlConstraintFactory.getDescendantsConstraint(parentMembers, mcc);
            List<RolapMember> list = this.getMembersInLevel(childLevel, 0, Integer.MAX_VALUE, lmc);
            children.addAll(list);
            return;
        }
        for (RolapMember parentMember : parentMembers) {
            this.getMemberChildren(parentMember, children, mcc);
        }
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        Connection jdbcConnection;
        if (!parentMember.isAll() && parentMember.isCalculated()) {
            return;
        }
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating connection from data source");
        }
        try {
            this.getMemberChildren(parentMember, children, jdbcConnection, constraint);
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    private RolapLevel getCommonChildLevelForDescendants(List<RolapMember> parents) {
        if (parents.size() < 2) {
            return null;
        }
        RolapLevel parentLevel = null;
        RolapLevel childLevel = null;
        for (RolapMember member : parents) {
            if (member.isCalculated()) {
                return null;
            }
            if (parentLevel == null) {
                parentLevel = member.getLevel();
                if (parentLevel.isParentChild()) {
                    return null;
                }
                childLevel = (RolapLevel)parentLevel.getChildLevel();
                if (childLevel == null) {
                    return null;
                }
                if (!childLevel.isParentChild()) continue;
                return null;
            }
            if (parentLevel == member.getLevel()) continue;
            return null;
        }
        return childLevel;
    }

    private void getMemberChildren(RolapMember parentMember, List<RolapMember> children, Connection jdbcConnection, MemberChildrenConstraint constraint) {
        RolapLevel childLevel;
        boolean parentChild;
        String sql;
        RolapLevel parentLevel = parentMember.getLevel();
        if (parentLevel.isParentChild()) {
            sql = this.makeChildMemberSqlPC(parentMember, jdbcConnection);
            parentChild = true;
            childLevel = parentLevel;
        } else {
            childLevel = (RolapLevel)parentLevel.getChildLevel();
            if (childLevel == null) {
                return;
            }
            if (childLevel.isParentChild()) {
                sql = this.makeChildMemberSql_PCRoot(parentMember, jdbcConnection);
                parentChild = true;
            } else {
                sql = this.makeChildMemberSql(parentMember, jdbcConnection, constraint);
                parentChild = false;
            }
        }
        ResultSet resultSet = null;
        try {
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "SqlMemberSource.getMemberChildren");
            int limit = MondrianProperties.instance().ResultLimit.get();
            int nFetch = 0;
            boolean checkCacheStatus = true;
            while (resultSet.next()) {
                if (limit > 0 && limit < ++nFetch) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(Autobox.valueOf((int)limit));
                }
                Object value = resultSet.getObject(1);
                if (value == null) {
                    value = RolapUtil.sqlNullValue;
                }
                Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(2) : null;
                Object key = this.cache.makeKey(parentMember, value);
                RolapMember member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    member = this.makeMember(parentMember, childLevel, value, captionValue, parentChild, resultSet, key, 1);
                }
                if (value == RolapUtil.sqlNullValue) {
                    this.addAsOldestSibling(children, member);
                    continue;
                }
                children.add(member);
            }
        }
        catch (SQLException e) {
            throw Util.newInternal(e, new StringBuffer().append("while building member cache; sql=[").append(sql).append("]").toString());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    @Override
    public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, ResultSet resultSet, Object key, int columnOffset) throws SQLException {
        RolapMember member = new RolapMember(parentMember, childLevel, value);
        if (childLevel.getOrdinalExp() != childLevel.getKeyExp()) {
            member.setOrdinal(this.lastOrdinal++);
        }
        if (captionValue != null) {
            member.setCaption(captionValue.toString());
        }
        if (parentChild) {
            RolapParentChildMember parentChildMember = childLevel.hasClosedPeer() ? new RolapParentChildMember(parentMember, childLevel, value, member) : new RolapParentChildMemberNoClosure(parentMember, childLevel, value, member);
            member = parentChildMember;
        }
        RolapProperty[] properties = childLevel.getProperties();
        for (int j = 0; j < properties.length; ++j) {
            RolapProperty property = properties[j];
            member.setProperty(property.getName(), resultSet.getObject(columnOffset + j + 1));
        }
        this.cache.putMember(key, member);
        return member;
    }

    private String makeChildMemberSql_PCRoot(RolapMember member, Connection jdbcConnection) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to retrieve children of parent/child hierarchy member ").append(member).toString());
        Util.assertTrue(member.isAll(), "In the current implementation, parent/child hierarchies must have only one level (plus the 'All' level).");
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), new StringBuffer().append("parent-child level '").append(level).append("' must be unique").toString());
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuffer condition = new StringBuffer(64);
        condition.append(parentId);
        if (level.getNullParentValue() == null || level.getNullParentValue().equalsIgnoreCase("NULL")) {
            condition.append(" IS NULL");
        } else {
            try {
                Util.discard((double)Double.parseDouble(level.getNullParentValue()));
                condition.append(" = ");
                condition.append(level.getNullParentValue());
            }
            catch (NumberFormatException e) {
                condition.append(" = ");
                Util.singleQuoteString(level.getNullParentValue(), condition);
            }
        }
        sqlQuery.addWhere(condition.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(childId);
        sqlQuery.addGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    private String makeChildMemberSqlPC(RolapMember member, Connection jdbcConnection) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, new StringBuffer().append("while generating query to retrieve children of parent/child hierarchy member ").append(member).toString());
        RolapLevel level = member.getLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), new StringBuffer().append("parent-child level '").append(level).append("' must be unique").toString());
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuffer buf = new StringBuffer();
        sqlQuery.getDialect().quote(buf, member.getKey(), level.getDatatype());
        sqlQuery.addWhere(parentId, " = ", buf.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(childId);
        sqlQuery.addGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> memberList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlMemberSource == null ? (class$mondrian$rolap$SqlMemberSource = SqlMemberSource.class$("mondrian.rolap.SqlMemberSource")) : class$mondrian$rolap$SqlMemberSource).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class RolapParentChildMemberNoClosure
    extends RolapParentChildMember {
        public RolapParentChildMemberNoClosure(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember);
        }

        public boolean isCalculated() {
            return true;
        }

        public Exp getExpression() {
            return this.getHierarchy().getAggregateChildrenExpression();
        }
    }

    private static class RolapParentChildMember
    extends RolapMember {
        private final RolapMember dataMember;
        private int depth = 0;

        public RolapParentChildMember(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value);
            this.dataMember = dataMember;
            this.depth = parentMember != null ? parentMember.getDepth() + 1 : 0;
        }

        public Member getDataMember() {
            return this.dataMember;
        }

        public Object getPropertyValue(String propertyName, boolean matchCase) {
            if (Util.equal(propertyName, Property.CONTRIBUTING_CHILDREN.name, matchCase)) {
                ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                list.add(this.dataMember);
                RolapHierarchy hierarchy = this.getHierarchy();
                hierarchy.getMemberReader().getMemberChildren(this.dataMember, list);
                return list;
            }
            return super.getPropertyValue(propertyName, matchCase);
        }

        public int getDepth() {
            return this.depth;
        }

        public int getOrdinal() {
            return this.dataMember.getOrdinal();
        }
    }
}

