/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintUtils {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlConstraintUtils;

    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, AggStar aggStar, Evaluator evaluator, boolean strict) {
        CellRequest request;
        Member[] members = evaluator.getMembers();
        if (strict) {
            if (SqlConstraintUtils.containsCalculatedMember(members)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
            members = SqlConstraintUtils.removeDefaultMembers(members);
        }
        if ((request = RolapAggregationManager.makeRequest(members, false, false)) == null) {
            if (strict) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        int arity = columns.length;
        for (int i = 0; i < arity; ++i) {
            String expr;
            RolapStar.Column column = columns[i];
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = column.generateExprString(sqlQuery);
            }
            String value = String.valueOf(values[i]);
            if ("#null".equalsIgnoreCase(value)) {
                sqlQuery.addWhere(expr, " is ", "null");
                continue;
            }
            if (column.getDatatype().isNumeric()) {
                Double.valueOf(value);
            }
            StringBuffer buf = new StringBuffer();
            sqlQuery.getDialect().quote(buf, value, column.getDatatype());
            sqlQuery.addWhere(expr, " = ", buf.toString());
        }
    }

    private static Member[] removeDefaultMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        result.add(members[0]);
        for (int i = 1; i < members.length; ++i) {
            Member m = members[i];
            if (m.getHierarchy().getDefaultMember().equals(m)) continue;
            result.add(m);
        }
        return result.toArray(new Member[result.size()]);
    }

    private static Member[] removeCalculatedMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (member.isCalculated()) continue;
            result.add(member);
        }
        return result.toArray(new Member[result.size()]);
    }

    private static boolean containsCalculatedMember(Member[] members) {
        for (Member member : members) {
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, AggStar aggStar, Evaluator e, RolapLevel level, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
        RolapCube cube = (RolapCube)e.getCube();
        if (!cube.isVirtual()) {
            RolapStar star = cube.getStar();
            levelToColumnMap = star.getLevelToColumnMap(cube);
        }
        RolapStar.Column starColumn = levelToColumnMap.get(level);
        if (!$assertionsDisabled && starColumn == null) {
            throw new AssertionError();
        }
        if (aggStar != null) {
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            AggStar.Table table = aggColumn.getTable();
            table.addToFrom(sqlQuery, false, true);
        } else {
            RolapStar.Table table = starColumn.getTable();
            if (!$assertionsDisabled && table == null) {
                throw new AssertionError();
            }
            table.addToFrom(sqlQuery, false, true);
        }
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap, AggStar aggStar, RolapMember parent, boolean strict) {
        List list = Collections.singletonList((Object)parent);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, levelToColumnMap, aggStar, list, strict, false);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap, AggStar aggStar, List<RolapMember> parents, boolean strict, boolean crossJoin) {
        RolapLevel level;
        if (parents.size() == 0) {
            return;
        }
        if (crossJoin && !(level = parents.get(0).getLevel()).isUnique() && !SqlConstraintUtils.membersAreCrossProduct(parents)) {
            SqlConstraintUtils.constrainMultiLevelMembers(sqlQuery, parents, strict);
            return;
        }
        SequencedCollection<RolapMember> c = parents;
        while (!c.isEmpty()) {
            RolapMember m = (RolapMember)c.iterator().next();
            if (!m.isAll()) {
                if (m.isCalculated()) {
                    if (strict) {
                        throw Util.newInternal(new StringBuffer().append("addMemberConstraint: cannot restrict SQL to calculated member :").append(m).toString());
                    }
                } else {
                    String where;
                    RolapLevel level2 = m.getLevel();
                    RolapHierarchy hierarchy = level2.getHierarchy();
                    hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
                    String q = level2.getKeyExp().getExpression(sqlQuery);
                    RolapStar.Column column = levelToColumnMap.get(level2);
                    StarColumnPredicate cc = SqlConstraintUtils.getColumnPredicates(column, c);
                    if (!(!strict && cc instanceof ListColumnPredicate && ((ListColumnPredicate)cc).getPredicates().size() >= MondrianProperties.instance().MaxConstraints.get() || (where = RolapStar.Column.createInExpr(q, cc, level2.getDatatype(), sqlQuery.getDialect())).equals("true"))) {
                        sqlQuery.addWhere(where);
                    }
                    if (level2.isUnique()) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
    }

    private static StarColumnPredicate getColumnPredicates(RolapStar.Column column, Collection<RolapMember> members) {
        switch (members.size()) {
            case 0: {
                return new LiteralStarPredicate(column, false);
            }
            case 1: {
                return new MemberColumnPredicate(column, members.iterator().next());
            }
        }
        ArrayList<StarColumnPredicate> predicateList = new ArrayList<StarColumnPredicate>();
        for (RolapMember member : members) {
            predicateList.add(new MemberColumnPredicate(column, member));
        }
        return new ListColumnPredicate(column, predicateList);
    }

    private static LinkedHashSet<RolapMember> getUniqueParentMembers(Collection<RolapMember> members) {
        LinkedHashSet<RolapMember> set = new LinkedHashSet<RolapMember>();
        for (RolapMember m : members) {
            if ((m = m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    private static void constrainMultiLevelMembers(SqlQuery sqlQuery, List<RolapMember> members, boolean strict) {
        if (sqlQuery.getDialect().supportsMultiValueInExpr() && SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, members, strict)) {
            return;
        }
        String condition = "(";
        boolean firstMember = true;
        for (RolapMember m : members) {
            if (m.isCalculated()) {
                if (!strict) continue;
                throw Util.newInternal(new StringBuffer().append("addMemberConstraint: cannot restrict SQL to calculated member :").append(m).toString());
            }
            if (!firstMember) {
                condition = new StringBuffer().append(condition).append(" or ").toString();
            }
            condition = new StringBuffer().append(condition).append("(").toString();
            boolean firstLevel = true;
            do {
                if (m.isAll()) continue;
                RolapLevel level = m.getLevel();
                if (firstMember) {
                    RolapHierarchy hierarchy = level.getHierarchy();
                    hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                }
                if (!firstLevel) {
                    condition = new StringBuffer().append(condition).append(" and ").toString();
                } else {
                    firstLevel = false;
                }
                condition = new StringBuffer().append(condition).append(SqlConstraintUtils.constrainLevel(level, sqlQuery, SqlConstraintUtils.getColumnValue(m.getSqlKey(), sqlQuery.getDialect(), level.getDatatype()), false)).toString();
            } while ((m = m.getParentMember()) != null);
            condition = new StringBuffer().append(condition).append(")").toString();
            firstMember = false;
        }
        condition = new StringBuffer().append(condition).append(")").toString();
        sqlQuery.addWhere(condition);
    }

    private static boolean membersAreCrossProduct(List<RolapMember> members) {
        int crossProdSize = SqlConstraintUtils.getNumUniqueMemberKeys(members);
        LinkedHashSet<RolapMember> parents = SqlConstraintUtils.getUniqueParentMembers(members);
        while (!parents.isEmpty()) {
            crossProdSize *= parents.size();
            parents = SqlConstraintUtils.getUniqueParentMembers(parents);
        }
        return crossProdSize == members.size();
    }

    private static int getNumUniqueMemberKeys(List<RolapMember> members) {
        HashSet<Object> set = new HashSet<Object>();
        for (RolapMember m : members) {
            set.add(m.getKey());
        }
        return set.size();
    }

    private static String getColumnValue(Object key, SqlQuery.Dialect dialect, SqlQuery.Datatype datatype) {
        if (key != RolapUtil.sqlNullValue) {
            return key.toString();
        }
        return "#null";
    }

    public static String constrainLevel(RolapLevel level, SqlQuery query, String columnValue, boolean caseSensitive) {
        String constraint;
        SqlQuery.Datatype datatype;
        MondrianDef.Expression exp = level.getNameExp();
        if (exp == null) {
            exp = level.getKeyExp();
            datatype = level.getDatatype();
        } else {
            datatype = SqlQuery.Datatype.String;
        }
        String column = exp.getExpression(query);
        if ("#null".equalsIgnoreCase(columnValue)) {
            constraint = new StringBuffer().append(column).append(" is ").append("null").toString();
        } else {
            if (datatype.isNumeric()) {
                Double.valueOf(columnValue);
            }
            StringBuffer buf = new StringBuffer();
            query.getDialect().quote(buf, columnValue, datatype);
            String value = buf.toString();
            if (caseSensitive && datatype == SqlQuery.Datatype.String && !MondrianProperties.instance().CaseSensitive.get()) {
                column = query.getDialect().toUpper(column);
                value = query.getDialect().toUpper(value);
            }
            constraint = new StringBuffer().append(column).append(" = ").append(value).toString();
        }
        return constraint;
    }

    private static boolean generateMultiValueInExpr(SqlQuery sqlQuery, List<RolapMember> members, boolean strict) {
        StringBuffer columnBuf = new StringBuffer();
        columnBuf.append("(");
        StringBuffer valueBuf = new StringBuffer();
        valueBuf.append("(");
        boolean firstMember = true;
        for (RolapMember m : members) {
            if (m.isCalculated()) {
                if (!strict) continue;
                throw Util.newInternal(new StringBuffer().append("addMemberConstraint: cannot restrict SQL to calculated member :").append(m).toString());
            }
            boolean firstLevel = true;
            do {
                if (m.isAll()) {
                    m = m.getParentMember();
                    continue;
                }
                RolapLevel level = m.getLevel();
                if (firstMember) {
                    MondrianDef.Expression exp;
                    RolapHierarchy hierarchy = level.getHierarchy();
                    hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    if (!firstLevel) {
                        columnBuf.append(",");
                    }
                    if ((exp = level.getNameExp()) == null) {
                        exp = level.getKeyExp();
                    }
                    columnBuf.append(exp.getExpression(sqlQuery));
                }
                if (firstLevel) {
                    if (!firstMember) {
                        valueBuf.append("), ");
                    }
                    valueBuf.append("(");
                    firstLevel = false;
                } else {
                    valueBuf.append(",");
                }
                String value = SqlConstraintUtils.getColumnValue(m.getSqlKey(), sqlQuery.getDialect(), level.getDatatype());
                if ("#null".equalsIgnoreCase(value)) {
                    return false;
                }
                StringBuffer buf = new StringBuffer();
                sqlQuery.getDialect().quote(buf, value, level.getDatatype());
                valueBuf.append(buf.toString());
                m = m.getParentMember();
            } while (m != null);
            firstMember = false;
        }
        columnBuf.append(")");
        valueBuf.append("))");
        sqlQuery.addWhere(new StringBuffer().append(columnBuf.toString()).append(" in ").append(valueBuf.toString()).toString());
        return true;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlConstraintUtils == null ? (class$mondrian$rolap$SqlConstraintUtils = SqlConstraintUtils.class$("mondrian.rolap.SqlConstraintUtils")) : class$mondrian$rolap$SqlConstraintUtils).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

