/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.type.StringType;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapSchemaReader
implements SchemaReader {
    private final Role role;
    private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();
    private final RolapSchema schema;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private static final Logger LOGGER;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapSchemaReader;

    RolapSchemaReader(Role role, RolapSchema schema) {
        if (!$assertionsDisabled && role == null) {
            throw new AssertionError((Object)"precondition: role != null");
        }
        this.role = role;
        this.schema = schema;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public Member[] getHierarchyRootMembers(Hierarchy hierarchy) {
        Level firstLevel;
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        if (hierarchyAccess == null) {
            firstLevel = hierarchy.getLevels()[0];
        } else {
            firstLevel = hierarchyAccess.getTopLevel();
            if (firstLevel == null) {
                firstLevel = hierarchy.getLevels()[0];
            }
        }
        return this.getLevelMembers(firstLevel, true);
    }

    synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
        MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
        if (memberReader == null) {
            memberReader = ((RolapHierarchy)hierarchy).getMemberReader(this.role);
            this.hierarchyReaders.put(hierarchy, memberReader);
        }
        return memberReader;
    }

    @Override
    public void getMemberRange(Level level, Member startMember, Member endMember, List<Member> list) {
        this.getMemberReader(level.getHierarchy()).getMemberRange((RolapLevel)level, (RolapMember)startMember, (RolapMember)endMember, list);
    }

    @Override
    public int compareMembersHierarchically(Member m1, Member m2) {
        RolapMember member1 = (RolapMember)m1;
        RolapMember member2 = (RolapMember)m2;
        RolapHierarchy hierarchy = member1.getHierarchy();
        Util.assertPrecondition(hierarchy == m2.getHierarchy());
        return this.getMemberReader(hierarchy).compare(member1, member2, true);
    }

    @Override
    public Member getMemberParent(Member member) {
        Role.HierarchyAccess hierarchyAccess;
        Member parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        if (parentMember != null && (hierarchyAccess = this.role.getAccessDetails(member.getHierarchy())) != null && hierarchyAccess.getAccess(parentMember) == Access.NONE) {
            return null;
        }
        return parentMember;
    }

    @Override
    public int getMemberDepth(Member member) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            int memberDepth = member.getLevel().getDepth();
            Level topLevel = hierarchyAccess.getTopLevel();
            if (topLevel != null) {
                memberDepth -= topLevel.getDepth();
            }
            return memberDepth;
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            int depth = 0;
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                ++depth;
            }
            return depth;
        }
        return member.getLevel().getDepth();
    }

    @Override
    public Member[] getMemberChildren(Member member) {
        return this.getMemberChildren(member, null);
    }

    @Override
    public Member[] getMemberChildren(Member member, Evaluator context) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        List<RolapMember> memberList = this.internalGetMemberChildren(member, constraint);
        return memberList.toArray(new Member[memberList.size()]);
    }

    private List<RolapMember> internalGetMemberChildren(Member member, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberChildren((RolapMember)member, children, constraint);
        return children;
    }

    @Override
    public int getChildrenCountFromCache(Member member) {
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List<RolapMember> list = ((MemberCache)((Object)memberReader)).getChildrenFromCache((RolapMember)member, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    private int getLevelCardinalityFromCache(Level level) {
        Hierarchy hierarchy = level.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return Integer.MIN_VALUE;
        }
        List list = ((MemberCache)((Object)memberReader)).getLevelMembersFromCache((RolapLevel)level, null);
        if (list == null) {
            return Integer.MIN_VALUE;
        }
        return list.size();
    }

    @Override
    public int getLevelCardinality(Level level, boolean approximate, boolean materialize) {
        int rowCount = Integer.MIN_VALUE;
        if (approximate) {
            rowCount = level.getApproxRowCount();
        }
        if (rowCount == Integer.MIN_VALUE) {
            rowCount = this.getLevelCardinalityFromCache(level);
        }
        if (rowCount == Integer.MIN_VALUE && materialize) {
            rowCount = this.getLevelMembers(level, false).length;
            ((RolapLevel)level).setApproxRowCount(rowCount);
        }
        return rowCount;
    }

    @Override
    public Member[] getMemberChildren(Member[] members) {
        return this.getMemberChildren(members, null);
    }

    @Override
    public Member[] getMemberChildren(Member[] members, Evaluator context) {
        if (members.length == 0) {
            return RolapUtil.emptyMemberArray;
        }
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        Hierarchy hierarchy = members[0].getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        memberReader.getMemberChildren(Arrays.asList((Object[])members), children, constraint);
        return RolapUtil.toArray(children);
    }

    public abstract Cube getCube();

    @Override
    public OlapElement getElementChild(OlapElement parent, String name) {
        return this.getElementChild(parent, name, MatchType.EXACT);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, String name, MatchType matchType) {
        return parent.lookupChild(this, name, matchType);
    }

    @Override
    public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
        return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, MatchType.EXACT);
    }

    @Override
    public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
        return null;
    }

    @Override
    public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category) {
        return this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category, MatchType matchType) {
        return Util.lookupCompound(this, parent, names, failIfNotFound, category, matchType);
    }

    @Override
    public Member lookupMemberChildByName(Member parent, String childName) {
        return this.lookupMemberChildByName(parent, childName, MatchType.EXACT);
    }

    @Override
    public Member lookupMemberChildByName(Member parent, String childName, MatchType matchType) {
        LOGGER.debug((Object)new StringBuffer().append("looking for child \"").append(childName).append("\" of ").append(parent).toString());
        try {
            MemberChildrenConstraint constraint = matchType == MatchType.EXACT ? this.sqlConstraintFactory.getChildByNameConstraint((RolapMember)parent, childName) : this.sqlConstraintFactory.getMemberChildrenConstraint(null);
            List<RolapMember> children = this.internalGetMemberChildren(parent, constraint);
            if (children.size() > 0) {
                return RolapUtil.findBestMemberMatch(children, (RolapMember)parent, children.get(0).getLevel(), childName, matchType, true);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Object)new StringBuffer().append("NumberFormatException in lookupMemberChildByName for parent = \"").append(parent).append("\", childName=\"").append(childName).append("\", exception: ").append(e.getMessage()).toString());
        }
        return null;
    }

    @Override
    public Member getCalculatedMember(String[] nameParts) {
        return null;
    }

    @Override
    public NamedSet getNamedSet(String[] nameParts) {
        if (nameParts.length != 1) {
            return null;
        }
        String name = nameParts[0];
        return this.schema.getNamedSet(name);
    }

    @Override
    public Member getLeadMember(Member member, int n) {
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.getLeadMember((RolapMember)member, n);
    }

    @Override
    public Member[] getLevelMembers(Level level, boolean includeCalculated) {
        return this.getLevelMembers(level, null);
    }

    @Override
    public Member[] getLevelMembers(Level level, Evaluator context) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(context, new Level[]{level});
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        List<RolapMember> membersInLevel = memberReader.getMembersInLevel((RolapLevel)level, 0, Integer.MAX_VALUE, constraint);
        return RolapUtil.toArray(membersInLevel);
    }

    @Override
    public Level[] getHierarchyLevels(Hierarchy hierarchy) {
        if (!$assertionsDisabled && hierarchy == null) {
            throw new AssertionError();
        }
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        Level[] levels = hierarchy.getLevels();
        if (hierarchyAccess == null) {
            return levels;
        }
        Level topLevel = hierarchyAccess.getTopLevel();
        Level bottomLevel = hierarchyAccess.getBottomLevel();
        if (topLevel == null && bottomLevel == null) {
            return levels;
        }
        if (topLevel == null) {
            topLevel = levels[0];
        }
        if (bottomLevel == null) {
            bottomLevel = levels[levels.length - 1];
        }
        int levelCount = bottomLevel.getDepth() - topLevel.getDepth() + 1;
        Level[] restrictedLevels = new Level[levelCount];
        System.arraycopy(levels, topLevel.getDepth(), restrictedLevels, 0, levelCount);
        Util.assertPostcondition(restrictedLevels.length >= 1, "return.length >= 1");
        return restrictedLevels;
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        if (!$assertionsDisabled && hierarchy == null) {
            throw new AssertionError();
        }
        Member defaultMember = hierarchy.getDefaultMember();
        if (!(this.role.getAccess(hierarchy) == Access.NONE || defaultMember != null && this.role.canAccess(defaultMember))) {
            Member[] rootMembers = this.getHierarchyRootMembers(hierarchy);
            defaultMember = rootMembers.length > 0 ? rootMembers[0] : null;
        }
        return defaultMember;
    }

    @Override
    public boolean isDrillable(Member member) {
        RolapLevel level = (RolapLevel)member.getLevel();
        if (level.getParentExp() != null) {
            return this.getMemberChildren(member).length > 0;
        }
        Level childLevel = level.getChildLevel();
        return childLevel != null && this.role.getAccess(childLevel) != Access.NONE;
    }

    @Override
    public boolean isVisible(Member member) {
        return !member.isHidden() && this.role.canAccess(member);
    }

    @Override
    public Cube[] getCubes() {
        List<RolapCube> cubes = this.schema.getCubeList();
        ArrayList<RolapCube> visibleCubes = new ArrayList<RolapCube>(cubes.size());
        for (RolapCube cube : cubes) {
            if (!this.role.canAccess(cube)) continue;
            visibleCubes.add(cube);
        }
        return visibleCubes.toArray(new Cube[visibleCubes.size()]);
    }

    @Override
    public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers(Level level) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers() {
        return Collections.emptyList();
    }

    @Override
    public NativeEvaluator getNativeSetEvaluator(FunDef fun, Exp[] args, Evaluator evaluator, Calc calc) {
        RolapEvaluator revaluator = (RolapEvaluator)AbstractCalc.simplifyEvaluator(calc, evaluator);
        return this.schema.getNativeRegistry().createEvaluator(revaluator, fun, args);
    }

    @Override
    public Parameter getParameter(String name) {
        for (RolapSchemaParameter parameter : this.schema.parameterList) {
            if (!Util.equalName(parameter.getName(), name)) continue;
            return parameter;
        }
        List<Property> propertyList = MondrianProperties.instance().getPropertyList();
        for (Property property : propertyList) {
            if (!property.getPath().equals(name)) continue;
            return new SystemPropertyParameter(name, false);
        }
        if (System.getProperty(name) != null) {
            return new SystemPropertyParameter(name, true);
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return this.schema.getInternalConnection().getDataSource();
    }

    RolapSchema getSchema() {
        return this.schema;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapSchemaReader == null ? (class$mondrian$rolap$RolapSchemaReader = RolapSchemaReader.class$("mondrian.rolap.RolapSchemaReader")) : class$mondrian$rolap$RolapSchemaReader).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapSchemaReader == null ? (class$mondrian$rolap$RolapSchemaReader = RolapSchemaReader.class$("mondrian.rolap.RolapSchemaReader")) : class$mondrian$rolap$RolapSchemaReader));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class SystemPropertyParameter
    extends ParameterImpl {
        private final boolean system;
        private final Property propertyDefinition;

        public SystemPropertyParameter(String name, boolean system) {
            super(name, Literal.nullValue, "System property '" + name + "'", new StringType());
            this.system = system;
            this.propertyDefinition = system ? null : MondrianProperties.instance().getPropertyDefinition(name);
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.System;
        }

        public boolean isModifiable() {
            return false;
        }

        public Calc compile(ExpCompiler compiler) {
            return new GenericCalc(new DummyExp(this.getType())){

                public Calc[] getCalcs() {
                    return new Calc[0];
                }

                public Object evaluate(Evaluator evaluator) {
                    if (SystemPropertyParameter.access$000(SystemPropertyParameter.this)) {
                        String name = SystemPropertyParameter.this.getName();
                        return System.getProperty(name);
                    }
                    return SystemPropertyParameter.access$100(SystemPropertyParameter.this).stringValue();
                }
            };
        }

        static boolean access$000(SystemPropertyParameter x0) {
            return x0.system;
        }

        static Property access$100(SystemPropertyParameter x0) {
            return x0.propertyDefinition;
        }
    }
}

