/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Collections;
import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.CellFormatter;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Util;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.Modulos;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.Format;
import mondrian.util.ObjectPool;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RolapResult
extends ResultBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$olap$ResultBase == null ? (class$mondrian$olap$ResultBase = RolapResult.class$("mondrian.olap.ResultBase")) : class$mondrian$olap$ResultBase));
    private RolapEvaluator evaluator;
    private final CellKey point;
    private CellInfoContainer cellInfos;
    private FastBatchingCellReader batchingReader;
    AggregatingCellReader aggregatingReader = new AggregatingCellReader(null);
    private Modulos modulos = null;
    private final int maxEvalDepth;
    protected static final Map<Locale, ValueFormatter> formatValueFormatters = Collections.synchronizedMap(new HashMap());
    protected static final Map<CellFormatter, ValueFormatter> cellFormatters = Collections.synchronizedMap(new HashMap());
    private static final /* synthetic */ Class class$mondrian$olap$ResultBase;

    RolapResult(Query query, boolean execute) {
        super(query, new Axis[query.axes.length]);
        this.maxEvalDepth = MondrianProperties.instance().MaxEvalDepth.get();
        this.point = CellKey.Generator.newCellKey(query.axes.length);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new RolapDependencyTestingEvaluator(this, expDeps);
        } else {
            RolapResultEvaluatorRoot root = new RolapResultEvaluatorRoot(this);
            this.evaluator = new RolapEvaluator(root);
        }
        RolapCube rcube = (RolapCube)query.getCube();
        this.batchingReader = new FastBatchingCellReader(rcube);
        CellInfoContainer cellInfoContainer = this.cellInfos = query.axes.length > 4 ? new CellInfoMap(this.point) : new CellInfoPool(query.axes.length);
        if (!execute) {
            return;
        }
        boolean normalExecution = true;
        try {
            int limit;
            rcube.clearCachedAggregations();
            rcube.checkAggregateModifications();
            ArrayList<Member> axisMembers = new ArrayList<Member>();
            ArrayList<Member> slicerMembers = new ArrayList<Member>();
            for (int i = -1; i < this.axes.length; ++i) {
                Axis axisResult;
                Calc calc;
                QueryAxis axis;
                block27: {
                    if (i == -1) {
                        axis = query.slicerAxis;
                        calc = query.slicerCalc;
                    } else {
                        axis = query.axes[i];
                        calc = query.axisCalcs[i];
                    }
                    int attempt = 0;
                    do {
                        this.evaluator.setCellReader(this.batchingReader);
                        axisResult = this.executeAxis(this.evaluator.push(), axis, calc, false, axisMembers);
                        Util.discard((Object)axisResult);
                        this.evaluator.clearExpResultCache();
                        if (!this.batchingReader.loadAggregations(query)) break block27;
                    } while (attempt++ <= this.maxEvalDepth);
                    throw Util.newInternal(new StringBuffer().append("Failed to load all aggregations after ").append(this.maxEvalDepth).append("passes; there's probably a cycle").toString());
                }
                this.evaluator.setCellReader(this.aggregatingReader);
                axisResult = this.executeAxis(this.evaluator.push(), axis, calc, true, null);
                this.evaluator.clearExpResultCache();
                if (i == -1) {
                    this.slicerAxis = axisResult;
                    switch (this.slicerAxis.getPositions().size()) {
                        case 0: {
                            throw MondrianResource.instance().EmptySlicer.ex();
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw MondrianResource.instance().CompoundSlicer.ex();
                        }
                    }
                    Position position = this.slicerAxis.getPositions().get(0);
                    this.evaluator.setContext(position);
                    for (Member member : position) {
                        slicerMembers.add(member);
                    }
                    continue;
                }
                this.axes[i] = axisResult;
            }
            if (MondrianProperties.instance().UseImplicitMembers.get()) {
                this.purge(axisMembers, slicerMembers);
                if (axisMembers.size() > 0) {
                    this.reExecuteWithImpliedMembers(axisMembers);
                }
            }
            if ((limit = MondrianProperties.instance().ResultLimit.get()) > 0) {
                long n = 1L;
                for (Axis axis : this.axes) {
                    n *= (long)axis.getPositions().size();
                }
                if (n > (long)limit) {
                    throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(Autobox.valueOf((long)n), Autobox.valueOf((int)limit));
                }
            }
            this.executeBody(query);
            if (this.cellInfos.size() > 10000) {
                this.cellInfos.trimToSize();
            }
        }
        catch (ResultLimitExceededException ex) {
            normalExecution = false;
            this.evaluator = null;
            this.cellInfos = null;
            this.batchingReader = null;
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = null;
            }
            this.slicerAxis = null;
            throw ex;
        }
        finally {
            if (normalExecution) {
                rcube.pushAggregateModificationsToGlobalCache();
                this.evaluator.clearExpResultCache();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)new StringBuffer().append("RolapResult<init>: ").append(Util.printMemory()).toString());
            }
        }
    }

    protected void reExecuteWithImpliedMembers(List<Member> axisMembers) {
        boolean didEvaluatorReplacementMember = false;
        RolapEvaluator rolapEval = this.evaluator;
        int cnt = 0;
        boolean foundTimeMember = false;
        for (Member m : axisMembers) {
            if (rolapEval.setContextConditional(m) == null) continue;
            System.out.println(new StringBuffer().append("RolapResult.reExecuteWithImpliedMembers: m=").append(m.getUniqueName()).toString());
            ++cnt;
            if (m.getHierarchy().getDimension().getDimensionType() == DimensionType.TimeDimension) {
                foundTimeMember = true;
            }
            didEvaluatorReplacementMember = true;
        }
        if (didEvaluatorReplacementMember) {
            if (cnt > 1) {
                String msg = new StringBuffer().append("Evaluation Error: there were ").append(cnt).append(" implied Members during MDX evaluation of [").append(this.query.getQueryString()).append("]").toString();
                this.getLogger().warn((Object)msg);
            }
            for (int i = 0; i < this.axes.length; ++i) {
                Axis axisResult;
                Calc calc;
                QueryAxis axis;
                block6: {
                    axis = this.query.axes[i];
                    calc = this.query.axisCalcs[i];
                    int attempt = 0;
                    do {
                        this.evaluator.setCellReader(this.batchingReader);
                        axisResult = this.executeAxis(this.evaluator.push(), axis, calc, false, null);
                        Util.discard((Object)axisResult);
                        this.evaluator.clearExpResultCache();
                        if (!this.batchingReader.loadAggregations(this.query)) break block6;
                    } while (attempt++ <= this.maxEvalDepth);
                    throw Util.newInternal(new StringBuffer().append("Failed to load all aggregations after ").append(this.maxEvalDepth).append("passes; there's probably a cycle").toString());
                }
                this.evaluator.setCellReader(this.aggregatingReader);
                axisResult = this.executeAxis(this.evaluator.push(), axis, calc, true, null);
                this.evaluator.clearExpResultCache();
                this.axes[i] = foundTimeMember ? RolapResult.mergeAxes(this.axes[i], axisResult) : axisResult;
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public Cube getCube() {
        return this.evaluator.getCube();
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Cell getCell(int[] pos) {
        if (pos.length != this.point.size()) {
            throw Util.newError(new StringBuffer().append("coordinates should have dimension ").append(this.point.size()).toString());
        }
        CellInfo ci = this.cellInfos.lookup(pos);
        if (ci.value == null) {
            ci.value = Util.nullValue;
        }
        return new RolapCell(this, (int[])pos.clone(), ci);
    }

    private Axis executeAxis(Evaluator evaluator, QueryAxis axis, Calc axisCalc, boolean construct, List<Member> axisMembers) {
        RolapAxis axisResult = null;
        if (axis == null) {
            if (construct) {
                axisResult = new RolapAxis.SingleEmptyPosition();
            }
        } else {
            evaluator.setNonEmpty(axis.isNonEmpty());
            evaluator.setEvalAxes(true);
            Object value = axisCalc.evaluate(evaluator);
            evaluator.setNonEmpty(false);
            if (value != null) {
                if (value instanceof List) {
                    List list = (List)value;
                    if (construct) {
                        axisResult = list.size() == 0 ? new RolapAxis.NoPosition() : (list.get(0) instanceof Member[] ? new RolapAxis.MemberArrayList((List)value) : new RolapAxis.MemberList((List)value));
                    } else if (axisMembers != null && list.size() != 0) {
                        if (list.get(0) instanceof Member[]) {
                            for (Member[] o : (List)value) {
                                this.merge(axisMembers, o);
                            }
                        } else {
                            for (Member o : (List)value) {
                                this.merge(axisMembers, o);
                            }
                        }
                    }
                } else {
                    Iterable_ iter = (Iterable_)value;
                    Iterator it = IterableMethods.iterator((Object)iter);
                    if (construct) {
                        axisResult = !it.hasNext() ? new RolapAxis.NoPosition() : (it.next() instanceof Member[] ? new RolapAxis.MemberArrayIterable((Iterable_)value) : new RolapAxis.MemberIterable((Iterable_)value));
                    } else if (axisMembers != null && it.hasNext()) {
                        Object o = it.next();
                        if (o instanceof Member[]) {
                            this.merge(axisMembers, (Member[])o);
                            while (it.hasNext()) {
                                o = it.next();
                                this.merge(axisMembers, (Member[])o);
                            }
                        } else {
                            this.merge(axisMembers, (Member)o);
                            while (it.hasNext()) {
                                o = it.next();
                                this.merge(axisMembers, (Member)o);
                            }
                        }
                    }
                }
            }
            evaluator.setEvalAxes(false);
        }
        return axisResult;
    }

    private void executeBody(Query query) {
        int count = 0;
        while (true) {
            this.evaluator.setCellReader(this.batchingReader);
            this.executeStripe(query.axes.length - 1, (RolapEvaluator)this.evaluator.push());
            this.evaluator.clearExpResultCache();
            if (!this.batchingReader.loadAggregations(query)) {
                return;
            }
            if (count++ > this.maxEvalDepth) {
                if (this.evaluator instanceof RolapDependencyTestingEvaluator) {
                    ((RolapDependencyTestingEvaluator.DteRoot)this.evaluator.root).disabled = true;
                    if (count > this.maxEvalDepth * 2) {
                        throw Util.newInternal(new StringBuffer().append("Query required more than ").append(count).append(" iterations").toString());
                    }
                } else {
                    throw Util.newInternal(new StringBuffer().append("Query required more than ").append(count).append(" iterations").toString());
                }
            }
            this.cellInfos.clear();
        }
    }

    boolean isDirty() {
        return this.batchingReader.isDirty();
    }

    private Object evaluateExp(Calc calc, Evaluator evaluator) {
        RolapEvaluator ev;
        boolean dirty;
        block2: {
            int attempt = 0;
            dirty = this.batchingReader.isDirty();
            do {
                ev = (RolapEvaluator)evaluator.push();
                ev.setCellReader(this.batchingReader);
                Object preliminaryValue = calc.evaluate(ev);
                Util.discard((Object)preliminaryValue);
                if (!this.batchingReader.loadAggregations(evaluator.getQuery())) break block2;
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal(new StringBuffer().append("Failed to load all aggregations after ").append(this.maxEvalDepth).append("passes; there's probably a cycle").toString());
        }
        if (dirty) {
            this.batchingReader.setDirty(true);
        }
        ev = (RolapEvaluator)evaluator.push();
        ev.setCellReader(this.aggregatingReader);
        Object value = calc.evaluate(ev);
        return value;
    }

    private void executeStripe(int axisOrdinal, RolapEvaluator revaluator) {
        if (axisOrdinal < 0) {
            Axis axis = this.slicerAxis;
            List<Position> positions = axis.getPositions();
            for (Position position : positions) {
                Object o;
                this.getQuery().checkCancelOrTimeout();
                revaluator.setContext(position);
                try {
                    o = revaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    o = e;
                }
                CellInfo ci = null;
                try {
                    ValueFormatter valueFormatter;
                    ci = this.cellInfos.create(this.point.getOrdinals());
                    String cachedFormatString = null;
                    RolapCube cube = (RolapCube)this.getCube();
                    Dimension measuresDim = cube.getMeasuresHierarchy().getDimension();
                    RolapMeasure m = (RolapMeasure)revaluator.getContext(measuresDim);
                    CellFormatter cf = m.getFormatter();
                    if (cf != null) {
                        valueFormatter = cellFormatters.get(cf);
                        if (valueFormatter == null) {
                            valueFormatter = new CellFormatterValueFormatter(cf);
                            cellFormatters.put(cf, valueFormatter);
                        }
                    } else {
                        cachedFormatString = revaluator.getFormatString();
                        Locale locale = this.query.getConnection().getLocale();
                        valueFormatter = formatValueFormatters.get(locale);
                        if (valueFormatter == null) {
                            valueFormatter = new FormatValueFormatter(locale);
                            formatValueFormatters.put(locale, valueFormatter);
                        }
                    }
                    ci.formatString = cachedFormatString;
                    ci.valueFormatter = valueFormatter;
                }
                catch (ResultLimitExceededException e) {
                    throw e;
                }
                catch (MondrianEvaluationException e) {
                }
                catch (Throwable e) {
                    Util.discard((Object)e);
                }
                if (o == RolapUtil.valueNotReadyException) continue;
                ci.value = o;
            }
        } else {
            Axis axis = this.axes[axisOrdinal];
            List<Position> positions = axis.getPositions();
            int i = 0;
            for (Position position : positions) {
                this.point.setAxis(axisOrdinal, i);
                revaluator.setContext(position);
                this.getQuery().checkCancelOrTimeout();
                this.executeStripe(axisOrdinal - 1, revaluator);
                ++i;
            }
        }
    }

    int[] getCellPos(int cellOrdinal) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellPos(cellOrdinal);
    }

    int getCellOrdinal(int[] pos) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellOrdinal(pos);
    }

    protected void makeModulos() {
        this.modulos = Modulos.Generator.create(this.axes);
    }

    RolapEvaluator getCellEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = (RolapEvaluator)this.evaluator.push();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    Member[] getCellMembers(int[] pos) {
        Member[] members = (Member[])this.evaluator.getMembers().clone();
        Cube cube = this.getCube();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            for (Member member : position) {
                RolapMember m = (RolapMember)member;
                int ordinal = m.getDimension().getOrdinal(cube);
                members[ordinal] = m;
            }
        }
        return members;
    }

    Evaluator getRootEvaluator() {
        return this.evaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        Evaluator cellEvaluator = this.evaluator.push();
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.getPositions().get(index);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    private Member getTopParent(Member m) {
        Member parent = m.getParentMember();
        return parent == null ? m : this.getTopParent(parent);
    }

    private void merge(List<Member> axisMembers, Axis axis) {
        for (Position position : axis.getPositions()) {
            this.merge(axisMembers, position);
        }
    }

    private void merge(List<Member> axisMembers, List<Member> members) {
        for (Member member : members) {
            this.merge(axisMembers, member);
        }
    }

    private void merge(List<Member> axisMembers, Member[] members) {
        for (Member member : members) {
            this.merge(axisMembers, member);
        }
    }

    private void merge(List<Member> axisMembers, Member member) {
        Member topParent = this.getTopParent(member);
        if (topParent.isNull()) {
            return;
        }
        if (topParent.isMeasure()) {
            return;
        }
        if (topParent.isCalculated()) {
            return;
        }
        if (topParent.isAll()) {
            return;
        }
        axisMembers.add(topParent);
    }

    private void purge(List<Member> axisMembers, List<Member> slicerMembers) {
        for (Member slicerMember : slicerMembers) {
            this.purge(axisMembers, slicerMember);
        }
    }

    private void purge(List<Member> axisMembers, Member slicerMember) {
        Hierarchy hier = slicerMember.getHierarchy();
        Iterator<Member> it = axisMembers.iterator();
        while (it.hasNext()) {
            Member member = it.next();
            if (!member.getHierarchy().equals(hier)) continue;
            it.remove();
            break;
        }
    }

    static Axis mergeAxes(Axis axis1, Axis axis2) {
        int i;
        ArrayList<Member> list;
        List<Position> pl1 = axis1.getPositions();
        List<Position> pl2 = axis2.getPositions();
        int arrayLen = -1;
        if (pl1 instanceof RolapAxis.PositionListBase) {
            if (pl1.size() == 0) {
                return axis2;
            }
            arrayLen = pl1.get(0).size();
        }
        if (axis1 instanceof RolapAxis.SingleEmptyPosition) {
            return axis2;
        }
        if (axis1 instanceof RolapAxis.NoPosition) {
            return axis2;
        }
        if (pl2 instanceof RolapAxis.PositionListBase) {
            if (pl2.size() == 0) {
                return axis1;
            }
            arrayLen = pl2.get(0).size();
        }
        if (axis2 instanceof RolapAxis.SingleEmptyPosition) {
            return axis1;
        }
        if (axis2 instanceof RolapAxis.NoPosition) {
            return axis1;
        }
        if (arrayLen == -1) {
            arrayLen = 0;
            Iterator<Position> i$ = pl1.iterator();
            if (i$.hasNext()) {
                Position p1 = i$.next();
                for (Member m1 : p1) {
                    ++arrayLen;
                }
            }
        }
        if (arrayLen == 1) {
            list = new ArrayList<Member>();
            for (Position p1 : pl1) {
                for (Member m1 : p1) {
                    list.add(m1);
                }
            }
            for (Position p2 : pl2) {
                for (Member m2 : p2) {
                    if (list.contains(m2)) continue;
                    list.add(m2);
                }
            }
            return new RolapAxis.MemberList(list);
        }
        list = new ArrayList();
        for (Position p1 : pl1) {
            Member[] members = new Member[arrayLen];
            i = 0;
            for (Member m1 : p1) {
                members[i++] = m1;
            }
            list.add((Member)members);
        }
        ArrayList<Object[]> extras = new ArrayList<Object[]>();
        for (Position p2 : pl2) {
            i = 0;
            Object[] members = new Member[arrayLen];
            for (Member m2 : p2) {
                members[i++] = m2;
            }
            Iterator it1 = list.iterator();
            boolean found = false;
            while (it1.hasNext()) {
                Object[] m1 = (Member[])it1.next();
                if (!Arrays.equals((Object[])members, (Object[])m1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            extras.add(members);
        }
        list.addAll(extras);
        return new RolapAxis.MemberArrayList(list);
    }

    static Query access$100(RolapResult x0) {
        return x0.query;
    }

    static Object access$200(RolapResult x0, Calc x1, Evaluator x2) {
        return x0.evaluateExp(x1, x2);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$olap$Parameter$Scope;

        static {
            $SwitchMap$mondrian$olap$Parameter$Scope = new int[Parameter.Scope.values().length];
            try {
                1.$SwitchMap$mondrian$olap$Parameter$Scope[Parameter.Scope.System.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$olap$Parameter$Scope[Parameter.Scope.Schema.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$olap$Parameter$Scope[Parameter.Scope.Connection.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$olap$Parameter$Scope[Parameter.Scope.Statement.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static class CellInfoPool
    implements CellInfoContainer {
        protected static final long MAX_AXIS_SIZE_2 = Integer.MAX_VALUE;
        protected static final long MAX_AXIS_SIZE_3 = 2000000L;
        protected static final long MAX_AXIS_SIZE_4 = 50000L;
        private final ObjectPool<CellInfo> cellInfoPool = new ObjectPool();
        private final CellKeyMaker cellKeyMaker;

        CellInfoPool(int axisLength) {
            switch (axisLength) {
                case 0: {
                    this.cellKeyMaker = new Zero();
                    break;
                }
                case 1: {
                    this.cellKeyMaker = new One();
                    break;
                }
                case 2: {
                    this.cellKeyMaker = new Two();
                    break;
                }
                case 3: {
                    this.cellKeyMaker = new Three();
                    break;
                }
                case 4: {
                    this.cellKeyMaker = new Four();
                    break;
                }
                default: {
                    throw new RuntimeException("Creating CellInfoPool with axisLength=" + axisLength);
                }
            }
        }

        public int size() {
            return this.cellInfoPool.size();
        }

        public void trimToSize() {
            this.cellInfoPool.trimToSize();
        }

        public void clear() {
            this.cellInfoPool.clear();
        }

        public CellInfo create(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        public CellInfo lookup(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        static class Four
        implements CellKeyMaker {
            Four() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 50000L * (long)pos[1];
                l += 2500000000L * (long)pos[2];
                return l += 125000000000000L * (long)pos[3];
            }
        }

        static class Three
        implements CellKeyMaker {
            Three() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 2000000L * (long)pos[1];
                return l += 4000000000000L * (long)pos[2];
            }
        }

        static class Two
        implements CellKeyMaker {
            Two() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                return l += Integer.MAX_VALUE * (long)pos[1];
            }
        }

        static class One
        implements CellKeyMaker {
            One() {
            }

            public long generate(int[] pos) {
                return pos[0];
            }
        }

        static class Zero
        implements CellKeyMaker {
            Zero() {
            }

            public long generate(int[] pos) {
                return 0L;
            }
        }

        static interface CellKeyMaker {
            public long generate(int[] var1);
        }
    }

    static class CellInfoMap
    implements CellInfoContainer {
        private final Map<CellKey, CellInfo> cellInfoMap;
        private final CellKey point;

        CellInfoMap(CellKey point) {
            this.point = point;
            this.cellInfoMap = new HashMap<CellKey, CellInfo>();
        }

        public int size() {
            return this.cellInfoMap.size();
        }

        public void trimToSize() {
        }

        public void clear() {
            this.cellInfoMap.clear();
        }

        public CellInfo create(int[] pos) {
            CellKey key = this.point.copy();
            CellInfo ci = this.cellInfoMap.get(key);
            if (ci == null) {
                ci = new CellInfo(0L);
                this.cellInfoMap.put(key, ci);
            }
            return ci;
        }

        public CellInfo lookup(int[] pos) {
            CellKey key = CellKey.Generator.newCellKey(pos);
            return this.cellInfoMap.get(key);
        }
    }

    static interface CellInfoContainer {
        public int size();

        public void trimToSize();

        public void clear();

        public CellInfo create(int[] var1);

        public CellInfo lookup(int[] var1);
    }

    static class CellInfo {
        Object value;
        String formatString;
        ValueFormatter valueFormatter;
        long key;

        CellInfo(long key) {
            this(key, null, null, null);
        }

        CellInfo(long key, Object value, String formatString, ValueFormatter valueFormatter) {
            this.key = key;
            this.value = value;
            this.formatString = formatString;
            this.valueFormatter = valueFormatter;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object o) {
            if (o instanceof CellInfo) {
                CellInfo that = (CellInfo)o;
                return that.key == this.key;
            }
            return false;
        }

        String getFormatValue() {
            return this.valueFormatter.format(this.value, this.formatString);
        }
    }

    class FormatValueFormatter
    implements ValueFormatter {
        final Locale locale;

        FormatValueFormatter(Locale locale) {
            this.locale = locale;
        }

        public String format(Object value, String formatString) {
            if (value == Util.nullValue) {
                Format format = this.getFormat(formatString);
                return format.format(null);
            }
            if (value instanceof Throwable) {
                return "#ERR: " + value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            Format format = this.getFormat(formatString);
            return format.format(value);
        }

        private Format getFormat(String formatString) {
            return Format.get(formatString, this.locale);
        }
    }

    class CellFormatterValueFormatter
    implements ValueFormatter {
        final CellFormatter cf;

        CellFormatterValueFormatter(CellFormatter cf) {
            this.cf = cf;
        }

        public String format(Object value, String formatString) {
            return this.cf.formatCell(value);
        }
    }

    static interface ValueFormatter {
        public String format(Object var1, String var2);
    }

    protected static class RolapResultEvaluatorRoot
    extends RolapEvaluator.RolapEvaluatorRoot {
        private final Map<String, Object> namedSetValues = new HashMap<String, Object>();
        private RolapEvaluator slicerEvaluator;
        private final RolapResult result;
        private static final Object Sentinel = new Object();

        public RolapResultEvaluatorRoot(RolapResult result) {
            super(RolapResult.access$100(result));
            this.result = result;
        }

        protected void init(Evaluator evaluator) {
            this.slicerEvaluator = (RolapEvaluator)evaluator;
        }

        protected Object evaluateNamedSet(String name, Exp exp) {
            Object value = this.namedSetValues.get(name);
            if (value == null) {
                ArrayList list;
                RolapEvaluator.RolapEvaluatorRoot root = this.slicerEvaluator.root;
                Calc calc = root.getCompiled(exp, false);
                Object o = RolapResult.access$200(this.result, calc, this.slicerEvaluator.push());
                if (o instanceof List) {
                    list = (ArrayList)o;
                } else {
                    Iterable_ iter = (Iterable_)o;
                    list = new ArrayList();
                    Iterator i$ = IterableMethods.iterator((Object)iter);
                    while (i$.hasNext()) {
                        Object e = i$.next();
                        list.add(e);
                    }
                }
                value = Collections.unmodifiableList((List)list);
                this.namedSetValues.put(name, value);
            }
            return value;
        }

        protected void clearNamedSets() {
            this.namedSetValues.clear();
        }

        public Object getParameterValue(ParameterSlot slot) {
            Object value = slot.getParameterValue();
            if (value != null) {
                return value;
            }
            Parameter.Scope scope = slot.getParameter().getScope();
            switch (1.$SwitchMap$mondrian$olap$Parameter$Scope[scope.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw Util.badValue(scope);
                }
            }
            value = slot.getCachedDefaultValue();
            if (value != null) {
                if (value == Sentinel) {
                    throw MondrianResource.instance().CycleDuringParameterEvaluation.ex(slot.getParameter().getName());
                }
                return value;
            }
            slot.setCachedDefaultValue(Sentinel);
            value = RolapResult.access$200(this.result, slot.getDefaultValueCalc(), this.slicerEvaluator.push());
            slot.setCachedDefaultValue(value);
            return value;
        }
    }

    private static class AggregatingCellReader
    implements CellReader {
        private final RolapAggregationManager aggMan = AggregationManager.instance();

        private AggregatingCellReader() {
        }

        public Object get(Evaluator evaluator) {
            RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
            return this.aggMan.getCellFromCache(rolapEvaluator.getCurrentMembers());
        }

        public int getMissCount() {
            return this.aggMan.getMissCount();
        }

        AggregatingCellReader(1 x0) {
            this();
        }
    }
}

