/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapUtil;

public class RolapNativeCrossJoin
extends RolapNativeSet {
    public RolapNativeCrossJoin() {
        super.setEnabled(MondrianProperties.instance().EnableNativeCrossJoin.get());
    }

    protected boolean isStrict() {
        return false;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoin(fun, args);
        if (cargs == null) {
            this.alertCrossJoinNonNative(evaluator, fun, "arguments not supported");
            return null;
        }
        if (this.isPreferInterpreter(cargs)) {
            return null;
        }
        Level[] levels = new RolapLevel[cargs.length];
        for (int i = 0; i < cargs.length; ++i) {
            levels[i] = cargs[i].getLevel();
        }
        if (cube.isVirtual() && !evaluator.getQuery().nativeCrossJoinVirtualCube()) {
            this.alertCrossJoinNonNative(evaluator, fun, "not all functions on [Measures] dimension supported");
            return null;
        }
        if (!NonEmptyCrossJoinConstraint.isValidContext(evaluator, false, levels)) {
            return null;
        }
        if (!evaluator.isNonEmpty()) {
            return null;
        }
        LOGGER.debug((Object)"using native crossjoin");
        NonEmptyCrossJoinConstraint constraint = new NonEmptyCrossJoinConstraint(cargs, evaluator);
        SchemaReader schemaReader = evaluator.getSchemaReader();
        return new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
    }

    private void alertCrossJoinNonNative(RolapEvaluator evaluator, FunDef fun, String reason) {
        if (!(fun instanceof NonEmptyCrossJoinFunDef)) {
            return;
        }
        if (!evaluator.getQuery().shouldAlertForNonNative(fun)) {
            return;
        }
        RolapUtil.alertNonNative("NonEmptyCrossJoin", reason);
    }

    static class NonEmptyCrossJoinConstraint
    extends RolapNativeSet.SetConstraint {
        NonEmptyCrossJoinConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator) {
            super(args, evaluator, false);
        }
    }
}

