/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.PropertyFormatter;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RolapMember
extends MemberBase {
    private static final Logger LOGGER;
    private int ordinal;
    private final Object key;
    private Map<String, Object> mapPropertyNameToValue;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Member[][] getAllMembers(SchemaReader schemaReader, Hierarchy hierarchy) {
        long start = System.currentTimeMillis();
        try {
            Level[] levels;
            ArrayList<Member[]> list = new ArrayList<Member[]>(500);
            Level[] arr$ = levels = hierarchy.getLevels();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Level level = arr$[i$];
                Member[] members = schemaReader.getLevelMembers(level, true);
                if (members == null) continue;
                list.add(members);
            }
            Member[][] memberArray = (Member[][])list.toArray((T[])new Member[list.size()][]);
            return memberArray;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.getAllMembers: time=" + (end - start)));
            }
        }
    }

    public static int getHierarchyCardinality(SchemaReader schemaReader, Hierarchy hierarchy) {
        Level[] levels;
        int cardinality = 0;
        Level[] arr$ = levels = hierarchy.getLevels();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Level level1 = arr$[i$];
            cardinality += schemaReader.getLevelCardinality(level1, true, true);
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinals(SchemaReader schemaReader, Member seedMember) {
        long start = System.currentTimeMillis();
        try {
            Member member;
            int i$;
            int len$;
            Member[] arr$;
            int i;
            Member[] leafMembers;
            Hierarchy hierarchy = seedMember.getHierarchy();
            int ordinal = hierarchy.hasAll() ? 1 : 0;
            Member[][] membersArray = RolapMember.getAllMembers(schemaReader, hierarchy);
            Member[] arr$2 = leafMembers = membersArray[membersArray.length - 1];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Member child = arr$2[i$2];
                ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, child);
                ordinal = RolapMember.setOrdinal(child, ordinal);
            }
            boolean needsFullTopDown = false;
            block4: for (i = 0; i < membersArray.length - 1; ++i) {
                Member[] members;
                arr$ = members = membersArray[i];
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    member = arr$[i$];
                    if (member.getOrdinal() != -1) continue;
                    needsFullTopDown = true;
                    continue block4;
                }
            }
            if (needsFullTopDown) {
                for (i = 0; i < membersArray.length - 1; ++i) {
                    Member[] members = membersArray[i];
                    arr$ = members;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        member = arr$[i$];
                        if (!(member instanceof RolapMember)) continue;
                        ((RolapMember)member).resetOrdinal();
                    }
                }
                RolapMember.setOrdinalsTopDown(schemaReader, seedMember);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinals: time=" + (end - start)));
            }
        }
    }

    private static int bottomUpSetParentOrdinals(int ordinal, Member child) {
        Member parent = child.getParentMember();
        if (parent != null && parent.getOrdinal() == -1) {
            ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, parent);
            ordinal = RolapMember.setOrdinal(parent, ordinal);
        }
        return ordinal;
    }

    private static int setOrdinal(Member member, int ordinal) {
        if (member instanceof RolapMember) {
            ((RolapMember)member).setOrdinal(ordinal++);
        } else {
            LOGGER.warn((Object)("RolapMember.setAllChildren: NOT RolapMember member.name=" + member.getName() + ", member.class=" + member.getClass().getName() + ", ordinal=" + ordinal));
            ++ordinal;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinalsTopDown(SchemaReader schemaReader, Member member) {
        long start = System.currentTimeMillis();
        try {
            Member parent = schemaReader.getMemberParent(member);
            if (parent == null) {
                Member[] siblings;
                int ordinal = 0;
                Member[] arr$ = siblings = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Member sibling = arr$[i$];
                    ordinal = RolapMember.setAllChildren(ordinal, schemaReader, sibling);
                }
            } else {
                RolapMember.setOrdinalsTopDown(schemaReader, parent);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinalsTopDown: time=" + (end - start)));
            }
        }
    }

    private static int setAllChildren(int ordinal, SchemaReader schemaReader, Member member) {
        Member[] children;
        ordinal = RolapMember.setOrdinal(member, ordinal);
        Member[] arr$ = children = schemaReader.getMemberChildren(member);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Member child = arr$[i$];
            ordinal = RolapMember.setAllChildren(ordinal, schemaReader, child);
        }
        return ordinal;
    }

    private static String keyToString(Object key) {
        String name = key == null ? "#null" : key.toString();
        if (key instanceof Number && name.endsWith(".0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    protected RolapMember(RolapMember parentMember, RolapLevel level, Object key, String name, Member.MemberType flags) {
        super(parentMember, level, flags);
        this.key = key;
        this.ordinal = -1;
        this.mapPropertyNameToValue = Collections.emptyMap();
        if (!(name == null || key != null && name.equals(key.toString()))) {
            this.setProperty(Property.NAME.name, name);
        } else {
            this.setUniqueName(key);
        }
    }

    RolapMember(RolapMember parentMember, RolapLevel level, Object value) {
        this(parentMember, level, value, null, Member.MemberType.REGULAR);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public RolapLevel getLevel() {
        return (RolapLevel)this.level;
    }

    public RolapHierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    public RolapMember getParentMember() {
        return (RolapMember)super.getParentMember();
    }

    public boolean equals(Object o) {
        return o instanceof RolapMember && this.equals((RolapMember)o);
    }

    public boolean equals(OlapElement o) {
        return o instanceof RolapMember && this.equals((RolapMember)o);
    }

    private boolean equals(RolapMember that) {
        if (!$assertionsDisabled && that == null) {
            throw new AssertionError();
        }
        return this.getUniqueName().equalsIgnoreCase(that.getUniqueName());
    }

    void makeUniqueName(HierarchyUsage hierarchyUsage) {
        String n;
        if (this.parentMember == null && this.key != null && (n = hierarchyUsage.getName()) != null) {
            String name = RolapMember.keyToString(this.key);
            n = Util.quoteMdxIdentifier(n);
            this.uniqueName = Util.makeFqName(n, name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapMember.makeUniqueName: uniqueName=" + this.uniqueName));
            }
        }
    }

    private void setUniqueName(Object key) {
        String name = RolapMember.keyToString(key);
        this.uniqueName = this.parentMember == null ? Util.makeFqName(this.getHierarchy(), name) : Util.makeFqName(this.parentMember, name);
    }

    public boolean isCalculatedInQuery() {
        return false;
    }

    public String getName() {
        String name = (String)this.getPropertyValue(Property.NAME.name);
        return name != null ? name : RolapMember.keyToString(this.key);
    }

    public void setName(String name) {
        throw new Error("unsupported");
    }

    public synchronized void setProperty(String name, Object value) {
        if (name.equals(Property.CAPTION.name)) {
            this.setCaption((String)value);
            return;
        }
        if (this.mapPropertyNameToValue.isEmpty()) {
            this.mapPropertyNameToValue = new HashMap<String, Object>();
        }
        if (name.equals(Property.NAME.name)) {
            if (value == null) {
                value = "#null";
            }
            this.setUniqueName(value);
        }
        if (name.equals(Property.MEMBER_ORDINAL.name)) {
            String ordinal = (String)value;
            if (ordinal.startsWith("\"") && ordinal.endsWith("\"")) {
                ordinal = ordinal.substring(1, ordinal.length() - 1);
            }
            double d = Double.parseDouble(ordinal);
            this.setOrdinal((int)d);
        }
        this.mapPropertyNameToValue.put(name, value);
    }

    public final Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = Property.lookup(propertyName, matchCase);
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 4: {
                    ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                    this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    Schema schema = this.getHierarchy().getDimension().getSchema();
                    return schema.getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return Autobox.valueOf((int)this.getLevel().getDepth());
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return Autobox.valueOf((int)this.getMemberType().ordinal());
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return Autobox.valueOf((int)this.getOrdinal());
                }
                case 23: {
                    Integer cardinality;
                    if (this.isAllMember() && this.childLevelHasApproxRowCount()) {
                        cardinality = Autobox.valueOf((int)this.getLevel().getChildLevel().getApproxRowCount());
                    } else {
                        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                        this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                        cardinality = Autobox.valueOf((int)list.size());
                    }
                    return cardinality;
                }
                case 24: {
                    RolapMember parentMember = this.getParentMember();
                    return Autobox.valueOf((int)(parentMember == null ? 0 : parentMember.getLevel().getDepth()));
                }
                case 25: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    RolapMember parentMember = this.getParentMember();
                    return Autobox.valueOf((int)(parentMember == null ? 0 : 1));
                }
                case 27: {
                    return this.getDescription();
                }
                case 28: {
                    break;
                }
            }
        }
        RolapMember rolapMember = this;
        synchronized (rolapMember) {
            if (matchCase) {
                return this.mapPropertyNameToValue.get(propertyName);
            }
            Iterator<String> i$ = this.mapPropertyNameToValue.keySet().iterator();
            while (i$.hasNext()) {
                String key = i$.next();
                if (!key.equalsIgnoreCase(propertyName)) continue;
                return this.mapPropertyNameToValue.get(key);
            }
            return null;
        }
    }

    private boolean childLevelHasApproxRowCount() {
        return this.getLevel().getChildLevel().getApproxRowCount() > Integer.MIN_VALUE;
    }

    private boolean isAllMember() {
        return this.getLevel().getHierarchy().hasAll() && this.getLevel().getDepth() == 0;
    }

    public Property[] getProperties() {
        return this.level.getInheritedProperties();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        if (this.ordinal == -1) {
            this.ordinal = ordinal;
        }
    }

    private void resetOrdinal() {
        this.ordinal = -1;
    }

    public Object getKey() {
        return this.key;
    }

    public int compareTo(Object o) {
        RolapMember other = (RolapMember)o;
        if (this.key != null && other.key == null) {
            return 1;
        }
        if (this.key == null && other.key != null) {
            return -1;
        }
        if (this.key == null && other.key == null) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key == RolapUtil.sqlNullValue || other.key == RolapUtil.sqlNullValue) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key.getClass().equals(other.key.getClass())) {
            if (this.key instanceof String) {
                return Util.compareName((String)this.key, (String)other.key);
            }
            return Util.compareKey(this.key, other.key);
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    public boolean isHidden() {
        RolapLevel rolapLevel = this.getLevel();
        switch (1.$SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition[rolapLevel.getHideMemberCondition().ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                String name = this.getName();
                return name.equals("#null") || name.equals("");
            }
            case 3: {
                RolapMember parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw Util.badValue(rolapLevel.getHideMemberCondition());
    }

    public int getDepth() {
        return this.level.getDepth();
    }

    public Object getSqlKey() {
        return this.key;
    }

    public String getPropertyFormattedValue(String propertyName) {
        PropertyFormatter pf;
        RolapProperty[] props = this.getLevel().getProperties();
        Property prop = null;
        RolapProperty[] arr$ = props;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            RolapProperty prop1 = arr$[i$];
            if (!prop1.getName().equals(propertyName)) continue;
            prop = prop1;
            break;
        }
        if (prop != null && (pf = prop.getFormatter()) != null) {
            return pf.formatProperty(this, propertyName, this.getPropertyValue(propertyName));
        }
        Object val = this.getPropertyValue(propertyName);
        return val == null ? "" : val.toString();
    }

    public Member getParentMember() {
        return this.getParentMember();
    }

    public Level getLevel() {
        return this.getLevel();
    }

    public Hierarchy getHierarchy() {
        return this.getHierarchy();
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapMember == null ? (class$mondrian$rolap$RolapMember = RolapMember.class$("mondrian.rolap.RolapMember")) : class$mondrian$rolap$RolapMember).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapMember == null ? (class$mondrian$rolap$RolapMember = RolapMember.class$("mondrian.rolap.RolapMember")) : class$mondrian$rolap$RolapMember));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition;

        static {
            $SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition = new int[RolapLevel.HideMemberCondition.values().length];
            try {
                1.$SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition[RolapLevel.HideMemberCondition.Never.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition[RolapLevel.HideMemberCondition.IfBlankName.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$rolap$RolapLevel$HideMemberCondition[RolapLevel.HideMemberCondition.IfParentsName.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

