/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Enum_;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.LevelBase;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapEvaluator == null ? (class$mondrian$rolap$RolapEvaluator = RolapLevel.class$("mondrian.rolap.RolapEvaluator")) : class$mondrian$rolap$RolapEvaluator));
    static final int ALL = 2;
    static final int UNIQUE = 4;
    private final MondrianDef.Expression keyExp;
    private final MondrianDef.Expression ordinalExp;
    private final MondrianDef.Expression captionExp;
    private final boolean unique;
    private final SqlQuery.Datatype datatype;
    private final int flags;
    private final RolapProperty[] properties;
    private final RolapProperty[] inheritedProperties;
    private final MondrianDef.Expression nameExp;
    private final MondrianDef.Expression parentExp;
    private final String nullParentValue;
    private final HideMemberCondition hideMemberCondition;
    private final MondrianDef.Closure xmlClosure;
    private LevelReader levelReader;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapEvaluator;

    public static RolapLevel lookupLevel(RolapLevel[] levels, String levelName) {
        for (RolapLevel level : levels) {
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, String name, MondrianDef.Expression keyExp, MondrianDef.Expression nameExp, MondrianDef.Expression captionExp, MondrianDef.Expression ordinalExp, MondrianDef.Expression parentExp, String nullParentValue, MondrianDef.Closure xmlClosure, RolapProperty[] properties, int flags, SqlQuery.Datatype datatype, HideMemberCondition hideMemberCondition, LevelType levelType, String approxRowCount) {
        super(hierarchy, name, depth, levelType);
        Util.assertPrecondition(properties != null, "properties != null");
        Util.assertPrecondition(hideMemberCondition != null, "hideMemberCondition != null");
        Util.assertPrecondition(levelType != null, "levelType != null");
        if (keyExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)keyExp);
        }
        this.approxRowCount = this.loadApproxRowCount(approxRowCount);
        this.flags = flags;
        boolean isAll = (flags & 2) == 2;
        this.unique = (flags & 4) == 4;
        this.datatype = datatype;
        this.keyExp = keyExp;
        if (nameExp != null && nameExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)nameExp);
        }
        this.nameExp = nameExp;
        if (captionExp != null && captionExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)captionExp);
        }
        this.captionExp = captionExp;
        if (ordinalExp != null) {
            if (ordinalExp instanceof MondrianDef.Column) {
                this.checkColumn((MondrianDef.Column)ordinalExp);
            }
            this.ordinalExp = ordinalExp;
        } else {
            this.ordinalExp = this.keyExp;
        }
        this.parentExp = parentExp;
        if (parentExp != null) {
            Util.assertTrue(!isAll, new StringBuffer().append("'All' level '").append(this).append("' must not be parent-child").toString());
            Util.assertTrue(this.unique, new StringBuffer().append("Parent-child level '").append(this).append("' must have uniqueMembers=\"true\"").toString());
        }
        this.nullParentValue = nullParentValue;
        Util.assertPrecondition(parentExp != null || nullParentValue == null, "parentExp != null || nullParentValue == null");
        this.xmlClosure = xmlClosure;
        for (RolapProperty property : properties) {
            if (!(property.getExp() instanceof MondrianDef.Column)) continue;
            this.checkColumn((MondrianDef.Column)property.getExp());
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Level level = this; level != null; level = level.getParentLevel()) {
            Property[] levelProperties;
            for (Property levelProperty : levelProperties = level.getProperties()) {
                Property existingProperty = this.lookupProperty(list, levelProperty.getName());
                if (existingProperty == null) {
                    list.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError(new StringBuffer().append("Property ").append(this.getName()).append(".").append(levelProperty.getName()).append(" overrides a ").append("property with the same name but different type").toString());
            }
        }
        this.inheritedProperties = list.toArray(new RolapProperty[list.size()]);
        Dimension dim = hierarchy.getDimension();
        if (dim.getDimensionType() == DimensionType.TimeDimension) {
            if (!levelType.isTime() && !isAll) {
                throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
            }
        } else if (dim.getDimensionType() != null && levelType.isTime()) {
            throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
        }
        this.hideMemberCondition = hideMemberCondition;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return (RolapHierarchy)this.hierarchy;
    }

    private int loadApproxRowCount(String approxRowCount) {
        boolean notNullAndNumeric;
        boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
        if (notNullAndNumeric) {
            return Integer.parseInt(approxRowCount);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    String getTableName() {
        String tableName = null;
        MondrianDef.Expression expr = this.getKeyExp();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column mc = (MondrianDef.Column)expr;
            tableName = mc.getTableAlias();
        }
        return tableName;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public MondrianDef.Expression getKeyExp() {
        return this.keyExp;
    }

    MondrianDef.Expression getOrdinalExp() {
        return this.ordinalExp;
    }

    public MondrianDef.Expression getCaptionExp() {
        return this.captionExp;
    }

    public boolean hasCaptionColumn() {
        return this.captionExp != null;
    }

    int getFlags() {
        return this.flags;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    public boolean isUnique() {
        return this.unique;
    }

    SqlQuery.Datatype getDatatype() {
        return this.datatype;
    }

    String getNullParentValue() {
        return this.nullParentValue;
    }

    public boolean isParentChild() {
        return this.parentExp != null;
    }

    MondrianDef.Expression getParentExp() {
        return this.parentExp;
    }

    MondrianDef.Expression getNameExp() {
        return this.nameExp;
    }

    private Property lookupProperty(List<Property> list, String propertyName) {
        for (Property property : list) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, MondrianDef.Level xmlLevel) {
        this(hierarchy, depth, xmlLevel.name, xmlLevel.getKeyExp(), xmlLevel.getNameExp(), xmlLevel.getCaptionExp(), xmlLevel.getOrdinalExp(), xmlLevel.getParentExp(), xmlLevel.nullParentValue, xmlLevel.closure, RolapLevel.createProperties(xmlLevel), xmlLevel.uniqueMembers != false ? 4 : 0, xmlLevel.getDatatype(), HideMemberCondition.valueOf(xmlLevel.hideMemberIf), LevelType.valueOf(xmlLevel.levelType), xmlLevel.approxRowCount);
        if (!Util.isEmpty(xmlLevel.caption)) {
            this.setCaption(xmlLevel.caption);
        }
        if (!Util.isEmpty(xmlLevel.formatter)) {
            try {
                Class<?> clazz = Class.forName(xmlLevel.formatter);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.memberFormatter = (MemberFormatter)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw MondrianResource.instance().MemberFormatterLoadFailed.ex(xmlLevel.formatter, this.getUniqueName(), e);
            }
        }
    }

    private static RolapProperty[] createProperties(MondrianDef.Level xmlLevel) {
        ArrayList<RolapProperty> list = new ArrayList<RolapProperty>();
        MondrianDef.Expression nameExp = xmlLevel.getNameExp();
        if (nameExp != null) {
            list.add(new RolapProperty(Property.NAME.name, Property.Datatype.TYPE_STRING, nameExp, null, null));
        }
        for (int i = 0; i < xmlLevel.properties.length; ++i) {
            MondrianDef.Property property = xmlLevel.properties[i];
            list.add(new RolapProperty(property.name, RolapLevel.convertPropertyTypeNameToCode(property.type), xmlLevel.getPropertyExp(i), property.formatter, property.caption));
        }
        return list.toArray(new RolapProperty[list.size()]);
    }

    private static Property.Datatype convertPropertyTypeNameToCode(String type) {
        if (type.equals("String")) {
            return Property.Datatype.TYPE_STRING;
        }
        if (type.equals("Numeric")) {
            return Property.Datatype.TYPE_NUMERIC;
        }
        if (type.equals("Boolean")) {
            return Property.Datatype.TYPE_BOOLEAN;
        }
        throw Util.newError(new StringBuffer().append("Unknown property type '").append(type).append("'").toString());
    }

    private void checkColumn(MondrianDef.Column nameColumn) {
        RolapHierarchy rolapHierarchy = (RolapHierarchy)this.hierarchy;
        if (nameColumn.table == null) {
            MondrianDef.Relation table = rolapHierarchy.getUniqueTable();
            if (table == null) {
                throw Util.newError(new StringBuffer().append("must specify a table for level ").append(this.getUniqueName()).append(" because hierarchy has more than one table").toString());
            }
            nameColumn.table = table.getAlias();
        } else {
            Util.assertTrue(rolapHierarchy.tableExists(nameColumn.table));
        }
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        if (this.isAll()) {
            this.levelReader = new AllLevelReaderImpl();
        } else if (this.levelType == LevelType.Null) {
            this.levelReader = new NullLevelReader();
        } else if (this.xmlClosure != null) {
            RolapDimension dimension = ((RolapHierarchy)this.hierarchy).createClosedPeerDimension(this, this.xmlClosure, cube, xmlDimension);
            dimension.init(cube, xmlDimension);
            cube.registerDimension(dimension);
            RolapLevel closedPeer = (RolapLevel)dimension.getHierarchies()[0].getLevels()[1];
            this.levelReader = new ParentChildLevelReaderImpl(closedPeer);
        } else {
            this.levelReader = new RegularLevelReader();
        }
    }

    @Override
    public boolean isAll() {
        return this.hierarchy.hasAll() && this.depth == 0;
    }

    @Override
    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public String getTableAlias() {
        return this.keyExp.getTableAlias();
    }

    public RolapProperty[] getProperties() {
        return this.properties;
    }

    @Override
    public Property[] getInheritedProperties() {
        return this.inheritedProperties;
    }

    @Override
    public int getApproxRowCount() {
        return this.approxRowCount;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) {
        return this.lookupChild(schemaReader, name, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name, MatchType matchType) {
        Object[] levelMembers = schemaReader.getLevelMembers((Level)this, true);
        if (levelMembers.length > 0) {
            Member parent = levelMembers[0].getParentMember();
            return RolapUtil.findBestMemberMatch(Arrays.asList((Object[])levelMembers), (RolapMember)parent, this, name, matchType, false);
        }
        return null;
    }

    boolean hasClosedPeer() {
        return this.levelReader instanceof ParentChildLevelReaderImpl;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getHierarchy();
    }

    @Override
    public Property[] getProperties() {
        return this.getProperties();
    }

    static Hierarchy access$000(RolapLevel x0) {
        return x0.hierarchy;
    }

    static Hierarchy access$100(RolapLevel x0) {
        return x0.hierarchy;
    }

    static boolean access$200(RolapLevel x0) {
        return x0.unique;
    }

    static LevelReader access$300(RolapLevel x0) {
        return x0.levelReader;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            return true;
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            return false;
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParentChildLevelReaderImpl
    extends RegularLevelReader {
        private final RolapLevel closedPeer;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapLevel;

        ParentChildLevelReaderImpl(RolapLevel closedPeer) {
            this.closedPeer = closedPeer;
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            if (member.getDataMember() == null) {
                return super.constrainRequest(member, levelToColumnMap, request);
            }
            if (request.drillThrough) {
                member = (RolapMember)member.getDataMember();
                return super.constrainRequest(member, levelToColumnMap, request);
            }
            RolapLevel level = this.closedPeer;
            RolapMember allMember = (RolapMember)level.getHierarchy().getDefaultMember();
            if (!$assertionsDisabled && !allMember.isAll()) {
                throw new AssertionError();
            }
            member = new RolapMember(allMember, level, member.getKey());
            return level.getLevelReader().constrainRequest(member, levelToColumnMap, request);
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapLevel == null ? (class$mondrian$rolap$RolapLevel = ParentChildLevelReaderImpl.class$("mondrian.rolap.RolapLevel")) : class$mondrian$rolap$RolapLevel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegularLevelReader
    implements LevelReader {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapLevel;

        RegularLevelReader() {
        }

        @Override
        public boolean constrainRequest(RolapMember member, Map<RolapLevel, RolapStar.Column> levelToColumnMap, CellRequest request) {
            LevelReader levelReader;
            if (!$assertionsDisabled && member.getLevel() != RolapLevel.this) {
                throw new AssertionError();
            }
            if (member.getKey() == null) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                throw Util.newInternal("why is key null?");
            }
            RolapStar.Column column = levelToColumnMap.get(RolapLevel.this);
            if (column == null) {
                return member != RolapLevel.access$000(RolapLevel.this).getDefaultMember() || RolapLevel.access$100(RolapLevel.this).hasAll();
            }
            ValueColumnPredicate predicate = member.isCalculated() ? null : new ValueColumnPredicate(column, member.getSqlKey());
            request.addConstrainedColumn(column, predicate);
            if (request.extendedContext && RolapLevel.this.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                Util.assertTrue(nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
            if (member.isCalculated()) {
                return false;
            }
            if (RolapLevel.access$200(RolapLevel.this)) {
                return false;
            }
            RolapMember parent = member.getParentMember();
            while (true) {
                if (parent == null) {
                    return false;
                }
                RolapLevel level = parent.getLevel();
                levelReader = RolapLevel.access$300(level);
                if (levelReader != this) break;
                parent = parent.getParentMember();
            }
            return levelReader.constrainRequest(parent, levelToColumnMap, request);
        }

        @Override
        public void constrainRegion(StarColumnPredicate predicate, Map<RolapLevel, RolapStar.Column> levelToColumnMap, RolapCacheRegion cacheRegion) {
            RolapStar.Column column = levelToColumnMap.get(RolapLevel.this);
            if (column == null) {
                return;
            }
            if (predicate instanceof MemberColumnPredicate) {
                MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)predicate;
                RolapMember member = memberColumnPredicate.getMember();
                if (!$assertionsDisabled && member.getLevel() != RolapLevel.this) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && member.isCalculated()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && memberColumnPredicate.getMember().getKey() == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && member.isNull()) {
                    throw new AssertionError();
                }
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(levelToColumnMap, member);
                cacheRegion.addPredicate(column, predicate);
                return;
            }
            if (predicate instanceof RangeColumnPredicate) {
                RolapMember upperMember;
                RolapMember lowerMember;
                RangeColumnPredicate rangeColumnPredicate = (RangeColumnPredicate)predicate;
                ValueColumnPredicate lowerBound = rangeColumnPredicate.getLowerBound();
                if (lowerBound == null) {
                    lowerMember = null;
                } else if (lowerBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)lowerBound;
                    lowerMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                ValueColumnPredicate upperBound = rangeColumnPredicate.getUpperBound();
                if (upperBound == null) {
                    upperMember = null;
                } else if (upperBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)upperBound;
                    upperMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(levelToColumnMap, lowerMember, !rangeColumnPredicate.getLowerInclusive(), upperMember, !rangeColumnPredicate.getUpperInclusive());
                cacheRegion.addPredicate(predicate2);
                return;
            }
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapLevel == null ? (class$mondrian$rolap$RolapLevel = RegularLevelReader.class$("mondrian.rolap.RolapLevel")) : class$mondrian$rolap$RolapLevel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface LevelReader {
        public boolean constrainRequest(RolapMember var1, Map<RolapLevel, RolapStar.Column> var2, CellRequest var3);

        public void constrainRegion(StarColumnPredicate var1, Map<RolapLevel, RolapStar.Column> var2, RolapCacheRegion var3);
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.rolap.RolapLevel$HideMemberCondition>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HideMemberCondition
    extends Enum_ {
        public static final /* enum */ HideMemberCondition Never = new HideMemberCondition("Never", 0);
        public static final /* enum */ HideMemberCondition IfBlankName = new HideMemberCondition("IfBlankName", 1);
        public static final /* enum */ HideMemberCondition IfParentsName = new HideMemberCondition("IfParentsName", 2);
        private static final /* synthetic */ HideMemberCondition[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapLevel$HideMemberCondition;

        public static final HideMemberCondition[] values() {
            return (HideMemberCondition[])$VALUES.clone();
        }

        public static HideMemberCondition valueOf(String name) {
            return (HideMemberCondition)Enum_.valueOf((Class)(class$mondrian$rolap$RolapLevel$HideMemberCondition == null ? (class$mondrian$rolap$RolapLevel$HideMemberCondition = HideMemberCondition.class$("mondrian.rolap.RolapLevel$HideMemberCondition")) : class$mondrian$rolap$RolapLevel$HideMemberCondition), (String)name);
        }

        private HideMemberCondition(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new HideMemberCondition[]{Never, IfBlankName, IfParentsName};
            Enum_.setEnumValues((Object[])HideMemberCondition.values(), (Class)(class$mondrian$rolap$RolapLevel$HideMemberCondition == null ? (class$mondrian$rolap$RolapLevel$HideMemberCondition = HideMemberCondition.class$("mondrian.rolap.RolapLevel$HideMemberCondition")) : class$mondrian$rolap$RolapLevel$HideMemberCondition));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

