/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Autobox;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Access;
import mondrian.olap.CellFormatter;
import mondrian.olap.Cube;
import mondrian.olap.CubeBase;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionBase;
import mondrian.olap.DimensionType;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.CellReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.MeasureMemberSource;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.RolapVirtualCubeMeasure;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.aggmatcher.ExplicitRules;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCube
extends CubeBase {
    private static final Logger LOGGER;
    private final RolapSchema schema;
    private final RolapHierarchy measuresHierarchy;
    final MondrianDef.Relation fact;
    private final CellReader cellReader;
    private int[] localDimensionOrdinals;
    private SchemaReader schemaReader;
    private Formula[] calculatedMembers;
    private Formula[] namedSets;
    private final List<HierarchyUsage> hierarchyUsages;
    private RolapStar star;
    private ExplicitRules.Group aggGroup;
    private boolean load;
    private final Map<Hierarchy, HierarchyUsage> firstUsageMap = new HashMap<Hierarchy, HierarchyUsage>();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapCube;

    private RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, String name, boolean isCache, MondrianDef.Relation fact, MondrianDef.CubeDimension[] dimensions, boolean load) {
        super(name, new RolapDimension[dimensions.length + 1]);
        this.schema = schema;
        this.fact = fact;
        this.hierarchyUsages = new ArrayList<HierarchyUsage>();
        this.cellReader = AggregationManager.instance();
        this.calculatedMembers = new Formula[0];
        this.namedSets = new Formula[0];
        this.load = load;
        if (!this.isVirtual()) {
            this.star = schema.getRolapStarRegistry().getOrCreateStar(fact);
            if (!isCache) {
                this.star.setCacheAggregations(isCache);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            if (this.isVirtual()) {
                this.getLogger().debug((Object)new StringBuffer().append("RolapCube<init>: virtual cube=").append(this.name).toString());
            } else {
                this.getLogger().debug((Object)new StringBuffer().append("RolapCube<init>: cube=").append(this.name).toString());
            }
        }
        RolapDimension measuresDimension = new RolapDimension((Schema)schema, "Measures", 0, DimensionType.StandardDimension);
        this.dimensions[0] = measuresDimension;
        this.measuresHierarchy = measuresDimension.newHierarchy(null, false);
        if (!Util.isEmpty(xmlSchema.measuresCaption)) {
            measuresDimension.setCaption(xmlSchema.measuresCaption);
            this.measuresHierarchy.setCaption(xmlSchema.measuresCaption);
        }
        for (int i = 0; i < dimensions.length; ++i) {
            MondrianDef.CubeDimension xmlCubeDimension = dimensions[i];
            RolapDimension dimension = this.getOrCreateDimension(xmlCubeDimension, schema, xmlSchema);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)new StringBuffer().append("RolapCube<init>: dimension=").append(dimension.getName()).toString());
            }
            this.dimensions[i + 1] = dimension;
            if (this.isVirtual()) continue;
            this.createUsages(dimension, xmlCubeDimension);
        }
        schema.addCube(this);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.Cube xmlCube, boolean load) {
        this(schema, xmlSchema, xmlCube.name, xmlCube.cache, xmlCube.fact, xmlCube.dimensions, load);
        if (this.fact.getAlias() == null) {
            throw Util.newError(new StringBuffer().append("Must specify alias for fact table of cube ").append(this.getUniqueName()).toString());
        }
        RolapLevel measuresLevel = this.measuresHierarchy.newLevel("MeasuresLevel", 0);
        RolapMember[] measures = new RolapMember[xmlCube.measures.length];
        for (int i = 0; i < xmlCube.measures.length; ++i) {
            Boolean visible;
            MondrianDef.Expression measureExp;
            MondrianDef.Measure xmlMeasure = xmlCube.measures[i];
            if (xmlMeasure.column != null) {
                if (xmlMeasure.measureExp != null) {
                    throw MondrianResource.instance().BadMeasureSource.ex(xmlCube.name, xmlMeasure.name);
                }
                measureExp = new MondrianDef.Column(this.fact.getAlias(), xmlMeasure.column);
            } else if (xmlMeasure.measureExp != null) {
                measureExp = xmlMeasure.measureExp;
            } else {
                throw MondrianResource.instance().BadMeasureSource.ex(xmlCube.name, xmlMeasure.name);
            }
            RolapBaseCubeMeasure measure = new RolapBaseCubeMeasure(this, null, measuresLevel, xmlMeasure.name, xmlMeasure.formatString, measureExp, xmlMeasure.aggregator, xmlMeasure.datatype);
            measures[i] = measure;
            if (!Util.isEmpty(xmlMeasure.formatter)) {
                try {
                    Class<?> clazz = Class.forName(xmlMeasure.formatter);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    CellFormatter cellFormatter = (CellFormatter)ctor.newInstance(new Object[0]);
                    measure.setFormatter(cellFormatter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!Util.isEmpty(xmlMeasure.caption)) {
                measure.setProperty(Property.CAPTION.name, xmlMeasure.caption);
            }
            if ((visible = xmlMeasure.visible) == null) {
                visible = Boolean.TRUE;
            }
            measure.setProperty(Property.VISIBLE.name, visible);
            ArrayList<String> propNames = new ArrayList<String>();
            ArrayList<String> propExprs = new ArrayList<String>();
            this.validateMemberProps(xmlMeasure.memberProperties, propNames, propExprs, xmlMeasure.name);
            for (int j = 0; j < propNames.size(); ++j) {
                String propName = (String)propNames.get(j);
                Object propExpr = propExprs.get(j);
                measure.setProperty(propName, propExpr);
            }
        }
        this.measuresHierarchy.setMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measures)));
        this.init(xmlCube.dimensions);
        this.init(xmlCube);
        this.checkOrdinals(xmlCube.name, measures, xmlCube.calculatedMembers);
        this.loadAggGroup(xmlCube);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.VirtualCube xmlVirtualCube, boolean load) {
        this(schema, xmlSchema, xmlVirtualCube.name, true, null, xmlVirtualCube.dimensions, load);
        RolapLevel measuresLevel = this.measuresHierarchy.newLevel("MeasuresLevel", 0);
        ArrayList<RolapVirtualCubeMeasure> origMeasureList = new ArrayList<RolapVirtualCubeMeasure>();
        ArrayList<MondrianDef.CalculatedMember> origCalcMeasureList = new ArrayList<MondrianDef.CalculatedMember>();
        CubeComparator cubeComparator = new CubeComparator(null);
        TreeMap<RolapCube, ArrayList<MondrianDef.CalculatedMember>> calculatedMembersMap = new TreeMap<RolapCube, ArrayList<MondrianDef.CalculatedMember>>(cubeComparator);
        for (MondrianDef.VirtualCubeMeasure xmlMeasure : xmlVirtualCube.measures) {
            RolapCube cube = schema.lookupCube(xmlMeasure.cubeName);
            Member[] cubeMeasures = cube.getMeasures();
            boolean found = false;
            for (Member cubeMeasure : cubeMeasures) {
                if (!cubeMeasure.getUniqueName().equals(xmlMeasure.name)) continue;
                found = true;
                if (cubeMeasure instanceof RolapCalculatedMember) {
                    MondrianDef.CalculatedMember calcMember = schema.lookupXmlCalculatedMember(xmlMeasure.name, xmlMeasure.cubeName);
                    if (calcMember == null) {
                        throw Util.newInternal(new StringBuffer().append("Could not find XML Calculated Member '").append(xmlMeasure.name).append("' in XML cube '").append(xmlMeasure.cubeName).append("'").toString());
                    }
                    ArrayList<MondrianDef.CalculatedMember> memberList = (ArrayList<MondrianDef.CalculatedMember>)calculatedMembersMap.get(cube);
                    if (memberList == null) {
                        memberList = new ArrayList<MondrianDef.CalculatedMember>();
                    }
                    memberList.add(calcMember);
                    origCalcMeasureList.add(calcMember);
                    calculatedMembersMap.put(cube, memberList);
                    break;
                }
                RolapVirtualCubeMeasure virtualCubeMeasure = new RolapVirtualCubeMeasure(null, measuresLevel, (RolapStoredMeasure)cubeMeasure);
                Boolean visible = xmlMeasure.visible;
                if (visible == null) {
                    visible = Boolean.TRUE;
                }
                virtualCubeMeasure.setProperty(Property.VISIBLE.name, visible);
                origMeasureList.add(virtualCubeMeasure);
                break;
            }
            if (found) continue;
            throw Util.newInternal(new StringBuffer().append("could not find measure '").append(xmlMeasure.name).append("' in cube '").append(xmlMeasure.cubeName).append("'").toString());
        }
        this.init(xmlVirtualCube.dimensions);
        ArrayList<RolapVirtualCubeMeasure> modifiedMeasureList = new ArrayList<RolapVirtualCubeMeasure>(origMeasureList);
        Iterator i$ = calculatedMembersMap.keySet().iterator();
        while (i$.hasNext()) {
            RolapCube o;
            RolapCube baseCube = o = (RolapCube)i$.next();
            List calculatedMemberList = (List)calculatedMembersMap.get(baseCube);
            Query queryExp = this.resolveCalcMembers(calculatedMemberList.toArray(new MondrianDef.CalculatedMember[calculatedMemberList.size()]), new MondrianDef.NamedSet[0], baseCube, false);
            MeasureFinder measureFinder = new MeasureFinder(this, baseCube, measuresLevel);
            queryExp.accept(measureFinder);
            modifiedMeasureList.addAll(measureFinder.getMeasuresFound());
        }
        ArrayList calculatedMemberList = new ArrayList();
        Iterator i$2 = calculatedMembersMap.keySet().iterator();
        while (i$2.hasNext()) {
            RolapCube o;
            RolapCube baseCube = o = (RolapCube)i$2.next();
            calculatedMemberList.addAll((Collection)calculatedMembersMap.get(baseCube));
        }
        calculatedMemberList.addAll(Arrays.asList((Object[])xmlVirtualCube.calculatedMembers));
        RolapMember[] measures = modifiedMeasureList.toArray(new RolapMember[modifiedMeasureList.size()]);
        this.measuresHierarchy.setMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measures)));
        this.createCalcMembersAndNamedSets(calculatedMemberList.toArray(new MondrianDef.CalculatedMember[calculatedMemberList.size()]), new MondrianDef.NamedSet[0], new ArrayList<Member>(), new ArrayList<Formula>(), this, false);
        measures = origMeasureList.toArray(new RolapMember[origMeasureList.size()]);
        this.measuresHierarchy.setMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measures)));
        ArrayList<Formula> finalCalcMemberList = new ArrayList<Formula>();
        for (Formula calculatedMember : this.calculatedMembers) {
            if (this.findOriginalMembers(calculatedMember, origCalcMeasureList, finalCalcMemberList)) continue;
            this.findOriginalMembers(calculatedMember, Arrays.asList((Object[])xmlVirtualCube.calculatedMembers), finalCalcMemberList);
        }
        this.calculatedMembers = finalCalcMemberList.toArray(new Formula[finalCalcMemberList.size()]);
    }

    private boolean findOriginalMembers(Formula formula, List<MondrianDef.CalculatedMember> calcMemberList, List<Formula> finalCalcMemberList) {
        for (MondrianDef.CalculatedMember xmlCalcMember : calcMemberList) {
            Dimension dimension = (Dimension)this.lookupDimension(xmlCalcMember.dimension);
            if (!formula.getName().equals(xmlCalcMember.name) || !formula.getMdxMember().getDimension().getName().equals(dimension.getName())) continue;
            finalCalcMemberList.add(formula);
            return true;
        }
        return false;
    }

    protected void validate() {
        HashMap<String, List<Object>> aliases = new HashMap<String, List<Object>>();
        ArrayList<Object> joinPath = new ArrayList<Object>();
        joinPath.add(this);
        for (Dimension dimension : this.dimensions) {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                MondrianDef.Relation relation = ((RolapHierarchy)hierarchy).getRelation();
                if (relation == null) continue;
                HierarchyUsage hierarchyUsage = this.getFirstUsage(hierarchy);
                joinPath.add(hierarchyUsage.getForeignKey());
                this.validateRelation(aliases, relation, joinPath);
                joinPath.remove(joinPath.size() - 1);
            }
        }
    }

    private void validateRelation(Map<String, List<Object>> aliases, MondrianDef.Relation relation, List<Object> joinPath) {
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            this.validateRelation(aliases, join.left, joinPath);
            int saveSize = joinPath.size();
            this.flatten(relation, joinPath);
            joinPath.add(join.leftKey);
            joinPath.add(join.rightKey);
            this.validateRelation(aliases, join.right, joinPath);
            while (joinPath.size() > saveSize) {
                joinPath.remove(joinPath.size() - 1);
            }
        } else {
            String alias;
            MondrianDef.Relation table;
            if (relation instanceof MondrianDef.Table) {
                table = (MondrianDef.Table)relation;
                alias = table.alias;
                if (alias == null) {
                    alias = table.name;
                }
            } else if (relation instanceof MondrianDef.InlineTable) {
                table = (MondrianDef.InlineTable)relation;
                alias = ((MondrianDef.InlineTable)table).alias;
            } else {
                MondrianDef.View view = (MondrianDef.View)relation;
                alias = view.alias;
            }
            joinPath.add((Object)relation);
            joinPath.add(alias);
            List<Object> joinPath2 = aliases.get(alias);
            if (joinPath2 == null) {
                aliases.put(alias, new ArrayList<Object>(joinPath));
            } else if (!((Object)joinPath).equals(joinPath2)) {
                throw MondrianResource.instance().DuplicateAliasInCube.ex(alias, this.getUniqueName());
            }
            joinPath.remove(joinPath.size() - 1);
            joinPath.remove(joinPath.size() - 1);
        }
    }

    private void flatten(MondrianDef.Relation relation, List<Object> joinPath) {
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            this.flatten(join.left, joinPath);
            this.flatten(join.right, joinPath);
        } else {
            joinPath.add((Object)relation);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public boolean hasAggGroup() {
        return this.aggGroup != null;
    }

    public ExplicitRules.Group getAggGroup() {
        return this.aggGroup;
    }

    void loadAggGroup(MondrianDef.Cube xmlCube) {
        this.aggGroup = ExplicitRules.Group.make(this, xmlCube);
    }

    private RolapDimension getOrCreateDimension(MondrianDef.CubeDimension xmlCubeDimension, RolapSchema schema, MondrianDef.Schema xmlSchema) {
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy sharedHierarchy = schema.getSharedHierarchy(usage.source);
            if (sharedHierarchy != null) {
                return (RolapDimension)sharedHierarchy.getDimension();
            }
        }
        MondrianDef.Dimension xmlDimension = xmlCubeDimension.getDimension(xmlSchema);
        return new RolapDimension(schema, this, xmlDimension, xmlCubeDimension);
    }

    private void init(MondrianDef.Cube xmlCube) {
        ArrayList<Member> memberList = new ArrayList<Member>();
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        this.createCalcMembersAndNamedSets(xmlCube.calculatedMembers, xmlCube.namedSets, memberList, formulaList, this, true);
    }

    private void checkOrdinals(String cubeName, RolapMember[] measures, MondrianDef.CalculatedMember[] xmlCalcMembers) {
        HashMap<Integer, String> ordinals = new HashMap<Integer, String>();
        for (RolapMember rolapMember : measures) {
            Integer ordinal = Autobox.valueOf((int)rolapMember.getOrdinal());
            if (ordinals.containsKey(ordinal)) {
                throw MondrianResource.instance().MeasureOrdinalsNotUnique.ex(cubeName, ordinal.toString(), (String)ordinals.get(ordinal), rolapMember.getUniqueName());
            }
            ordinals.put(ordinal, rolapMember.getUniqueName());
        }
        for (MondrianDef.CalculatedMember calculatedMember : xmlCalcMembers) {
            if (!calculatedMember.dimension.equalsIgnoreCase("Measures")) continue;
            MondrianDef.CalculatedMemberProperty[] properties = calculatedMember.memberProperties;
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].name.equals(Property.MEMBER_ORDINAL.getName())) continue;
                Integer ordinal = new Integer(properties[j].value);
                String uname = new StringBuffer().append("[Measures].[").append(calculatedMember.name).append("]").toString();
                if (!ordinals.containsKey(ordinal)) {
                    ordinals.put(ordinal, uname);
                    continue;
                }
                throw MondrianResource.instance().MeasureOrdinalsNotUnique.ex(cubeName, ordinal.toString(), (String)ordinals.get(ordinal), uname);
            }
        }
    }

    private void createCalcMembersAndNamedSets(MondrianDef.CalculatedMember[] xmlCalcMembers, MondrianDef.NamedSet[] xmlNamedSets, List<Member> memberList, List<Formula> formulaList, RolapCube cube, boolean errOnDups) {
        int i;
        Query queryExp = this.resolveCalcMembers(xmlCalcMembers, xmlNamedSets, cube, errOnDups);
        if (queryExp == null) {
            return;
        }
        Util.assertTrue(queryExp.formulas.length == xmlCalcMembers.length + xmlNamedSets.length);
        for (i = 0; i < xmlCalcMembers.length; ++i) {
            this.postCalcMember(xmlCalcMembers, i, queryExp, memberList);
        }
        for (i = 0; i < xmlNamedSets.length; ++i) {
            this.postNamedSet(xmlNamedSets, xmlCalcMembers.length, i, queryExp, formulaList);
        }
    }

    private Query resolveCalcMembers(MondrianDef.CalculatedMember[] xmlCalcMembers, MondrianDef.NamedSet[] xmlNamedSets, RolapCube cube, boolean errOnDups) {
        Query queryExp;
        if (xmlCalcMembers.length == 0 && xmlNamedSets.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("WITH").append(Util.nl);
        for (int i = 0; i < xmlCalcMembers.length; ++i) {
            this.preCalcMember(xmlCalcMembers, i, buf, cube, errOnDups);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (Formula formula : this.namedSets) {
            nameSet.add(formula.getName());
        }
        for (MondrianDef.NamedSet namedSet : xmlNamedSets) {
            this.preNamedSet(namedSet, nameSet, buf);
        }
        buf.append("SELECT FROM ").append(Util.quoteMdxIdentifier(cube.getUniqueName()));
        String string = buf.toString();
        try {
            RolapConnection conn = this.schema.getInternalConnection();
            queryExp = conn.parseQuery(string, this.load);
        }
        catch (Exception e) {
            throw MondrianResource.instance().UnknownNamedSetHasBadFormula.ex(this.getUniqueName(), e);
        }
        queryExp.resolve();
        return queryExp;
    }

    private void postNamedSet(MondrianDef.NamedSet[] xmlNamedSets, int offset, int i, Query queryExp, List<Formula> formulaList) {
        MondrianDef.NamedSet xmlNamedSet = xmlNamedSets[i];
        Util.discard((Object)((Object)xmlNamedSet));
        Formula formula = queryExp.formulas[offset + i];
        this.namedSets = (Formula[])RolapUtil.addElement(this.namedSets, formula);
        formulaList.add(formula);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void preNamedSet(MondrianDef.NamedSet xmlNamedSet, Set nameSet, StringBuffer buf) {
        if (!nameSet.add(xmlNamedSet.name)) {
            throw MondrianResource.instance().NamedSetNotUnique.ex(xmlNamedSet.name, this.getUniqueName());
        }
        buf.append("SET ").append(Util.makeFqName(xmlNamedSet.name)).append(Util.nl).append(" AS ");
        Util.singleQuoteString(xmlNamedSet.getFormula(), buf);
        buf.append(Util.nl);
    }

    private void postCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int i, Query queryExp, List<Member> memberList) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[i];
        Formula formula = queryExp.formulas[i];
        this.calculatedMembers = (Formula[])RolapUtil.addElement(this.calculatedMembers, formula);
        Member member = formula.getMdxMember();
        Boolean visible = xmlCalcMember.visible;
        if (visible == null) {
            visible = Boolean.TRUE;
        }
        member.setProperty(Property.VISIBLE.name, visible);
        if (xmlCalcMember.caption != null && xmlCalcMember.caption.length() > 0) {
            member.setProperty(Property.CAPTION.name, xmlCalcMember.caption);
        }
        memberList.add(formula.getMdxMember());
    }

    private void preCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int j, StringBuffer buf, RolapCube cube, boolean errOnDup) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[j];
        Dimension dimension = (Dimension)this.lookupDimension(xmlCalcMember.dimension);
        if (dimension == null) {
            throw MondrianResource.instance().CalcMemberHasBadDimension.ex(xmlCalcMember.dimension, xmlCalcMember.name, this.getUniqueName());
        }
        ArrayList<Formula> newCalcMemberList = new ArrayList<Formula>();
        for (Formula formula : this.calculatedMembers) {
            if (formula.getName().equals(xmlCalcMember.name) && formula.getMdxMember().getDimension().getName().equals(dimension.getName())) {
                if (!errOnDup) continue;
                throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getUniqueName());
            }
            newCalcMemberList.add(formula);
        }
        this.calculatedMembers = newCalcMemberList.toArray(new Formula[newCalcMemberList.size()]);
        for (int k = 0; k < j; ++k) {
            MondrianDef.CalculatedMember xmlCalcMember2 = xmlCalcMembers[k];
            if (!xmlCalcMember2.name.equals(xmlCalcMember.name) || !xmlCalcMember2.dimension.equals(xmlCalcMember.dimension)) continue;
            throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getUniqueName());
        }
        String memberUniqueName = Util.makeFqName(dimension.getUniqueName(), xmlCalcMember.name);
        MondrianDef.CalculatedMemberProperty[] xmlProperties = xmlCalcMember.memberProperties;
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propExprs = new ArrayList<String>();
        this.validateMemberProps(xmlProperties, propNames, propExprs, xmlCalcMember.name);
        int measureCount = cube.measuresHierarchy.getMemberReader().getMemberCount();
        if (!$assertionsDisabled && !memberUniqueName.startsWith("[")) {
            throw new AssertionError();
        }
        buf.append("MEMBER ").append(memberUniqueName).append(Util.nl).append("  AS ");
        Util.singleQuoteString(xmlCalcMember.getFormula(), buf);
        if (!$assertionsDisabled && propNames.size() != propExprs.size()) {
            throw new AssertionError();
        }
        this.processFormatStringAttribute(xmlCalcMember, buf);
        for (int i = 0; i < propNames.size(); ++i) {
            String name = (String)propNames.get(i);
            String expr = (String)propExprs.get(i);
            buf.append(",").append(Util.nl).append(name).append(" = ").append(expr);
        }
        buf.append(",").append(Util.nl).append(Util.quoteMdxIdentifier(Property.MEMBER_SCOPE.name)).append(" = 'CUBE'");
        if (!propNames.contains(Property.MEMBER_ORDINAL.getName())) {
            buf.append(",").append(Util.nl).append(Property.MEMBER_ORDINAL).append(" = ").append(measureCount + j);
        }
        buf.append(Util.nl);
    }

    void processFormatStringAttribute(MondrianDef.CalculatedMember xmlCalcMember, StringBuffer buf) {
        if (xmlCalcMember.formatString != null) {
            buf.append(",").append(Util.nl).append(Property.FORMAT_STRING.name).append(" = ").append(Util.quoteForMdx(xmlCalcMember.formatString));
        }
    }

    private void validateMemberProps(MondrianDef.CalculatedMemberProperty[] xmlProperties, List<String> propNames, List<String> propExprs, String memberName) {
        MemberProperty[] properties = new MemberProperty[xmlProperties.length];
        for (int i = 0; i < properties.length; ++i) {
            MondrianDef.CalculatedMemberProperty xmlProperty = xmlProperties[i];
            if (xmlProperty.expression == null && xmlProperty.value == null) {
                throw MondrianResource.instance().NeitherExprNorValueForCalcMemberProperty.ex(xmlProperty.name, memberName, this.getUniqueName());
            }
            if (xmlProperty.expression != null && xmlProperty.value != null) {
                throw MondrianResource.instance().ExprAndValueForMemberProperty.ex(xmlProperty.name, memberName, this.getUniqueName());
            }
            propNames.add(xmlProperty.name);
            if (xmlProperty.expression != null) {
                propExprs.add(xmlProperty.expression);
                continue;
            }
            propExprs.add(Util.quoteForMdx(xmlProperty.value));
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public synchronized SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = this.getSchemaReader(null);
        }
        return this.schemaReader;
    }

    @Override
    public SchemaReader getSchemaReader(Role role) {
        if (role == null) {
            role = this.schema.getDefaultRole().makeMutableClone();
            role.grant(this, Access.ALL);
        }
        return new RolapCubeSchemaReader(role);
    }

    MondrianDef.CubeDimension lookup(MondrianDef.CubeDimension[] xmlDimensions, String name) {
        for (MondrianDef.CubeDimension cd : xmlDimensions) {
            if (!name.equals(cd.name)) continue;
            return cd;
        }
        return null;
    }

    private void init(MondrianDef.CubeDimension[] xmlDimensions) {
        int max = -1;
        for (Dimension dimension1 : this.dimensions) {
            RolapDimension dimension = (RolapDimension)dimension1;
            dimension.init(this, this.lookup(xmlDimensions, dimension.getName()));
            max = Math.max(max, dimension.getGlobalOrdinal());
        }
        this.localDimensionOrdinals = new int[max + 1];
        Arrays.fill((int[])this.localDimensionOrdinals, (int)-1);
        int i = 0;
        while (i < this.dimensions.length) {
            RolapDimension dimension = (RolapDimension)this.dimensions[i];
            int globalOrdinal = dimension.getGlobalOrdinal();
            this.localDimensionOrdinals[globalOrdinal] = i++;
        }
        this.register();
    }

    private void register() {
        Dimension[] dimensions;
        Member[] measures;
        if (this.isVirtual()) {
            return;
        }
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member measure : measures = this.getMeasures()) {
            if (!(measure instanceof RolapBaseCubeMeasure)) continue;
            list.add(measure);
        }
        RolapBaseCubeMeasure[] storedMeasures = list.toArray(new RolapBaseCubeMeasure[list.size()]);
        RolapStar star = this.getStar();
        RolapStar.Table table = star.getFactTable();
        for (RolapBaseCubeMeasure storedMeasure : storedMeasures) {
            table.makeMeasure(storedMeasure);
        }
        for (Dimension dimension : dimensions = this.getDimensions()) {
            this.registerDimension(dimension);
        }
    }

    int getOrdinal(int globalOrdinal) {
        return this.localDimensionOrdinals[globalOrdinal];
    }

    CellReader getCellReader() {
        return this.cellReader;
    }

    public boolean isCacheAggregations() {
        return this.isVirtual() || this.star.isCacheAggregations();
    }

    public void setCacheAggregations(boolean cache) {
        if (!this.isVirtual()) {
            this.star.setCacheAggregations(cache);
        }
    }

    public void clearCachedAggregations() {
        if (this.isVirtual()) {
            this.schema.flushRolapStarCaches(false);
        } else {
            this.star.clearCachedAggregations(false);
        }
    }

    public void checkAggregateModifications() {
        if (this.isVirtual()) {
            this.schema.checkAggregateModifications();
        } else {
            this.star.checkAggregateModifications();
        }
    }

    public void pushAggregateModificationsToGlobalCache() {
        if (this.isVirtual()) {
            this.schema.pushAggregateModificationsToGlobalCache();
        } else {
            this.star.pushAggregateModificationsToGlobalCache();
        }
    }

    public RolapStar getStar() {
        return this.star;
    }

    private void createUsages(RolapDimension dimension, MondrianDef.CubeDimension xmlCubeDimension) {
        RolapHierarchy[] hierarchies = (RolapHierarchy[])dimension.getHierarchies();
        if (hierarchies.length == 1) {
            this.createUsage(hierarchies[0], xmlCubeDimension);
        } else if (xmlCubeDimension instanceof MondrianDef.DimensionUsage && ((MondrianDef.DimensionUsage)xmlCubeDimension).level != null) {
            MondrianDef.DimensionUsage du = (MondrianDef.DimensionUsage)xmlCubeDimension;
            int cnt = 0;
            for (RolapHierarchy hierarchy : hierarchies) {
                RolapLevel joinLevel;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)new StringBuffer().append("RolapCube<init>: hierarchy=").append(hierarchy.getName()).toString());
                }
                if ((joinLevel = (RolapLevel)Util.lookupHierarchyLevel(hierarchy, du.level)) == null) continue;
                this.createUsage(hierarchy, xmlCubeDimension);
                ++cnt;
            }
            if (cnt == 0) {
                this.createUsage(hierarchies[0], xmlCubeDimension);
            }
        } else {
            for (RolapHierarchy hierarchy : hierarchies) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)new StringBuffer().append("RolapCube<init>: hierarchy=").append(hierarchy.getName()).toString());
                }
                this.createUsage(hierarchy, xmlCubeDimension);
            }
        }
    }

    synchronized void createUsage(RolapHierarchy hierarchy, MondrianDef.CubeDimension cubeDim) {
        HierarchyUsage usage = new HierarchyUsage(this, hierarchy, cubeDim);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)new StringBuffer().append("RolapCube.createUsage: cube=").append(this.getName()).append(", hierarchy=").append(hierarchy.getName()).append(", usage=").append(usage).toString());
        }
        for (HierarchyUsage hierUsage : this.hierarchyUsages) {
            if (!hierUsage.equals(usage)) continue;
            this.getLogger().warn((Object)new StringBuffer().append("RolapCube.createUsage: duplicate ").append(hierUsage).toString());
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)new StringBuffer().append("RolapCube.createUsage: register ").append(usage).toString());
        }
        this.hierarchyUsages.add(usage);
    }

    private synchronized HierarchyUsage getUsageByName(String name) {
        for (HierarchyUsage hierUsage : this.hierarchyUsages) {
            if (!hierUsage.getFullName().equals(name)) continue;
            return hierUsage;
        }
        return null;
    }

    public synchronized HierarchyUsage[] getUsages(Hierarchy hierarchy) {
        String name = hierarchy.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsages: name=").append(name).toString());
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        for (HierarchyUsage hu : this.hierarchyUsages) {
            if (!hu.getHierarchyName().equals(name)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsages: add list HierarchyUsage.name=").append(hu.getName()).toString());
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsages: add list hierUsage.name=").append(hierUsage.getName()).append(", hu.name=").append(hu.getName()).toString());
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsages: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    synchronized HierarchyUsage getFirstUsage(Hierarchy hier) {
        HierarchyUsage[] hierarchyUsages;
        HierarchyUsage hierarchyUsage = this.firstUsageMap.get(hier);
        if (hierarchyUsage == null && (hierarchyUsages = this.getUsages(hier)).length != 0) {
            hierarchyUsage = hierarchyUsages[0];
            this.firstUsageMap.put(hier, hierarchyUsage);
        }
        return hierarchyUsage;
    }

    synchronized HierarchyUsage[] getUsagesBySource(String source) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsagesBySource: source=").append(source).toString());
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        for (HierarchyUsage hu : this.hierarchyUsages) {
            String s = hu.getSource();
            if (s == null || !s.equals(source)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsagesBySource: add list HierarchyUsage.name=").append(hu.getName()).toString());
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)new StringBuffer().append("RolapCube.getUsagesBySource: add list hierUsage.name=").append(hierUsage.getName()).append(", hu.name=").append(hu.getName()).toString());
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsagesBySource: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    void registerDimension(Dimension dimension) {
        Hierarchy[] hierarchies;
        RolapStar star = this.getStar();
        for (Hierarchy hierarchy1 : hierarchies = dimension.getHierarchies()) {
            RolapHierarchy hierarchy = (RolapHierarchy)hierarchy1;
            MondrianDef.Relation relation = hierarchy.getRelation();
            if (relation == null) continue;
            RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
            HierarchyUsage[] hierarchyUsages = this.getUsages(hierarchy);
            if (hierarchyUsages.length == 0) {
                if (!this.getLogger().isDebugEnabled()) continue;
                StringBuffer buf = new StringBuffer(64);
                buf.append("RolapCube.registerDimension: ");
                buf.append("hierarchyUsages == null for cube=\"");
                buf.append(this.name);
                buf.append("\", hierarchy=\"");
                buf.append(hierarchy.getName());
                buf.append("\"");
                this.getLogger().debug((Object)buf.toString());
                continue;
            }
            block1: for (HierarchyUsage hierarchyUsage : hierarchyUsages) {
                String usagePrefix = hierarchyUsage.getUsagePrefix();
                RolapStar.Table table = star.getFactTable();
                String levelName = hierarchyUsage.getLevelName();
                if (relation instanceof MondrianDef.Join) {
                    MondrianDef.Relation relationTmp1 = relation;
                    if ((relation = RolapCube.reorder(relation, levels)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after reorder relation==null");
                        this.getLogger().debug((Object)new StringBuffer().append("RolapCube.registerDimension: reorder relationTmp1=").append(RolapCube.format(relationTmp1)).toString());
                    }
                }
                MondrianDef.Relation relationTmp2 = relation;
                if (levelName != null) {
                    String tableName;
                    RolapLevel childLevel;
                    RolapLevel level = RolapLevel.lookupLevel(levels, levelName);
                    if (level == null) {
                        StringBuffer buf = new StringBuffer(64);
                        buf.append("For cube \"");
                        buf.append(this.getName());
                        buf.append("\" and HierarchyUsage [");
                        buf.append(hierarchyUsage);
                        buf.append("], there is no level with given");
                        buf.append(" level name \"");
                        buf.append(levelName);
                        buf.append("\"");
                        throw Util.newInternal(buf.toString());
                    }
                    if (relation instanceof MondrianDef.Join && (childLevel = (RolapLevel)level.getChildLevel()) != null && (tableName = childLevel.getTableName()) != null && (relation = RolapCube.snip(relation, tableName)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after snip relation==null");
                        this.getLogger().debug((Object)new StringBuffer().append("RolapCube.registerDimension: snip relationTmp2=").append(RolapCube.format(relationTmp2)).toString());
                    }
                }
                if (!relation.equals((Object)table.getRelation())) {
                    if (hierarchyUsage.getForeignKey() == null) {
                        throw MondrianResource.instance().HierarchyMustHaveForeignKey.ex(hierarchy.getName(), this.getName());
                    }
                    MondrianDef.Column column = new MondrianDef.Column(table.getAlias(), hierarchyUsage.getForeignKey());
                    RolapStar.Condition joinCondition = new RolapStar.Condition(column, hierarchyUsage.getJoinExp());
                    table = table.addJoin(relation, joinCondition);
                }
                RolapStar.Column parentColumn = null;
                if (levelName != null) {
                    for (RolapLevel level : levels) {
                        if (level.getKeyExp() != null) {
                            parentColumn = this.makeColumns(table, level, parentColumn, usagePrefix);
                        }
                        if (levelName.equals(level.getName())) continue block1;
                    }
                    continue;
                }
                for (RolapLevel level : levels) {
                    if (level.getKeyExp() == null) continue;
                    parentColumn = this.makeColumns(table, level, parentColumn, usagePrefix);
                }
            }
        }
    }

    protected RolapStar.Column makeColumns(RolapStar.Table table, RolapLevel level, RolapStar.Column parentColumn, String usagePrefix) {
        String tableName = level.getTableName();
        if (tableName != null) {
            if (table.getAlias().equals(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else if (table.equalsTableName(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else {
                RolapStar.Table t = table.findAncestor(tableName);
                if (t != null) {
                    parentColumn = t.makeColumns(this, level, parentColumn, usagePrefix);
                } else {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("RolapCube.makeColumns: for cube \"");
                    buf.append(this.getName());
                    buf.append("\" the Level \"");
                    buf.append(level.getName());
                    buf.append("\" has a table name attribute \"");
                    buf.append(tableName);
                    buf.append("\" but the associated RolapStar does not");
                    buf.append(" have a table with that name.");
                    this.getLogger().warn((Object)buf.toString());
                    parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
                }
            }
        } else {
            parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
        }
        return parentColumn;
    }

    private static String format(MondrianDef.Relation relation) {
        StringBuffer buf = new StringBuffer();
        RolapCube.format(relation, buf, "");
        return buf.toString();
    }

    private static void format(MondrianDef.Relation relation, StringBuffer buf, String indent) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            buf.append(indent);
            buf.append(table.name);
            if (table.alias != null) {
                buf.append('(');
                buf.append(table.alias);
                buf.append(')');
            }
            buf.append(Util.nl);
        } else {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String subindent = new StringBuffer().append(indent).append("  ").toString();
            buf.append(indent);
            buf.append(join.getLeftAlias());
            buf.append('.');
            buf.append(join.leftKey);
            buf.append('=');
            buf.append(join.getRightAlias());
            buf.append('.');
            buf.append(join.rightKey);
            buf.append(Util.nl);
            RolapCube.format(join.left, buf, subindent);
            RolapCube.format(join.right, buf, indent);
        }
    }

    private static MondrianDef.Relation reorder(MondrianDef.Relation relation, RolapLevel[] levels) {
        if (levels.length < 2) {
            return relation;
        }
        HashMap<String, RelNode> nodeMap = new HashMap<String, RelNode>();
        for (int i = 0; i < levels.length; ++i) {
            RolapLevel level = levels[i];
            if (level.isAll()) continue;
            String tableName = level.getTableName();
            if (tableName == null) {
                return relation;
            }
            RelNode rnode = new RelNode(tableName, i);
            nodeMap.put(tableName, rnode);
        }
        if (!RolapCube.validateNodes(relation, nodeMap)) {
            return relation;
        }
        relation = RolapCube.copy(relation);
        RolapCube.leftToRight(relation, nodeMap);
        RolapCube.topToBottom(relation);
        return relation;
    }

    private static boolean validateNodes(MondrianDef.Relation relation, Map<String, RelNode> map) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            RelNode relNode = RelNode.access$100(table, map);
            return relNode != null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return RolapCube.validateNodes(join.left, map) && RolapCube.validateNodes(join.right, map);
        }
        throw Util.newInternal(new StringBuffer().append("bad relation type ").append((Object)relation).toString());
    }

    private static int leftToRight(MondrianDef.Relation relation, Map<String, RelNode> map) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            RelNode relNode = RelNode.access$100(table, map);
            RelNode.access$202(relNode, table);
            return RelNode.access$300(relNode);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            int leftDepth = RolapCube.leftToRight(join.left, map);
            int rightDepth = RolapCube.leftToRight(join.right, map);
            if (rightDepth > leftDepth) {
                String leftAlias = join.leftAlias;
                String leftKey = join.leftKey;
                MondrianDef.Relation left = join.left;
                join.leftAlias = join.rightAlias;
                join.leftKey = join.rightKey;
                join.left = join.right;
                join.rightAlias = leftAlias;
                join.rightKey = leftKey;
                join.right = left;
            }
            return leftDepth;
        }
        throw Util.newInternal(new StringBuffer().append("bad relation type ").append((Object)relation).toString());
    }

    private static void topToBottom(MondrianDef.Relation relation) {
        if (!(relation instanceof MondrianDef.Table) && relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            while (join.left instanceof MondrianDef.Join) {
                MondrianDef.Join jleft = (MondrianDef.Join)join.left;
                join.right = new MondrianDef.Join(join.leftAlias, join.leftKey, jleft.right, join.rightAlias, join.rightKey, join.right);
                join.left = jleft.left;
                join.rightAlias = jleft.rightAlias;
                join.rightKey = jleft.rightKey;
                join.leftAlias = jleft.leftAlias;
                join.leftKey = jleft.leftKey;
            }
        }
    }

    private static MondrianDef.Relation copy(MondrianDef.Relation relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return new MondrianDef.Table(table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation left = RolapCube.copy(join.left);
            MondrianDef.Relation right = RolapCube.copy(join.right);
            return new MondrianDef.Join(join.leftAlias, join.leftKey, left, join.rightAlias, join.rightKey, right);
        }
        throw Util.newInternal(new StringBuffer().append("bad relation type ").append((Object)relation).toString());
    }

    private static MondrianDef.Relation snip(MondrianDef.Relation relation, String tableName) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.alias != null && table.alias.equals(tableName) ? null : (table.name.equals(tableName) ? null : table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation left = RolapCube.snip(join.left, tableName);
            if (left == null) {
                return join.right;
            }
            join.left = left;
            MondrianDef.Relation right = RolapCube.snip(join.right, tableName);
            if (right == null) {
                return join.left;
            }
            join.right = right;
            return join;
        }
        throw Util.newInternal(new StringBuffer().append("bad relation type ").append((Object)relation).toString());
    }

    @Override
    public Member[] getMembersForQuery(String query, List<Member> calcMembers) {
        throw new UnsupportedOperationException();
    }

    Member[] getMeasures() {
        Level measuresLevel = this.dimensions[0].getHierarchies()[0].getLevels()[0];
        return this.getSchemaReader().getLevelMembers(measuresLevel, true);
    }

    MondrianDef.Relation getFact() {
        return this.fact;
    }

    public boolean isVirtual() {
        return this.fact == null;
    }

    RolapDimension createDimension(MondrianDef.CubeDimension xmlCubeDimension) {
        RolapDimension dimension;
        if (xmlCubeDimension instanceof MondrianDef.Dimension) {
            MondrianDef.Dimension xmlDimension = (MondrianDef.Dimension)xmlCubeDimension;
            dimension = new RolapDimension(this.schema, this, xmlDimension, xmlCubeDimension);
        } else if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy sharedHierarchy = this.schema.getSharedHierarchy(usage.source);
            if (sharedHierarchy == null) {
                throw Util.newInternal(new StringBuffer().append("todo: Shared hierarchy '").append(usage.source).append("' not found").toString());
            }
            RolapDimension sharedDimension = (RolapDimension)sharedHierarchy.getDimension();
            dimension = sharedDimension.copy(this, usage.name, xmlCubeDimension);
        } else {
            throw Util.newInternal(new StringBuffer().append("Unexpected subtype, ").append((Object)xmlCubeDimension).toString());
        }
        dimension.init(this, xmlCubeDimension);
        int localOrdinal = this.dimensions.length;
        this.dimensions = (DimensionBase[])RolapUtil.addElement(this.dimensions, dimension);
        RolapHierarchy hierarchy = (RolapHierarchy)dimension.getHierarchy();
        this.createUsage(hierarchy, xmlCubeDimension);
        int globalOrdinal = dimension.getGlobalOrdinal();
        if (globalOrdinal >= this.localDimensionOrdinals.length) {
            int[] newLocalDimensionOrdinals = new int[globalOrdinal + 1];
            System.arraycopy(this.localDimensionOrdinals, 0, newLocalDimensionOrdinals, 0, this.localDimensionOrdinals.length);
            Arrays.fill((int[])newLocalDimensionOrdinals, (int)this.localDimensionOrdinals.length, (int)newLocalDimensionOrdinals.length, (int)-1);
            this.localDimensionOrdinals = newLocalDimensionOrdinals;
        }
        Util.assertTrue(this.localDimensionOrdinals[globalOrdinal] == -1);
        this.localDimensionOrdinals[globalOrdinal] = localOrdinal;
        this.registerDimension(dimension);
        return dimension;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return this.lookupChild(schemaReader, s, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String s, MatchType matchType) {
        OlapElement oe;
        String status = null;
        if (s.equals("Measures")) {
            oe = super.lookupChild(schemaReader, s, MatchType.EXACT);
        } else {
            HierarchyUsage hierUsage = this.getUsageByName(s);
            if (hierUsage == null) {
                HierarchyUsage[] usages;
                oe = super.lookupChild(schemaReader, s, MatchType.EXACT);
                status = "hierUsage == null";
                if (oe instanceof RolapDimension && (usages = this.getUsagesBySource(s)).length > 0) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("RolapCube.lookupChild: ");
                    buf.append("In cube \"");
                    buf.append(this.getName());
                    buf.append("\" use of unaliased Dimension name \"");
                    buf.append(s);
                    if (usages.length == 1) {
                        buf.append("\" rather than the alias name ");
                        buf.append("\"");
                        buf.append(usages[0].getName());
                        buf.append("\" ");
                        this.getLogger().error((Object)buf.toString());
                        throw new MondrianException(buf.toString());
                    }
                    buf.append("\" rather than one of the alias names ");
                    for (HierarchyUsage usage : usages) {
                        buf.append("\"");
                        buf.append(usage.getName());
                        buf.append("\" ");
                    }
                    this.getLogger().error((Object)buf.toString());
                    throw new MondrianException(buf.toString());
                }
            } else if (hierUsage.isShared()) {
                status = "hierUsage == shared";
                String source = hierUsage.getSource();
                oe = super.lookupChild(schemaReader, source, MatchType.EXACT);
            } else {
                status = "hierUsage == not shared";
                oe = super.lookupChild(schemaReader, s, MatchType.EXACT);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("RolapCube.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (status != null) {
                buf.append(", status=");
                buf.append(status);
            }
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=").append(oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public Hierarchy getMeasuresHierarchy() {
        return this.measuresHierarchy;
    }

    public RolapMember[] getMeasuresMembers() {
        return this.measuresHierarchy.getMemberReader().getMembers();
    }

    @Override
    public Member createCalculatedMember(String xml) {
        MondrianDef.CalculatedMember xmlCalcMember;
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(xml);
            String tagName = def.getTagName();
            if (!tagName.equals("CalculatedMember")) {
                throw new XOMException(new StringBuffer().append("Got <").append(tagName).append("> when expecting <CalculatedMember>").toString());
            }
            xmlCalcMember = new MondrianDef.CalculatedMember(def);
        }
        catch (XOMException e) {
            throw Util.newError(e, new StringBuffer().append("Error while creating calculated member from XML [").append(xml).append("]").toString());
        }
        ArrayList<Member> memberList = new ArrayList<Member>();
        this.createCalcMembersAndNamedSets(new MondrianDef.CalculatedMember[]{xmlCalcMember}, new MondrianDef.NamedSet[0], memberList, new ArrayList<Formula>(), this, true);
        if (!$assertionsDisabled && memberList.size() != 1) {
            throw new AssertionError();
        }
        return memberList.get(0);
    }

    static RolapSchema access$400(RolapCube x0) {
        return x0.schema;
    }

    static Formula[] access$500(RolapCube x0) {
        return x0.calculatedMembers;
    }

    static Formula[] access$600(RolapCube x0) {
        return x0.namedSets;
    }

    static RolapHierarchy access$700(RolapCube x0) {
        return x0.measuresHierarchy;
    }

    static String access$800(RolapCube x0) {
        return x0.name;
    }

    static void access$900(RolapCube x0, MondrianDef.CalculatedMember[] x1, MondrianDef.NamedSet[] x2, List x3, List x4, RolapCube x5, boolean x6) {
        x0.createCalcMembersAndNamedSets(x1, x2, x3, x4, x5, x6);
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapCube == null ? (class$mondrian$rolap$RolapCube = RolapCube.class$("mondrian.rolap.RolapCube")) : class$mondrian$rolap$RolapCube).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapCube == null ? (class$mondrian$rolap$RolapCube = RolapCube.class$("mondrian.rolap.RolapCube")) : class$mondrian$rolap$RolapCube));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CubeComparator
    implements Comparator<RolapCube> {
        private CubeComparator() {
        }

        @Override
        public int compare(RolapCube c1, RolapCube c2) {
            return c1.getName().compareTo(c2.getName());
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((RolapCube)x0, (RolapCube)x1);
        }

        CubeComparator(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeasureFinder
    extends MdxVisitorImpl {
        private RolapCube virtualCube;
        private RolapCube baseCube;
        private RolapLevel measuresLevel;
        private List<RolapVirtualCubeMeasure> measuresFound;
        private List<RolapCalculatedMember> calcMembersSeen;

        public MeasureFinder(RolapCube virtualCube, RolapCube baseCube, RolapLevel measuresLevel) {
            this.virtualCube = virtualCube;
            this.baseCube = baseCube;
            this.measuresLevel = measuresLevel;
            this.measuresFound = new ArrayList<RolapVirtualCubeMeasure>();
            this.calcMembersSeen = new ArrayList<RolapCalculatedMember>();
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            RolapBaseCubeMeasure baseMeasure;
            RolapVirtualCubeMeasure virtualCubeMeasure;
            Member member = memberExpr.getMember();
            if (member instanceof RolapCalculatedMember) {
                if (this.calcMembersSeen.contains(member)) {
                    return null;
                }
                RolapCalculatedMember calcMember = (RolapCalculatedMember)member;
                Formula formula = calcMember.getFormula();
                formula.accept(this);
                this.calcMembersSeen.add(calcMember);
                RolapMember[] measures = this.measuresFound.toArray(new RolapMember[this.measuresFound.size()]);
                RolapCube.access$700(this.virtualCube).setMemberReader(new CacheMemberReader(new MeasureMemberSource(RolapCube.access$700(this.virtualCube), measures)));
                MondrianDef.CalculatedMember xmlCalcMember = RolapCube.access$400(RolapCube.this).lookupXmlCalculatedMember(calcMember.getUniqueName(), RolapCube.access$800(this.baseCube));
                RolapCube.access$900(RolapCube.this, new MondrianDef.CalculatedMember[]{xmlCalcMember}, new MondrianDef.NamedSet[0], new ArrayList(), new ArrayList(), this.virtualCube, false);
                return null;
            }
            if (member instanceof RolapBaseCubeMeasure && !this.measuresFound.contains(virtualCubeMeasure = new RolapVirtualCubeMeasure(null, this.measuresLevel, baseMeasure = (RolapBaseCubeMeasure)member))) {
                this.measuresFound.add(virtualCubeMeasure);
            }
            return null;
        }

        public List<RolapVirtualCubeMeasure> getMeasuresFound() {
            return this.measuresFound;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RolapCubeSchemaReader
    extends RolapSchemaReader {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapCube;

        public RolapCubeSchemaReader(Role role) {
            super(role, RolapCube.access$400(RolapCube.this));
            if (!$assertionsDisabled && role == null) {
                throw new AssertionError((Object)"precondition: role != null");
            }
        }

        @Override
        public Member[] getLevelMembers(Level level, boolean includeCalculated) {
            Member[] members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        @Override
        public Member getCalculatedMember(String[] nameParts) {
            String uniqueName = Util.implode(nameParts);
            for (Formula formula : RolapCube.access$500(RolapCube.this)) {
                String formulaUniqueName = formula.getMdxMember().getUniqueName();
                if (!formulaUniqueName.equals(uniqueName) || !this.getRole().canAccess(formula.getMdxMember())) continue;
                return formula.getMdxMember();
            }
            return null;
        }

        @Override
        public NamedSet getNamedSet(String[] nameParts) {
            if (nameParts.length == 1) {
                String name = nameParts[0];
                for (Formula namedSet : RolapCube.access$600(RolapCube.this)) {
                    if (!namedSet.getName().equals(name)) continue;
                    return namedSet.getNamedSet();
                }
            }
            return super.getNamedSet(nameParts);
        }

        @Override
        public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(hierarchy) == Access.NONE) {
                return list;
            }
            for (Formula formula : RolapCube.access$500(RolapCube.this)) {
                Member member = formula.getMdxMember();
                if (!member.getHierarchy().equals(hierarchy) || !this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers(Level level) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(level) == Access.NONE) {
                return list;
            }
            for (Member member : this.getCalculatedMembers(level.getHierarchy())) {
                if (!member.getLevel().equals(level) || !this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers() {
            ArrayList<Member> list = new ArrayList<Member>();
            for (Formula formula : RolapCube.access$500(RolapCube.this)) {
                Member member = formula.getMdxMember();
                if (!this.getRole().canAccess(member)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
            return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, MatchType.EXACT);
        }

        @Override
        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
            Member member = (Member)this.lookupCompound(RolapCube.this, uniqueNameParts, failIfNotFound, 6, matchType);
            if (!failIfNotFound && member == null) {
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        @Override
        public Cube getCube() {
            return RolapCube.this;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapCube == null ? (class$mondrian$rolap$RolapCube = RolapCubeSchemaReader.class$("mondrian.rolap.RolapCube")) : class$mondrian$rolap$RolapCube).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelNode {
        private int depth;
        private String alias;
        private MondrianDef.Table table;

        private static RelNode lookup(MondrianDef.Table table, Map<String, RelNode> map) {
            RelNode relNode = map.get(table.name);
            if (relNode == null && table.alias != null) {
                relNode = map.get(table.alias);
            }
            return relNode;
        }

        RelNode(String alias, int depth) {
            this.alias = alias;
            this.depth = depth;
        }

        static RelNode access$100(MondrianDef.Table x0, Map x1) {
            return RelNode.lookup(x0, x1);
        }

        static MondrianDef.Table access$202(RelNode x0, MondrianDef.Table x1) {
            x0.table = x1;
            return x0.table;
        }

        static int access$300(RelNode x0) {
            return x0.depth;
        }
    }
}

