/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import mondrian.olap.Axis;
import mondrian.olap.CacheControl;
import mondrian.olap.Cell;
import mondrian.olap.ConnectionBase;
import mondrian.olap.Cube;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapConnectionPool;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.log4j.Logger;

public class RolapConnection
extends ConnectionBase {
    private static final Logger LOGGER;
    private final Util.PropertyList connectInfo;
    private final DataSource dataSource;
    private final String catalogUrl;
    private final RolapSchema schema;
    private SchemaReader schemaReader;
    protected Role role;
    private Locale locale = Locale.US;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapConnection;

    public RolapConnection(Util.PropertyList connectInfo) {
        this(connectInfo, null, null);
    }

    public RolapConnection(Util.PropertyList connectInfo, DataSource datasource) {
        this(connectInfo, null, datasource);
    }

    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema) {
        this(connectInfo, schema, null);
    }

    RolapConnection(Util.PropertyList connectInfo, RolapSchema schema, DataSource dataSource) {
        String localeString;
        String provider = connectInfo.get(RolapConnectionProperties.Provider.name(), "mondrian");
        Util.assertTrue(provider.equalsIgnoreCase("mondrian"));
        this.connectInfo = connectInfo;
        this.catalogUrl = connectInfo.get(RolapConnectionProperties.Catalog.name());
        this.dataSource = dataSource != null ? dataSource : RolapConnection.createDataSource(connectInfo);
        Role role = null;
        if (schema == null) {
            if (dataSource == null) {
                String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
                String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
                String strDataSource = connectInfo.get(RolapConnectionProperties.DataSource.name());
                String connectionKey = jdbcConnectString + RolapConnection.getJDBCProperties(connectInfo).toString();
                schema = RolapSchema.Pool.instance().get(this.catalogUrl, connectionKey, jdbcUser, strDataSource, connectInfo);
            } else {
                schema = RolapSchema.Pool.instance().get(this.catalogUrl, dataSource, connectInfo);
            }
            String roleName = connectInfo.get(RolapConnectionProperties.Role.name());
            if (roleName != null && (role = schema.lookupRole(roleName)) == null) {
                throw Util.newError("Role '" + roleName + "' not found");
            }
        }
        if (role == null) {
            role = schema.getDefaultRole();
        }
        if ((localeString = connectInfo.get(RolapConnectionProperties.Locale.name())) != null) {
            String[] strings = localeString.split("_");
            switch (strings.length) {
                case 1: {
                    this.locale = new Locale(strings[0]);
                    break;
                }
                case 2: {
                    this.locale = new Locale(strings[0], strings[1]);
                    break;
                }
                case 3: {
                    this.locale = new Locale(strings[0], strings[1], strings[2]);
                    break;
                }
                default: {
                    throw Util.newInternal("bad locale string '" + localeString + "'");
                }
            }
        }
        this.schema = schema;
        this.setRole(role);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    static DataSource createDataSource(Util.PropertyList connectInfo) {
        DataSource dataSource;
        String jdbcConnectString = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String poolNeededString = connectInfo.get(RolapConnectionProperties.PoolNeeded.name());
        Properties jdbcProperties = RolapConnection.getJDBCProperties(connectInfo);
        String propertyString = jdbcProperties.toString();
        if (jdbcConnectString != null) {
            String jdbcDrivers = connectInfo.get(RolapConnectionProperties.JdbcDrivers.name());
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            boolean poolNeeded = poolNeededString == null ? true : poolNeededString.equalsIgnoreCase("true");
            String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
            String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
            if (jdbcUser != null) {
                jdbcProperties.put("user", jdbcUser);
            }
            if (jdbcPassword != null) {
                jdbcProperties.put("password", jdbcPassword);
            }
            if (!poolNeeded) {
                return new DriverManagerDataSource(jdbcConnectString, jdbcProperties);
            }
            if (jdbcConnectString.toLowerCase().indexOf("mysql") > -1) {
                jdbcProperties.setProperty("autoReconnect", "true");
            }
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcConnectString, jdbcProperties);
            try {
                return RolapConnectionPool.instance().getPoolingDataSource(jdbcConnectString + propertyString, (ConnectionFactory)connectionFactory);
            }
            catch (Throwable e) {
                throw Util.newInternal(e, "Error while creating connection pool (with URI " + jdbcConnectString + ")");
            }
        }
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        if (dataSourceName == null) {
            throw Util.newInternal("Connect string '" + connectInfo.toString() + "' must contain either '" + (Object)((Object)RolapConnectionProperties.Jdbc) + "' or '" + (Object)((Object)RolapConnectionProperties.DataSource) + "'");
        }
        boolean poolNeeded = poolNeededString == null ? false : poolNeededString.equalsIgnoreCase("true");
        try {
            dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
        }
        catch (NamingException e) {
            throw Util.newInternal(e, "Error while looking up data source (" + dataSourceName + ")");
        }
        if (!poolNeeded) {
            return dataSource;
        }
        DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(dataSource);
        try {
            return RolapConnectionPool.instance().getPoolingDataSource(dataSourceName, (ConnectionFactory)connectionFactory);
        }
        catch (Exception e) {
            throw Util.newInternal(e, "Error while creating connection pool (with URI " + dataSourceName + ")");
        }
    }

    private static Properties getJDBCProperties(Util.PropertyList connectInfo) {
        Properties jdbcProperties = new Properties();
        Iterator<String[]> iterator = connectInfo.iterator();
        while (iterator.hasNext()) {
            String[] entry = iterator.next();
            if (!entry[0].startsWith("jdbc.")) continue;
            jdbcProperties.put(entry[0].substring("jdbc.".length()), entry[1]);
        }
        return jdbcProperties;
    }

    public Util.PropertyList getConnectInfo() {
        return this.connectInfo;
    }

    public void close() {
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getConnectString() {
        return this.connectInfo.toString();
    }

    public String getCatalogName() {
        return this.catalogUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public Object getProperty(String name) {
        if (name.equals(RolapConnectionProperties.JdbcPassword.name()) || name.equals(RolapConnectionProperties.CatalogContent.name())) {
            return "";
        }
        return this.connectInfo.get(name);
    }

    public CacheControl getCacheControl(PrintWriter pw) {
        return AggregationManager.instance().getCacheControl(pw);
    }

    public Result execute(Query query) {
        class Listener
        implements MemoryMonitor.Listener {
            private final Query query;

            Listener(Query query) {
                this.query = query;
            }

            public void memoryUsageNotification(long used, long max) {
                StringBuffer buf = new StringBuffer(200);
                buf.append("OutOfMemory used=");
                buf.append(used);
                buf.append(", max=");
                buf.append(max);
                buf.append(" for connection: ");
                buf.append(RolapConnection.this.getConnectString());
                RolapConnection.memoryUsageNotification(this.query, buf.toString());
            }
        }
        Listener listener = new Listener(query);
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        try {
            mm.addListener(listener);
            query.checkCancelOrTimeout();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)Util.unparse(query));
            }
            query.setQueryStartTime();
            ResultBase result = new RolapResult(query, true);
            for (int i = 0; i < query.axes.length; ++i) {
                QueryAxis axis = query.axes[i];
                if (!axis.isNonEmpty()) continue;
                result = new NonEmptyResult(result, query, i);
            }
            if (LOGGER.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                result.print(pw);
                pw.flush();
                LOGGER.debug((Object)sw.toString());
            }
            query.setQueryEndExecution();
            RolapResult sw = result;
            return sw;
        }
        catch (ResultLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            String queryString;
            query.setQueryEndExecution();
            try {
                queryString = Util.unparse(query);
            }
            catch (Exception e1) {
                queryString = "?";
            }
            throw Util.newError(e, "Error while executing query [" + queryString + "]");
        }
        finally {
            mm.removeListener(listener);
        }
    }

    public void setRole(Role role) {
        if (!$assertionsDisabled && role == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && role.isMutable()) {
            throw new AssertionError();
        }
        this.role = role;
        this.schemaReader = new RolapSchemaReader(role, this.schema){

            public Cube getCube() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Role getRole() {
        Util.assertPostcondition(this.role != null, "role != null");
        Util.assertPostcondition(!this.role.isMutable(), "!role.isMutable()");
        return this.role;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    static Logger access$000() {
        return LOGGER;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$RolapConnection == null ? (class$mondrian$rolap$RolapConnection = RolapConnection.class$("mondrian.rolap.RolapConnection")) : class$mondrian$rolap$RolapConnection).desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapConnection == null ? (class$mondrian$rolap$RolapConnection = RolapConnection.class$("mondrian.rolap.RolapConnection")) : class$mondrian$rolap$RolapConnection));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class NonEmptyResult
    extends ResultBase {
        final Result underlying;
        private final int axis;
        private final Map<Integer, Integer> map;
        private final int[] pos;

        NonEmptyResult(Result result, Query query, int axis) {
            super(query, (Axis[])result.getAxes().clone());
            this.underlying = result;
            this.axis = axis;
            this.map = new HashMap<Integer, Integer>();
            int axisCount = this.underlying.getAxes().length;
            this.pos = new int[axisCount];
            this.slicerAxis = this.underlying.getSlicerAxis();
            List<Position> positions = this.underlying.getAxes()[axis].getPositions();
            ArrayList<Position> positionsList = new ArrayList<Position>();
            int i = 0;
            Iterator<Position> i$ = positions.iterator();
            while (i$.hasNext()) {
                Position position = i$.next();
                if (!this.isEmpty(i, axis)) {
                    this.map.put(Autobox.valueOf((int)positionsList.size()), Autobox.valueOf((int)i));
                    positionsList.add(position);
                }
                ++i;
            }
            this.axes[axis] = new RolapAxis.PositionList(positionsList);
        }

        protected Logger getLogger() {
            return RolapConnection.access$000();
        }

        private boolean isEmpty(int offset, int fixedAxis) {
            int axisCount = this.getAxes().length;
            this.pos[fixedAxis] = offset;
            return this.isEmptyRecurse(fixedAxis, axisCount - 1);
        }

        private boolean isEmptyRecurse(int fixedAxis, int axis) {
            if (axis < 0) {
                RolapCell cell = (RolapCell)this.underlying.getCell(this.pos);
                return cell.isNull();
            }
            if (axis == fixedAxis) {
                return this.isEmptyRecurse(fixedAxis, axis - 1);
            }
            List<Position> positions = this.getAxes()[axis].getPositions();
            int i = 0;
            Iterator<Position> i$ = positions.iterator();
            while (i$.hasNext()) {
                Position position = i$.next();
                this.pos[axis] = i++;
                if (this.isEmptyRecurse(fixedAxis, axis - 1)) continue;
                return false;
            }
            return true;
        }

        public synchronized Cell getCell(int[] externalPos) {
            int mappedOffset;
            System.arraycopy(externalPos, 0, this.pos, 0, externalPos.length);
            int offset = externalPos[this.axis];
            this.pos[this.axis] = mappedOffset = this.mapOffsetToUnderlying(offset);
            return this.underlying.getCell(this.pos);
        }

        private int mapOffsetToUnderlying(int offset) {
            return this.map.get(Autobox.valueOf((int)offset));
        }

        public void close() {
            this.underlying.close();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DriverManagerDataSource
    implements DataSource {
        private final String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = properties;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return new DelegatingConnection(DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties));
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.jdbcProperties == null) {
                return DriverManager.getConnection(this.jdbcConnectString, username, password);
            }
            Properties temp = (Properties)this.jdbcProperties.clone();
            temp.put("user", username);
            temp.put("password", password);
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("not a wrapper");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

