/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;

class RolapCell
implements Cell {
    private final RolapResult result;
    protected final int[] pos;
    protected RolapResult.CellInfo ci;

    RolapCell(RolapResult result, int[] pos, RolapResult.CellInfo ci) {
        this.result = result;
        this.pos = pos;
        this.ci = ci;
    }

    public Object getValue() {
        return this.ci.value;
    }

    public String getCachedFormatString() {
        return this.ci.formatString;
    }

    public String getFormattedValue() {
        return this.ci.getFormatValue();
    }

    public boolean isNull() {
        return this.ci.value == Util.nullValue;
    }

    public boolean isError() {
        return this.ci.value instanceof Throwable;
    }

    public String getDrillThroughSQL(boolean extendedContext) {
        AggregationManager aggMan = AggregationManager.instance();
        Member[] currentMembers = this.getMembers();
        CellRequest cellRequest = RolapAggregationManager.makeRequest(currentMembers, extendedContext, true);
        return cellRequest == null ? null : ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, false);
    }

    public int getDrillThroughCount() {
        AggregationManager aggMan = AggregationManager.instance();
        Member[] currentMembers = this.getMembers();
        CellRequest cellRequest = RolapAggregationManager.makeRequest(currentMembers, false, true);
        if (cellRequest == null) {
            return -1;
        }
        RolapConnection connection = (RolapConnection)this.result.getQuery().getConnection();
        Connection jdbcConnection = null;
        ResultSet rs = null;
        String sql = ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, true);
        try {
            jdbcConnection = connection.getDataSource().getConnection();
            rs = RolapUtil.executeQuery(jdbcConnection, sql, "RolapCell.getDrillThroughCount");
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw Util.newError(e, "Error while counting drill-through, SQL ='" + sql + "'");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {}
            try {
                if (jdbcConnection != null && !jdbcConnection.isClosed()) {
                    jdbcConnection.close();
                }
            }
            catch (SQLException ignored) {}
        }
    }

    public boolean canDrillThrough() {
        if (((RolapCube)this.result.getCube()).isVirtual()) {
            return false;
        }
        Member[] currentMembers = this.getMembers();
        return currentMembers[0] instanceof RolapStoredMeasure;
    }

    private RolapEvaluator getEvaluator() {
        return this.result.getCellEvaluator(this.pos);
    }

    private Member[] getMembers() {
        return this.result.getCellMembers(this.pos);
    }

    public Object getPropertyValue(String propertyName) {
        Property property = Property.lookup(propertyName, true);
        Integer defaultValue = null;
        if (property != null) {
            switch (property.ordinal) {
                case 32: {
                    return Autobox.valueOf((int)this.result.getCellOrdinal(this.pos));
                }
                case 41: {
                    return this.getValue();
                }
                case 38: {
                    if (this.ci.formatString == null) {
                        this.ci.formatString = this.getEvaluator().getFormatString();
                    }
                    return this.ci.formatString;
                }
                case 37: {
                    return this.getFormattedValue();
                }
                case 36: {
                    defaultValue = Autobox.valueOf((int)0);
                    break;
                }
                case 40: {
                    defaultValue = Autobox.valueOf((int)0);
                    break;
                }
            }
        }
        return this.getEvaluator().getProperty(propertyName, defaultValue);
    }

    public Member getContextMember(Dimension dimension) {
        return this.result.getMember(this.pos, dimension);
    }
}

