/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import java.util.List;
import mondrian.olap.CellFormatter;
import mondrian.olap.Literal;
import mondrian.olap.MondrianDef;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.sql.SqlQuery;

class RolapBaseCubeMeasure
extends RolapMember
implements RolapStoredMeasure {
    private static final List<String> datatypeList = Arrays.asList((Object[])new String[]{"Integer", "Numeric", "String"});
    private final MondrianDef.Expression expression;
    private final RolapAggregator aggregator;
    private final RolapCube cube;
    private Object starMeasure;
    private CellFormatter formatter;

    RolapBaseCubeMeasure(RolapCube cube, RolapMember parentMember, RolapLevel level, String name, String formatString, MondrianDef.Expression expression, String aggregatorName, String datatype) {
        super(parentMember, level, name);
        this.cube = cube;
        this.expression = expression;
        if (formatString == null) {
            formatString = "";
        }
        this.setProperty(Property.FORMAT_EXP.name, Literal.createString(formatString));
        this.aggregator = RolapAggregator.enumeration.getValue(aggregatorName, true);
        if (this.aggregator == null) {
            throw Util.newError("Unknown aggregator '" + aggregatorName + "'");
        }
        this.setProperty(Property.AGGREGATION_TYPE.name, this.aggregator);
        if (datatype == null) {
            datatype = this.aggregator == RolapAggregator.Count || this.aggregator == RolapAggregator.DistinctCount ? "Integer" : "Numeric";
        }
        Util.assertTrue(datatypeList.contains(datatype), "invalid datatype " + datatype);
        this.setProperty(Property.DATATYPE.name, datatype);
    }

    public MondrianDef.Expression getMondrianDefExpression() {
        return this.expression;
    }

    public RolapAggregator getAggregator() {
        return this.aggregator;
    }

    public RolapCube getCube() {
        return this.cube;
    }

    public CellFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(CellFormatter formatter) {
        this.formatter = formatter;
    }

    public Object getStarMeasure() {
        return this.starMeasure;
    }

    void setStarMeasure(Object starMeasure) {
        this.starMeasure = starMeasure;
    }

    public SqlQuery.Datatype getDatatype() {
        Object datatype = this.getPropertyValue(Property.DATATYPE.name);
        try {
            return SqlQuery.Datatype.valueOf((String)datatype);
        }
        catch (ClassCastException e) {
            return SqlQuery.Datatype.String;
        }
        catch (IllegalArgumentException e) {
            return SqlQuery.Datatype.String;
        }
    }
}

