/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.util.UnsupportedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAxis
implements Axis {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapAxis == null ? (class$mondrian$rolap$RolapAxis = RolapAxis.class$("mondrian.rolap.RolapAxis")) : class$mondrian$rolap$RolapAxis));
    private static final /* synthetic */ Class class$mondrian$rolap$RolapAxis;

    public static String toString(Axis axis) {
        List<Position> pl = axis.getPositions();
        return RolapAxis.toString(pl);
    }

    public static String toString(List<Position> pl) {
        StringBuffer buf = new StringBuffer();
        for (Position p : pl) {
            buf.append('{');
            boolean firstTime = true;
            for (Member m : p) {
                if (!firstTime) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
                firstTime = false;
            }
            buf.append('}');
            buf.append('\n');
        }
        return buf.toString();
    }

    protected RolapAxis() {
    }

    @Override
    public abstract List<Position> getPositions();

    static Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    protected static abstract class PositionListBase
    extends PositionListUnsupported {
        protected PositionListBase() {
        }

        @Override
        public abstract int size();

        @Override
        public abstract Position get(int var1);

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public ListIterator<Position> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Position> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Position> iterator() {
            return new UnsupportedList.Itr(this);
        }

        @Override
        public Object get(int x0) {
            return this.get(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionIterBase
    extends PositionListUnsupported {
        protected PositionIterBase() {
        }

        @Override
        public abstract Iterator<Position> iterator();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionListUnsupported
    extends UnsupportedList<Position> {
        protected PositionListUnsupported() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionBase
    extends PositionUnsupported {
        protected PositionBase() {
        }

        @Override
        public ListIterator<Member> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Member> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Member> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PositionUnsupported
    extends UnsupportedList<Member>
    implements Position {
        protected PositionUnsupported() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayList
    extends RolapAxis {
        private final List<Member[]> list;
        private final int len;

        public MemberArrayList(List<Member[]> list) {
            this.list = list;
            this.len = list.size() == 0 ? 0 : list.get(0).length;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        static List access$900(MemberArrayList x0) {
            return x0.list;
        }

        static int access$1000(MemberArrayList x0) {
            return x0.len;
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MALPosition
        extends PositionBase {
            protected final int offset;

            MALPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayList.access$1000(MemberArrayList.this);
            }

            public Member get(int index) {
                if (index > MemberArrayList.access$1000(MemberArrayList.this)) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayList.access$1000(MemberArrayList.this));
                }
                return ((Member[])MemberArrayList.access$900(MemberArrayList.this).get(this.offset))[index];
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberArrayList.access$900(MemberArrayList.this).size();
            }

            public Position get(int index) {
                return new MALPosition(index);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberArrayIterable
    extends RolapAxis {
        private Iterable<Member[]> iter;
        private List<Member[]> list;
        private int len;

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public MemberArrayIterable(Iterable_ iter) {
            this.iter = iter;
            this.list = null;
            this.len = 0;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator it = IterableMethods.iterator(this.iter);
                this.list = new ArrayList<Member[]>();
                while (it.hasNext()) {
                    this.list.add((Member[])it.next());
                }
                this.iter = null;
                this.len = this.list.size() == 0 ? 0 : this.list.get(0).length;
            }
        }

        static Iterable_ access$500(MemberArrayIterable x0) {
            return x0.iter;
        }

        static List access$700(MemberArrayIterable x0) {
            return x0.list;
        }

        static int access$800(MemberArrayIterable x0) {
            return x0.len;
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MALPosition
        extends PositionBase {
            protected final int offset;

            MALPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return MemberArrayIterable.access$800(MemberArrayIterable.this);
            }

            public Member get(int index) {
                if (index > MemberArrayIterable.access$800(MemberArrayIterable.this)) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + MemberArrayIterable.access$800(MemberArrayIterable.this));
                }
                return ((Member[])MemberArrayIterable.access$700(MemberArrayIterable.this).get(this.offset))[index];
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberArrayIterable.access$700(MemberArrayIterable.this).size();
            }

            public Position get(int index) {
                return new MALPosition(index);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MIPosition
        extends PositionBase {
            Member[] members;

            MIPosition(Member[] members) {
                this.members = members;
            }

            @Override
            public int size() {
                return this.members.length;
            }

            @Override
            public Member get(int index) {
                return this.members[index];
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MIPosition.this.members.length;
                    }

                    @Override
                    public Member next() {
                        return MIPosition.this.members[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member[]> it;

            PositionIter() {
                this.it = IterableMethods.iterator((Object)MemberArrayIterable.access$500(MemberArrayIterable.this));
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){
                    int nextCnt = 0;

                    @Override
                    public boolean hasNext() {
                        return PositionIter.access$600(PositionIter.this).hasNext();
                    }

                    @Override
                    public Position next() {
                        ++this.nextCnt;
                        return new MIPosition((Member[])PositionIter.access$600(PositionIter.this).next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public Object next() {
                        return this.next();
                    }
                };
            }

            static Iterator access$600(PositionIter x0) {
                return x0.it;
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (RolapAxis.access$000().isDebugEnabled()) {
                    RolapAxis.access$000().debug((Object)new StringBuffer().append("PositionWrapper.materialize: Member[] iter.class=").append(MemberArrayIterable.access$500(MemberArrayIterable.this).getClass().getName()).toString());
                }
                MemberArrayIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }

            @Override
            public Object get(int x0) {
                return this.get(x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberList
    extends RolapAxis {
        private final List<Member> list;

        public MemberList(List<Member> list) {
            this.list = list;
        }

        @Override
        public List<Position> getPositions() {
            return new PositionList();
        }

        static List access$400(MemberList x0) {
            return x0.list;
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MLPosition
        extends PositionBase {
            protected final int offset;

            MLPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberList.access$400(MemberList.this).get(this.offset);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberList.access$400(MemberList.this).size();
            }

            public Position get(int index) {
                return new MLPosition(index);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberIterable
    extends RolapAxis {
        private Iterable<Member> iter;
        private List<Member> list;

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public MemberIterable(Iterable_ iter) {
            this.iter = iter;
            this.list = null;
        }

        @Override
        public synchronized List<Position> getPositions() {
            return this.list == null ? new PositionWrapper() : new PositionList();
        }

        protected synchronized void materialize() {
            if (this.list == null) {
                Iterator it = IterableMethods.iterator(this.iter);
                this.list = new ArrayList<Member>();
                while (it.hasNext()) {
                    this.list.add((Member)it.next());
                }
                this.iter = null;
            }
        }

        static Iterable_ access$100(MemberIterable x0) {
            return x0.iter;
        }

        static List access$300(MemberIterable x0) {
            return x0.list;
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MLPosition
        extends PositionBase {
            protected final int offset;

            MLPosition(int offset) {
                this.offset = offset;
            }

            public int size() {
                return 1;
            }

            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
                }
                return (Member)MemberIterable.access$300(MemberIterable.this).get(this.offset);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionList
        extends PositionListBase {
            PositionList() {
            }

            public int size() {
                return MemberIterable.access$300(MemberIterable.this).size();
            }

            public Position get(int index) {
                return new MLPosition(index);
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         * Duplicate member names - consider using --renamedupmembers true
         */
        class MIPosition
        extends PositionBase {
            Member member;

            MIPosition(Member member) {
                this.member = member;
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Member get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException(new StringBuffer().append("Index: ").append(index).append(", Size: 1").toString());
                }
                return this.member;
            }

            @Override
            public Iterator<Member> iterator() {
                return new Iterator<Member>(){

                    @Override
                    public boolean hasNext() {
                        return MIPosition.this.member != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Member next() {
                        try {
                            Member member = MIPosition.this.member;
                            return member;
                        }
                        finally {
                            MIPosition.this.member = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public Object get(int x0) {
                return this.get(x0);
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PositionIter
        extends PositionIterBase {
            private Iterator<Member> it;

            PositionIter() {
                this.it = IterableMethods.iterator((Object)MemberIterable.access$100(MemberIterable.this));
            }

            @Override
            public Iterator<Position> iterator() {
                return new Iterator<Position>(){

                    @Override
                    public boolean hasNext() {
                        return PositionIter.access$200(PositionIter.this).hasNext();
                    }

                    @Override
                    public Position next() {
                        return new MIPosition((Member)PositionIter.access$200(PositionIter.this).next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public Object next() {
                        return this.next();
                    }
                };
            }

            static Iterator access$200(PositionIter x0) {
                return x0.it;
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         * Duplicate member names - consider using --renamedupmembers true
         */
        class PositionWrapper
        extends PositionListUnsupported {
            List<Position> positionList;

            PositionWrapper() {
                this.positionList = new PositionIter();
            }

            protected synchronized void materialize() {
                if (RolapAxis.access$000().isDebugEnabled()) {
                    RolapAxis.access$000().debug((Object)new StringBuffer().append("PositionWrapper.materialize: Member iter.class=").append(MemberIterable.access$100(MemberIterable.this).getClass().getName()).toString());
                }
                MemberIterable.this.materialize();
                this.positionList = new PositionList();
            }

            @Override
            public int size() {
                try {
                    return this.positionList.size();
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.size();
                }
            }

            @Override
            public Position get(int index) {
                try {
                    return this.positionList.get(index);
                }
                catch (UnsupportedOperationException ex) {
                    this.materialize();
                    return this.positionList.get(index);
                }
            }

            @Override
            public Iterator<Position> iterator() {
                return this.positionList.iterator();
            }

            @Override
            public Object get(int x0) {
                return this.get(x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleEmptyPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return com.rc.retroweaver.runtime.Collections.singletonList((Object)new EmptyPosition());
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        static class EmptyPosition
        extends PositionBase {
            EmptyPosition() {
            }

            public int size() {
                return 0;
            }

            public Member get(int index) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
            }

            public Object get(int x0) {
                return this.get(x0);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PositionList
    extends RolapAxis {
        protected final List<Position> positions;

        public PositionList(List<Position> positions) {
            this.positions = positions;
        }

        @Override
        public List<Position> getPositions() {
            return this.positions;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoPosition
    extends RolapAxis {
        @Override
        public List<Position> getPositions() {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Wrapper
    extends RolapAxis {
        private final Axis axis;

        protected Wrapper(Axis axis) {
            this.axis = axis;
        }

        @Override
        public List<Position> getPositions() {
            return this.axis.getPositions();
        }
    }
}

