/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Iterable_;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.olap.Aggregator;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.fun.FunUtil;

public abstract class RolapAggregator
extends EnumeratedValues.BasicValue
implements Aggregator {
    private static int index = 0;
    public static final RolapAggregator Sum = new RolapAggregator("sum", index++, false){

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            return FunUtil.sum(evaluator, members, exp);
        }
    };
    public static final RolapAggregator Count = new RolapAggregator("count", index++, false){

        public Aggregator getRollup() {
            return Sum;
        }

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            return Autobox.valueOf((int)FunUtil.count(evaluator, (Iterable_)members, false));
        }
    };
    public static final RolapAggregator Min = new RolapAggregator("min", index++, false){

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            return FunUtil.min(evaluator, members, exp);
        }
    };
    public static final RolapAggregator Max = new RolapAggregator("max", index++, false){

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            return FunUtil.max(evaluator, members, exp);
        }
    };
    public static final RolapAggregator Avg = new RolapAggregator("avg", index++, false){

        public Aggregator getRollup() {
            return null;
        }

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            return FunUtil.avg(evaluator, members, exp);
        }
    };
    public static final RolapAggregator DistinctCount = new RolapAggregator("distinct count", index++, true){

        public Aggregator getRollup() {
            return Sum;
        }

        public RolapAggregator getNonDistinctAggregator() {
            return Count;
        }

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            throw new UnsupportedOperationException();
        }

        public String getExpression(String operand) {
            return "count(distinct " + operand + ")";
        }
    };
    public static final EnumeratedValues<RolapAggregator> enumeration = new EnumeratedValues((EnumeratedValues.Value[])new RolapAggregator[]{Sum, Count, Min, Max, Avg, DistinctCount});
    private final boolean distinct;

    public RolapAggregator(String name, int ordinal, boolean distinct) {
        super(name, ordinal, null);
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getExpression(String operand) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.name);
        buf.append('(');
        if (this.distinct) {
            buf.append("distinct ");
        }
        buf.append(operand);
        buf.append(')');
        return buf.toString();
    }

    public RolapAggregator getNonDistinctAggregator() {
        throw new UnsupportedOperationException();
    }

    public Aggregator getRollup() {
        return this;
    }

    static int access$008() {
        return index++;
    }

    public static class SumFromAvg
    extends BaseAggor {
        public SumFromAvg(String factCountExpr) {
            super("SumFromAvg", factCountExpr);
        }

        public String getExpression(String operand) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(" * ");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }
    }

    public static class AvgFromAvg
    extends BaseAggor {
        public AvgFromAvg(String factCountExpr) {
            super("AvgFromAvg", factCountExpr);
        }

        public String getExpression(String operand) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(" * ");
            buf.append(this.factCountExpr);
            buf.append(") / sum(");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }
    }

    public static class AvgFromSum
    extends BaseAggor {
        public AvgFromSum(String factCountExpr) {
            super("AvgFromSum", factCountExpr);
        }

        public String getExpression(String operand) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("sum(");
            buf.append(operand);
            buf.append(") / sum(");
            buf.append(this.factCountExpr);
            buf.append(')');
            return buf.toString();
        }
    }

    protected static abstract class BaseAggor
    extends RolapAggregator {
        protected final String factCountExpr;

        protected BaseAggor(String name, String factCountExpr) {
            super(name, RolapAggregator.access$008(), false);
            this.factCountExpr = factCountExpr;
        }

        public Object aggregate(Evaluator evaluator, List members, Calc exp) {
            throw new UnsupportedOperationException();
        }
    }
}

