/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Access;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.DelegatingMemberReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RestrictedMemberReader
extends DelegatingMemberReader {
    private final Role.HierarchyAccess hierarchyAccess;
    private final boolean ragged;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();

    RestrictedMemberReader(MemberReader memberReader, Role role) {
        super(memberReader);
        RolapHierarchy hierarchy = memberReader.getHierarchy();
        this.hierarchyAccess = role.getAccessDetails(hierarchy);
        this.ragged = hierarchy.isRagged();
        Util.assertPrecondition(this.hierarchyAccess != null || this.ragged, "role.getAccessDetails(memberReader.getHierarchy()) != null || hierarchy.isRagged()");
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        int i = 0;
        int increment = 1;
        if (n < 0) {
            increment = -1;
            n = -n;
        }
        while (i < n) {
            if ((member = this.memberReader.getLeadMember(member, increment)).isNull()) {
                return member;
            }
            if (!this.canSee(member)) continue;
            ++i;
        }
        return member;
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        this.memberReader.getMemberChildren(parentMember, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    private void processMemberChildren(List<RolapMember> fullChildren, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> grandChildren = null;
        for (int i = 0; i < fullChildren.size(); ++i) {
            Access access;
            RolapMember member = fullChildren.get(i);
            if (this.ragged && member.isHidden()) {
                fullChildren.remove(i);
                if (grandChildren == null) {
                    grandChildren = new ArrayList<RolapMember>();
                } else {
                    grandChildren.clear();
                }
                this.memberReader.getMemberChildren(member, grandChildren, constraint);
                fullChildren.addAll(i, grandChildren);
                --i;
                continue;
            }
            if (this.hierarchyAccess != null && (access = this.hierarchyAccess.getAccess(member)) == Access.NONE) continue;
            children.add(member);
        }
    }

    private void filterMembers(List<RolapMember> members, List<RolapMember> filteredMembers) {
        for (RolapMember member : members) {
            if (!this.canSee(member)) continue;
            filteredMembers.add(member);
        }
    }

    private boolean canSee(RolapMember member) {
        if (this.ragged && member.isHidden()) {
            return false;
        }
        if (this.hierarchyAccess != null) {
            Access access = this.hierarchyAccess.getAccess(member);
            return access != Access.NONE;
        }
        return true;
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public synchronized void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> fullChildren = new ArrayList<RolapMember>();
        super.getMemberChildren(parentMembers, fullChildren, constraint);
        this.processMemberChildren(fullChildren, children, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        if (this.hierarchyAccess != null) {
            int depth = level.getDepth();
            if (this.hierarchyAccess.getTopLevel() != null && depth < this.hierarchyAccess.getTopLevel().getDepth()) {
                return Collections.emptyList();
            }
            if (this.hierarchyAccess.getBottomLevel() != null && depth > this.hierarchyAccess.getBottomLevel().getDepth()) {
                return Collections.emptyList();
            }
        }
        List<RolapMember> membersInLevel = super.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
        ArrayList<RolapMember> filteredMembers = new ArrayList<RolapMember>();
        this.filterMembers(membersInLevel, filteredMembers);
        return filteredMembers;
    }
}

