/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.aggmatcher.AggGen;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$FastBatchingCellReader == null ? (class$mondrian$rolap$FastBatchingCellReader = FastBatchingCellReader.class$("mondrian.rolap.FastBatchingCellReader")) : class$mondrian$rolap$FastBatchingCellReader));
    private static boolean generateAggregateSql = MondrianProperties.instance().GenerateAggregateSql.get();
    private final RolapCube cube;
    private final Map<BatchKey, Batch> batches;
    private int requestCount;
    final AggregationManager aggMgr = AggregationManager.instance();
    private final RolapAggregationManager.PinSet pinnedSegments = this.aggMgr.createPinSet();
    private boolean dirty;
    private static final Logger BATCH_LOGGER;
    private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader;
    private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader$Batch;

    public FastBatchingCellReader(RolapCube cube) {
        this.cube = cube;
        this.batches = new HashMap<BatchKey, Batch>();
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        Member[] currentMembers = rolapEvaluator.getCurrentMembers();
        CellRequest request = RolapAggregationManager.makeRequest(currentMembers, false, false);
        if (request == null || request.isUnsatisfiable()) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        if (o == Boolean.TRUE) {
            return RolapUtil.valueNotReadyException;
        }
        if (o != null) {
            return o;
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    public int getMissCount() {
        return this.requestCount;
    }

    void recordCellRequest(CellRequest request) {
        if (request.isUnsatisfiable()) {
            return;
        }
        ++this.requestCount;
        BitKey bitkey = request.getConstrainedColumnsBitKey();
        BatchKey key = new BatchKey(bitkey, request.getMeasure().getStar());
        Batch batch = this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            this.batches.put(key, batch);
            if (LOGGER.isDebugEnabled()) {
                RolapStar.Column[] columns;
                StringBuffer buf = new StringBuffer(100);
                buf.append("FastBatchingCellReader: bitkey=");
                buf.append(request.getConstrainedColumnsBitKey());
                buf.append(Util.nl);
                RolapStar.Column[] arr$ = columns = request.getConstrainedColumns();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    RolapStar.Column column = arr$[i$];
                    buf.append("  ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
        }
        batch.add(request);
    }

    boolean isDirty() {
        return this.dirty || !this.batches.isEmpty();
    }

    boolean loadAggregations() {
        return this.loadAggregations(null);
    }

    boolean loadAggregations(Query query) {
        long t1 = System.currentTimeMillis();
        this.requestCount = 0;
        if (this.batches.isEmpty() && !this.dirty) {
            return false;
        }
        ArrayList<Batch> batchList = new ArrayList<Batch>(this.batches.values());
        Collections.sort(batchList, (Comparator)BatchComparator.instance);
        Iterator i$ = batchList.iterator();
        while (i$.hasNext()) {
            Batch batch = (Batch)i$.next();
            if (query != null) {
                query.checkCancelOrTimeout();
            }
            batch.loadAggregation();
        }
        this.batches.clear();
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("loadAggregation (millis): " + (t2 - t1)));
        }
        this.dirty = false;
        return true;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static boolean access$002(boolean x0) {
        generateAggregateSql = x0;
        return generateAggregateSql;
    }

    static boolean access$000() {
        return generateAggregateSql;
    }

    static RolapCube access$100(FastBatchingCellReader x0) {
        return x0.cube;
    }

    static Logger access$200() {
        return BATCH_LOGGER;
    }

    static RolapAggregationManager.PinSet access$300(FastBatchingCellReader x0) {
        return x0.pinnedSegments;
    }

    static {
        MondrianProperties.instance().GenerateAggregateSql.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                FastBatchingCellReader.access$002(property.booleanValue());
            }
        });
        BATCH_LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$FastBatchingCellReader$Batch == null ? (class$mondrian$rolap$FastBatchingCellReader$Batch = FastBatchingCellReader.class$("mondrian.rolap.FastBatchingCellReader$Batch")) : class$mondrian$rolap$FastBatchingCellReader$Batch));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueColumnConstraintComparator
    implements Comparator<ValueColumnPredicate> {
        static final ValueColumnConstraintComparator instance = new ValueColumnConstraintComparator();

        private ValueColumnConstraintComparator() {
        }

        @Override
        public int compare(ValueColumnPredicate o1, ValueColumnPredicate o2) {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((ValueColumnPredicate)x0, (ValueColumnPredicate)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchComparator
    implements Comparator<Batch> {
        static final BatchComparator instance = new BatchComparator();

        private BatchComparator() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            int c;
            int i;
            if (o1.columns.length != o2.columns.length) {
                return o1.columns.length - o2.columns.length;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = o1.columns[i].getName().compareTo(o2.columns[i].getName());
                if (c == 0) continue;
                return c;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = this.compare(o1.valueSets[i], o2.valueSets[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        <T> int compare(Set<T> set1, Set<T> set2) {
            if (set1.size() != set2.size()) {
                return set1.size() - set2.size();
            }
            Iterator<T> iter1 = set1.iterator();
            Iterator<T> iter2 = set2.iterator();
            while (iter1.hasNext()) {
                T v2;
                T v1 = iter1.next();
                int c = Util.compareKey(v1, v2 = iter2.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((Batch)x0, (Batch)x1);
        }
    }

    class BatchKey {
        BitKey key;
        RolapStar star;

        BatchKey(BitKey key, RolapStar star) {
            this.key = key;
            this.star = star;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.star.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof BatchKey) {
                BatchKey bkey = (BatchKey)other;
                return this.key.equals(bkey.key) && this.star.equals(bkey.star);
            }
            return false;
        }

        public String toString() {
            return this.star.getFactTable().getTableName() + " " + this.key.toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Batch {
        final RolapStar.Column[] columns;
        final BitKey constrainedColumnsBitKey;
        final List<RolapStar.Measure> measuresList = new ArrayList<RolapStar.Measure>();
        final Set<StarColumnPredicate>[] valueSets;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$FastBatchingCellReader;

        public Batch(CellRequest request) {
            this.columns = request.getConstrainedColumns();
            this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet<StarColumnPredicate>();
            }
        }

        public void add(CellRequest request) {
            List<StarColumnPredicate> values = request.getValueList();
            for (int j = 0; j < this.columns.length; ++j) {
                this.valueSets[j].add(values.get(j));
            }
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                if (!$assertionsDisabled && this.measuresList.size() != 0 && measure.getStar() != this.measuresList.get(0).getStar()) {
                    throw new AssertionError((Object)"Measure must belong to same star as other measures");
                }
                this.measuresList.add(measure);
            }
        }

        private RolapStar getStar() {
            RolapStar.Measure measure = this.measuresList.get(0);
            return measure.getStar();
        }

        void loadAggregation() {
            int measureCount;
            if (FastBatchingCellReader.access$000()) {
                RolapCube cube = FastBatchingCellReader.access$100(FastBatchingCellReader.this);
                if (cube == null || cube.isVirtual()) {
                    StringBuffer buf = new StringBuffer(64);
                    buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"");
                    buf.append(FastBatchingCellReader.access$100(FastBatchingCellReader.this).getName());
                    buf.append("\", operation not currently supported");
                    FastBatchingCellReader.access$200().error((Object)buf.toString());
                } else {
                    AggGen aggGen = new AggGen(FastBatchingCellReader.access$100(FastBatchingCellReader.this).getStar(), this.columns);
                    if (aggGen.isReady()) {
                        System.out.println(new StringBuffer().append("createLost:").append(Util.nl).append(aggGen.createLost()).toString());
                        System.out.println(new StringBuffer().append("insertIntoLost:").append(Util.nl).append(aggGen.insertIntoLost()).toString());
                        System.out.println(new StringBuffer().append("createCollapsed:").append(Util.nl).append(aggGen.createCollapsed()).toString());
                        System.out.println(new StringBuffer().append("insertIntoCollapsed:").append(Util.nl).append(aggGen.insertIntoCollapsed()).toString());
                    } else {
                        FastBatchingCellReader.access$200().error((Object)"AggGen failed");
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            AggregationManager aggmgr = AggregationManager.instance();
            StarColumnPredicate[] predicates = new StarColumnPredicate[this.columns.length];
            for (int j = 0; j < this.columns.length; ++j) {
                AbstractColumnPredicate predicate;
                Set<StarColumnPredicate> valueSet = this.valueSets[j];
                if (valueSet == null) {
                    predicate = LiteralStarPredicate.FALSE;
                } else {
                    Object[] values = valueSet.toArray(new ValueColumnPredicate[valueSet.size()]);
                    Arrays.sort((Object[])values, (Comparator)ValueColumnConstraintComparator.instance);
                    predicate = new ListColumnPredicate(this.columns[j], Arrays.asList((Object[])((StarColumnPredicate[])values)));
                }
                predicates[j] = predicate;
            }
            if (!this.getStar().getSqlQueryDialect().allowsCountDistinct()) {
                RolapStar.Measure distinctMeasure;
                while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                    String expr = distinctMeasure.getExpression().getGenericExpression();
                    ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                    int i = 0;
                    while (i < this.measuresList.size()) {
                        RolapStar.Measure measure = this.measuresList.get(i);
                        if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                            this.measuresList.remove(i);
                            distinctMeasuresList.add(distinctMeasure);
                            continue;
                        }
                        ++i;
                    }
                    RolapStar.Measure[] measures = distinctMeasuresList.toArray(new RolapStar.Measure[distinctMeasuresList.size()]);
                    aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, predicates, FastBatchingCellReader.access$300(FastBatchingCellReader.this));
                }
            }
            if ((measureCount = this.measuresList.size()) > 0) {
                RolapStar.Measure[] measures = this.measuresList.toArray(new RolapStar.Measure[measureCount]);
                aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, predicates, FastBatchingCellReader.access$300(FastBatchingCellReader.this));
            }
            if (FastBatchingCellReader.access$200().isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                FastBatchingCellReader.access$200().debug((Object)new StringBuffer().append("Batch.loadAggregation (millis) ").append(t2 - t1).toString());
            }
        }

        RolapStar.Measure getFirstDistinctMeasure(List<RolapStar.Measure> measuresList) {
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$FastBatchingCellReader == null ? (class$mondrian$rolap$FastBatchingCellReader = Batch.class$("mondrian.rolap.FastBatchingCellReader")) : class$mondrian$rolap$FastBatchingCellReader).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

