/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheMemberReader
implements MemberReader,
MemberCache {
    private final MemberSource source;
    private final RolapMember[] members;
    private final Map<Object, RolapMember> mapKeyToMember;

    CacheMemberReader(MemberSource source) {
        this.source = source;
        this.mapKeyToMember = new HashMap<Object, RolapMember>();
        this.members = source.getMembers();
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].setOrdinal(i);
        }
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember[] getMembers() {
        return this.members;
    }

    @Override
    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    @Override
    public RolapMember getMember(Object key) {
        return this.mapKeyToMember.get(key);
    }

    @Override
    public RolapMember getMember(Object key, boolean mustCheckCacheStatus) {
        return this.mapKeyToMember.get(key);
    }

    @Override
    public Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        return null;
    }

    @Override
    public List getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        return null;
    }

    @Override
    public RolapMember lookupMember(String[] uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    @Override
    public List<RolapMember> getRootMembers() {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        for (RolapMember member : this.members) {
            if (member.getParentUniqueName() != null) continue;
            list.add(member);
        }
        return list;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        int levelDepth = level.getDepth();
        for (RolapMember member : this.members) {
            if (member.getLevel().getDepth() != levelDepth || startOrdinal > member.getOrdinal() || member.getOrdinal() >= endOrdinal) continue;
            list.add(member);
        }
        return list;
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        return this.getMembersInLevel(level, startOrdinal, endOrdinal);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        for (RolapMember member : this.members) {
            if (member.getParentMember() != parentMember) continue;
            children.add(member);
        }
    }

    @Override
    public void getMemberChildren(RolapMember member, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(member, children);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        for (RolapMember member : this.members) {
            if (!parentMembers.contains(member.getParentMember())) continue;
            children.add(member);
        }
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(parentMembers, children);
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        if (n >= 0) {
            for (int ordinal = member.getOrdinal(); ordinal < this.members.length; ++ordinal) {
                if (this.members[ordinal].getLevel() != member.getLevel() || n-- != 0) continue;
                return this.members[ordinal];
            }
            return (RolapMember)member.getHierarchy().getNullMember();
        }
        for (int ordinal = member.getOrdinal(); ordinal >= 0; --ordinal) {
            if (this.members[ordinal].getLevel() != member.getLevel() || n++ != 0) continue;
            return this.members[ordinal];
        }
        return (RolapMember)member.getHierarchy().getNullMember();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> list) {
        Util.assertPrecondition(startMember != null, "startMember != null");
        Util.assertPrecondition(endMember != null, "endMember != null");
        Util.assertPrecondition(startMember.getLevel() == endMember.getLevel(), "startMember.getLevel() == endMember.getLevel()");
        for (int i = startMember.getOrdinal(); i <= endMember.getOrdinal(); ++i) {
            if (this.members[i].getLevel() != endMember.getLevel()) continue;
            list.add(this.members[i]);
        }
    }

    @Override
    public int getMemberCount() {
        return this.members.length;
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        if (m1 == m2) {
            return 0;
        }
        if (siblingsAreEqual && m1.getParentMember() == m2.getParentMember()) {
            return 0;
        }
        Util.assertTrue(this.members[m1.getOrdinal()] == m1);
        Util.assertTrue(this.members[m2.getOrdinal()] == m2);
        return m1.getOrdinal() < m2.getOrdinal() ? -1 : 1;
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return null;
    }
}

