/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Enum_;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.recorder.MessageRecorder;
import mondrian.recorder.RecorderException;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;

public abstract class AbstractRecorder
implements MessageRecorder {
    public static final int DEFAULT_MSG_LIMIT = 10;
    private final int errorMsgLimit;
    private final List<String> contexts;
    private int errorMsgCount;
    private int warningMsgCount;
    private int infoMsgCount;
    private String contextMsgCache;
    private long startTime;

    public static void logMessage(String context, String msg, MsgType msgType, Logger logger) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(context);
        buf.append(": ");
        buf.append(msg);
        switch (1.$SwitchMap$mondrian$recorder$AbstractRecorder$MsgType[msgType.ordinal()]) {
            case 1: {
                logger.info((Object)buf.toString());
                break;
            }
            case 2: {
                logger.warn((Object)buf.toString());
                break;
            }
            case 3: {
                logger.error((Object)buf.toString());
                break;
            }
            default: {
                logger.warn((Object)("Unknown message type enum \"" + (Object)((Object)msgType) + "\" for message: " + buf.toString()));
            }
        }
    }

    protected AbstractRecorder() {
        this(10);
    }

    protected AbstractRecorder(int errorMsgLimit) {
        this.errorMsgLimit = errorMsgLimit;
        this.contexts = new ArrayList<String>();
        this.startTime = System.currentTimeMillis();
    }

    public void clear() {
        this.errorMsgCount = 0;
        this.warningMsgCount = 0;
        this.infoMsgCount = 0;
        this.contextMsgCache = null;
        this.contexts.clear();
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTimeMillis() {
        return this.startTime;
    }

    public long getRunTimeMillis() {
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean hasInformation() {
        return this.infoMsgCount > 0;
    }

    public boolean hasWarnings() {
        return this.warningMsgCount > 0;
    }

    public boolean hasErrors() {
        return this.errorMsgCount > 0;
    }

    public int getInfoCount() {
        return this.infoMsgCount;
    }

    public int getWarningCount() {
        return this.warningMsgCount;
    }

    public int getErrorCount() {
        return this.errorMsgCount;
    }

    public String getContext() {
        if (this.contextMsgCache == null) {
            StringBuffer buf = new StringBuffer();
            int k = 0;
            Iterator<String> i$ = this.contexts.iterator();
            while (i$.hasNext()) {
                String name = i$.next();
                if (k++ > 0) {
                    buf.append(':');
                }
                buf.append(name);
            }
            this.contextMsgCache = buf.toString();
        }
        return this.contextMsgCache;
    }

    public void pushContextName(String name) {
        this.contexts.add(name);
        this.contextMsgCache = null;
    }

    public void popContextName() {
        this.contexts.remove(this.contexts.size() - 1);
        this.contextMsgCache = null;
    }

    public void throwRTException() throws RecorderException {
        if (this.hasErrors()) {
            String errorMsg = MondrianResource.instance().ForceMessageRecorderError.str(this.getContext(), Autobox.valueOf((int)this.errorMsgCount));
            throw new RecorderException(errorMsg);
        }
    }

    public void reportError(Exception ex) throws RecorderException {
        this.reportError(ex, null);
    }

    public void reportError(Exception ex, Object info) throws RecorderException {
        this.reportError(ex.toString(), info);
    }

    public void reportError(String msg) throws RecorderException {
        this.reportError(msg, null);
    }

    public void reportError(String msg, Object info) throws RecorderException {
        ++this.errorMsgCount;
        this.recordMessage(msg, info, MsgType.ERROR);
        if (this.errorMsgCount >= this.errorMsgLimit) {
            String errorMsg = MondrianResource.instance().TooManyMessageRecorderErrors.str(this.getContext(), Autobox.valueOf((int)this.errorMsgCount));
            throw new RecorderException(errorMsg);
        }
    }

    public void reportWarning(String msg) {
        this.reportWarning(msg, null);
    }

    public void reportWarning(String msg, Object info) {
        ++this.warningMsgCount;
        this.recordMessage(msg, info, MsgType.WARN);
    }

    public void reportInfo(String msg) {
        this.reportInfo(msg, null);
    }

    public void reportInfo(String msg, Object info) {
        ++this.infoMsgCount;
        this.recordMessage(msg, info, MsgType.INFO);
    }

    protected abstract void recordMessage(String var1, Object var2, MsgType var3);

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$recorder$AbstractRecorder$MsgType;

        static {
            $SwitchMap$mondrian$recorder$AbstractRecorder$MsgType = new int[MsgType.values().length];
            try {
                1.$SwitchMap$mondrian$recorder$AbstractRecorder$MsgType[MsgType.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$recorder$AbstractRecorder$MsgType[MsgType.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$recorder$AbstractRecorder$MsgType[MsgType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.recorder.AbstractRecorder$MsgType>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MsgType
    extends Enum_ {
        public static final /* enum */ MsgType INFO = new MsgType("INFO", 0);
        public static final /* enum */ MsgType WARN = new MsgType("WARN", 1);
        public static final /* enum */ MsgType ERROR = new MsgType("ERROR", 2);
        private static final /* synthetic */ MsgType[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$recorder$AbstractRecorder$MsgType;

        public static final MsgType[] values() {
            return (MsgType[])$VALUES.clone();
        }

        public static MsgType valueOf(String name) {
            return (MsgType)Enum_.valueOf((Class)(class$mondrian$recorder$AbstractRecorder$MsgType == null ? (class$mondrian$recorder$AbstractRecorder$MsgType = MsgType.class$("mondrian.recorder.AbstractRecorder$MsgType")) : class$mondrian$recorder$AbstractRecorder$MsgType), (String)name);
        }

        private MsgType(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new MsgType[]{INFO, WARN, ERROR};
            Enum_.setEnumValues((Object[])MsgType.values(), (Class)(class$mondrian$recorder$AbstractRecorder$MsgType == null ? (class$mondrian$recorder$AbstractRecorder$MsgType = MsgType.class$("mondrian.recorder.AbstractRecorder$MsgType")) : class$mondrian$recorder$AbstractRecorder$MsgType));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

