/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.extra;

import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;

public class CalculatedChildFunDef
extends FunDefBase {
    public static final CalculatedChildFunDef instance = new CalculatedChildFunDef();

    CalculatedChildFunDef() {
        super("CalculatedChild", "<Member>.CalculatedChild(<String>)", "Returns an existing calculated child member with name <String> from the specified <Member>.", "mmmS");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, stringCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                Member member = memberCalc.evaluateMember(evaluator);
                String name = stringCalc.evaluateString(evaluator);
                return CalculatedChildFunDef.access$000(CalculatedChildFunDef.this, member, name, evaluator);
            }
        };
    }

    private Member getCalculatedChild(Member parent, String childName, Evaluator evaluator) {
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        Level childLevel = parent.getLevel().getChildLevel();
        if (childLevel == null) {
            return parent.getHierarchy().getNullMember();
        }
        List<Member> calcMemberList = schemaReader.getCalculatedMembers(childLevel);
        Iterator<Member> i$ = calcMemberList.iterator();
        while (i$.hasNext()) {
            Member child = i$.next();
            if (child.getParentMember() != parent || !child.getName().equals(childName)) continue;
            return child;
        }
        return parent.getHierarchy().getNullMember();
    }

    static Member access$000(CalculatedChildFunDef x0, Member x1, String x2, Evaluator x3) {
        return x0.getCalculatedChild(x1, x2, x3);
    }
}

