/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.spi.UserDefinedFunction;

public class UdfResolver
implements Resolver {
    private final UserDefinedFunction udf;
    private static final String[] emptyStringArray = new String[0];

    public UdfResolver(UserDefinedFunction udf) {
        this.udf = udf;
    }

    public String getName() {
        return this.udf.getName();
    }

    public String getDescription() {
        return this.udf.getDescription();
    }

    public String getSignature() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        int returnCategory = TypeUtil.typeToCategory(returnType);
        return this.getSyntax().getSignature(this.getName(), returnCategory, parameterCategories);
    }

    public Syntax getSyntax() {
        return this.udf.getSyntax();
    }

    public FunDef getFunDef() {
        Type[] parameterTypes = this.udf.getParameterTypes();
        int[] parameterCategories = new int[parameterTypes.length];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = TypeUtil.typeToCategory(parameterTypes[i]);
        }
        Type returnType = this.udf.getReturnType(parameterTypes);
        int returnCategory = TypeUtil.typeToCategory(returnType);
        return new UdfFunDef(returnCategory, parameterCategories);
    }

    public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
        Type[] parameterTypes = this.udf.getParameterTypes();
        if (args.length != parameterTypes.length) {
            return null;
        }
        int[] parameterCategories = new int[parameterTypes.length];
        Type[] argTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            Exp arg = args[i];
            argTypes[i] = arg.getType();
            Type argType = argTypes[i];
            if (parameterType.equals(argType)) continue;
            int parameterCategory = TypeUtil.typeToCategory(parameterType);
            if (!validator.canConvert(arg, parameterCategory, conversionCount)) {
                return null;
            }
            parameterCategories[i] = parameterCategory;
        }
        Type returnType = this.udf.getReturnType(argTypes);
        int returnCategory = TypeUtil.typeToCategory(returnType);
        return new UdfFunDef(returnCategory, parameterCategories);
    }

    public boolean requiresExpression(int k) {
        return false;
    }

    public String[] getReservedWords() {
        String[] reservedWords = this.udf.getReservedWords();
        return reservedWords == null ? emptyStringArray : reservedWords;
    }

    static UserDefinedFunction access$000(UdfResolver x0) {
        return x0.udf;
    }

    private static class CalcExp
    implements UserDefinedFunction.Argument {
        private final Calc calc;
        private final Calc scalarCalc;

        public CalcExp(Calc calc, Calc scalarCalc) {
            this.calc = calc;
            this.scalarCalc = scalarCalc;
        }

        public Type getType() {
            return this.calc.getType();
        }

        public Object evaluate(Evaluator evaluator) {
            return this.calc.evaluate(evaluator);
        }

        public Object evaluateScalar(Evaluator evaluator) {
            return this.scalarCalc.evaluate(evaluator);
        }
    }

    private static class CalcImpl
    extends GenericCalc {
        private final Calc[] calcs;
        private final UserDefinedFunction udf;
        private final UserDefinedFunction.Argument[] args;

        public CalcImpl(ResolvedFunCall call, Calc[] calcs, UserDefinedFunction udf, UserDefinedFunction.Argument[] args) {
            super(call);
            this.calcs = calcs;
            this.udf = udf;
            this.args = args;
        }

        public Calc[] getCalcs() {
            return this.calcs;
        }

        public Object evaluate(Evaluator evaluator) {
            return this.udf.execute(evaluator, this.args);
        }

        public boolean dependsOn(Dimension dimension) {
            return true;
        }
    }

    private class UdfFunDef
    extends FunDefBase {
        public UdfFunDef(int returnCategory, int[] parameterCategories) {
            super(UdfResolver.this, returnCategory, parameterCategories);
        }

        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            Exp[] args = call.getArgs();
            Calc[] calcs = new Calc[args.length];
            UserDefinedFunction.Argument[] expCalcs = new UserDefinedFunction.Argument[args.length];
            for (int i = 0; i < args.length; ++i) {
                Exp arg = args[i];
                Calc calc = compiler.compile(arg);
                Calc scalarCalc = compiler.compileScalar(arg, true);
                expCalcs[i] = new CalcExp(calc, scalarCalc);
            }
            return new CalcImpl(call, calcs, UdfResolver.access$000(UdfResolver.this), expCalcs);
        }
    }
}

