/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

class SetItemFunDef
extends FunDefBase {
    static final Resolver intResolver = new ReflectiveMultiResolver("Item", "<Set>.Item(<Index>)", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the zero-based position of the tuple in the set in <Index>.", new String[]{"mmxn"}, class$mondrian$olap$fun$SetItemFunDef == null ? (class$mondrian$olap$fun$SetItemFunDef = SetItemFunDef.class$("mondrian.olap.fun.SetItemFunDef")) : class$mondrian$olap$fun$SetItemFunDef);
    static final Resolver stringResolver = new ResolverBase("Item", "<Set>.Item(<String> [, ...])", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the member name (or names) in <String>.", Syntax.Method){

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 1) {
                return null;
            }
            Exp setExp = args[0];
            if (!(setExp.getType() instanceof SetType)) {
                return null;
            }
            SetType setType = (SetType)setExp.getType();
            int arity = setType.getElementType() instanceof TupleType ? ((TupleType)setType.getElementType()).elementTypes.length : 1;
            for (int i = 1; i < args.length; ++i) {
                if (validator.canConvert(args[i], 9, conversionCount)) continue;
                return null;
            }
            if (args.length - 1 != arity) {
                throw Util.newError("Argument count does not match set's cardinality " + arity);
            }
            int category = arity == 1 ? 6 : 10;
            FunDef dummy = 1.createDummyFunDef(this, category, args);
            return new SetItemFunDef(dummy);
        }
    };
    private static final /* synthetic */ Class class$mondrian$olap$fun$SetItemFunDef;

    public SetItemFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        SetType setType = (SetType)args[0].getType();
        return setType.getElementType();
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        StringCalc[] stringCalcs;
        IntegerCalc indexCalc;
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        Type elementType = ((SetType)listCalc.getType()).getElementType();
        boolean isString = call.getArgCount() < 2 || call.getArg(1).getType() instanceof StringType;
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        calcList.add(listCalc);
        if (isString) {
            indexCalc = null;
            stringCalcs = new StringCalc[call.getArgCount() - 1];
            for (int i = 0; i < stringCalcs.length; ++i) {
                stringCalcs[i] = compiler.compileString(call.getArg(i + 1));
                calcList.add(stringCalcs[i]);
            }
        } else {
            stringCalcs = null;
            indexCalc = compiler.compileInteger(call.getArg(1));
            calcList.add(indexCalc);
        }
        Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        if (elementType instanceof TupleType) {
            TupleType tupleType = (TupleType)elementType;
            final Member[] nullTuple = SetItemFunDef.makeNullTuple(tupleType);
            if (isString) {
                return new AbstractTupleCalc(call, calcs){
                    static final /* synthetic */ boolean $assertionsDisabled;
                    private static final /* synthetic */ Class class$mondrian$olap$fun$SetItemFunDef;

                    public Member[] evaluateTuple(Evaluator evaluator) {
                        List list = listCalc.evaluateList(evaluator);
                        if (!$assertionsDisabled && list == null) {
                            throw new AssertionError();
                        }
                        String[] results = new String[stringCalcs.length];
                        for (int i = 0; i < stringCalcs.length; ++i) {
                            results[i] = stringCalcs[i].evaluateString(evaluator);
                        }
                        Iterator i$ = list.iterator();
                        block1: while (i$.hasNext()) {
                            Member[] members = (Member[])i$.next();
                            for (int j = 0; j < results.length; ++j) {
                                Member member = members[j];
                                String result = results[j];
                                if (!SetItemFunDef.access$000(member, result)) continue block1;
                            }
                            return members;
                        }
                        return null;
                    }

                    static {
                        $assertionsDisabled = !(class$mondrian$olap$fun$SetItemFunDef == null ? (class$mondrian$olap$fun$SetItemFunDef = 2.class$("mondrian.olap.fun.SetItemFunDef")) : class$mondrian$olap$fun$SetItemFunDef).desiredAssertionStatus();
                    }

                    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                            try {
                                noClassDefFoundError.initCause(classNotFoundException);
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                // empty catch block
                            }
                            throw noClassDefFoundError;
                        }
                        return clazz;
                    }
                };
            }
            return new AbstractTupleCalc(call, calcs){
                static final /* synthetic */ boolean $assertionsDisabled;
                private static final /* synthetic */ Class class$mondrian$olap$fun$SetItemFunDef;

                public Member[] evaluateTuple(Evaluator evaluator) {
                    int listSize;
                    List list = listCalc.evaluateList(evaluator);
                    if (!$assertionsDisabled && list == null) {
                        throw new AssertionError();
                    }
                    int index = indexCalc.evaluateInteger(evaluator);
                    if (index >= (listSize = list.size()) || index < 0) {
                        return nullTuple;
                    }
                    return (Member[])list.get(index);
                }

                static {
                    $assertionsDisabled = !(class$mondrian$olap$fun$SetItemFunDef == null ? (class$mondrian$olap$fun$SetItemFunDef = 3.class$("mondrian.olap.fun.SetItemFunDef")) : class$mondrian$olap$fun$SetItemFunDef).desiredAssertionStatus();
                }

                static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                        try {
                            noClassDefFoundError.initCause(classNotFoundException);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        throw noClassDefFoundError;
                    }
                    return clazz;
                }
            };
        }
        MemberType memberType = (MemberType)elementType;
        final Member nullMember = SetItemFunDef.makeNullMember(memberType);
        if (isString) {
            return new AbstractMemberCalc(call, calcs){
                static final /* synthetic */ boolean $assertionsDisabled;
                private static final /* synthetic */ Class class$mondrian$olap$fun$SetItemFunDef;

                public Member evaluateMember(Evaluator evaluator) {
                    List list = listCalc.evaluateList(evaluator);
                    if (!$assertionsDisabled && list == null) {
                        throw new AssertionError();
                    }
                    String result = stringCalcs[0].evaluateString(evaluator);
                    Iterator i$ = list.iterator();
                    while (i$.hasNext()) {
                        Member member = (Member)i$.next();
                        if (!SetItemFunDef.access$000(member, result)) continue;
                        return member;
                    }
                    return nullMember;
                }

                static {
                    $assertionsDisabled = !(class$mondrian$olap$fun$SetItemFunDef == null ? (class$mondrian$olap$fun$SetItemFunDef = 4.class$("mondrian.olap.fun.SetItemFunDef")) : class$mondrian$olap$fun$SetItemFunDef).desiredAssertionStatus();
                }

                static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                        try {
                            noClassDefFoundError.initCause(classNotFoundException);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        throw noClassDefFoundError;
                    }
                    return clazz;
                }
            };
        }
        return new AbstractMemberCalc(call, calcs){
            static final /* synthetic */ boolean $assertionsDisabled;
            private static final /* synthetic */ Class class$mondrian$olap$fun$SetItemFunDef;

            public Member evaluateMember(Evaluator evaluator) {
                int listSize;
                List list = listCalc.evaluateList(evaluator);
                if (!$assertionsDisabled && list == null) {
                    throw new AssertionError();
                }
                int index = indexCalc.evaluateInteger(evaluator);
                if (index >= (listSize = list.size()) || index < 0) {
                    return nullMember;
                }
                return (Member)list.get(index);
            }

            static {
                $assertionsDisabled = !(class$mondrian$olap$fun$SetItemFunDef == null ? (class$mondrian$olap$fun$SetItemFunDef = 5.class$("mondrian.olap.fun.SetItemFunDef")) : class$mondrian$olap$fun$SetItemFunDef).desiredAssertionStatus();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        };
    }

    private static boolean matchMember(Member member, String name) {
        return member.getName().equals(name);
    }

    Object makeNullMember(Evaluator evaluator, Exp[] args) {
        Type elementType = ((SetType)args[0].getType()).getElementType();
        return this.makeNullMemberOrTuple(elementType);
    }

    Object makeNullMemberOrTuple(Type elementType) {
        if (elementType instanceof MemberType) {
            MemberType memberType = (MemberType)elementType;
            return SetItemFunDef.makeNullMember(memberType);
        }
        if (elementType instanceof TupleType) {
            return SetItemFunDef.makeNullTuple((TupleType)elementType);
        }
        throw Util.newInternal("bad type " + elementType);
    }

    static boolean access$000(Member x0, String x1) {
        return SetItemFunDef.matchMember(x0, x1);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

