/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.ResolverBase;

class PropertiesFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl(null);

    public PropertiesFunDef(String name, String signature, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        super(name, signature, description, syntax, returnType, parameterTypes);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new GenericCalc(call){

            public Object evaluate(Evaluator evaluator) {
                return PropertiesFunDef.properties(memberCalc.evaluateMember(evaluator), stringCalc.evaluateString(evaluator));
            }

            public Calc[] getCalcs() {
                return new Calc[]{memberCalc, stringCalc};
            }
        };
    }

    static Object properties(Member member, String s) {
        boolean matchCase = MondrianProperties.instance().CaseSensitive.get();
        Object o = member.getPropertyValue(s, matchCase);
        if (o == null && !Util.isValidProperty(member, s)) {
            throw new MondrianEvaluationException("Property '" + s + "' is not valid for member '" + member + "'");
        }
        return o;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$olap$Property$Datatype;

        static {
            $SwitchMap$mondrian$olap$Property$Datatype = new int[Property.Datatype.values().length];
            try {
                2.$SwitchMap$mondrian$olap$Property$Datatype[Property.Datatype.TYPE_BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$mondrian$olap$Property$Datatype[Property.Datatype.TYPE_NUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$mondrian$olap$Property$Datatype[Property.Datatype.TYPE_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static class ResolverImpl
    extends ResolverBase {
        private ResolverImpl() {
            super("Properties", "<Member>.Properties(<String Expression>)", "Returns the value of a member property.", Syntax.Method);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            int[] argTypes = new int[]{6, 9};
            Exp propertyNameExp = args[1];
            Exp memberExp = args[0];
            if (args.length != 2 || memberExp.getCategory() != 6 || propertyNameExp.getCategory() != 9) {
                return null;
            }
            int returnType = this.deducePropertyCategory(memberExp, propertyNameExp);
            return new PropertiesFunDef(this.getName(), this.getSignature(), this.getDescription(), this.getSyntax(), returnType, argTypes);
        }

        private int deducePropertyCategory(Exp memberExp, Exp propertyNameExp) {
            if (!(propertyNameExp instanceof Literal)) {
                return 13;
            }
            String propertyName = (String)((Literal)propertyNameExp).getValue();
            Hierarchy hierarchy = memberExp.getType().getHierarchy();
            if (hierarchy == null) {
                return 13;
            }
            Level[] levels = hierarchy.getLevels();
            Property property = ResolverImpl.lookupProperty(levels[levels.length - 1], propertyName);
            if (property == null) {
                return 13;
            }
            switch (2.$SwitchMap$mondrian$olap$Property$Datatype[property.getType().ordinal()]) {
                case 1: {
                    return 5;
                }
                case 2: {
                    return 7;
                }
                case 3: {
                    return 9;
                }
            }
            throw Util.badValue(property.getType());
        }

        public boolean requiresExpression(int k) {
            return true;
        }

        ResolverImpl(1 x0) {
            this();
        }
    }
}

