/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;

public abstract class MultiResolver
extends FunUtil
implements Resolver {
    private final String name;
    private final String signature;
    private final String description;
    private final String[] signatures;
    private final Syntax syntax;

    protected MultiResolver(String name, String signature, String description, String[] signatures) {
        this.name = name;
        this.signature = signature;
        this.description = description;
        this.signatures = signatures;
        Util.assertTrue(signatures.length > 0);
        this.syntax = MultiResolver.decodeSyntacticType(signatures[0]);
        for (int i = 1; i < signatures.length; ++i) {
            Util.assertTrue(MultiResolver.decodeSyntacticType(signatures[i]) == this.syntax);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSignature() {
        return this.signature;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String[] getReservedWords() {
        return emptyStringArray;
    }

    public String[] getSignatures() {
        return this.signatures;
    }

    public FunDef getFunDef() {
        return null;
    }

    public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
        String[] arr$ = this.signatures;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            String signature = arr$[i$];
            int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
            if (parameterTypes.length != args.length) continue;
            for (int i = 0; i < args.length; ++i) {
                if (!validator.canConvert(args[i], parameterTypes[i], conversionCount)) continue block0;
            }
            int returnType = MultiResolver.decodeReturnCategory(signature);
            FunDef dummy = MultiResolver.createDummyFunDef(this, returnType, args);
            return this.createFunDef(args, dummy);
        }
        return null;
    }

    public boolean requiresExpression(int k) {
        String[] arr$ = this.signatures;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String signature = arr$[i$];
            int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
            if (k >= parameterTypes.length || parameterTypes[k] != 8) continue;
            return false;
        }
        return true;
    }

    protected abstract FunDef createFunDef(Exp[] var1, FunDef var2);
}

