/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.DimensionCurrentMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LastPeriodsFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("LastPeriods", "LastPeriods(<Index> [, <Member>])", "Returns a set of members prior to and including a specified member.", new String[]{"fxn", "fxnm"}, class$mondrian$olap$fun$LastPeriodsFunDef == null ? (class$mondrian$olap$fun$LastPeriodsFunDef = LastPeriodsFunDef.class$("mondrian.olap.fun.LastPeriodsFunDef")) : class$mondrian$olap$fun$LastPeriodsFunDef);
    private static final /* synthetic */ Class class$mondrian$olap$fun$LastPeriodsFunDef;

    public LastPeriodsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
            return new SetType(MemberType.forHierarchy(hierarchy));
        }
        Type type = args[1].getType();
        Type memberType = TypeUtil.toMemberOrTupleType(type);
        return new SetType(memberType);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        MemberCalc memberCalc;
        Exp[] args = call.getArgs();
        if (args.length == 1) {
            Dimension timeDimension = compiler.getEvaluator().getCube().getTimeDimension();
            memberCalc = new DimensionCurrentMemberCalc(timeDimension);
        } else {
            memberCalc = compiler.compileMember(args[1]);
        }
        final IntegerCalc indexValueCalc = compiler.compileInteger(args[0]);
        return new AbstractListCalc(call, new Calc[]{memberCalc, indexValueCalc}){

            public List evaluateList(Evaluator evaluator) {
                Member member = memberCalc.evaluateMember(evaluator);
                int indexValue = indexValueCalc.evaluateInteger(evaluator);
                return LastPeriodsFunDef.this.lastPeriods(member, evaluator, indexValue);
            }
        };
    }

    List<Member> lastPeriods(Member member, Evaluator evaluator, int indexValue) {
        Member endMember;
        Member startMember;
        if (indexValue == 0 || member.isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Member> list = new ArrayList<Member>();
        if (indexValue == 1 || indexValue == -1) {
            list.add(member);
            return list;
        }
        if (indexValue > 0) {
            startMember = evaluator.getSchemaReader().getLeadMember(member, -(indexValue - 1));
            endMember = member;
            if (startMember.isNull()) {
                Member[] members = evaluator.getSchemaReader().getLevelMembers(member.getLevel(), false);
                startMember = members[0];
            }
        } else {
            startMember = member;
            endMember = evaluator.getSchemaReader().getLeadMember(member, -(indexValue + 1));
            if (endMember.isNull()) {
                Member[] members = evaluator.getSchemaReader().getLevelMembers(member.getLevel(), false);
                endMember = members[members.length - 1];
            }
        }
        evaluator.getSchemaReader().getMemberRange(member.getLevel(), startMember, endMember, list);
        return list;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

