/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;

class FilterFunDef
extends FunDefBase {
    static final FilterFunDef instance = new FilterFunDef();

    private FilterFunDef() {
        super("Filter", "Filter(<Set>, <Search Condition>)", "Returns the set resulting from filtering a set based on a search condition.", "fxxb");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ExpCompiler.ResultStyle[] rs = compiler.getAcceptableResultStyles();
        for (int i = 0; i < rs.length; ++i) {
            switch (1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[rs[i].ordinal()]) {
                case 1: 
                case 2: {
                    return this.compileCallIterable(call, compiler);
                }
                case 3: 
                case 4: {
                    return this.compileCallList(call, compiler);
                }
            }
        }
        throw ResultStyleException.generate(new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.ITERABLE, ExpCompiler.ResultStyle.LIST, ExpCompiler.ResultStyle.MUTABLE_LIST, ExpCompiler.ResultStyle.ANY}, rs);
    }

    protected Calc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc imlcalc = compiler.compile(call.getArg(0), ExpCompiler.ITERABLE_LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{imlcalc, bcalc};
        FilterFunDef.checkIterListResultStyles(imlcalc);
        if (((SetType)imlcalc.getType()).getElementType() instanceof MemberType) {
            if (imlcalc.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                return new IterMemberIterCalc(call, calcs);
            }
            if (imlcalc.getResultStyle() == ExpCompiler.ResultStyle.LIST) {
                return new ImMutableMemberIterCalc(call, calcs);
            }
            return new MutableMemberIterCalc(call, calcs);
        }
        if (imlcalc.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
            return new IterMemberArrayIterCalc(call, calcs);
        }
        if (imlcalc.getResultStyle() == ExpCompiler.ResultStyle.LIST) {
            return new ImMutableMemberArrayIterCalc(call, calcs);
        }
        return new MutableMemberArrayIterCalc(call, calcs);
    }

    protected Calc compileCallList(ResolvedFunCall call, ExpCompiler compiler) {
        Calc ilcalc = compiler.compile(call.getArg(0), ExpCompiler.MUTABLE_LIST_LIST_RESULT_STYLE_ARRAY);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{ilcalc, bcalc};
        if (((SetType)ilcalc.getType()).getElementType() instanceof MemberType) {
            switch (1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ilcalc.getResultStyle().ordinal()]) {
                case 4: {
                    return new ImMutableMemberListCalc(call, calcs);
                }
                case 3: {
                    return new MutableMemberListCalc(call, calcs);
                }
            }
            throw ResultStyleException.generateBadType(new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.LIST, ExpCompiler.ResultStyle.MUTABLE_LIST}, ilcalc.getResultStyle());
        }
        switch (1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ilcalc.getResultStyle().ordinal()]) {
            case 4: {
                return new ImMutableMemberArrayListCalc(call, calcs);
            }
            case 3: {
                return new MutableMemberArrayListCalc(call, calcs);
            }
        }
        throw ResultStyleException.generateBadType(new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.LIST, ExpCompiler.ResultStyle.MUTABLE_LIST}, ilcalc.getResultStyle());
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mondrian$calc$ExpCompiler$ResultStyle;

        static {
            $SwitchMap$mondrian$calc$ExpCompiler$ResultStyle = new int[ExpCompiler.ResultStyle.values().length];
            try {
                1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ExpCompiler.ResultStyle.ITERABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ExpCompiler.ResultStyle.ANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ExpCompiler.ResultStyle.MUTABLE_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mondrian$calc$ExpCompiler$ResultStyle[ExpCompiler.ResultStyle.LIST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static class ImMutableMemberArrayListCalc
    extends BaseListCalc {
        ImMutableMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            ArrayList<Member[]> result = new ArrayList<Member[]>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member[] member = (Member[])members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableMemberArrayListCalc
    extends BaseListCalc {
        MutableMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Member[] member = (Member[])it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static class ImMutableMemberListCalc
    extends BaseListCalc {
        ImMutableMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            ArrayList<Member> result = new ArrayList<Member>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member member = (Member)members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableMemberListCalc
    extends BaseListCalc {
        MutableMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Member member = (Member)it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static abstract class BaseListCalc
    extends AbstractListCalc {
        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        public List evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (List)nativeEvaluator.execute(ExpCompiler.ResultStyle.MUTABLE_LIST);
            }
            return this.makeList(evaluator);
        }

        protected abstract List makeList(Evaluator var1);

        public boolean dependsOn(Dimension dimension) {
            return BaseListCalc.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }

    private static class IterMemberArrayIterCalc
    extends BaseIterCalc {
        IterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            IterCalc icalc = (IterCalc)calcs[0];
            final BooleanCalc bcalc = (BooleanCalc)calcs[1];
            final Evaluator evaluator2 = evaluator.push();
            final Iterable_ iter = icalc.evaluateIterable(evaluator);
            Iterable<Member[]> result = new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator<Member[]> it;
                        Member[] m;
                        {
                            this.it = IterableMethods.iterator((Object)iter);
                            this.m = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.m != null) {
                                return true;
                            }
                            if (!this.it.hasNext()) {
                                return false;
                            }
                            this.m = this.it.next();
                            evaluator2.setContext(this.m);
                            while (!bcalc.evaluateBoolean(evaluator2)) {
                                if (!this.it.hasNext()) {
                                    return false;
                                }
                                this.m = this.it.next();
                                evaluator2.setContext(this.m);
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = this.m;
                                return memberArray;
                            }
                            finally {
                                this.m = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return result;
        }
    }

    private static class ImMutableMemberArrayIterCalc
    extends BaseIterCalc {
        ImMutableMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            ArrayList<Member[]> result = new ArrayList<Member[]>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member[] member = (Member[])members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableMemberArrayIterCalc
    extends BaseIterCalc {
        MutableMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Member[] member = (Member[])it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static class IterMemberIterCalc
    extends BaseIterCalc {
        IterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            IterCalc icalc = (IterCalc)calcs[0];
            final BooleanCalc bcalc = (BooleanCalc)calcs[1];
            final Evaluator evaluator2 = evaluator.push();
            final Iterable_ iter = icalc.evaluateIterable(evaluator);
            Iterable<Member> result = new Iterable<Member>(){

                @Override
                public Iterator<Member> iterator() {
                    return new Iterator<Member>(){
                        Iterator<Member> it;
                        Member m;
                        {
                            this.it = IterableMethods.iterator((Object)iter);
                            this.m = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.m != null) {
                                return true;
                            }
                            if (!this.it.hasNext()) {
                                return false;
                            }
                            this.m = this.it.next();
                            evaluator2.setContext(this.m);
                            while (!bcalc.evaluateBoolean(evaluator2)) {
                                if (!this.it.hasNext()) {
                                    return false;
                                }
                                this.m = this.it.next();
                                evaluator2.setContext(this.m);
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member next() {
                            try {
                                Member member = this.m;
                                return member;
                            }
                            finally {
                                this.m = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return result;
        }
    }

    private static class ImMutableMemberIterCalc
    extends BaseIterCalc {
        ImMutableMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            ArrayList<Member> result = new ArrayList<Member>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member member = (Member)members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableMemberIterCalc
    extends BaseIterCalc {
        MutableMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Iterable_ makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            ListCalc lcalc = (ListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push();
            List members = lcalc.evaluateList(evaluator);
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Member member = (Member)it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static abstract class BaseIterCalc
    extends AbstractIterCalc {
        protected BaseIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        public Iterable_ evaluateIterable(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (Iterable_)nativeEvaluator.execute(ExpCompiler.ResultStyle.ITERABLE);
            }
            return this.makeIterable(evaluator);
        }

        protected abstract Iterable_ makeIterable(Evaluator var1);

        public boolean dependsOn(Dimension dimension) {
            return BaseIterCalc.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }
}

