/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.util.UnsupportedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CrossJoinFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}, class$mondrian$olap$fun$CrossJoinFunDef == null ? (class$mondrian$olap$fun$CrossJoinFunDef = CrossJoinFunDef.class$("mondrian.olap.fun.CrossJoinFunDef")) : class$mondrian$olap$fun$CrossJoinFunDef);
    static final StarCrossJoinResolver StarResolver = new StarCrossJoinResolver();
    private static final /* synthetic */ Class class$mondrian$olap$fun$CrossJoinFunDef;

    public CrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList<Type> list = new ArrayList<Type>();
        for (Exp arg : args) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw Util.newInternal("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new Type[list.size()]);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, List<Type> list) {
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            CrossJoinFunDef.addTypes(setType.getElementType(), list);
        } else if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (Type elementType : tupleType.elementTypes) {
                CrossJoinFunDef.addTypes(elementType, list);
            }
        } else {
            list.add(type);
        }
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ExpCompiler.ResultStyle[] rs;
        for (ExpCompiler.ResultStyle r : rs = compiler.getAcceptableResultStyles()) {
            switch (r) {
                case ITERABLE: 
                case ANY: {
                    return this.compileCallIterable(call, compiler);
                }
                case LIST: {
                    return this.compileCallImmutableList(call, compiler);
                }
                case MUTABLE_LIST: {
                    return this.compileCallMutableList(call, compiler);
                }
            }
        }
        throw ResultStyleException.generate(new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.ITERABLE, ExpCompiler.ResultStyle.LIST, ExpCompiler.ResultStyle.MUTABLE_LIST, ExpCompiler.ResultStyle.ANY}, rs);
    }

    protected IterCalc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc calc1 = this.toIter(compiler, call.getArg(0));
        Calc calc2 = this.toIter(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{calc1, calc2};
        CrossJoinFunDef.checkIterListResultStyles(calc1);
        CrossJoinFunDef.checkIterListResultStyles(calc2);
        if (CrossJoinFunDef.isMemberType(calc1)) {
            if (CrossJoinFunDef.isMemberType(calc2)) {
                if (calc1.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                    if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                        return new IterMemberIterMemberIterCalc(call, calcs);
                    }
                    return new IterMemberListMemberIterCalc(call, calcs);
                }
                if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                    return new ListMemberIterMemberIterCalc(call, calcs);
                }
                return new ListMemberListMemberIterCalc(call, calcs);
            }
            if (calc1.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                    return new IterMemberIterMemberArrayIterCalc(call, calcs);
                }
                return new IterMemberListMemberArrayIterCalc(call, calcs);
            }
            if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                return new ListMemberIterMemberArrayIterCalc(call, calcs);
            }
            return new ListMemberListMemberArrayIterCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(calc2)) {
            if (calc1.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                    return new IterMemberArrayIterMemberIterCalc(call, calcs);
                }
                return new IterMemberArrayListMemberIterCalc(call, calcs);
            }
            if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                return new ListMemberArrayIterMemberIterCalc(call, calcs);
            }
            return new ListMemberArrayListMemberIterCalc(call, calcs);
        }
        if (calc1.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
            if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
                return new IterMemberArrayIterMemberArrayIterCalc(call, calcs);
            }
            return new IterMemberArrayListMemberArrayIterCalc(call, calcs);
        }
        if (calc2.getResultStyle() == ExpCompiler.ResultStyle.ITERABLE) {
            return new ListMemberArrayIterMemberArrayIterCalc(call, calcs);
        }
        return new ListMemberArrayListMemberArrayIterCalc(call, calcs);
    }

    private Calc toIter(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compile(exp, ExpCompiler.ITERABLE_LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY);
        }
        return new SetFunDef.IterSetCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ExpCompiler.ITERABLE_LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY);
    }

    protected ListCalc compileCallImmutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        if (CrossJoinFunDef.isMemberType(listCalc1)) {
            if (CrossJoinFunDef.isMemberType(listCalc2)) {
                return new ImmutableListMemberListMemberListCalc(call, calcs);
            }
            return new ImmutableListMemberListMemberArrayListCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(listCalc2)) {
            return new ImmutableListMemberArrayListMemberListCalc(call, calcs);
        }
        return new ImmutableListMemberArrayListMemberArrayListCalc(call, calcs);
    }

    private ListCalc toList(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return (ListCalc)compiler.compile(exp, ExpCompiler.LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY);
        }
        return new SetFunDef.ListSetCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ExpCompiler.LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY);
    }

    protected static List nonEmptyOptimizeList(Evaluator evaluator, List list, ResolvedFunCall call) {
        if (!evaluator.isNonEmpty()) {
            return list;
        }
        int opSize = MondrianProperties.instance().CrossJoinOptimizerSize.get();
        int size = list.size();
        if (size <= opSize) {
            System.out.println(new StringBuffer().append("NO USE OPTIMIZER ").append(opSize).toString());
            return list;
        }
        System.out.println(new StringBuffer().append("USE OPTIMIZER ").append(opSize).toString());
        int puntMissCountListSize = 1000;
        int missCount = evaluator.getMissCount();
        list = CrossJoinFunDef.optimizeNonEmptyList(evaluator, list, call);
        size = list.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        int missCount2 = evaluator.getMissCount();
        if (missCount2 > missCount && size > 1000) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    protected ListCalc compileCallMutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        if (CrossJoinFunDef.isMemberType(listCalc1)) {
            if (CrossJoinFunDef.isMemberType(listCalc2)) {
                return new MutableListMemberListMemberListCalc(call, calcs);
            }
            return new MutableListMemberListMemberArrayListCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(listCalc2)) {
            return new MutableListMemberArrayListMemberListCalc(call, calcs);
        }
        return new MutableListMemberArrayListMemberArrayListCalc(call, calcs);
    }

    List crossJoin(List list1, List list2, Evaluator evaluator, ResolvedFunCall call) {
        if ((list1 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, list1, call)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if ((list2 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, list2, call)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        long size = (long)list1.size() * (long)list2.size();
        int resultLimit = MondrianProperties.instance().ResultLimit.get();
        if (resultLimit > 0 && (long)resultLimit < size) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(Autobox.valueOf((long)size), Autobox.valueOf((int)resultLimit));
        }
        if (size > Integer.MAX_VALUE) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(Autobox.valueOf((long)size), Autobox.valueOf((int)Integer.MAX_VALUE));
        }
        ArrayList<Object> result = new ArrayList<Object>((int)size);
        boolean neitherSideIsTuple = true;
        int arity0 = 1;
        int arity1 = 1;
        if (list1.get(0) instanceof Member[]) {
            arity0 = ((Member[])list1.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (list2.get(0) instanceof Member[]) {
            arity1 = ((Member[])list2.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (neitherSideIsTuple) {
            for (Member o0 : list1) {
                for (Member o1 : list2) {
                    result.add(new Member[]{o0, o1});
                }
            }
        } else {
            Member[] row = new Member[arity0 + arity1];
            int m = list1.size();
            for (int i = 0; i < m; ++i) {
                int x = 0;
                Object o0 = list1.get(i);
                if (o0 instanceof Member) {
                    row[x++] = (Member)o0;
                } else {
                    Member[] members;
                    CrossJoinFunDef.assertTrue(o0 instanceof Member[]);
                    for (Member member : members = (Member[])o0) {
                        row[x++] = member;
                    }
                }
                int n = list2.size();
                for (int j = 0; j < n; ++j) {
                    Object o1 = list2.get(j);
                    if (o1 instanceof Member) {
                        row[x++] = (Member)o1;
                    } else {
                        Member[] members;
                        CrossJoinFunDef.assertTrue(o1 instanceof Member[]);
                        for (Member member : members = (Member[])o1) {
                            row[x++] = member;
                        }
                    }
                    result.add(row.clone());
                    x = arity0;
                }
            }
        }
        return result;
    }

    protected static List optimizeNonEmptyList(Evaluator evaluator, List list, ResolvedFunCall call) {
        Object value;
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 2 >> 1);
        Query query = evaluator.getQuery();
        Set<Member> measureSet = null;
        Set<Member> queryMeasureSet = query.getMeasuresMembers();
        if (queryMeasureSet.size() > 0) {
            MeasureVisitor visitor = new MeasureVisitor(queryMeasureSet, call);
            QueryAxis[] axes = query.getAxes();
            QueryAxis slicerAxis = query.getSlicerAxis();
            if (slicerAxis != null) {
                slicerAxis.accept(visitor);
            }
            if (visitor.measureSet != null) {
                measureSet = visitor.measureSet;
            } else if (axes.length > 0) {
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i] == null) continue;
                    axes[i].accept(visitor);
                }
                measureSet = visitor.measureSet;
            }
        }
        evaluator = evaluator.push();
        if (list.get(0) instanceof Member[]) {
            block1: for (Member[] ms : list) {
                evaluator.setContext(ms);
                if (measureSet == null) {
                    value = evaluator.evaluateCurrent();
                    if (value == null || value instanceof Throwable) continue;
                    result.add(ms);
                    continue;
                }
                for (Member measure : measureSet) {
                    evaluator.setContext(measure);
                    Object value2 = evaluator.evaluateCurrent();
                    if (value2 == null || value2 instanceof Throwable) continue;
                    result.add(ms);
                    continue block1;
                }
            }
        } else {
            block3: for (Member m : list) {
                evaluator.setContext(m);
                if (measureSet == null) {
                    value = evaluator.evaluateCurrent();
                    if (value == null || value instanceof Throwable) continue;
                    result.add(m);
                    continue;
                }
                for (Member measure : measureSet) {
                    evaluator.setContext(measure);
                    Object value3 = evaluator.evaluateCurrent();
                    if (value3 == null || value3 instanceof Throwable) continue;
                    result.add(m);
                    continue block3;
                }
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class StarCrossJoinResolver
    extends MultiResolver {
        public StarCrossJoinResolver() {
            super("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"});
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (validator.requiresExpression()) {
                return null;
            }
            return super.resolve(args, validator, conversionCount);
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new CrossJoinFunDef(dummyFunDef);
        }
    }

    private static class ResolvedFunCallFinder
    extends MdxVisitorImpl {
        private ResolvedFunCall call;
        public boolean found;

        public ResolvedFunCallFinder(ResolvedFunCall call) {
            this.call = call;
            this.found = false;
        }

        public Object visit(ResolvedFunCall funCall) {
            if (funCall == this.call) {
                this.found = true;
            }
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            if (member.isCalculated()) {
                Exp memberExp = member.getExpression();
                memberExp.accept(this);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MeasureVisitor
    extends MdxVisitorImpl {
        Set<Member> measureSet;
        Set<Member> queryMeasureSet;
        ResolvedFunCall crossJoinCall;

        MeasureVisitor(Set<Member> queryMeasureSet, ResolvedFunCall crossJoinCall) {
            this.queryMeasureSet = queryMeasureSet;
            this.crossJoinCall = crossJoinCall;
        }

        @Override
        public Object visit(ParameterExpr parameterExpr) {
            Object value;
            Parameter parameter = parameterExpr.getParameter();
            Type type = parameter.getType();
            if (type instanceof MemberType && (value = parameter.getValue()) instanceof Member) {
                Member member = (Member)value;
                this.process(member);
            }
            return null;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.process(member);
            return null;
        }

        private void process(Member member) {
            for (Member measure : this.queryMeasureSet) {
                if (!measure.equals(member) || !this.validMeasure(measure)) continue;
                if (this.measureSet == null) {
                    this.measureSet = new HashSet<Member>();
                }
                this.measureSet.add(measure);
                break;
            }
        }

        private boolean validMeasure(Member measure) {
            if (measure.isCalculated()) {
                Exp measureExp = measure.getExpression();
                ResolvedFunCallFinder finder = new ResolvedFunCallFinder(this.crossJoinCall);
                measureExp.accept(finder);
                if (finder.found) {
                    Exp[] args = this.crossJoinCall.getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        Set<Member> measureSet = new HashSet<Member>();
                        measureSet.add(measure);
                        MeasureVisitor measureFinder = new MeasureVisitor(measureSet, null);
                        args[i].accept(measureFinder);
                        measureSet = measureFinder.measureSet;
                        if (measureSet == null || measureSet.size() <= 0) continue;
                        throw FunUtil.newEvalException(null, new StringBuffer().append("Infinite loop detected in ").append(this.crossJoinCall.toString()).toString());
                    }
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MutableListMemberArrayListMemberArrayListCalc
    extends BaseListCalc {
        MutableListMemberArrayListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List l1, List l2) {
            int size1 = l1.size();
            int len1 = ((Member[])l1.get(0)).length;
            int size2 = l2.size();
            int len2 = ((Member[])l2.get(0)).length;
            int totalLen = len1 + len2;
            int arraySize = totalLen * (size1 * size2);
            Member[] members = new Member[arraySize];
            for (int i = 0; i < size1; ++i) {
                Member[] ma1 = (Member[])l1.get(i);
                int ii = i * size2;
                for (int j = 0; j < size2; ++j) {
                    for (int k = 0; k < len1; ++k) {
                        Member m1;
                        members[totalLen * (ii + j) + k] = m1 = ma1[k];
                    }
                    Member[] ma2 = (Member[])l2.get(j);
                    for (int k = 0; k < len2; ++k) {
                        Member m2;
                        members[totalLen * (ii + j) + len1 + k] = m2 = ma2[k];
                    }
                }
            }
            return this.makeList(members, totalLen);
        }

        protected List<Member[]> makeList(Member[] members, final int totalLen) {
            BaseMutableList list = new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.length / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int i = totalLen * index;
                    Member[] ma = new Member[totalLen];
                    System.arraycopy(this.members, i, ma, 0, totalLen);
                    return ma;
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(element, 0, this.members, i, totalLen);
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(this.members, i + totalLen, this.members, i, this.members.length - (i + totalLen));
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    Member[] sublist = new Member[to - from];
                    System.arraycopy(this.members, from, sublist, 0, to - from);
                    return MutableListMemberArrayListMemberArrayListCalc.this.makeList(sublist, totalLen);
                }

                @Override
                public Object remove(int x0) {
                    return this.remove(x0);
                }

                @Override
                public Object set(int x0, Object x1) {
                    return this.set(x0, (Member[])x1);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            };
            return list;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MutableListMemberArrayListMemberListCalc
    extends BaseListCalc {
        MutableListMemberArrayListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List l1, List l2) {
            int size1 = l1.size();
            int len1 = ((Member[])l1.get(0)).length;
            int size2 = l2.size();
            int totalLen = 1 + len1;
            int arraySize = totalLen * (size1 * size2);
            Member[] members = new Member[arraySize];
            for (int i = 0; i < size1; ++i) {
                Member[] ma1 = (Member[])l1.get(i);
                int ii = i * size2;
                for (int j = 0; j < size2; ++j) {
                    Member m2;
                    for (int k = 0; k < len1; ++k) {
                        Member m1;
                        members[totalLen * (ii + j) + k] = m1 = ma1[k];
                    }
                    members[totalLen * (ii + j) + len1] = m2 = (Member)l2.get(j);
                }
            }
            return this.makeList(members, totalLen);
        }

        protected List<Member[]> makeList(Member[] members, final int totalLen) {
            BaseMutableList list = new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.length / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int i = totalLen * index;
                    Member[] ma = new Member[totalLen];
                    System.arraycopy(this.members, i, ma, 0, totalLen);
                    return ma;
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(element, 0, this.members, i, totalLen);
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(this.members, i + totalLen, this.members, i, this.members.length - (i + totalLen));
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    Member[] sublist = new Member[to - from];
                    System.arraycopy(this.members, from, sublist, 0, to - from);
                    return MutableListMemberArrayListMemberListCalc.this.makeList(sublist, totalLen);
                }

                @Override
                public Object remove(int x0) {
                    return this.remove(x0);
                }

                @Override
                public Object set(int x0, Object x1) {
                    return this.set(x0, (Member[])x1);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            };
            return list;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MutableListMemberListMemberArrayListCalc
    extends BaseListCalc {
        MutableListMemberListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List l1, List l2) {
            int size1 = l1.size();
            int size2 = l2.size();
            int len2 = ((Member[])l2.get(0)).length;
            int totalLen = 1 + len2;
            int arraySize = totalLen * (size1 * size2);
            Member[] members = new Member[arraySize];
            for (int i = 0; i < size1; ++i) {
                Member m1 = (Member)l1.get(i);
                int ii = i * size2;
                for (int j = 0; j < size2; ++j) {
                    Member[] ma2 = (Member[])l2.get(j);
                    members[totalLen * (ii + j)] = m1;
                    for (int k = 0; k < len2; ++k) {
                        Member m2;
                        members[totalLen * (ii + j) + k + 1] = m2 = ma2[k];
                    }
                }
            }
            return this.makeList(members, totalLen);
        }

        protected List<Member[]> makeList(Member[] members, final int totalLen) {
            BaseMutableList list = new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.length / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int i = totalLen * index;
                    Member[] ma = new Member[totalLen];
                    System.arraycopy(this.members, i, ma, 0, totalLen);
                    return ma;
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(element, 0, this.members, i, totalLen);
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int i = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    System.arraycopy(this.members, i, oldValue, 0, totalLen);
                    System.arraycopy(this.members, i + totalLen, this.members, i, this.members.length - (i + totalLen));
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    Member[] sublist = new Member[to - from];
                    System.arraycopy(this.members, from, sublist, 0, to - from);
                    return MutableListMemberListMemberArrayListCalc.this.makeList(sublist, totalLen);
                }

                @Override
                public Object remove(int x0) {
                    return this.remove(x0);
                }

                @Override
                public Object set(int x0, Object x1) {
                    return this.set(x0, (Member[])x1);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            };
            return list;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MutableListMemberListMemberListCalc
    extends BaseListCalc {
        MutableListMemberListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List l1, List l2) {
            int size1 = l1.size();
            int size2 = l2.size();
            int arraySize = 2 * (size1 * size2);
            Member[] members = new Member[arraySize];
            for (int i = 0; i < size1; ++i) {
                Member m1 = (Member)l1.get(i);
                int ii = i * size2;
                for (int j = 0; j < size2; ++j) {
                    Member m2 = (Member)l2.get(j);
                    members[2 * (ii + j)] = m1;
                    members[2 * (ii + j) + 1] = m2;
                }
            }
            return this.makeList(members);
        }

        protected List<Member[]> makeList(Member[] members) {
            BaseMutableList list = new BaseMutableList(members){
                int size;
                {
                    this.size = this.members.length / 2;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index + index;
                    return new Member[]{this.members[i], this.members[i + 1]};
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int i = index + index;
                    Member[] oldValue = new Member[]{this.members[i], this.members[i + 1]};
                    this.members[i] = element[0];
                    this.members[i + 1] = element[1];
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int i = index + index;
                    Member[] oldValue = new Member[]{this.members[i], this.members[i + 1]};
                    System.arraycopy(this.members, i + 2, this.members, i, this.members.length - (i + 2));
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = fromIndex + fromIndex;
                    int to = toIndex + toIndex;
                    Member[] sublist = new Member[to - from];
                    System.arraycopy(this.members, from, sublist, 0, to - from);
                    return MutableListMemberListMemberListCalc.this.makeList(sublist);
                }

                @Override
                public Object remove(int x0) {
                    return this.remove(x0);
                }

                @Override
                public Object set(int x0, Object x1) {
                    return this.set(x0, (Member[])x1);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            };
            return list;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static abstract class BaseMutableList
    extends UnsupportedList<Member[]> {
        protected final Member[] members;

        protected BaseMutableList(Member[] members) {
            this.members = members;
        }

        @Override
        public abstract int size();

        @Override
        public abstract Member[] get(int var1);

        @Override
        public abstract Member[] set(int var1, Member[] var2);

        @Override
        public abstract Member[] remove(int var1);

        @Override
        public abstract List<Member[]> subList(int var1, int var2);

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        public List<Member[]> toArrayList() {
            ArrayList<Member[]> l = new ArrayList<Member[]>(this.size());
            Iterator<Member[]> i = this.iterator();
            while (i.hasNext()) {
                l.add(i.next());
            }
            return l;
        }

        @Override
        public ListIterator<Member[]> listIterator() {
            return new LocalListItr(0);
        }

        @Override
        public ListIterator<Member[]> listIterator(int index) {
            return new LocalListItr(index);
        }

        @Override
        public Iterator<Member[]> iterator() {
            return new LocalItr();
        }

        @Override
        public Object remove(int x0) {
            return this.remove(x0);
        }

        @Override
        public Object set(int x0, Object x1) {
            return this.set(x0, (Member[])x1);
        }

        @Override
        public Object get(int x0) {
            return this.get(x0);
        }

        private class LocalListItr
        extends UnsupportedList.ListItr {
            public LocalListItr(int index) {
                super(BaseMutableList.this, index);
            }

            public void set(Member[] o) {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                try {
                    BaseMutableList.this.set(this.lastRet, o);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void set(Object x0) {
                this.set((Member[])x0);
            }
        }

        private class LocalItr
        extends UnsupportedList.Itr {
            public LocalItr() {
                super(BaseMutableList.this);
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                try {
                    BaseMutableList.this.remove(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImmutableListMemberArrayListMemberArrayListCalc
    extends BaseListCalc {
        ImmutableListMemberArrayListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len1 = ((Member[])l1.get(0)).length;
            final int len2 = ((Member[])l2.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             * Duplicate member names - consider using --renamedupmembers true
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[len1 + len2];
                    Member[] ma1 = (Member[])l1.get(i);
                    Member[] ma2 = (Member[])l2.get(j);
                    System.arraycopy(ma1, 0, ma, 0, len1);
                    System.arraycopy(ma2, 0, ma, len1, len2);
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
                     * Duplicate member names - consider using --renamedupmembers true
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len2;
                        final /* synthetic */ int val$len1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len2 = n;
                            this.val$len1 = n2;
                            this.val$l2 = list2;
                            this.val$size = n3;
                            super(ImmutableListMemberArrayListMemberArrayListCalc.this, n3, list2, n2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }

                        @Override
                        public Object get(int x0) {
                            return this.get(x0);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImmutableListMemberArrayListMemberListCalc
    extends BaseListCalc {
        ImmutableListMemberArrayListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len1 = ((Member[])l1.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             * Duplicate member names - consider using --renamedupmembers true
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[len1 + 1];
                    Member[] ma1 = (Member[])l1.get(i);
                    Member m2 = (Member)l2.get(j);
                    System.arraycopy(ma1, 0, ma, 0, len1);
                    ma[len1] = m2;
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
                     * Duplicate member names - consider using --renamedupmembers true
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len1 = n;
                            this.val$l2 = list2;
                            this.val$size = n2;
                            super(ImmutableListMemberArrayListMemberListCalc.this, n2, list2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }

                        @Override
                        public Object get(int x0) {
                            return this.get(x0);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImmutableListMemberListMemberArrayListCalc
    extends BaseListCalc {
        ImmutableListMemberListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len2 = ((Member[])l2.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             * Duplicate member names - consider using --renamedupmembers true
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[1 + len2];
                    Member m1 = (Member)l1.get(i);
                    Member[] ma2 = (Member[])l2.get(j);
                    ma[0] = m1;
                    System.arraycopy(ma2, 0, ma, 1, len2);
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
                     * Duplicate member names - consider using --renamedupmembers true
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len2;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len2 = n;
                            this.val$l2 = list2;
                            this.val$size = n2;
                            super(ImmutableListMemberListMemberArrayListCalc.this, n2, list2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }

                        @Override
                        public Object get(int x0) {
                            return this.get(x0);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImmutableListMemberListMemberListCalc
    extends BaseListCalc {
        ImmutableListMemberListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             * Duplicate member names - consider using --renamedupmembers true
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member m1 = (Member)l1.get(i);
                    Member m2 = (Member)l2.get(j);
                    return new Member[]{m1, m2};
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
                     * Duplicate member names - consider using --renamedupmembers true
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$l2 = list2;
                            this.val$size = n;
                            super(ImmutableListMemberListMemberListCalc.this, n, list2, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }

                        @Override
                        public Object get(int x0) {
                            return this.get(x0);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }

                @Override
                public Object get(int x0) {
                    return this.get(x0);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static abstract class BaseImmutableList
    extends UnsupportedList<Member[]> {
        protected BaseImmutableList() {
        }

        @Override
        public abstract int size();

        @Override
        public abstract Member[] get(int var1);

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        public List<Member[]> toArrayList() {
            ArrayList<Member[]> l = new ArrayList<Member[]>(this.size());
            Iterator<Member[]> i = this.iterator();
            while (i.hasNext()) {
                l.add(i.next());
            }
            return l;
        }

        @Override
        public ListIterator<Member[]> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Member[]> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Member[]> iterator() {
            return new UnsupportedList.Itr(this);
        }

        @Override
        public Object get(int x0) {
            return this.get(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseListCalc
    extends AbstractListCalc {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$olap$fun$CrossJoinFunDef;

        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs, boolean mutable) {
            super(call, calcs, mutable);
        }

        @Override
        public List<Member[]> evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (List)nativeEvaluator.execute(ExpCompiler.ResultStyle.LIST);
            }
            Calc[] calcs = this.getCalcs();
            ListCalc listCalc1 = (ListCalc)calcs[0];
            ListCalc listCalc2 = (ListCalc)calcs[1];
            Evaluator oldEval = null;
            if (!$assertionsDisabled && (oldEval = evaluator.push()) == null) {
                throw new AssertionError();
            }
            List l1 = listCalc1.evaluateList(evaluator);
            if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                throw new AssertionError((Object)"listCalc1 changed context");
            }
            List l2 = listCalc2.evaluateList(evaluator);
            if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                throw new AssertionError((Object)"listCalc2 changed context");
            }
            if ((l1 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if ((l2 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return this.makeList(l1, l2);
        }

        protected abstract List<Member[]> makeList(List var1, List var2);

        static {
            $assertionsDisabled = !(class$mondrian$olap$fun$CrossJoinFunDef == null ? (class$mondrian$olap$fun$CrossJoinFunDef = BaseListCalc.class$("mondrian.olap.fun.CrossJoinFunDef")) : class$mondrian$olap$fun$CrossJoinFunDef).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberArrayListMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        ListMemberArrayListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, (Iterable_)l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList((Iterable_)l1, l2);
            }
            return this.makeIterableIterable((Iterable_)l1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberArrayIterMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        ListMemberArrayIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable_ it2 = (Iterable_)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable((Iterable_)l1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberArrayListMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        IterMemberArrayListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberArrayIterMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        IterMemberArrayIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            Iterable_ it2 = (Iterable_)o2;
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberArrayListMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        ListMemberArrayListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, (Iterable_)l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList((Iterable_)l1, l2);
            }
            return this.makeIterableIterable((Iterable_)l1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberArrayIterMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        ListMemberArrayIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable_ it2 = (Iterable_)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable((Iterable_)l1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberArrayListMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        IterMemberArrayListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberArrayIterMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        IterMemberArrayIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            Iterable_ it2 = (Iterable_)o2;
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberListMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        ListMemberListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, (Iterable_)l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList((Iterable_)l1, l2);
            }
            return this.makeIterableIterable((Iterable_)l1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberIterMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        ListMemberIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable_ it2 = (Iterable_)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable((Iterable_)l1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberListMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        IterMemberListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberIterMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        IterMemberIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            Iterable_ it2 = (Iterable_)o2;
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberListMemberIterCalc
    extends BaseMemberMemberIterCalc {
        ListMemberListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, (Iterable_)l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList((Iterable_)l1, l2);
            }
            return this.makeIterableIterable((Iterable_)l1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListMemberIterMemberIterCalc
    extends BaseMemberMemberIterCalc {
        ListMemberIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable_ it2 = (Iterable_)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable((Iterable_)l1, it2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberListMemberIterCalc
    extends BaseMemberMemberIterCalc {
        IterMemberListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, (Iterable_)l2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IterMemberIterMemberIterCalc
    extends BaseMemberMemberIterCalc {
        IterMemberIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable_ it1 = (Iterable_)o1;
            Iterable_ it2 = (Iterable_)o2;
            return this.makeIterableIterable(it1, it2);
        }
    }

    static abstract class BaseMemberArrayMemberArrayIterCalc
    extends BaseIterCalc {
        BaseMemberArrayMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member[] ma1 = (Member[])o1;
            Member[] ma2 = (Member[])o2;
            Member[] ma = new Member[ma1.length + ma2.length];
            System.arraycopy(ma1, 0, ma, 0, ma1.length);
            System.arraycopy(ma2, 0, ma, ma1.length, ma2.length);
            return ma;
        }
    }

    static abstract class BaseMemberArrayMemberIterCalc
    extends BaseIterCalc {
        BaseMemberArrayMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member[] ma1 = (Member[])o1;
            Member m2 = (Member)o2;
            Member[] ma = new Member[ma1.length + 1];
            System.arraycopy(ma1, 0, ma, 0, ma1.length);
            ma[ma1.length] = m2;
            return ma;
        }
    }

    static abstract class BaseMemberMemberArrayIterCalc
    extends BaseIterCalc {
        BaseMemberMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member m1 = (Member)o1;
            Member[] ma2 = (Member[])o2;
            Member[] ma = new Member[ma2.length + 1];
            ma[0] = m1;
            System.arraycopy(ma2, 0, ma, 1, ma2.length);
            return ma;
        }
    }

    static abstract class BaseMemberMemberIterCalc
    extends BaseIterCalc {
        BaseMemberMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            return new Member[]{(Member)o1, (Member)o2};
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseIterCalc
    extends AbstractIterCalc {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$olap$fun$CrossJoinFunDef;

        protected BaseIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public Iterable_ evaluateIterable(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (Iterable_)nativeEvaluator.execute(ExpCompiler.ResultStyle.ITERABLE);
            }
            Calc[] calcs = this.getCalcs();
            Calc calc1 = calcs[0];
            Calc calc2 = calcs[1];
            Evaluator oldEval = null;
            if (!$assertionsDisabled && (oldEval = evaluator.push()) == null) {
                throw new AssertionError();
            }
            Object o1 = calc1.evaluate(evaluator);
            if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                throw new AssertionError((Object)"calc1 changed context");
            }
            if (o1 instanceof List) {
                List l1 = (List)o1;
                if ((l1 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                o1 = l1;
            }
            Object o2 = calc2.evaluate(evaluator);
            if (!$assertionsDisabled && !oldEval.equals(evaluator)) {
                throw new AssertionError((Object)"calc2 changed context");
            }
            if (o2 instanceof List) {
                List l2 = (List)o2;
                if ((l2 = CrossJoinFunDef.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                o2 = l2;
            }
            return this.makeIterable(o1, o2);
        }

        protected abstract Iterable<Member[]> makeIterable(Object var1, Object var2);

        protected abstract Member[] makeNext(Object var1, Object var2);

        protected Iterable<Member[]> makeIterableIterable(final Iterable_ it1, final Iterable_ it2) {
            Iterable<Member[]> iterable = new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator i1;
                        Object o1;
                        Iterator i2;
                        Object o2;
                        {
                            this.i1 = IterableMethods.iterator((Object)it1);
                            this.o1 = null;
                            this.i2 = IterableMethods.iterator((Object)it2);
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.i2 = IterableMethods.iterator((Object)it2);
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (!this.i1.hasNext()) {
                                    return false;
                                }
                                this.o1 = this.i1.next();
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (!this.i2.hasNext()) {
                                    return false;
                                }
                                this.o2 = this.i2.next();
                            }
                            return true;
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return iterable;
        }

        protected Iterable<Member[]> makeIterableList(final Iterable_ it1, final List l2) {
            Iterable<Member[]> iterable = new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator i1;
                        Object o1;
                        int index2;
                        Object o2;
                        {
                            this.i1 = IterableMethods.iterator((Object)it1);
                            this.o1 = null;
                            this.index2 = 0;
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.index2 = 0;
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (!this.i1.hasNext()) {
                                    return false;
                                }
                                this.o1 = this.i1.next();
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (this.index2 == l2.size()) {
                                    return false;
                                }
                                this.o2 = l2.get(this.index2++);
                            }
                            return true;
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return iterable;
        }

        protected Iterable<Member[]> makeListIterable(final List l1, final Iterable_ it2) {
            Iterable<Member[]> iterable = new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        int index1 = 0;
                        Object o1 = null;
                        Iterator i2;
                        Object o2;
                        {
                            this.i2 = IterableMethods.iterator((Object)it2);
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.i2 = IterableMethods.iterator((Object)it2);
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (this.index1 == l1.size()) {
                                    return false;
                                }
                                this.o1 = l1.get(this.index1++);
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (!this.i2.hasNext()) {
                                    return false;
                                }
                                this.o2 = this.i2.next();
                            }
                            return true;
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return iterable;
        }

        protected Iterable<Member[]> makeListList(final List l1, final List l2) {
            Iterable<Member[]> iterable = new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        int index1 = 0;
                        Object o1 = null;
                        int index2 = 0;
                        Object o2 = null;

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.index2 = 0;
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (this.index1 == l1.size()) {
                                    return false;
                                }
                                this.o1 = l1.get(this.index1++);
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (this.index2 == l2.size()) {
                                    return false;
                                }
                                this.o2 = l2.get(this.index2++);
                            }
                            return true;
                        }

                        @Override
                        public Object next() {
                            return this.next();
                        }
                    };
                }
            };
            return iterable;
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$fun$CrossJoinFunDef == null ? (class$mondrian$olap$fun$CrossJoinFunDef = BaseIterCalc.class$("mondrian.olap.fun.CrossJoinFunDef")) : class$mondrian$olap$fun$CrossJoinFunDef).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

