/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class CastFunDef
extends FunDefBase {
    static final ResolverBase Resolver = new ResolverImpl();

    private CastFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final Type targetType = call.getType();
        Exp arg = call.getArg(0);
        final Calc calc = compiler.compileScalar(arg, false);
        return new GenericCalc(arg){

            public Calc[] getCalcs() {
                return new Calc[]{calc};
            }

            public Object evaluate(Evaluator evaluator) {
                return calc.evaluate(evaluator);
            }

            public String evaluateString(Evaluator evaluator) {
                Object o = this.evaluate(evaluator);
                if (o == null) {
                    return null;
                }
                return String.valueOf(o);
            }

            public int evaluateInteger(Evaluator evaluator) {
                Object o = this.evaluate(evaluator);
                if (o == null) {
                    return -2147483647;
                }
                if (o instanceof String) {
                    return Integer.parseInt((String)o);
                }
                if (o instanceof Number) {
                    return ((Number)o).intValue();
                }
                throw this.cannotConvert(o);
            }

            public double evaluateDouble(Evaluator evaluator) {
                Object o = this.evaluate(evaluator);
                if (o == null) {
                    return 1.2345E-8;
                }
                if (o instanceof String) {
                    return Double.valueOf((String)o);
                }
                if (o instanceof Number) {
                    return ((Number)o).doubleValue();
                }
                throw this.cannotConvert(o);
            }

            public boolean evaluateBoolean(Evaluator evaluator) {
                Object o = this.evaluate(evaluator);
                if (o == null) {
                    return false;
                }
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                if (o instanceof String) {
                    return Boolean.valueOf((String)o);
                }
                throw this.cannotConvert(o);
            }

            private RuntimeException cannotConvert(Object o) {
                return Util.newInternal("cannot convert value '" + o + "' to targetType '" + targetType + "'");
            }
        };
    }

    CastFunDef(FunDef x0, 1 x1) {
        this(x0);
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("Cast", "Cast(<Expression> AS <Type>)", "Converts values to another type.", Syntax.Cast);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            int returnCategory;
            if (args.length != 2) {
                return null;
            }
            if (!(args[1] instanceof Literal)) {
                return null;
            }
            Literal literal = (Literal)args[1];
            String typeName = (String)literal.getValue();
            if (typeName.equalsIgnoreCase("String")) {
                returnCategory = 9;
            } else if (typeName.equalsIgnoreCase("Numeric")) {
                returnCategory = 7;
            } else if (typeName.equalsIgnoreCase("Boolean")) {
                returnCategory = 5;
            } else if (typeName.equalsIgnoreCase("Integer")) {
                returnCategory = 15;
            } else {
                throw MondrianResource.instance().CastInvalidType.ex(typeName);
            }
            FunDef dummyFunDef = ResolverImpl.createDummyFunDef(this, returnCategory, args);
            return new CastFunDef(dummyFunDef, null);
        }
    }
}

