/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddCalculatedMembersFunDef
extends FunDefBase {
    private static final AddCalculatedMembersFunDef instance = new AddCalculatedMembersFunDef();
    public static final Resolver resolver = new ResolverImpl();
    private static final String FLAG = "fxx";

    private AddCalculatedMembersFunDef() {
        super("AddCalculatedMembers", "AddCalculatedMembers(<Set>)", "Adds calculated members to a set.", FLAG);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public List evaluateList(Evaluator evaluator) {
                List list = listCalc.evaluateList(evaluator);
                return AddCalculatedMembersFunDef.access$000(AddCalculatedMembersFunDef.this, list, evaluator);
            }
        };
    }

    private List<Member> addCalculatedMembers(List<Member> memberList, Evaluator evaluator) {
        HashMap levelMap = new HashMap();
        Dimension dim = null;
        for (Member member : memberList) {
            if (dim == null) {
                dim = member.getDimension();
            } else if (dim != member.getDimension()) {
                throw AddCalculatedMembersFunDef.newEvalException(this, new StringBuffer().append("Only members from the same dimension are allowed in the AddCalculatedMembers set: ").append(dim.toString()).append(" vs ").append(member.getDimension().toString()).toString());
            }
            if (levelMap.containsKey(member.getLevel())) continue;
            levelMap.put(member.getLevel(), null);
        }
        ArrayList<Member> workingList = new ArrayList<Member>(memberList);
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        for (Level level : levelMap.keySet()) {
            List<Member> calcMemberList = schemaReader.getCalculatedMembers(level);
            workingList.addAll(calcMemberList);
        }
        memberList = workingList;
        return memberList;
    }

    static List access$000(AddCalculatedMembersFunDef x0, List x1, Evaluator x2) {
        return x0.addCalculatedMembers(x1, x2);
    }

    static AddCalculatedMembersFunDef access$100() {
        return instance;
    }

    private static class ResolverImpl
    extends MultiResolver {
        public ResolverImpl() {
            super(AddCalculatedMembersFunDef.access$100().getName(), AddCalculatedMembersFunDef.access$100().getSignature(), AddCalculatedMembersFunDef.access$100().getDescription(), new String[]{AddCalculatedMembersFunDef.FLAG});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            Exp arg;
            Type type1;
            if (args.length == 1 && (type1 = (arg = args[0]).getType()) instanceof SetType) {
                SetType type = (SetType)type1;
                if (type.getElementType() instanceof MemberType) {
                    return AddCalculatedMembersFunDef.access$100();
                }
                throw ResolverImpl.newEvalException(AddCalculatedMembersFunDef.access$100(), "Only single dimension members allowed in set for AddCalculatedMembers");
            }
            return null;
        }
    }
}

