/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Enum_;
import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.Util;

/*
 * Signature claims super is java.lang.Enum<mondrian.olap.Syntax>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Syntax
extends Enum_ {
    public static final /* enum */ Syntax Function = new Syntax("Function", 0){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, fun + "(", ", ", ")");
        }
    };
    public static final /* enum */ Syntax Property = new Syntax("Property", 1){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.access$100(argTypes[0]) + "." + name;
        }
    };
    public static final /* enum */ Syntax Method = new Syntax("Method", 2){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
            pw.print("(");
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    pw.print(", ");
                }
                args[i].unparse(pw);
            }
            pw.print(")");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return (returnType == 0 ? "" : Syntax.access$100(returnType) + " ") + Syntax.access$100(argTypes[0]) + "." + name + "(" + Syntax.access$200(argTypes, 1) + ")";
        }
    };
    public static final /* enum */ Syntax Infix = new Syntax("Infix", 3){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.access$300(args)) {
                ExpBase.unparseList(pw, args, "(", " " + fun + " ", ")");
            } else {
                ExpBase.unparseList(pw, args, "", " " + fun + " ", "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.access$100(argTypes[0]) + " " + name + " " + Syntax.access$100(argTypes[1]);
        }
    };
    public static final /* enum */ Syntax Prefix = new Syntax("Prefix", 4){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.access$300(args)) {
                ExpBase.unparseList(pw, args, "(" + fun + " ", null, ")");
            } else {
                ExpBase.unparseList(pw, args, fun + " ", null, "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return name + " " + Syntax.access$100(argTypes[0]);
        }
    };
    public static final /* enum */ Syntax Postfix = new Syntax("Postfix", 5){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.access$300(args)) {
                ExpBase.unparseList(pw, args, "(", null, " " + fun + ")");
            } else {
                ExpBase.unparseList(pw, args, "", null, " " + fun);
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.access$100(argTypes[0]) + " " + name;
        }
    };
    public static final /* enum */ Syntax Braces = new Syntax("Braces", 6){

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "{" + Syntax.access$200(argTypes, 0) + "}";
        }

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "{", ", ", "}");
        }
    };
    public static final /* enum */ Syntax Parentheses = new Syntax("Parentheses", 7){

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "(" + Syntax.access$200(argTypes, 0) + ")";
        }

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "(", ", ", ")");
        }
    };
    public static final /* enum */ Syntax Case = new Syntax("Case", 8){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (fun.equals("_CaseTest")) {
                pw.print("CASE");
                int j = 0;
                int clauseCount = (args.length - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            } else {
                Util.assertTrue(fun.equals("_CaseMatch"));
                pw.print("CASE ");
                int j = 0;
                args[j++].unparse(pw);
                int clauseCount = (args.length - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            String s = Syntax.access$100(argTypes[0]);
            if (argTypes[0] == 5) {
                return "CASE WHEN " + s + " THEN <Expression> ... END";
            }
            return "CASE " + s + " WHEN " + s + " THEN <Expression> ... END";
        }
    };
    public static final /* enum */ Syntax Internal = new Syntax("Internal", 9);
    public static final /* enum */ Syntax Cast = new Syntax("Cast", 10){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            pw.print("CAST(");
            args[0].unparse(pw);
            pw.print(" AS ");
            args[1].unparse(pw);
            pw.print(")");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "CAST(<Expression> AS <Type>)";
        }
    };
    public static final /* enum */ Syntax QuotedProperty = new Syntax("QuotedProperty", 11);
    public static final /* enum */ Syntax AmpersandQuotedProperty = new Syntax("AmpersandQuotedProperty", 12);
    private static final /* synthetic */ Syntax[] $VALUES;
    private static final /* synthetic */ long serialVersionUID = 0L;
    private static final /* synthetic */ Class class$mondrian$olap$Syntax;

    public static final Syntax[] values() {
        return (Syntax[])$VALUES.clone();
    }

    public static Syntax valueOf(String name) {
        return (Syntax)Enum_.valueOf((Class)(class$mondrian$olap$Syntax == null ? (class$mondrian$olap$Syntax = Syntax.class$("mondrian.olap.Syntax")) : class$mondrian$olap$Syntax), (String)name);
    }

    private Syntax(String string, int n) {
        super(string, n);
    }

    public void unparse(String fun, Exp[] args, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }

    public String getSignature(String name, int returnType, int[] argTypes) {
        return new StringBuffer().append(returnType == 0 ? "" : new StringBuffer().append(Syntax.getTypeDescription(returnType)).append(" ").toString()).append(name).append("(").append(Syntax.getTypeDescriptionCommaList(argTypes, 0)).append(")").toString();
    }

    private static boolean needParen(Exp[] args) {
        return args.length != 1 || !(args[0] instanceof FunCall) || ((FunCall)args[0]).getSyntax() != Parentheses;
    }

    private static String getTypeDescription(int type) {
        return new StringBuffer().append("<").append(Category.instance.getDescription(type & 0x1F)).append(">").toString();
    }

    private static String getTypeDescriptionCommaList(int[] types, int start) {
        int initialSize = (types.length - start) * 16;
        StringBuffer sb = new StringBuffer(initialSize > 0 ? initialSize : 16);
        for (int i = start; i < types.length; ++i) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("<").append(Category.instance.getDescription(types[i] & 0x1F)).append(">");
        }
        return sb.toString();
    }

    Syntax(String x0, int x1, 1 x2) {
        this(x0, x1);
    }

    static String access$100(int x0) {
        return Syntax.getTypeDescription(x0);
    }

    static String access$200(int[] x0, int x1) {
        return Syntax.getTypeDescriptionCommaList(x0, x1);
    }

    static boolean access$300(Exp[] x0) {
        return Syntax.needParen(x0);
    }

    static {
        $VALUES = new Syntax[]{Function, Property, Method, Infix, Prefix, Postfix, Braces, Parentheses, Case, Internal, Cast, QuotedProperty, AmpersandQuotedProperty};
        Enum_.setEnumValues((Object[])Syntax.values(), (Class)(class$mondrian$olap$Syntax == null ? (class$mondrian$olap$Syntax = Syntax.class$("mondrian.olap.Syntax")) : class$mondrian$olap$Syntax));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

