/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Schema;
import mondrian.olap.Util;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Role {
    private boolean mutable = true;
    private final Map<Schema, Access> schemaGrants = new HashMap<Schema, Access>();
    private final Map<Cube, Access> cubeGrants = new HashMap<Cube, Access>();
    private final Map<Dimension, Access> dimensionGrants = new HashMap<Dimension, Access>();
    private final Map<Hierarchy, HierarchyAccess> hierarchyGrants = new HashMap<Hierarchy, HierarchyAccess>();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$Role;
    private static final /* synthetic */ Class class$mondrian$olap$Access;

    protected Role clone() {
        Role role = new Role();
        role.mutable = this.mutable;
        role.schemaGrants.putAll(this.schemaGrants);
        role.cubeGrants.putAll(this.cubeGrants);
        role.dimensionGrants.putAll(this.dimensionGrants);
        Iterator<Map.Entry<Hierarchy, HierarchyAccess>> i$ = this.hierarchyGrants.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Hierarchy, HierarchyAccess> entry = i$.next();
            role.hierarchyGrants.put(entry.getKey(), entry.getValue().clone());
        }
        return role;
    }

    public Role makeMutableClone() {
        Role role = this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, Access access) {
        if (!$assertionsDisabled && schema == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && access != Access.ALL && access != Access.NONE && access != Access.ALL_DIMENSIONS) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isMutable()) {
            throw new AssertionError();
        }
        this.schemaGrants.put(schema, access);
    }

    public Access getAccess(Schema schema) {
        if (!$assertionsDisabled && schema == null) {
            throw new AssertionError();
        }
        return Role.toAccess(this.schemaGrants.get(schema));
    }

    private static Access toAccess(Access access) {
        return access == null ? Access.NONE : access;
    }

    public void grant(Cube cube, Access access) {
        Util.assertPrecondition(cube != null, "cube != null");
        if (!$assertionsDisabled && access != Access.ALL && access != Access.NONE) {
            throw new AssertionError();
        }
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.cubeGrants.put(cube, access);
    }

    public Access getAccess(Cube cube) {
        if (!$assertionsDisabled && cube == null) {
            throw new AssertionError();
        }
        Access access = this.cubeGrants.get(cube);
        if (access == null) {
            access = this.schemaGrants.get(cube.getSchema());
        }
        return Role.toAccess(access);
    }

    public void grant(Dimension dimension, Access access) {
        if (!$assertionsDisabled && dimension == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && access != Access.ALL && access != Access.NONE) {
            throw new AssertionError();
        }
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.dimensionGrants.put(dimension, access);
    }

    public Access getAccess(Dimension dimension) {
        if (!$assertionsDisabled && dimension == null) {
            throw new AssertionError();
        }
        Access access = this.dimensionGrants.get(dimension);
        if (access != null) {
            return Role.toAccess(access);
        }
        Iterator<Map.Entry<Cube, Access>> i$ = this.cubeGrants.entrySet().iterator();
        while (i$.hasNext()) {
            Dimension[] dimensions;
            Map.Entry<Cube, Access> cubeGrant = i$.next();
            access = Role.toAccess(cubeGrant.getValue());
            if (access == Access.NONE) continue;
            Dimension[] arr$ = dimensions = cubeGrant.getKey().getDimensions();
            int len$ = arr$.length;
            for (int i$2 = 0; i$2 < len$; ++i$2) {
                Dimension dimension1 = arr$[i$2];
                if (dimension1 != dimension) continue;
                return access;
            }
        }
        switch (1.$SwitchMap$mondrian$olap$Access[this.getAccess(dimension.getSchema()).ordinal()]) {
            case 2: 
            case 3: {
                return Access.ALL;
            }
        }
        return Access.NONE;
    }

    public void grant(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        if (!$assertionsDisabled && access == null) {
            throw new AssertionError();
        }
        Util.assertPrecondition(access == Access.CUSTOM || topLevel == null && bottomLevel == null, "access == Access.CUSTOM) || (topLevel == null && bottomLevel == null)");
        Util.assertPrecondition(topLevel == null || topLevel.getHierarchy() == hierarchy, "topLevel == null || topLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(bottomLevel == null || bottomLevel.getHierarchy() == hierarchy, "bottomLevel == null || bottomLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.hierarchyGrants.put(hierarchy, new HierarchyAccess(hierarchy, access, topLevel, bottomLevel));
    }

    public Access getAccess(Hierarchy hierarchy) {
        if (!$assertionsDisabled && hierarchy == null) {
            throw new AssertionError();
        }
        HierarchyAccess access = this.hierarchyGrants.get(hierarchy);
        if (access != null) {
            return HierarchyAccess.access$100(access);
        }
        return this.getAccess(hierarchy.getDimension());
    }

    public HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        return this.hierarchyGrants.get(hierarchy);
    }

    public Access getAccess(Level level) {
        if (!$assertionsDisabled && level == null) {
            throw new AssertionError();
        }
        HierarchyAccess access = this.hierarchyGrants.get(level.getHierarchy());
        if (access != null) {
            if (HierarchyAccess.access$200(access) != null && level.getDepth() < HierarchyAccess.access$200(access).getDepth()) {
                return Access.NONE;
            }
            if (HierarchyAccess.access$300(access) != null && level.getDepth() > HierarchyAccess.access$300(access).getDepth()) {
                return Access.NONE;
            }
            return HierarchyAccess.access$100(access);
        }
        return this.getAccess(level.getDimension());
    }

    public void grant(Member member, Access access) {
        Util.assertPrecondition(member != null, "member != null");
        if (!$assertionsDisabled && !Util.isValid(class$mondrian$olap$Access == null ? (class$mondrian$olap$Access = Role.class$("mondrian.olap.Access")) : class$mondrian$olap$Access, access)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isMutable()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getAccess(member.getHierarchy()) != Access.CUSTOM) {
            throw new AssertionError();
        }
        HierarchyAccess hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (!$assertionsDisabled && hierarchyAccess == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && HierarchyAccess.access$100(hierarchyAccess) != Access.CUSTOM) {
            throw new AssertionError();
        }
        hierarchyAccess.grant(member, access);
    }

    public Access getAccess(Member member) {
        if (!$assertionsDisabled && member == null) {
            throw new AssertionError();
        }
        HierarchyAccess hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        return this.getAccess(member.getDimension());
    }

    public Access getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        return Access.ALL;
    }

    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != Access.NONE;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != Access.NONE;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    static Access access$000(Access x0) {
        return Role.toAccess(x0);
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$Role == null ? (class$mondrian$olap$Role = Role.class$("mondrian.olap.Role")) : class$mondrian$olap$Role).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class HierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final Access access;
        private final Level bottomLevel;
        private final Map<Member, Access> memberGrants = new HashMap<Member, Access>();
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$olap$Role;

        HierarchyAccess(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel) {
            if (!$assertionsDisabled && access == null) {
                throw new AssertionError();
            }
            this.hierarchy = hierarchy;
            this.access = access;
            this.topLevel = topLevel;
            this.bottomLevel = bottomLevel;
        }

        public HierarchyAccess clone() {
            HierarchyAccess hierarchyAccess = new HierarchyAccess(this.hierarchy, this.access, this.topLevel, this.bottomLevel);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(Member member, Access access) {
            Member m;
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator<Member> memberIter = this.memberGrants.keySet().iterator();
            while (memberIter.hasNext()) {
                Member m2 = memberIter.next();
                if (!m2.isChildOrEqualTo(member)) continue;
                memberIter.remove();
            }
            this.memberGrants.put(member, access);
            if (access == Access.NONE) {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access memberAccess = this.memberGrants.get(m);
                    if (memberAccess == null) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess == Access.CUSTOM) {
                        if (this.childGrantsExist(m)) {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue;
                        }
                    } else if (memberAccess != Access.NONE && memberAccess != Access.ALL) {
                        continue;
                    }
                    break;
                }
            } else {
                block5: for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    switch (Role.access$000(this.memberGrants.get(m))) {
                        case NONE: {
                            this.memberGrants.put(m, Access.CUSTOM);
                            continue block5;
                        }
                    }
                }
            }
        }

        private boolean childGrantsExist(Member parent) {
            for (Member member : this.memberGrants.keySet()) {
                Access access;
                if (member.getParentMember() != parent || (access = Role.access$000(this.memberGrants.get(member))) == Access.NONE) continue;
                return true;
            }
            return false;
        }

        public Access getAccess(Member member) {
            if (this.access != Access.CUSTOM) {
                return this.access;
            }
            if (this.topLevel != null && member.getLevel().getDepth() < this.topLevel.getDepth()) {
                return Access.NONE;
            }
            if (this.bottomLevel != null && member.getLevel().getDepth() > this.bottomLevel.getDepth()) {
                return Access.NONE;
            }
            for (Member m = member; m != null; m = m.getParentMember()) {
                Access memberAccess = this.memberGrants.get(m);
                if (memberAccess == null) continue;
                if (memberAccess == Access.CUSTOM && m != member) {
                    return Access.NONE;
                }
                return memberAccess;
            }
            return Access.NONE;
        }

        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        public Level getTopLevel() {
            return this.topLevel;
        }

        public Level getBottomLevel() {
            return this.bottomLevel;
        }

        public Map<Member, Access> getMemberGrants() {
            return Collections.unmodifiableMap(this.memberGrants);
        }

        public Object clone() throws CloneNotSupportedException {
            return this.clone();
        }

        static Access access$100(HierarchyAccess x0) {
            return x0.access;
        }

        static Level access$200(HierarchyAccess x0) {
            return x0.topLevel;
        }

        static Level access$300(HierarchyAccess x0) {
            return x0.bottomLevel;
        }

        static {
            $assertionsDisabled = !(class$mondrian$olap$Role == null ? (class$mondrian$olap$Role = HierarchyAccess.class$("mondrian.olap.Role")) : class$mondrian$olap$Role).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

