/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Enum_;
import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class QueryAxis
extends QueryPart {
    private boolean nonEmpty;
    private Exp exp;
    private final AxisOrdinal axisOrdinal;
    private SubtotalVisibility subtotalVisibility;
    private final Id[] dimensionProperties;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$QueryAxis;

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisDef, SubtotalVisibility subtotalVisibility, Id[] dimensionProperties) {
        if (!$assertionsDisabled && dimensionProperties == null) {
            throw new AssertionError();
        }
        this.nonEmpty = nonEmpty || MondrianProperties.instance().EnableNonEmptyOnAllAxis.get();
        this.exp = set;
        this.axisOrdinal = axisDef;
        this.subtotalVisibility = subtotalVisibility;
        this.dimensionProperties = dimensionProperties;
    }

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisDef, SubtotalVisibility subtotalVisibility) {
        this(nonEmpty, set, axisDef, subtotalVisibility, new Id[0]);
    }

    public Object clone() {
        return new QueryAxis(this.nonEmpty, this.exp.clone(), this.axisOrdinal, this.subtotalVisibility, (Id[])this.dimensionProperties.clone());
    }

    static QueryAxis[] cloneArray(QueryAxis[] a) {
        QueryAxis[] a2 = new QueryAxis[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (QueryAxis)a[i].clone();
        }
        return a2;
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        this.exp.accept(visitor);
        return o;
    }

    public Calc compile(ExpCompiler compiler, ExpCompiler.ResultStyle[] resultStyles) {
        Exp exp = this.exp;
        if (this.axisOrdinal == AxisOrdinal.SLICER) {
            exp = QueryAxis.normalizeSlicerExpression(exp);
            exp = exp.accept(compiler.getValidator());
        }
        return compiler.compile(exp, resultStyles);
    }

    private static Exp normalizeSlicerExpression(Exp exp) {
        Exp slicer = exp;
        if (slicer instanceof LevelExpr || slicer instanceof HierarchyExpr || slicer instanceof DimensionExpr) {
            slicer = new UnresolvedFunCall("DefaultMember", Syntax.Property, new Exp[]{slicer});
        }
        if (slicer != null) {
            slicer = slicer instanceof FunCall && ((FunCall)slicer).getSyntax() == Syntax.Parentheses ? new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{slicer}) : new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{new UnresolvedFunCall("()", Syntax.Parentheses, new Exp[]{slicer})});
        }
        return slicer;
    }

    public String getAxisName() {
        return this.axisOrdinal.name();
    }

    public AxisOrdinal getAxisOrdinal() {
        return this.axisOrdinal;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public Exp getSet() {
        return this.exp;
    }

    public void setSet(Exp set) {
        this.exp = set;
    }

    public void resolve(Validator validator) {
        this.exp = validator.validate(this.exp, false);
        Type type = this.exp.getType();
        if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxAxisIsNotSet.ex(this.axisOrdinal.name());
        }
    }

    public Object[] getChildren() {
        return new Object[]{this.exp};
    }

    public void unparse(PrintWriter pw) {
        if (this.nonEmpty) {
            pw.print("NON EMPTY ");
        }
        if (this.exp != null) {
            this.exp.unparse(pw);
        }
        if (this.dimensionProperties.length > 0) {
            pw.print(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimensionProperties.length; ++i) {
                Id dimensionProperty = this.dimensionProperties[i];
                if (i > 0) {
                    pw.print(", ");
                }
                dimensionProperty.unparse(pw);
            }
        }
        if (this.axisOrdinal != AxisOrdinal.SLICER) {
            pw.print(" ON " + (Object)((Object)this.axisOrdinal));
        }
    }

    public void addLevel(Level level) {
        Util.assertTrue(level != null, "addLevel needs level");
        this.exp = new UnresolvedFunCall("Crossjoin", Syntax.Function, new Exp[]{this.exp, new UnresolvedFunCall("Members", Syntax.Property, new Exp[]{new LevelExpr(level)})});
    }

    void setSubtotalVisibility(boolean bShowSubtotals) {
        this.subtotalVisibility = bShowSubtotals ? SubtotalVisibility.Show : SubtotalVisibility.Hide;
    }

    public SubtotalVisibility getSubtotalVisibility() {
        return this.subtotalVisibility;
    }

    public void resetSubtotalVisibility() {
        this.subtotalVisibility = SubtotalVisibility.Undefined;
    }

    public void validate(Validator validator) {
        if (this.axisOrdinal == AxisOrdinal.SLICER && this.exp != null) {
            this.exp = validator.validate(this.exp, false);
        }
    }

    public Id[] getDimensionProperties() {
        return this.dimensionProperties;
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$QueryAxis == null ? (class$mondrian$olap$QueryAxis = QueryAxis.class$("mondrian.olap.QueryAxis")) : class$mondrian$olap$QueryAxis).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.olap.QueryAxis$SubtotalVisibility>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SubtotalVisibility
    extends Enum_ {
        public static final /* enum */ SubtotalVisibility Undefined = new SubtotalVisibility("Undefined", 0);
        public static final /* enum */ SubtotalVisibility Hide = new SubtotalVisibility("Hide", 1);
        public static final /* enum */ SubtotalVisibility Show = new SubtotalVisibility("Show", 2);
        private static final /* synthetic */ SubtotalVisibility[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$olap$QueryAxis$SubtotalVisibility;

        public static final SubtotalVisibility[] values() {
            return (SubtotalVisibility[])$VALUES.clone();
        }

        public static SubtotalVisibility valueOf(String name) {
            return (SubtotalVisibility)Enum_.valueOf((Class)(class$mondrian$olap$QueryAxis$SubtotalVisibility == null ? (class$mondrian$olap$QueryAxis$SubtotalVisibility = SubtotalVisibility.class$("mondrian.olap.QueryAxis$SubtotalVisibility")) : class$mondrian$olap$QueryAxis$SubtotalVisibility), (String)name);
        }

        private SubtotalVisibility(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new SubtotalVisibility[]{Undefined, Hide, Show};
            Enum_.setEnumValues((Object[])SubtotalVisibility.values(), (Class)(class$mondrian$olap$QueryAxis$SubtotalVisibility == null ? (class$mondrian$olap$QueryAxis$SubtotalVisibility = SubtotalVisibility.class$("mondrian.olap.QueryAxis$SubtotalVisibility")) : class$mondrian$olap$QueryAxis$SubtotalVisibility));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

