/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    protected final String parentUniqueName;

    protected MemberBase(Member parentMember, Level level, Member.MemberType memberType) {
        this.parentMember = parentMember;
        this.level = level;
        this.parentUniqueName = parentMember == null ? null : parentMember.getUniqueName();
        this.flags = memberType.ordinal();
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.uniqueName);
    }

    public abstract String getName();

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        String caption = super.getCaption();
        return caption != null ? caption : this.getName();
    }

    public final String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public Dimension getDimension() {
        return this.level.getDimension();
    }

    public Hierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    public Level getLevel() {
        return this.level;
    }

    public final Member.MemberType getMemberType() {
        return Member.MemberType.values()[this.flags & 7];
    }

    public String getDescription() {
        return null;
    }

    public final boolean isMeasure() {
        return this.level.getHierarchy().getDimension().isMeasures();
    }

    public final boolean isAll() {
        return this.level.isAll();
    }

    public boolean isNull() {
        return false;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return this.lookupChild(schemaReader, s, MatchType.EXACT);
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, s, matchType);
    }

    public Member getParentMember() {
        if (this.parentUniqueName == null) {
            return null;
        }
        if (this.parentMember != null) {
            return this.parentMember;
        }
        boolean failIfNotFound = true;
        Hierarchy hierarchy = this.getHierarchy();
        SchemaReader schemaReader = hierarchy.getDimension().getSchema().getSchemaReader();
        String[] parentUniqueNameParts = Util.explode(this.parentUniqueName);
        this.parentMember = schemaReader.getMemberByUniqueName(parentUniqueNameParts, failIfNotFound);
        return this.parentMember;
    }

    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        String thisUniqueName = this.getUniqueName();
        if (thisUniqueName.equals(uniqueName)) {
            return true;
        }
        String parentUniqueName = this.getParentUniqueName();
        return parentUniqueName == null ? false : ((MemberBase)this.getParentMember()).isChildOrEqualTo(uniqueName);
    }

    public boolean isCalculated() {
        return this.isCalculatedInQuery() || this.getMemberType() == Member.MemberType.FORMULA;
    }

    public int getSolveOrder() {
        return -1;
    }

    public Exp getExpression() {
        return null;
    }

    public Member[] getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list.toArray(new Member[list.size()]);
    }

    public int getOrdinal() {
        return -1;
    }

    public boolean isHidden() {
        return false;
    }

    public Member getDataMember() {
        return null;
    }

    public String getPropertyFormattedValue(String propertyName) {
        return this.getPropertyValue(propertyName).toString();
    }
}

