/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Autobox;
import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Literal
extends ExpBase {
    public final int category;
    private final Object o;
    public static final Literal nullValue = new Literal(16, null);
    public static final Literal emptyString = new Literal("", false);
    public static final Literal zero = new Literal(Autobox.valueOf((int)0));
    public static final Literal one = new Literal(Autobox.valueOf((int)1));
    public static final Literal negativeOne = new Literal(Autobox.valueOf((int)-1));
    public static final Literal doubleZero = new Literal(Autobox.valueOf((double)0.0));
    public static final Literal doubleOne = new Literal(Autobox.valueOf((double)1.0));
    public static final Literal doubleNegativeOne = new Literal(Autobox.valueOf((double)-1.0));

    private Literal(int type, Object o) {
        this.category = type;
        this.o = o;
    }

    public static Literal createString(String s) {
        return s.equals("") ? emptyString : new Literal(s, false);
    }

    public static Literal createSymbol(String s) {
        return new Literal(s, true);
    }

    public static Literal create(Double d) {
        double dv = d;
        if (dv == 0.0) {
            return doubleZero;
        }
        if (dv == 1.0) {
            return doubleOne;
        }
        if (dv == -1.0) {
            return doubleNegativeOne;
        }
        return new Literal(d);
    }

    public static Literal create(Integer i) {
        switch (i) {
            case -1: {
                return negativeOne;
            }
            case 0: {
                return zero;
            }
            case 1: {
                return one;
            }
        }
        return new Literal(i);
    }

    private Literal(String s, boolean isSymbol) {
        this.o = s;
        this.category = isSymbol ? 11 : 9;
    }

    private Literal(Double d) {
        this.o = d;
        this.category = 7;
    }

    private Literal(Integer i) {
        this.o = i;
        this.category = 7;
    }

    public Literal clone() {
        return this;
    }

    public void unparse(PrintWriter pw) {
        switch (this.category) {
            case 7: 
            case 11: {
                pw.print(this.o);
                break;
            }
            case 9: {
                pw.print(Util.quoteForMdx((String)this.o));
                break;
            }
            case 16: {
                pw.print("NULL");
                break;
            }
            default: {
                throw Util.newInternal("bad literal type " + this.category);
            }
        }
    }

    public int getCategory() {
        return this.category;
    }

    public Type getType() {
        switch (this.category) {
            case 11: {
                return new SymbolType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
            case 16: {
                return new NullType();
            }
        }
        throw Category.instance.badValue(this.category);
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return new ConstantCalc(this.getType(), this.o);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public Object getValue() {
        return this.o;
    }

    public int getIntValue() {
        if (this.o instanceof Number) {
            return ((Number)this.o).intValue();
        }
        throw Util.newInternal("cannot convert " + this.o + " to int");
    }

    public Exp clone() {
        return this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

