/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Collections;
import com.rc.retroweaver.runtime.Enum_;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Id
extends ExpBase
implements Cloneable {
    private final List<Segment> segments;

    public Id(Segment segment) {
        this.segments = Collections.singletonList((Object)segment);
    }

    private Id(List<Segment> segments) {
        this.segments = segments;
    }

    @Override
    public Id clone() {
        return this;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Util.quoteMdxIdentifier(this.toStringArray());
    }

    public String[] toStringArray() {
        String[] names = new String[this.segments.size()];
        int k = 0;
        for (Segment segment : this.segments) {
            names[k++] = segment.name;
        }
        return names;
    }

    public String getElement(int i) {
        return this.segments.get((int)i).name;
    }

    public Id append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new Id(newSegments);
    }

    @Override
    public Exp accept(Validator validator) {
        if (this.segments.size() == 1) {
            Segment s = this.segments.get(0);
            if (s.quoting == Quoting.UNQUOTED && validator.getFunTable().isReserved(s.name)) {
                return Literal.createSymbol(s.name.toUpperCase());
            }
        }
        String[] names = this.toStringArray();
        Exp element = Util.lookup(validator.getQuery(), names, true);
        if (element == null) {
            return null;
        }
        return element.accept(validator);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(PrintWriter pw) {
        int k = 0;
        for (Segment s : this.segments) {
            if (k++ > 0) {
                pw.print(".");
            }
            switch (s.quoting) {
                case UNQUOTED: {
                    pw.print(s.name);
                    break;
                }
                case KEY: {
                    pw.print(new StringBuffer().append("&[").append(Util.mdxEncodeString(s.name)).append("]").toString());
                    break;
                }
                case QUOTED: {
                    pw.print(new StringBuffer().append("[").append(Util.mdxEncodeString(s.name)).append("]").toString());
                }
            }
        }
    }

    @Override
    public Exp clone() {
        return this.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    /*
     * Signature claims super is java.lang.Enum<mondrian.olap.Id$Quoting>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Quoting
    extends Enum_ {
        public static final /* enum */ Quoting UNQUOTED = new Quoting("UNQUOTED", 0);
        public static final /* enum */ Quoting QUOTED = new Quoting("QUOTED", 1);
        public static final /* enum */ Quoting KEY = new Quoting("KEY", 2);
        private static final /* synthetic */ Quoting[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$mondrian$olap$Id$Quoting;

        public static final Quoting[] values() {
            return (Quoting[])$VALUES.clone();
        }

        public static Quoting valueOf(String name) {
            return (Quoting)Enum_.valueOf((Class)(class$mondrian$olap$Id$Quoting == null ? (class$mondrian$olap$Id$Quoting = Quoting.class$("mondrian.olap.Id$Quoting")) : class$mondrian$olap$Id$Quoting), (String)name);
        }

        private Quoting(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Quoting[]{UNQUOTED, QUOTED, KEY};
            Enum_.setEnumValues((Object[])Quoting.values(), (Class)(class$mondrian$olap$Id$Quoting == null ? (class$mondrian$olap$Id$Quoting = Quoting.class$("mondrian.olap.Id$Quoting")) : class$mondrian$olap$Id$Quoting));
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    public static class Segment {
        public final String name;
        public final Quoting quoting;

        public Segment(String name, Quoting quoting) {
            this.name = name;
            this.quoting = quoting;
        }
    }
}

