/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Arrays;
import java.io.PrintWriter;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Cube;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.SchemaReader;
import mondrian.olap.SetBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class Formula
extends QueryPart {
    private final String[] names;
    private Exp exp;
    private final MemberProperty[] memberProperties;
    private final boolean isMember;
    private Member mdxMember;
    private NamedSet mdxSet;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$Formula;

    public Formula(String[] names, Exp exp) {
        this(false, names, exp, new MemberProperty[0], null, null);
        this.createElement(null);
    }

    public Formula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        this(true, names, exp, memberProperties, null, null);
    }

    private Formula(boolean isMember, String[] names, Exp exp, MemberProperty[] memberProperties, Member mdxMember, NamedSet mdxSet) {
        this.isMember = isMember;
        this.names = names;
        this.exp = exp;
        this.memberProperties = memberProperties;
        this.mdxMember = mdxMember;
        this.mdxSet = mdxSet;
        if (!$assertionsDisabled && !isMember && mdxMember != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && isMember && mdxSet != null) {
            throw new AssertionError();
        }
    }

    public Object clone() {
        return new Formula(this.isMember, this.names, this.exp.clone(), MemberProperty.cloneArray(this.memberProperties), this.mdxMember, this.mdxSet);
    }

    static Formula[] cloneArray(Formula[] x) {
        Formula[] x2 = new Formula[x.length];
        for (int i = 0; i < x.length; ++i) {
            x2[i] = (Formula)x[i].clone();
        }
        return x2;
    }

    void accept(Validator validator) {
        boolean scalar = this.isMember;
        this.exp = validator.validate(this.exp, scalar);
        String id = Util.quoteMdxIdentifier(this.names);
        Type type = this.exp.getType();
        if (this.isMember) {
            if (!TypeUtil.canEvaluate(type)) {
                throw MondrianResource.instance().MdxMemberExpIsSet.ex(this.exp.toString());
            }
        } else if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxSetExpNotSet.ex(id);
        }
        for (int i = 0; i < this.memberProperties.length; ++i) {
            validator.validate(this.memberProperties[i]);
        }
        if (this.isMember) {
            Exp formatExp = this.getFormatExp();
            if (formatExp != null) {
                this.mdxMember.setProperty(Property.FORMAT_EXP.name, formatExp);
            }
            List formatPropertyList = Arrays.asList((Object[])Property.FORMAT_PROPERTIES);
            MemberProperty[] arr$ = this.memberProperties;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Exp exp;
                MemberProperty memberProperty = arr$[i$];
                if (formatPropertyList.contains(memberProperty.getName()) || !((exp = memberProperty.getExp()) instanceof Literal)) continue;
                String value = String.valueOf(((Literal)exp).getValue());
                this.mdxMember.setProperty(memberProperty.getName(), value);
            }
        }
    }

    void createElement(Query q) {
        if (this.isMember) {
            if (this.mdxMember != null) {
                return;
            }
            OlapElement mdxElement = q.getCube();
            SchemaReader schemaReader = q.getSchemaReader(true);
            for (int i = 0; i < this.names.length; ++i) {
                Level level;
                Cube parent = mdxElement;
                if ((mdxElement = schemaReader.getElementChild(parent, this.names[i])) != null && i != this.names.length - 1) continue;
                Member parentMember = null;
                if (parent instanceof Member) {
                    parentMember = (Member)((Object)parent);
                    level = parentMember.getLevel().getChildLevel();
                } else {
                    Hierarchy hierarchy = parent.getHierarchy();
                    if (hierarchy == null) {
                        throw MondrianResource.instance().MdxCalculatedHierarchyError.ex(Util.quoteMdxIdentifier(this.names));
                    }
                    level = hierarchy.getLevels()[0];
                }
                Member mdxMember = level.getHierarchy().createMember(parentMember, level, this.names[i], this);
                mdxElement = mdxMember;
            }
            this.mdxMember = (Member)mdxElement;
        } else {
            Util.assertTrue(this.names.length == 1, "set names must not be compound");
            this.mdxSet = new SetBase(this.names[0], this.exp);
        }
    }

    public Object[] getChildren() {
        Object[] children = new Object[1 + this.memberProperties.length];
        children[0] = this.exp;
        System.arraycopy(this.memberProperties, 0, children, 1, this.memberProperties.length);
        return children;
    }

    public void unparse(PrintWriter pw) {
        if (this.isMember) {
            pw.print("member ");
            if (this.mdxMember != null) {
                pw.print(this.mdxMember.getUniqueName());
            } else {
                pw.print(Util.quoteMdxIdentifier(this.names));
            }
        } else {
            pw.print("set ");
            pw.print(Util.quoteMdxIdentifier(this.names));
        }
        pw.print(" as '");
        this.exp.unparse(pw);
        pw.print("'");
        if (this.memberProperties != null) {
            MemberProperty[] arr$ = this.memberProperties;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                MemberProperty memberProperty = arr$[i$];
                pw.print(", ");
                memberProperty.unparse(pw);
            }
        }
    }

    public boolean isMember() {
        return this.isMember;
    }

    public NamedSet getNamedSet() {
        return this.mdxSet;
    }

    String[] getNames() {
        return this.names;
    }

    public String getName() {
        return this.isMember ? this.mdxMember.getName() : this.mdxSet.getName();
    }

    public String getCaption() {
        return this.isMember ? this.mdxMember.getCaption() : this.mdxSet.getName();
    }

    void rename(String newName) {
        String oldName = this.getElement().getName();
        Util.assertTrue(this.names[this.names.length - 1].equalsIgnoreCase(oldName));
        this.names[this.names.length - 1] = newName;
        if (this.isMember) {
            this.mdxMember.setName(newName);
        } else {
            this.mdxSet.setName(newName);
        }
    }

    String getUniqueName() {
        return this.isMember ? this.mdxMember.getUniqueName() : this.mdxSet.getUniqueName();
    }

    OlapElement getElement() {
        return this.isMember ? this.mdxMember : this.mdxSet;
    }

    public Exp getExpression() {
        return this.exp;
    }

    private Exp getMemberProperty(String name) {
        return MemberProperty.get(this.memberProperties, name);
    }

    public Member getMdxMember() {
        return this.mdxMember;
    }

    public int getSolveOrder() {
        Type type;
        Exp exp = this.getMemberProperty(Property.SOLVE_ORDER.name);
        if (exp != null && (type = exp.getType()) instanceof NumericType) {
            return ((Literal)exp).getIntValue();
        }
        return 0;
    }

    private Exp getFormatExp() {
        String[] arr$ = Property.FORMAT_PROPERTIES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String prop = arr$[i$];
            Exp formatExp = this.getMemberProperty(prop);
            if (formatExp == null) continue;
            return formatExp;
        }
        Type type = this.exp.getType();
        if (type instanceof DecimalType) {
            int scale = ((DecimalType)type).getScale();
            String formatString = "#,##0";
            if (scale > 0) {
                formatString = formatString + ".";
                while (scale-- > 0) {
                    formatString = formatString + "0";
                }
            }
            return Literal.createString(formatString);
        }
        if (!this.mdxMember.isMeasure()) {
            return null;
        }
        try {
            this.exp.accept(new MdxVisitorImpl(){

                public Object visit(MemberExpr memberExpr) {
                    Exp formatExp = (Exp)memberExpr.getMember().getPropertyValue(Property.FORMAT_EXP.name);
                    if (formatExp != null) {
                        throw new FoundOne(formatExp);
                    }
                    return super.visit(memberExpr);
                }
            });
            return null;
        }
        catch (FoundOne foundOne) {
            return FoundOne.access$000(foundOne);
        }
    }

    public void compile() {
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        this.exp.accept(visitor);
        return o;
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$Formula == null ? (class$mondrian$olap$Formula = Formula.class$("mondrian.olap.Formula")) : class$mondrian$olap$Formula).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class FoundOne
    extends RuntimeException {
        private final Exp exp;

        public FoundOne(Exp exp) {
            this.exp = exp;
        }

        static Exp access$000(FoundOne x0) {
            return x0.exp;
        }
    }
}

