/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.BetterExpCompiler;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;

public class ExpCacheDescriptor {
    private final Exp exp;
    private int[] dependentDimensionOrdinals;
    private final Calc calc;

    public ExpCacheDescriptor(Exp exp, Calc calc, Evaluator evaluator) {
        this.calc = calc;
        this.exp = exp;
        this.computeDepends(calc, evaluator);
    }

    public ExpCacheDescriptor(Exp exp, Evaluator evaluator) {
        this(exp, new BetterExpCompiler(evaluator, null));
    }

    public ExpCacheDescriptor(Exp exp, ExpCompiler compiler) {
        this.exp = exp;
        this.calc = compiler.compile(exp);
        this.computeDepends(this.calc, compiler.getEvaluator());
    }

    private void computeDepends(Calc calc, Evaluator evaluator) {
        int i;
        ArrayList<Integer> ordinalList = new ArrayList<Integer>();
        Member[] members = evaluator.getMembers();
        for (i = 0; i < members.length; ++i) {
            Dimension dimension = members[i].getDimension();
            if (!calc.dependsOn(dimension)) continue;
            ordinalList.add(Autobox.valueOf((int)i));
        }
        this.dependentDimensionOrdinals = new int[ordinalList.size()];
        for (i = 0; i < this.dependentDimensionOrdinals.length; ++i) {
            this.dependentDimensionOrdinals[i] = (Integer)ordinalList.get(i);
        }
    }

    public Exp getExp() {
        return this.exp;
    }

    public Calc getCalc() {
        return this.calc;
    }

    public Object evaluate(Evaluator evaluator) {
        return this.calc.evaluate(evaluator);
    }

    public int[] getDependentDimensionOrdinals() {
        return this.dependentDimensionOrdinals;
    }
}

