/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import com.rc.retroweaver.runtime.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedValues<V extends Value>
implements Cloneable {
    private Map<String, V> valuesByName = new LinkedHashMap<String, V>();
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private Value[] ordinalToValueMap;
    private static final String[] emptyStringArray;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$olap$EnumeratedValues;

    public EnumeratedValues() {
    }

    public EnumeratedValues(V[] values) {
        for (V value : values) {
            this.register(value);
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.register(new BasicValue(names[i], i, names[i]));
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes) {
        for (int i = 0; i < names.length; ++i) {
            this.register(new BasicValue(names[i], codes[i], names[i]));
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes, String[] descriptions) {
        for (int i = 0; i < names.length; ++i) {
            this.register(new BasicValue(names[i], codes[i], descriptions[i]));
        }
        this.makeImmutable();
    }

    public EnumeratedValues(Class<? extends Enum> clazz) {
        throw new UnsupportedOperationException();
    }

    public EnumeratedValues<V> clone() {
        EnumeratedValues clone;
        try {
            clone = (EnumeratedValues)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Util.newInternal(ex, new StringBuffer().append("error while cloning ").append(this).toString());
        }
        clone.valuesByName = new HashMap<String, V>(this.valuesByName);
        clone.ordinalToValueMap = null;
        return clone;
    }

    public EnumeratedValues getMutableClone() {
        return this.clone();
    }

    public void register(V value) {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError((Object)"pre: value != null");
        }
        Util.assertPrecondition(!this.isImmutable(), "isImmutable()");
        String name = value.getName();
        Util.assertPrecondition(name != null, "value.getName() != null");
        Value old = (Value)this.valuesByName.put(name, value);
        if (old != null) {
            throw Util.newInternal(new StringBuffer().append("Enumeration already contained a value '").append(old.getName()).append("'").toString());
        }
        int ordinal = value.getOrdinal();
        this.min = Math.min(this.min, ordinal);
        this.max = Math.max(this.max, ordinal);
    }

    public void makeImmutable() {
        this.ordinalToValueMap = new Value[1 + this.max - this.min];
        for (Value value : this.valuesByName.values()) {
            int index = value.getOrdinal() - this.min;
            if (this.ordinalToValueMap[index] != null) {
                throw Util.newInternal(new StringBuffer().append("Enumeration has more than one value with ordinal ").append(value.getOrdinal()).toString());
            }
            this.ordinalToValueMap[index] = value;
        }
    }

    public final boolean isImmutable() {
        return this.ordinalToValueMap != null;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final boolean isValid(int ordinal) {
        if (ordinal < this.min || ordinal > this.max) {
            return false;
        }
        return this.getName(ordinal) != null;
    }

    public final V getValue(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        return (V)this.ordinalToValueMap[ordinal - this.min];
    }

    public final String getName(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getName();
    }

    public final String getDescription(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getDescription();
    }

    public final int getOrdinal(String name) {
        return this.getValue(name, true).getOrdinal();
    }

    public V getValue(String name, boolean fail) {
        Value value = (Value)this.valuesByName.get(name);
        if (value == null && fail) {
            throw new Error(new StringBuffer().append("Unknown enum name:  ").append(name).toString());
        }
        return (V)value;
    }

    public V getValueIgnoreCase(String name, boolean fail) {
        for (Value value : this.ordinalToValueMap) {
            if (value == null || !value.getName().equalsIgnoreCase(name)) continue;
            return (V)value;
        }
        if (fail) {
            throw new Error(new StringBuffer().append("Unknown enum name:  ").append(name).toString());
        }
        return null;
    }

    public String[] getNames() {
        return this.valuesByName.keySet().toArray(emptyStringArray);
    }

    public List<V> getValuesSortedByName() {
        ArrayList<V> list = new ArrayList<V>();
        Object[] names = this.getNames();
        Arrays.sort((Object[])names);
        for (Object name : names) {
            list.add(this.getValue((String)name, true));
        }
        return list;
    }

    public RuntimeException badValue(int ordinal) {
        return Util.newInternal(new StringBuffer().append("bad value ").append(ordinal).append("(").append(this.getName(ordinal)).append(") for enumeration '").append(this.getClass().getName()).append("'").toString());
    }

    public RuntimeException unexpected(V value) {
        return Util.newInternal(new StringBuffer().append("Was not expecting value '").append(value).append("' for enumeration '").append(this.getClass().getName()).append("' in this context").toString());
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }

    static {
        $assertionsDisabled = !(class$mondrian$olap$EnumeratedValues == null ? (class$mondrian$olap$EnumeratedValues = EnumeratedValues.class$("mondrian.olap.EnumeratedValues")) : class$mondrian$olap$EnumeratedValues).desiredAssertionStatus();
        emptyStringArray = new String[0];
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static class BasicValue
    implements Value {
        public final String name;
        public final int ordinal;
        public final String description;

        public BasicValue(String name, int ordinal, String description) {
            Util.assertPrecondition(name != null, "name != null");
            this.name = name;
            this.ordinal = ordinal;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(String s) {
            return super.equals(s);
        }

        public RuntimeException unexpected() {
            return Util.newInternal("Value " + this.name + " of class " + this.getClass() + " unexpected here");
        }
    }

    public static interface Value {
        public String getName();

        public int getOrdinal();

        public String getDescription();
    }
}

